
*.............................................................................
*
*   Program Name: MDSKIP.PRG          Copyright: Borland International
*   Date Created:  7 Apr 94            Language: dBASE 5.0
*   Time Created: 21:40:11               Author: Borland dBASE R&D
*   /brief/library.src
*.............................................................................

*.................................................................
* Procedure Name:   MDSkip
* Parameters:       None
* Ext Memvars:      None
* Description:      Skips the number of records the user requests
*.................................................................
PROCEDURE MDSkip
    PRIVATE lVoid, nRec, oForm

    #include "TalkOff.hdb"
    
    oForm = GetForm(This)
    
    IF .NOT. ISBLANK(ALIAS())
        IF RECCOUNT() > 1
            #include "MDSKIP.DFM"
            
            lVoid = MDSkip.sbName2.SetFocus()
            lVoid = MDSkip.ReadModal()
            
            IF MDSkip.Action
                ON ERROR DO SkError
                nRec = RECNO()
                SKIP MDSkip.sbName2.Value
                ON ERROR
            ENDIF
            
            IF TYPE("oForm.ClassName") = "C"
                IF oForm.ClassName = "FORM"
                    lVoid = oForm.Refresh()
                ENDIF
            ENDIF
            
            lVoid = MDSkip.Release()
        ENDIF
    ENDIF
    
    #include "TalkOff.hdb"
    
RETURN


*...........................................................................
* Procedure Name:   SkError
* Parameters:       Last record number
* Ext Memvars:      None
* Description:      Displays an error message if the record is out of range
*...........................................................................
PROCEDURE SkError
PARAMETERS nRec
    PRIVATE lVoid
    
    IF MDSkip.sbName2.Value > 0
    	DO ErrorMsg WITH "Cannot skip past end of file"
    ELSE
    	DO ErrorMsg WITH "Cannot skip past beginning of file"
    ENDIF
       
    MDSkip.sbName2.Value = 0
    GOTO nRec
RETURN    
                
