
*.............................................................................
*
*   Program Name: MDIDXKEY.PRG        Copyright: Borland International
*   Date Created:  7 Apr 94            Language: dBASE 5.0
*   Time Created: 23:04:52               Author: Borland dBASE R&D
*   /brief/library.src
*.............................................................................

#define ALLTRIM(kStr) LTRIM(RTRIM(kStr))

*............................................................................
* Procedure Name:   MDIdxKey
* Parameters:       None
* Ext Memvars:      None
* Description:      Searches for the first record with the given index value
*............................................................................
PROCEDURE MDIdxKey
    PRIVATE lVoid, cStr, nKLen, nTLen, nLeft, nRec, xValue, lFlag, oForm, nLen
    
    #include "TalkOff.hdb"
    
    IF RECCOUNT() = 0
        DO InfoMsg WITH [This file has no records to search against.]
        #include "Talkon.hdb"
        RETURN
    ENDIF            
    
    oForm = GetForm(This)
    
    lFlag = .F.

    IF .NOT. ISBLANK(ALIAS())
        IF .NOT. ISBLANK(ORDER())
            cStr = KEY()
            nKLen = LEN(cStr)
            nTLen = FldLen(cStr)
            
            #include "MDIDXKEY.DFM"

            IF nKLen > 40
                MDIdxKey.txName5.Width = 40     && Key text
                nKLen = 40
            ENDIF
            
            IF nTLen > 40    
                MDIdxKey.etName4.Width = 40     && value to search for
                nTLen = 40
            ELSE 
                MDIdxKey.etName4.Width = nTLen    
            ENDIF
            
            nLeft = MAX(nKLen, nTLen)
            
            IF nLeft < 40
                nLeft = 1 + INT((40 - nLeft) / 2)
                MDIdxKey.txName5.Left = nLeft
                MDIdxKey.etName4.Left = nLeft
            ENDIF
            
            xValue = EVALUATE(cStr)
            
            DO CASE
                CASE TYPE("xValue") = "C"
                    nLen = LEN(m->xValue)
                    MDIdxKey.etName4.Value = SPACE(nLen)
                    IF nLen > 40
                        MDIdxKey.etName4.Width = 40
                    ENDIF    
                CASE (TYPE("xValue") = "F") .OR. (TYPE("xValue") = "N")
                    MDIdxKey.etName4.Value = 0
                CASE TYPE(cStr) = "D"
                    MDIdxKey.etName4.Value = {}
            ENDCASE            

            DO WHILE .NOT. lFlag
                lVoid = MDIdxKey.etName4.SetFocus()
                lVoid = MDIdxKey.ReadModal()
            
                IF MDIdxKey.Action
                    nRec = RECNO()
                    xValue = MDIdxKey.etName4.Value
                    IF .NOT. SEEK(xValue)
                        DO InfoMsg WITH [Search value not found]
                        GOTO nRec
                        MDIdxKey.Action = .F.
                        IF TYPE("oForm.ClassName") = "C"
                            IF oForm.ClassName = "FORM"
                                lVoid = oForm.Refresh()
                            ENDIF
                        ENDIF    
                    ELSE
                        *-----------------------------------------------
                        *-- This little dance step is a workaround until
                        *-- browse knows about seek()
                        *-----------------------------------------------
                        nRec = RECNO()
                        GOTO nRec
                        lFlag = .T.
                    ENDIF
                ELSE
                    lFlag = .T.
                ENDIF
            ENDDO
            
            lVoid = MDIdxKey.Release()

        ELSE
            DO InfoMsg WITH [Index not active]
        ENDIF
    ENDIF
#include "Talkon.hdb"
RETURN                                                            

