*.............................................................................
*
*   Program Name: MDADD.PRG           Copyright: Borland International
*   Date Created:  7 Apr 94            Language: dBASE 5.0
*   Time Created: 16:20:07               Author: Borland dBASE R&D
*   /brief/library.src
*.............................................................................

*..........................................................................
* Procedure Name:   MDAdd
* Parameters:       None
* Ext Memvars:      None
* Description:      Adds a record to the end of the current table and sets
*                   the record pointer to it.
*..........................................................................
PROCEDURE MDAdd
    PRIVATE lVoid, oRef, oForm, Form, oF, oC

    #include "TalkOff.hdb"

    *------------------------------------------------------------------
    *-- Get the object reference to the Form object.  Remember This. is
    *-- the menu item.
    *------------------------------------------------------------------
    oForm = This.Form

    *---------------------------------------------------------------------
    *-- Make sure this is a database form.  CurrMast will be set if it is.
    *---------------------------------------------------------------------
    IF oForm.ClassName = "FORM" .AND. TYPE( "oForm.CurrMast" ) = "C"

        *------------------------------------------------
        *-- Need to commit the current record if modified
        *------------------------------------------------
        IF oForm.Modified()
            lVoid = oForm.Submit()
        ENDIF

        *----------------------------------------------------------------
        *-- Set the AddingRec flag for future handling of the Next record
        *-- pushbutton.
        *----------------------------------------------------------------
        oForm.AddingRec = .T.

        *----------------------------
        *-- Go to the end of the file
        *----------------------------
        GO BOTTOM
        IF .NOT. EOF()
            SKIP
        ENDIF

        *---------------------------------------
        *-- Check for need to scan lookup fields
        *---------------------------------------
        IF TYPE( "oForm.Scan4Look" ) = "N" .AND. oForm.Scan4Look > 0

            *-----------------------------------------------------------
            *-- For Each field that has a lookup, call LookRef to update
            *-- the value of the look fields.
            *-----------------------------------------------------------
            oF = oForm.First
            oC = m->oF
            DO WHILE .T.
                IF oC.ClassName = "ENTRYFIELD"
                    IF TYPE( "oC.LookTag" ) = "C"
                        SELECT (oC.LookAlias)
                        SEEK EVAL( oc.DataLink )
                    ENDIF
                ENDIF
                oC = oC.After
                IF oC = m->oF
                    EXIT
                ENDIF
            ENDDO

        ENDIF

        *-------------------------------------------------------------
        *-- By doing a Refresh() here, the form values are blanked out
        *-------------------------------------------------------------
        lVoid = oForm.Refresh()

        *-------------------------------
        *-- Check for any default values
        *-------------------------------
        IF TYPE( "oForm.HasDefVal" ) = "L" .AND. oForm.HasDefVal
            Form = oForm                && Set Form. reference for DefValue
            DO DefValue
        ENDIF

        *------------------------------------------
        *-- Check for need to update Detail regions
        *------------------------------------------
        IF TYPE( "oForm.DetExist" ) = "L" .AND. oForm.DetExist
            DO UpDetail WITH m->oForm
        ENDIF

        *-------------------------------
        *-- Select the master alias back
        *-------------------------------
        SELECT ( oForm.CurrMast )

        *------------------------------------------
        *-- Make sure focus goes to the first field
        *------------------------------------------
        oF = Form.First
        oC = m->oF
        DO WHILE .T.
            IF .NOT. ( oC.ClassName $ "RECTANGLE,TEXT,PAGEBREAK" )
                lVoid = oC.SetFocus()
                EXIT
            ENDIF
            oC = oC.After
            IF oC = m->oF
                EXIT
            ENDIF
        ENDDO

    ENDIF    

    #include "TalkOn.hdb"

RETURN

