*
* File DISPLNUM.PRG
* Sample program for "Programmer's Guide",
* Chapter 20, "Introduction to UI object programming"
*
DEFINE FORM PreCalc;
   PROPERTY ;
      Text "Display a Number",;
      Top 5,;
      Width 30,;
      Height 10,;
      Left 20,;
      Sizeable .F.

DEFINE ENTRYFIELD NumField OF PreCalc;
   PROPERTY ;
      Width 11,;
      Top 0,;
      Left 8,;
      Value 0                  && Initially displays 0 in the entry field.

DEFINE PUSHBUTTON pb1 of PreCalc;
   PROPERTY ;
      Text "1",;
      Width 5, ;
      Top PreCalc.NumField.Top + 2,;
      Left PreCalc.Width / 2 -3,;
      OnClick NumClick         && Event handler when user clicks btn. is NumClick.

***** Two form properties declared with dot reference notation. *****

PreCalc.Height = PreCalc.pb1.Top + PreCalc.pb1.Height + 3
PreCalc.OnClose = "PreClcCls"

lVoid = PreCalc.pb1.SetFocus() && Gives pushbutton focus when form opens.
lVoid = PreCalc.Open()         && Opens the form as a modeless window.

PROCEDURE NumClick
*--------------------------------------------------------------------
* This event handler takes the current value in the entry field, 
* multiplies it by 10, and adds to it the numeric value of the 
* pushbutton text. Because the entry field's value property changes,
* the number it displays changes. Note use of form and this object
* reference variables.
*--------------------------------------------------------------------
   form.NumField.Value = form.NumField.Value * 10 + VAL(this.Text)
RETURN

PROCEDURE PreClcCls
*--------------------------------------------------------------------
* This OnClose event handler for form window PreCalc releases the 
* object reference to the form, erasing it from memory.
*--------------------------------------------------------------------
   lVoid = this.Release()
RETURN
