PROCEDURE Cust
    PRIVATE mFormName, lVoid, mDesk, mActive, mClass
    IF TYPE("Cust1.ClassName") # "C"    &&  form doesn't already exist
        mFormOpen=.F.
        DEFINE FORM mTemp PROPERTY VISIBLE .F.
        lVoid = mTemp.OPEN()
        mDesk = mTemp.PARENT
        lVoid = mTemp.CLOSE()

        mFormName=SPACE(8)
        mActive=mDesk.ActiveControl()
        IF TYPE("mActive.ClassName")="C"
            mClass=mActive.ClassName
            IF mClass="FORM"
                mFormName=mActive.Name
                mFormOpen=.T.
            ENDIF
        ENDIF

        #include "Cust.dfm"
        PUBLIC NewRecord


        NewRecord = .F.

        cust1.Action = .F.
        lVoid = Cust1.Open()
    ELSE
        lVoid = Cust1.SetFocus()    && if form exists, make current
    ENDIF
RETURN
******************
PROCEDURE OpenCust
    PRIVATE lOpen       &&

    lOpen = .T.         && was file already open? (assume .T.)


    IF SUBSTR(DBF(),3)<>"CUST.DBF"
         SELECT SELECT()
         USE Cust ORDER Cust_id ALIAS Cust
         lOpen = .F.
    ENDIF

    This.lOPen = lOpen &&   save lOpen in form

    lVoid = This.Refresh()

    IF .NOT. mFormOpen
        Main.F1.CloseAll.Enabled=.F.
        Main.S.Srch.Enabled=.T.
        Main.S.Tp.Enabled=.T.
        Main.S.Btm.Enabled=.T.
        Main.S.Pck.Enabled=.F.
        Main.S.Indx.Enabled=.F.
        Main.E.Undo.Enabled=.T.
        Main.E.Save.Enabled=.T.
        Main.V.Frm.Enabled=.F.
        Main.App.Ord.Enabled=.F.
        Main.App.Acc.Enabled=.F.
        Main.F1.Bac.Enabled=.F.
        Main.App.Inv.Enabled=.F.
    ENDIF
    Main.App.Cust.Enabled=.F.

RETURN

*******************
PROCEDURE CloseCust
    IF This.Action
        lVoid = This.Submit()
    ELSE
        IF This.Modified()
            DO ErrorMsg WITH "Exit Cust without saving ..."
        ENDIF
    ENDIF

    IF .NOT. This.lOpen     &&   if file wasn't already open on startup
        USE IN Cust         &&   shut it down
    ENDIF
    USE CUST EXCLUS
    DELE FOR CUST_ID=' '
    COUNT FOR DELETED() TO EmpRec
    IF EmpRec<>0
      PACK
    ENDIF
    USE
    LVoid = This.Release()

    mFormOpen=.F.
    DEFINE FORM mTemp PROPERTY VISIBLE .F.
    lVoid = mTemp.OPEN()
    mDesk = mTemp.PARENT
    lVoid = mTemp.CLOSE()

    mFormName=SPACE(8)
    mActive=mDesk.ActiveControl()
    IF TYPE("mActive.ClassName")="C"
        mClass=mActive.ClassName
        IF mClass="FORM"
            mFormName=mActive.Name
            mFormOpen=.T.
        ENDIF
    ENDIF

    IF .NOT. mFormOpen
        Main.F1.CloseAll.Enabled=.T.
        Main.S.Srch.Enabled=.F.
        Main.S.Tp.Enabled=.F.
        Main.S.Btm.Enabled=.F.
        Main.S.Pck.Enabled=.T.
        Main.S.Indx.Enabled=.T.
        Main.E.Undo.Enabled=.F.
        Main.E.Save.Enabled=.F.
        Main.V.Frm.Enabled=.T.
        Main.App.Ord.Enabled=.T.
        Main.App.Acc.Enabled=.T.
        Main.F1.Bac.Enabled=.T.
        Main.App.Inv.Enabled=.T.
    ENDIF
    Main.App.Cust.Enabled=.T.
    RELEASE Cust1


RETURN

******************
FUNCTION DupCheck
    If NewRecord
        ? "Checking for Duplicates ..."
        SEEK(Cust1.CustID.Value)
        IF FOUND() .AND. Cust1.CustID.Value<>''
            DO ErrorMsg WITH "Duplicate Found, Try Again..."+Cust1.CustID.Value
            CLEAR
            RETURN .F.
        ELSE
            Newrecord = .f.
        ENDIF
    Endif
    CLEAR
RETURN .T.

******************
FUNCTION FindID
    * Generate a form that will can be used by other procedures
    DO GenForm
    * Make the user select Ok before moving on
    lVoid = Search.sValue.Setfocus()
    lVoid = Search.ReadModal()

*    ?"FindLast ok"

RETURN .T.
**********************
PROCEDURE GenForm
    * Define a search form
    DEFINE FORM Search FROM 5,10 TO 11,45 ;
        PROPERTY ;
            Text "Search"

    DEFINE TEXT sVal OF Search AT 1,5 ;
        PROPERTY ;
            Text "Cust ID :"
    DEFINE ENTRYFIELD Svalue OF Search AT 1,14 ;
        PROPERTY ;
            Width 7
    DEFINE PUSHBUTTON sOk OF Search AT 3,12 ;
        PROPERTY ;
            Text "OK",;
            Width 10  ,;
            Default .T. ,;
            OnClick "CloseMe"


RETURN
*****************
PROCEDURE CloseMe
CLEAR
    * Get value user entered before closing form
    SearchFor = Search.Svalue.value
    SearchWidth = Search.Width  && See if size is Less than 50

    lVoid = Search.Close()
    * remove from memory
    lVoid = Search.Release()

    * Note : If you place this code in the FindLast routine you will
    * have a timing problem where the variable SearchFor has not been
    * Defined before there is a call referencing it.

    * Now Search for value given - Exact match
    IF LEN(SearchFor) > 0
        SEEK(TRIM(SearchFor))
        IF FOUND()
            Cust1.StatusMessage = "Found ID  = "+trim(SearchFor)
            * repaint the form with the current record
            lVoid = Cust1.Refresh()
        ELSE
            DO ErrorMsg WITH "Customer ID Not Found ..."+trim(SearchFor)
        ENDIF
    ENDIF
CLEAR
RETURN
******************
PROCEDURE PrevHand

    * Check to see that the record pointer is not at Beginning of File

     IF .NOT. BOF()
        IF Form.Modified()
            lVoid = Form.Submit()
        ENDIF

        SKIP -1
        IF BOF()
           DO ErrorMsg WITH "Top of file!"
        ENDIF

        IF DELETED()
           Form.cStatus.Text = "DELETED"
        ELSE
           Form.cStatus.Text = ""
        Endif
        lVoid = Form.Refresh()
    ELSE
        DO ErrorMsg WITH "Top of file!"
    ENDIF
    Form.Action = .F.
RETURN

*******************
PROCEDURE SkipHand

    * Check to see that the record pointer is not end of file
    IF .NOT. EOF()
        IF Form.Modified()
            lVoid = Form.Submit()

        ENDIF
        SKIP
        IF CUST_ID=' '
         SKIP -1
         DO ErrorMsg WITH "End of file encountered!"
        ENDIF
        * Show user if the record is marked for deletion
        IF DELETED()
           Form.cStatus.Text = "DELETED"
        ELSE
           Form.cStatus.Text = ""
        Endif
        lVoid = Form.Refresh()
    ELSE
        * Record pointer is at the end of file, tell user
        DO ErrorMsg WITH "End of file encountered!"
    ENDIF
    Form.Action = .F.

RETURN
******************
PROCEDURE Add_new
    *Write data to disk
    lvoid = Form.submit()
    NewRecord=.T.
    * Append a record
    APPEND BLANK

    *Refresh Screen Data
    lvoid = Form.refresh()
    Form.cStatus.Text=""

RETURN
******************
PROCEDURE DelIt && Marks record for deletion
    IF DELETED()
      Form.cStatus.Text = ""
      RECALL
    ELSE
      Form.cStatus.Text = "DELETED"
      DELETE
    ENDIF

RETURN
*****************
PROCEDURE CanHand
    Form.Action = .F.
    lVoid = Form.Close()
RETURN

*****************
PROCEDURE RePaint
    SELE Cust
    lVoid = Cust1.Refresh()
RETURN

******************
PROCEDURE PrintForm

DEFINE FORM Prt FROM 5,25 TO 16,50 ;
    PROPERTY ;
        TEXT "Print Form"

DEFINE TEXT t1 OF Prt AT 1,1 ;
    PROPERTY ;
        Text "Type :",;
        COLORNORMAL "R/W"

DEFINE RADIOBUTTON Rep OF Prt AT 2,1 ;
    PROPERTY ;
        Text "Report",;
        Group .T.,;
        COLORNORMAL "N/W",;
        WIDTH 15

DEFINE RADIOBUTTON Lab OF Prt AT 3,1 ;
    PROPERTY ;
        Text "Labels",;
        Group .F.,;
        COLORNORMAL "N/W",;
        WIDTH 15

DEFINE TEXT T3 OF Prt AT 9,5 ;
    PROPERTY ;
        TEXT "PRINTING ..." ,;
        VISIBLE .F.,;
        WIDTH 15

DEFINE PUSHBUTTON P1 OF Prt AT 8,12 ;
    PROPERTY ;
        TEXT "&Ok",;
        ONCLICK "RunRep",;
        Width 10

DEFINE PUSHBUTTON P2 OF Prt AT 8,2 ;
    PROPERTY ;
        TEXT "&Cancel",;
        ONCLICK "CanHand",;
        Width 10

lVoid = Prt.Open()

******************
PROCEDURE Runrep

* Check for Labels or Reports
DO CASE
    CASE Form.Rep.Value
         * display to user something is happening
         Form.T3.Visible = .t.
         REPORT FORM Cust TO PRINTER
    CASE Form.Lab.Value
         * display to user something is happening
         Form.T3.Visible = .t.
         LABEL FORM Cust TO PRINTER

ENDCASE
lVoid = Form.Close()
lVoid = Form.Release()
RETURN

