
*.............................................................................
*
*   Program Name: CALENDAR.DFM        Copyright: Borland International
*   Date Created: 01/24/94             Language: dBASE 5.0
*   Time Created: 10:20:02               Author: Borland dBASE R&D
*   /brief/library.src
*.............................................................................

#include "dkeys.hdb"

#define kAmerican  1
#define kANSI      2
#define kBritish   3
#define kGerman    4
#define kItalian   5
#define kJapan     6
#define kUSA       7
#define kMDYString 8
#define kDMYString 9

#define kTop 1

#define ALLTRIM(kStr) LTRIM(RTRIM(kStr))

*.........................................................................
* Procedure Name:   Calendar
* Parameters:       None
* Ext Memvars:      None
* Description:      Displays a monthly calendar starting with the current
*                   month
*.........................................................................
PROCEDURE Calendar
    PRIVATE i, lVoid

    #include "TALKOFF.HDB"

    IF TYPE("_CmdWindow.dbCalndr.Top") = "N"    && if another instance is active
        * if the user released the public arrays, rebuild the calendar
        IF (TYPE("dB5___wk[1]") # "C") .OR. (TYPE("dB5___dat[1]") # "C")
            DO CalExit
            DO DefCalndr
        ELSE    
            lVoid = _CmdWindow.dbCalndr.Open()  && everything's ok
        ENDIF    
    ELSE
        DO DefCalndr    
    ENDIF

RETURN


*.........................................................................
* Procedure Name:   DefCalndr
* Parameters:       None
* Ext Memvars:      None
* Description:      Defines the calendar form
*.........................................................................
PROCEDURE DefCalndr
    PRIVATE lVoid, lSTalk, i
    
    lSTalk = SET("TALK") = "ON"

    SET TALK OFF
    
    RELEASE db5___wk
    PUBLIC ARRAY db5___wk[6]         && holds week character strings
    RELEASE db5___dat
    PUBLIC ARRAY db5___dat[42]       && holds individual dates of the month

    FOR m->i = 1 TO 6
        dB5___wk[i] = SPACE(26)
    ENDFOR
    
    #include "DBCALNDR.DFM"

    _CmdWindow.dbCalndr = dbCalndr

    DO InitDates WITH DATE()

    dbCalndr.Today.Text = " " + GetToday() + " "
    DO GetCoords WITH SUBSTR(dbCalndr.Today.Text,2,2)

    dbCalndr.lSTalk = m->lSTalk
    
    DO UpdateProp
            
    lVoid = dbCalndr.Open()
RETURN


*.................................................................
* Procedure Name:   SetTalk
* Parameters:       None
* Description:      Saves the value of SET TALK and sets TALK OFF
*.................................................................
PROCEDURE SetTalk
    IF (TYPE("dB5___wk[1]") # "C") .OR. (TYPE("dB5___dat[1]") # "C")
        DO CalExit
        DO DefCalndr
    ENDIF    
    
    IF TYPE("_CmdWindow.dbCalndr.lSTalk") = "L"
        _CmdWindow.dbCalndr.lSTalk = SET("TALK") = "ON"
    ELSE    
        dbCalndr.lSTalk = SET("TALK") = "ON"
    ENDIF
        
    SET TALK OFF
RETURN


*............................................................................
* Procedure Name:   ResetTalk
* Parameters:       None
* Ext Memvars:      This.TalkEnter
* Description:      Resets the value of SET TALK based on the value when the
*                   object got focus
*............................................................................
PROCEDURE ResetTalk
    IF _CmdWindow.dbCalndr.lSTalk
        SET TALK ON
    ELSE
        SET TALK OFF
    ENDIF
RETURN


*..........................................................................
* Procedure Name:   GoToday
* Parameters:       None
* Ext Memvars:      _CmdWindow.dbCalndr
* Description:      Makes the system date the current date on the calendar
*..........................................................................
PROCEDURE GoToday
    _CmdWindow.dbCalndr.dNewDate = DATE()
    DO InitDates WITH _CmdWindow.dbCalndr.dNewDate
    DO UpdateProp
    _CmdWindow.dbCalndr.nDay = DAY(_CmdWindow.dbCalndr.dNewDate)
    _CmdWindow.dbCalndr.Today.Text = " " + STR(_CmdWindow.dbCalndr.nDay, 2, 0) + " "
    DO GetCoords WITH SUBSTR(_CmdWindow.dbCalndr.Today.Text,2,2)
RETURN


*...........................................................................
* Procedure Name:   GetCoords
* Parameters:       cDStr, a string containing a number representing a date
* Ext. Memvars:     _CmdWindow.dbCalndr
* Description:      computes the row/column coordinates to print today's
*                   date in the calendar page
*...........................................................................
PROCEDURE GetCoords
PARAMETERS cDStr
    PRIVATE i, lExact

    lExact = SET("EXACT") = "ON"   && save setting of SET EXACT

    SET EXACT ON

    FOR m->i = 1 TO 42
        * search for today's date in the array of dates
        IF cDStr = dB5___dat[m->i]  
            EXIT             && exit the loop when found
        ENDIF
    ENDFOR

    IF .NOT. m->lExact
        SET EXACT OFF        && restore the SET EXACT setting
    ENDIF

    *.................................................
    * find the row that the date should be printed in
    *.................................................
    DO CASE
        CASE (m->i >= 1) .AND. (m->i <= 7)
            _CmdWindow.dbCalndr.Today.Top = kTop + 3
        CASE (m->i >= 8) .AND. (m->i <= 14)
            _CmdWindow.dbCalndr.Today.Top = kTop + 4
        CASE (m->i >= 15) .AND. (m->i <= 21)
            _CmdWindow.dbCalndr.Today.Top = kTop + 5
        CASE (m->i >= 22) .AND. (m->i <= 28)
            _CmdWindow.dbCalndr.Today.Top = kTop + 6
        CASE (m->i >= 29) .AND. (m->i <= 35)
            _CmdWindow.dbCalndr.Today.Top = kTop + 7
        CASE (m->i >= 36) .AND. (m->i <= 42)
            _CmdWindow.dbCalndr.Today.Top = kTop + 8
    ENDCASE

    *.............................................................
    * find the starting column that the date should be printed in
    *.............................................................
    DO CASE
        CASE (m->i = 1) .OR. (m->i = 8) .OR. (m->i = 15) .OR. (m->i = 22) .OR. (m->i = 29) .OR. (m->i = 36)                       
            _CmdWindow.dbCalndr.Today.Left = 1
        CASE (m->i = 2) .OR. (m->i = 9) .OR. (m->i = 16) .OR. (m->i = 23) .OR. (m->i = 30) .OR. (m->i = 37)
            _CmdWindow.dbCalndr.Today.Left = 5
        CASE (m->i = 3) .OR. (m->i = 10) .OR. (m->i = 17) .OR. (m->i = 24) .OR. (m->i = 31) .OR. (m->i = 38)
            _CmdWindow.dbCalndr.Today.Left = 9
        CASE (m->i = 4) .OR. (m->i = 11) .OR. (m->i = 18) .OR. (m->i = 25) .OR. (m->i = 32) .OR. (m->i = 39)
            _CmdWindow.dbCalndr.Today.Left = 13
        CASE (m->i = 5) .OR. (m->i = 12) .OR. (m->i = 19) .OR. (m->i = 26) .OR. (m->i = 33) .OR. (m->i = 40)
            _CmdWindow.dbCalndr.Today.Left = 17
        CASE (m->i = 6) .OR. (m->i = 13) .OR. (m->i = 20) .OR. (m->i = 27) .OR. (m->i = 34) .OR. (m->i = 41)
            _CmdWindow.dbCalndr.Today.Left = 21
        CASE (m->i = 7) .OR. (m->i = 14) .OR. (m->i = 21) .OR. (m->i = 28) .OR. (m->i = 35) .OR. (m->i = 42)
            _CmdWindow.dbCalndr.Today.Left = 25
    ENDCASE
RETURN


*..........................................................................
* Function Name:    GetToday
* Parameters:       None
* Ext. Memvars:     None
* Return Value:     String, day if current month, "" if not
* Description:      if value of nMth is within the current month, a string
*                   representing the value of the day is returned.  If not
*                   the current month an empty string is returned.
*..........................................................................
FUNCTION GetToday
    SET TALK OFF 
RETURN STR(DAY(DATE()),2,0)


*...........................................................................
* Procedure Name:   ChkArrow
* Parameters:       None
* Ext. Memvars:     _CmdWindow.dbCalndr
* Description:      Processes keystoke or mouseclick on _CmdWindow.dbCalndr.  If right
*                   key, or click in right place, then does PrevMth or 
*                   NextMth, or changes highlighted date
*...........................................................................
PROCEDURE CheckArw
    PRIVATE i, nTmp, nRow, nCol
    
    SET TALK OFF
    
    nRow = event.MouseRow
    nCol = event.MouseColumn

    DO CASE
        CASE event.eventType = evKeyDown            && keyboard event
            DO CASE
                CASE event.KeyValue = kbRight       && right arrow    
                    _CmdWindow.dbCalndr.nDay = IIF(_CmdWindow.dbCalndr.nDay < DAY(_CmdWindow.dbCalndr.dLast),;
                        _CmdWindow.dbCalndr.nDay + 1, 1)
                    _CmdWindow.dbCalndr.Today.Text = " " + STR(_CmdWindow.dbCalndr.nDay,2,0) + " "
                    DO GetCoords WITH SUBSTR(_CmdWindow.dbCalndr.Today.Text,2,2)
                CASE event.KeyValue = kbLeft      && left arrow
                    _CmdWindow.dbCalndr.nDay = IIF(_CmdWindow.dbCalndr.nDay > 1, _CmdWindow.dbCalndr.nDay - 1,;
                        DAY(_CmdWindow.dbCalndr.dLast))
                    _CmdWindow.dbCalndr.Today.Text = " " + STR(_CmdWindow.dbCalndr.nDay,2,0) + " "
                    DO GetCoords WITH SUBSTR(_CmdWindow.dbCalndr.Today.Text,2,2)
                CASE (event.KeyValue = kbUp) .AND. (.NOT.(event.KeyAlt))      && up arrow
                    IF _CmdWindow.dbCalndr.nDay >= 8  && if the 8th of the month or >
                        _CmdWindow.dbCalndr.nDay = _CmdWindow.dbCalndr.nDay - 7
                    ELSE    && < 8th, goto same weekday at bottom of month
                        nTmp = DOW(Num2Date(_CmdWindow.dbCalndr.nDay, _CmdWindow.dbCalndr.nMth,;
                            _CmdWindow.dbCalndr.nYear))    && get DOW of current day                                                                             
                        * starting from the end of the month, find the first
                        * day with the same day of the week as the current
                        * day 
                        FOR m->i = 42 TO 1 STEP -1
                            IF VAL(dB5___dat[m->i]) > 0   && if there is a number
                                * if the DOW of day in dB5___dat[i] = nTmp
                                IF DOW(Num2Date(VAL(dB5___dat[m->i]),; 
                                    _CmdWindow.dbCalndr.nMth, _CmdWindow.dbCalndr.nYear)) = nTmp
                                    * set nDay to this date
                                    _CmdWindow.dbCalndr.nDay = VAL(dB5___dat[m->i])
                                    EXIT    && exit the loop
                                ENDIF
                            ENDIF
                        ENDFOR
                    ENDIF
                    _CmdWindow.dbCalndr.Today.Text = " " + STR(_CmdWindow.dbCalndr.nDay,2,0) +" "
                    DO GetCoords WITH SUBSTR(_CmdWindow.dbCalndr.Today.Text,2,2)
                CASE (event.KeyValue = kbDown) .AND. (.NOT.(event.KeyAlt))  && downarrow
                    * if current day is at least 7 days prior to the last
                    * day of the month
                    IF _CmdWindow.dbCalndr.nDay <= (DAY(_CmdWindow.dbCalndr.dLast) - 7)
                        _CmdWindow.dbCalndr.nDay = _CmdWindow.dbCalndr.nDay + 7   && add a week
                    ELSE
                        nTmp = DOW(Num2Date(_CmdWindow.dbCalndr.nDay, _CmdWindow.dbCalndr.nMth,; 
                            _CmdWindow.dbCalndr.nYear))    && DOW of present day
                        * search month starting at beginning of month for the
                        * first day with the same DOW as the present day
                        FOR i = 1 TO 42 STEP 1
                            IF VAL(dB5___dat[m->i]) > 0   && if a day
                                * if DOW = DOW of present day, reset day to 
                                * new day in first week
                                IF DOW(Num2Date(VAL(dB5___dat[m->i]),; 
                                    _CmdWindow.dbCalndr.nMth, _CmdWindow.dbCalndr.nYear)) = m->nTmp
                                    _CmdWindow.dbCalndr.nDay = VAL(dB5___dat[m->i])
                                    EXIT
                                ENDIF
                            ENDIF
                        ENDFOR
                    ENDIF
                    _CmdWindow.dbCalndr.Today.Text = " " + STR(_CmdWindow.dbCalndr.nDay,2,0) + " "
                    DO GetCoords WITH SUBSTR(_CmdWindow.dbCalndr.Today.Text,2,2)
            ENDCASE
        CASE event.eventType = evMouseDown        && mouse event
            DO CASE
                CASE m->nRow = 1
                    DO CASE
                        CASE m->nCol = 20
                            DO PrevMth
                        CASE m->nCol = 23
                            DO NextMth
                    ENDCASE
                CASE (m->nRow >= 4) .AND. (m->nRow <= 9)
                    nTmp = MHiLite(m->nRow, m->nCol)
                    IF (m->nTmp > 0) .AND. (LEN(ALLTRIM(dB5___dat[m->nTmp])) > 0)
                        DO GetCoords WITH dB5___dat[m->nTmp]
                        _CmdWindow.dbCalndr.Today.Text = " " + dB5___dat[m->nTmp] + " "
                        _CmdWindow.dbCalndr.nDay = VAL(dB5___dat[m->nTmp])
                    ENDIF
            ENDCASE
    ENDCASE
    
RETURN


*.............................................................................
* Function Name:    MHiLite
* Parameters:       nRow - the row the mouse was clicked on
*                   nCol - the column the mouse was clicked on
* Return Value:     nRet - the index into dB5___dat[] that falls under nRow,nCol
* Ext Memvars:      None
* Description:      Determines which member of the array dB5___dat[] was clicked
*                   on with the mouse.  Returns the index into the array.
*.............................................................................
FUNCTION MHiLite
PARAMETERS nRow, nCol
    PRIVATE nTmp, nRet    

    DO CASE
        CASE m->nRow = 4
            nTmp =  0
        CASE m->nRow = 5
            nTmp =  7
        CASE m->nRow = 6
            nTmp = 14
        CASE m->nRow = 7
            nTmp = 21
        CASE m->nRow = 8
            nTmp = 28
        CASE m->nRow = 9
            nTmp = 35
    ENDCASE

    DO CASE
        CASE (m->nCol = 2) .OR. (m->nCol = 3)
            nRet = 1 + m->nTmp
        CASE (m->nCol = 6) .OR. (m->nCol = 7)
            nRet = 2 + m->nTmp
        CASE (m->nCol = 10) .OR. (m->nCol = 11)
            nRet = 3 + m->nTmp
        CASE (m->nCol = 14) .OR. (m->nCol = 15)
            nRet = 4 + m->nTmp
        CASE (m->nCol = 18) .OR. (m->nCol = 19)
            nRet = 5 + m->nTmp
        CASE (m->nCol = 22) .OR. (m->nCol = 23)
            nRet = 6 + m->nTmp
        CASE (m->nCol = 26) .OR. (m->nCol = 27)
            nRet = 7 + m->nTmp
        OTHERWISE
            nRet = 0
    ENDCASE

RETURN m->nRet


*.............................................................................
* Procedure Name:   PrevMth
* Parameters:       None
* Ext Memvars:      None
* Description:      Creates a date memvar with a value in the month previous
*                   to the month currently being viewed in the calendar.
*                   Then it calls the functions to create a new calendar page
*                   with the new date.  Finally it updates the object
*                   properties to display the new calendar page.
*.............................................................................
PROCEDURE PrevMth
    PRIVATE nTmp

    SET TALK OFF

    nTmp = _CmdWindow.dbCalndr.nDay    && save current day

    DO InitDates WITH (_CmdWindow.dbCalndr.dFirst - 10)
    DO UpdateProp
    _CmdWindow.dbCalndr.nDay = IIF(m->nTmp <= DAY(_CmdWindow.dbCalndr.dLast), m->nTmp,; 
        DAY(_CmdWindow.dbCalndr.dLAST))
    _CmdWindow.dbCalndr.Today.Text = " " + STR(_CmdWindow.dbCalndr.nDay, 2, 0) + " "
    DO GetCoords WITH SUBSTR(_CmdWindow.dbCalndr.Today.Text,2,2)
    _CmdWindow.dbCalndr.Today.Text = " " + STR(_CmdWindow.dbCalndr.nDay, 2, 0) + " "
RETURN


*.............................................................................
* Procedure Name:   NextMth
* Parameters:       None
* Ext Memvars:      None
* Description:      Creates a date memvar with a value in the month following
*                   the month currently being viewed in the calendar.
*                   Then it calls the functions to create a new calendar page
*                   with the new date.  Finally it updates the object
*                   properties to display the new calendar page.
*.............................................................................
PROCEDURE NextMth
    PRIVATE nTmp

    SET TALK OFF

    nTmp = _CmdWindow.dbCalndr.nDay    && save current day

    DO InitDates WITH (_CmdWindow.dbCalndr.dLast + 10)
    DO UpdateProp
    _CmdWindow.dbCalndr.nDay = IIF(m->nTmp <= DAY(_CmdWindow.dbCalndr.dLast), m->nTmp,; 
        DAY(_CmdWindow.dbCalndr.dLAST))
    _CmdWindow.dbCalndr.Today.Text = " " + STR(_CmdWindow.dbCalndr.nDay, 2, 0) + " "
    DO GetCoords WITH SUBSTR(_CmdWindow.dbCalndr.Today.Text,2,2)
    _CmdWindow.dbCalndr.Today.Text = " " + STR(_CmdWindow.dbCalndr.nDay, 2, 0) + " "
RETURN


*..........................................................................
* Procedure Name:   UpdateProp
* Parameters:       None
* Ext Memvars:      _CmdWindow.dbCalndr
* Description:      updates various text properties of _CmdWindow.dbCalndr to display
*                   a new month.
*..........................................................................
PROCEDURE UpdateProp
    _CmdWindow.dbCalndr.CalMth.Text = _CmdWindow.dbCalndr.cMYStr
    _CmdWindow.dbCalndr.Week1.Text = dB5___wk[1]
    _CmdWindow.dbCalndr.Week2.Text = dB5___wk[2]
    _CmdWindow.dbCalndr.Week3.Text = dB5___wk[3]
    _CmdWindow.dbCalndr.Week4.Text = dB5___wk[4]
    _CmdWindow.dbCalndr.Week5.Text = dB5___wk[5]
    _CmdWindow.dbCalndr.Week6.Text = dB5___wk[6]
RETURN


*......................................................................
* Procedure Name:   SetDate
* Parameters:       None
* Ext Memvars:      _CmdWindow.dbCalndr
* Description:      Creates a dialog for the user to enter a new date.
*                   Then changes the calendar date to the new date.
*......................................................................
PROCEDURE SetDate
    PRIVATE lVoid

    _CmdWindow.dbCalndr.dNewDate = Num2Date(_CmdWindow.dbCalndr.nDay, _CmdWindow.dbCalndr.nMth,; 
                                 _CmdWindow.dbCalndr.nYear)
                                 
    #include "NEWDATE.DFM"
    
    IF (NewDate.Top) > (NLines() - 10)
        NewDate.Top = NLines() - 10
    ENDIF
    
    IF NewDate.Left > 50
        NewDate.Left = 50
    ENDIF    

    NewDate.lSCent = SET("CENTURY") = "ON"
    SET CENTURY ON

    NewDate.e1.Value = _CmdWindow.dbCalndr.dNewDate
    lVoid = NewDate.e1.SetFocus()            
            
    lVoid = NewDate.ReadModal()
    
    IF (NewDate.lFlag) .AND. (_CmdWindow.dbCalndr.dNewDate # NewDate.e1.Value)
        _CmdWindow.dbCalndr.dNewDate = NewDate.e1.Value
        DO InitDates WITH _CmdWindow.dbCalndr.dNewDate
        DO UpdateProp
        _CmdWindow.dbCalndr.nDay = DAY(_CmdWindow.dbCalndr.dNewDate)
        _CmdWindow.dbCalndr.Today.Text = " " + STR(_CmdWindow.dbCalndr.nDay, 2, 0) + " "
        DO GetCoords WITH SUBSTR(_CmdWindow.dbCalndr.Today.Text,2,2)
    ENDIF
    
    IF .NOT. NewDate.lSCent
        SET CENTURY OFF
    ENDIF
        
    lVoid = NewDate.Release()
    RELEASE NewDate
RETURN 


*...........................................................................
* Procedure Name:   InitDates
* Parameters:       dDate, date to use as the basis for building a calendar
* Ext. Memvars:     dFirst, cMYStr
* Description:      Initializes an array with the days of the month for
*                   printing in the calendar.  Also sets some housekeeping
*                   variables
*...........................................................................
PROCEDURE InitDates
PARAMETERS dDate
    PRIVATE nStart, nEnd, i, j, n

    SET TALK OFF        && Work around for SET TALK bug    

    _CmdWindow.dbCalndr.dFirst = FDoM(m->dDate)   && date of first day of month
    _CmdWindow.dbCalndr.dLast  = LDoM(m->dDate)   && date of last day of month
    _CmdWindow.dbCalndr.nDay   = DAY(m->dDate)    && current day
    _CmdWindow.dbCalndr.nMth   = MONTH(m->dDate)  && current month
    _CmdWindow.dbCalndr.nYear  = YEAR(m->dDate)   && current year
    _CmdWindow.dbCalndr.cMYStr = SPACE(16)     && string holding current month and year

    nStart = DOW(_CmdWindow.dbCalndr.dFirst)   && day of week of first day of month
    nEnd   = DAY(_CmdWindow.dbCalndr.dLast)    && day (numeric) of last day of month
    n      = 1                      && day counter

    *..............................................................
    * initialize the date array with the days of the current month
    *..............................................................
    FOR m->i = 1 TO 42
        IF (m->i >= m->nStart) .AND. (m->n <= m->nEnd)  && if between 1st and last of mth
            dB5___dat[m->i] = STR(m->n,2,0)
            n = m->n + 1
        ELSE
            dB5___dat[m->i] = "  "    && if no date, use spaces
        ENDIF
    ENDFOR

    * create month/year string for top of calendar
    _CmdWindow.dbCalndr.cMYStr = CMONTH(_CmdWindow.dbCalndr.dFirst)
    DO WHILE LEN(_CmdWindow.dbCalndr.cMYStr) < 8    && month name must be 8 characters
        * add leading spaces (if necessary)
        _CmdWindow.dbCalndr.cMYStr = " " + _CmdWindow.dbCalndr.cMYStr
    ENDDO
    _CmdWindow.dbCalndr.cMYStr = _CmdWindow.dbCalndr.cMYStr + " " + STR(YEAR(_CmdWindow.dbCalndr.dFirst),4,0);
        + "   " && + CHR(30) + "  " + CHR(31)

    n = 1

    *......................................
    * build text strings for calendar page 
    *......................................
    FOR m->i = 1 TO 6
        dB5___wk[m->i] = ""                       && clear week string
        FOR m->j = 1 TO 7
            * add date to week
            dB5___wk[m->i] = dB5___wk[m->i] + dB5___dat[m->n]
            IF j < 7                        && if not Saturday
                * add space before next date
                dB5___wk[m->i] = dB5___wk[m->i] + "  "
            ENDIF
            n = m->n + 1                       && next date in month
        ENDFOR
    ENDFOR

RETURN


*....................................................
* Procedure Name:   CalExit
* Parameters:       None
* Ext Memvars:      _CmdWindow.dbCalndr, db5___wk, dB5___dat
* Description:      Closes and releases the calendar
*....................................................
PROCEDURE CalExit
    PRIVATE lVoid
    
    lVoid = _CmdWindow.dbCalndr.Close()
    lVoid = _CmdWindow.dbCalndr.Release()
    _CmdWindow.dbCalndr = .F.
    RELEASE dbCalndr, dB5___wk, dB5___dat
RETURN


*............................................................................
* Procedure Name:   CopyDate
* Parameters:       None
* Ext Memvars:      None
* Description:      Copies the selected date to the clipboard or to an entry
*                   field.  Copies in the format selected in the options 
*                   menu.
*............................................................................
PROCEDURE CopyDate
    PRIVATE cDate, lSCent, cTmp, dTmp, cSDate
    
    cDate = DTOC(DATE())

    cSDate = SET("DATE")
    SET DATE TO AMERICAN
    dTmp = CTOD(STR(_CmdWindow.dbCalndr.nMth,2,0) + "/" + STR(_CmdWindow.dbCalndr.nDay,2,0);
                + "/" + STR(_CmdWindow.dbCalndr.nYear,4,0))
    SET DATE TO &cSDate

    DO CASE
        CASE _CmdWindow.dbCalndr.nDateFmt = kAmerican
            SET DATE TO AMERICAN
            cDate = DTOC(m->dTmp)
        CASE _CmdWindow.dbCalndr.nDateFmt = kANSI
            SET DATE TO ANSI
            cDate = DTOC(m->dTmp)
        CASE _CmdWindow.dbCalndr.nDateFmt = kBritish
            SET DATE TO BRITISH
            cDate = DTOC(m->dTmp)
        CASE _CmdWindow.dbCalndr.nDateFmt = kGerman
            SET DATE TO GERMAN
            cDate = DTOC(m->dTmp)
        CASE _CmdWindow.dbCalndr.nDateFmt = kItalian
            SET DATE TO ITALIAN
            cDate = DTOC(m->dTmp)
        CASE _CmdWindow.dbCalndr.nDateFmt = kJapan
            SET DATE TO JAPAN
            cDate = DTOC(m->dTmp)
        CASE _CmdWindow.dbCalndr.nDateFmt = kUSA
            SET DATE TO USA
            cDate = DTOC(m->dTmp)
        CASE _CmdWindow.dbCalndr.nDateFmt = kMDYString
            lSCent = SET("CENTURY") = "ON"
            SET CENTURY ON
            SET DATE TO &cSDate
            cDate = MDY(m->dTmp)
            IF .NOT. lSCent 
                SET CENTURY OFF
            ENDIF    
        CASE _CmdWindow.dbCalndr.nDateFmt = kDMYString
            lSCent = SET("CENTURY") = "ON"
            SET CENTURY ON
            SET DATE TO &cSDate
            cDate = DMY(m->dTmp)
            IF .NOT. lSCent 
                SET CENTURY OFF
            ENDIF    
    ENDCASE

    _Clipboard.InsertLine = m->cDate
    _Clipboard.ExtendSelection = .T.
    _Clipboard.Column = 1
    _Clipboard.ExtendSelection = .F.
    
    SET DATE TO &cSDate
RETURN


*..........................................................................
* Procedure Name:   DateFrmt
* Parameters:       None
* Ext Memvars:      None
* Description:      Sets the format of dates when copied from the calendar
*..........................................................................
PROCEDURE DateFrmt
    PRIVATE nRet, nTmp, lVoid, lSCent, oRef, lFnd, i, n, cDStr
    
    nTmp = _CmdWindow.dbCalndr.nDateFmt
    
    lSCent = SET("CENTURY") = "ON"
    SET CENTURY ON

    #include "SELDATE.DFM"

    IF (SelDate.Top) > (NLines() - 20)
        SelDate.Top = NLines() - 20
    ENDIF
    
    IF SelDate.Left > 50
        SelDate.Left = 50
    ENDIF
    
    IF m->nTmp > 0
        m->i = 1
        oRef = SelDate.r1
        DO WHILE oRef.ClassName = "RADIOBUTTON"
            IF m->i = m->nTmp
                oRef.Value = .T.
                lVoid = oRef.SetFocus()
                EXIT
            ENDIF
            oRef = oRef.After
            i = m->i + 1
        ENDDO
    ELSE
        cDStr = SET("DATE")
        DO CASE
            CASE ((m->cDStr = "AMERICAN") .OR. (m->cDStr = "MDY"))
                SelDate.r1.Value = .T.
                lVoid = SelDate.r1.SetFocus()
            CASE m->cDStr = "ANSI"
                SelDate.r2.Value = .T.
                lVoid = SelDate.r2.SetFocus()
            CASE ((m->cDStr = "BRITISH") .OR. (m->cDStr = "FRENCH") .OR. (m->cDStr = "DMY"))
                SelDate.r3.Value = .T.
                lVoid = SelDate.r3.SetFocus()
            CASE m->cDStr = "GERMAN"                    
                SelDate.r4.Value = .T.
                lVoid = SelDate.r4.SetFocus()
            CASE m->cDStr = "ITALIAN"
                SelDate.r5.Value = .T.
                lVoid = SelDate.r5.SetFocus()
            CASE ((m->cDStr = "JAPAN") .OR. (m->cDStr = "YMD"))
                SelDate.r6.Value = .T.
                lVoid = SelDate.r6.SetFocus()
            CASE m->cDStr = "USA"
                SelDate.r7.Value = .T.
                lVoid = SelDate.r7.SetFocus()
        ENDCASE
    ENDIF    

    lVoid = SelDate.ReadModal()

    IF SelDate.lFlag
        DO CASE
            CASE SelDate.r1.Value
                _CmdWindow.dbCalndr.nDateFmt = kAmerican
            CASE SelDate.r2.Value
                _CmdWindow.dbCalndr.nDateFmt = kANSI
            CASE SelDate.r3.Value
                _CmdWindow.dbCalndr.nDateFmt = kBritish
            CASE SelDate.r4.Value
                _CmdWindow.dbCalndr.nDateFmt = kGerman
            CASE SelDate.r5.Value
                _CmdWindow.dbCalndr.nDateFmt = kItalian
            CASE SelDate.r6.Value
                _CmdWindow.dbCalndr.nDateFmt = kJapan
            CASE SelDate.r7.Value
                _CmdWindow.dbCalndr.nDateFmt = kUSA
            CASE SelDate.r8.Value
                _CmdWindow.dbCalndr.nDateFmt = kMDYString
            CASE SelDate.r9.Value
                _CmdWindow.dbCalndr.nDateFmt = kDMYString
        ENDCASE                
    ENDIF
    
    lVoid = SelDate.Release()
    RELEASE SelDate
    
    IF .NOT. lSCent
        SET CENTURY OFF
    ENDIF    
    
RETURN


*.............................................................................
* Procedure Name:   CHUsing
* Parameters:       None
* Ext Memvars:      None
* Description:      Displays help information on how to select and copy dates
*                   from the calendar, and how to change months.
*.............................................................................
PROCEDURE CHUsing
    * TBD
RETURN


*............................................................
* Procedure Name:   CHAbout
* Parameters:       None
* Ext Memvars:      None
* Description:      Displays an "About" box for the calendar
*............................................................
PROCEDURE CHAbout
    PRIVATE lVoid
    
    #include "CHABOUT.DFM"

    lVoid = HAbout.ReadModal()
    
    lVoid = HAbout.Release()
    RELEASE HAbout
RETURN


*..........................................
* Procedure Name:   PrAbout
* Parameters:       None
* Ext Memvars:      HAbout
* Description:      Closes the form HAbout
*..........................................
PROCEDURE PrAbout
    PRIVATE lVoid
    
    lVoid = HAbout.Close()
RETURN    


*......................................................................
* Procedure Name:   IDEHelp
* Parameters:       None
* Ext Memvars:      None
* Description:      Calls the help system with current object's HelpID
*......................................................................
PROCEDURE IDEHelp
    PRIVATE lVoid
    
    _SysHelp.HelpID = This.HelpID
    lVoid = _SysHelp.ReadModal()
RETURN    


*...........................................................................
* Function Name:    Num2Date
* Parameters:       nDay  - numeric representing a specific day of a month
*                   nMth  - numeric representing a month (1 - 12)
*                   nYear - numeric representing a year
* Return Value:     d - numerics combined to form a date
* Ext Memvars:      None
* Description:      Takes 3 numeric arguments and attempts to create a date
*                   from them.
*...........................................................................
FUNCTION Num2Date
    PARAMETERS nDay, nMth, nYear

    PRIVATE d, cSDate
    
    cSDate = SET("DATE")
    
    SET DATE TO AMERICAN

    IF (TYPE("m->nDay") = "N") .AND. (TYPE("m->nMth") = "N") .AND.; 
        (TYPE("m->nYear") = "N")
        d = CTOD(STR(m->nMth,2,0) + "/" + STR(m->nDay,2,0) + "/" + STR(m->nYear,4,0))
    ELSE
        d = {}
    ENDIF
    
    SET DATE TO &cSDate

RETURN d


*........................................................................
* Procedure Name:   PrOK
* Parameters:       None
* Ext Memvars:      NewDate    
* Description:      Processes the OK button, sets a flag so that changes
*                   get committed.
*........................................................................
PROCEDURE PrOK
    PRIVATE lVoid
    
    NewDate.lFlag = .T.
    lVoid = NewDate.Close()
RETURN


*............................................................................
* Procedure Name:   PrCancel
* Parameters:       None
* Ext Memvars:      NewDate
* Description:      Processes the Cancel button, sets a flag so that changes
*                   are NOT committed
*............................................................................
PROCEDURE PrCancel
    PRIVATE lVoid
    
    NewDate.lFlag = .F.
    lVoid = NewDate.Close()
RETURN



*........................................................................
* Procedure Name:   Pr1OK
* Parameters:       None
* Ext Memvars:      SelDate    
* Description:      Processes the OK button, sets a flag so that changes
*                   get committed.
*........................................................................
PROCEDURE Pr1OK
    PRIVATE lVoid 
    
    SelDate.lFlag = .T.
    lVoid = SelDate.Close()
RETURN


*............................................................................
* Procedure Name:   Pr1Cancel
* Parameters:       None
* Ext Memvars:      SelDate
* Description:      Processes the Cancel button, sets a flag so that changes
*                   are NOT committed
*............................................................................
PROCEDURE Pr1Cancel
    PRIVATE lVoid 
    
    SelDate.lFlag = .F.
    lVoid = SelDate.Close()
RETURN


*............................................................................
* Function Name:    nLines
* Parameters:       None
* Ext Memvars:      None
* Return Value:     numeric, the number of lines on the display
* Description:      returns the number of lines on the display, based on the
*                   current display mode.  If SET STATUS is on, the status
*                   bar is treated as the last line.
*............................................................................
FUNCTION NLines
    PRIVATE n
    
    n = VAL(RIGHT(ALLTRIM(SET("DISPLAY")),2))

    IF n = 0
        n = 25
    ENDIF
    
    IF SET("STATUS") = "ON"
        n = m->n - 2
    ENDIF    
    
RETURN m->n           


*.....................................................................
* The following functions are from the dUFLP library maintained by
* Ken Mayer of Team Borland.  These functions are in the public 
* domain.  The library may be downloaded from the Borland dBASE Forum
* on CompuServe.
*.....................................................................


FUNCTION FDoM
*-----------------------------------------------------------------------
*-- Programmer..: Kenneth Chan [ZAK] (CIS: 72662,1305)
*-- Date........: 01/05/1993
*-- Notes.......: First Day of Month 
*-- Written for.: dBASE IV, 1.5
*-- Rev. History: 01/05/1993 -- Original Release
*-- Calls.......: None
*-- Called by...: Any
*-- Usage.......: FDoM(<dArg>)
*-- Example.....: ?FDOM(date())
*-- Returns.....: Date
*-- Parameters..: dArg = a Date argument -- function returns first day
*--                      of the month of this date.
*-----------------------------------------------------------------------

   parameter dArg

RETURN m->dArg - day( m->dArg ) + 1
*-- EoF: FDoM()


FUNCTION LDoM
*-----------------------------------------------------------------------
*-- Programmer..: Ken Chan [HazMatZak] (CIS: 72662,1305)
*-- Date........: 02/26/1992
*-- Notes.......: Last Day of Month -- Zak wrote this one up as a MUCH
*--               shorter and more straightforward version of one I did.
*--               >sigh<.  This function returns the date of the last
*-                day of the month.
*-- Written for.: dBASE IV, 1.1
*-- Rev. History: 02/26/1992 -- Original Release
*-- Calls.......: None
*-- Called by...: Any
*-- Usage.......: LDoM(<dDate>)
*-- Example.....: ? LDoM(DATE())
*-- Returns.....: dBASE Date
*-- Parameters..: dDate  -- date to work from ...
*-----------------------------------------------------------------------

   parameter dDate
   private dNxtMonth
   
   dNxtMonth = m->dDate - day( m->dDate ) + 45 && middle of next month
   
RETURN m->dNxtMonth - day( m->dNxtMonth )
*-- EoF: LDoM()


* $Log:   /cms/dav.v/src/ide/calendar.prg,v  $
