PROCEDURE BldFile
PARAMETERS pcSpec, poListBox
*----------------------------------------------------------------------------
* NAME
*   BldFile - Use the file spec to set DataSource for poListBox
*
* PARAMETERS
*   pcSpec     = File spec with ? or *
*   poListBox  = Object ref to list box or combo box.
*
*----------------------------------------------------------------------------
    PRIVATE nFiles, nVoid, cSource

    DECLARE dB5___OFls[1,5]

    *----------------------------------------------------------------
    *-- Build an array containing the list of files for the file spec
    *----------------------------------------------------------------
    nFiles = ADIR( dB5___OFls, LTRIM(TRIM(m->pcSpec) ) )

    IF nFiles > 0

        *-----------------------------------------------------------------
        *-- Reshape the two dimensional array down to a single using ACOPY
        *-----------------------------------------------------------------
        DECLARE dB5___ORes[m->nFiles]
        nFiles = ACOPY( dB5___OFls, ;
                        dB5___ORes, ;
                        AELEMENT( dB5___OFls, 1, 1 ), ;
                        AELEMENT( dB5___OFls, m->nFiles, 1 ) , ;
                        1, 1 )

        nVoid = ASORT( dB5___ORes )
        cSource = "ARRAY dB5___ORes"
    ELSE
        cSource = "STRING <Empty>"
    ENDIF

    *-------------------------------------------------------------
    *-- Set the DataSource for the list box based on the file list
    *-------------------------------------------------------------
    poListBox.DataSource = m->cSource

RETURN
*-- EOP: BldFile WITH pcFileName, poListBox

