PROCEDURE BldDirs
PARAMETERS poListBox
*----------------------------------------------------------------------------
* NAME
*   BldDirs - Build a list of directories then set the DataSource.  This
*             routine can be used whenever a listbox of directories from
*             the current directory is needed.
*
* PARAMETERS
*   poListBox  = Object ref to list box or combo box.
*
*----------------------------------------------------------------------------
    PRIVATE cPath, n, i, nDirs, nMod, nOk

    cPath = SET( "DIRECTORY" )
    IF RIGHT( m->cPath, 1 ) <> "\"
        cPath = m->cPath + "\"
    ENDIF

    *--------------------------------
    *-- Build the list of directories
    *--------------------------------
    DECLARE dB5___OFls[1,5]
    n = ADIR( dB5___OFls, m->cPath + "*.*", "D" )

    n = MAX( 1, m->n )
    nDirs = 0
    DECLARE dB5___Dir[m->n]

    FOR i = 1 TO m->n
        IF dB5___OFls[ m->i, 5 ] = "....D."
            nDirs = m->nDirs + 1
            dB5___Dir[ m->nDirs ] = dB5___OFls[ m->i, 1 ]
        ENDIF
    ENDFOR

    *---------------------------------------------------------------
    *-- Chop the original size down to adjust the filled directories
    *-- and sort the result.
    *---------------------------------------------------------------
    DO CASE
        CASE m->nDirs = 1
            poListBox.DataSource = "ARRAY dB5___Dir"
        CASE nDirs > 1
            nMod = ARESIZE( dB5___Dir, m->nDirs )
            nOk = ASORT( dB5___Dir )
            IF LEFT( db5___Dir[1], 1 ) = "."
                IF db5___Dir[1] = ".." .OR. db5___Dir[2] = ".."
                    db5___Dir[1] = "\"
                    db5___Dir[2] = ".."
                ENDIF
            ENDIF
            poListBox.DataSource = "ARRAY dB5___Dir"
        CASE nDirs < 1
            poListBox.DataSource = "STRING \"
    ENDCASE

RETURN
*-- EOP: BldDirs


