PROCEDURE AreaCode
    PRIVATE lVoid

    IF TYPE("Area.ClassName") # "C" && make sure form doesn't already exist!
        #include "AreaCode.dfm"
        PUBLIC NewRecord

        NewRecord = .F.

        Area.Action = .F.
        lVoid = Area.Open()
    ELSE
        lVoid = Area.SetFocus() && if form already exists, bring to top
    ENDIF
RETURN
******************
PROCEDURE OpenArea
    PRIVATE lOpen

    lOpen = .T.     && is .DBF already open?

    IF SELECT("AreaCode") = 0       && Check to see if file is already open
        SELECT SELECT()             && Let dBASE find an open workarea
        USE Codes ALIAS AreaCode ORDER City
        lOpen = .F.                 && file was not already open
    ELSE
        SELECT AreaCode
    ENDIF

    This.lOpen = lOpen  && save lOpen to form
    Main.App.Are.Enabled=.F.
	 Main.F1.CloseAll.Enabled=.F.
    Main.S.Srch.Enabled=.T.
    Main.S.Tp.Enabled=.T.
    Main.S.Btm.Enabled=.T.
    Main.S.Pck.Enabled=.F.
    Main.S.Indx.Enabled=.F.
    Main.E.Undo.Enabled=.T.
    Main.E.Save.Enabled=.T.
    Main.V.Frm.Enabled=.F.
    Main.F1.Bac.Enabled=.F.


RETURN
******************
PROCEDURE CloseArea
    IF This.Action
        lVoid = This.Submit()
    ELSE
        IF This.Modified()
            DO ErrorMsg WITH "Exit Area Code without save"
        ENDIF
    ENDIF

    IF .NOT. This.lOpen     && if file wasn't already open on startup
        USE IN AreaCode     && then shut it down
    ENDIF

    USE CODES EXCLUS
    DELE FOR CITY=' '
    COUNT FOR DELETED() TO EmpRec
    IF EmpRec<>0
      PACK
    ENDIF
    USE


    Main.App.Are.Enabled=.T.
	 Main.F1.CloseAll.Enabled=.T.
    Main.S.Srch.Enabled=.F.
    Main.S.Tp.Enabled=.F.
    Main.S.Btm.Enabled=.F.
    Main.S.Pck.Enabled=.T.
    Main.S.Indx.Enabled=.T.
    Main.E.Undo.Enabled=.F.
    Main.E.Save.Enabled=.F.
    Main.V.Frm.Enabled=.T.
    Main.F1.Bac.Enabled=.T.


    lVoid = This.Release()
RETURN
******************
FUNCTION FindCode
    SET ORDER TO City
    * Generate a form that will can be used by other procedures
    DO GenForm
    * Make the user select Ok before moving on
    lVoid = Search.sValue.Setfocus()
    lVoid = Search.ReadModal()

RETURN .T.
**********************
PROCEDURE GenForm
    * Define a search form
    DEFINE FORM Search FROM 5,10 TO 11,45 ;
        PROPERTY ;
            Text "Search"

    DEFINE TEXT sVal OF Search AT 1,2 ;             && adjusted column
        PROPERTY ;
            Text "City :"
    DEFINE ENTRYFIELD Svalue OF Search AT 1,9 ;     && adjusted column
        PROPERTY ;
            Width 20                                && fixed entryfield width
    DEFINE PUSHBUTTON sOk OF Search AT 3,12 ;
        PROPERTY ;
            Default .T.,;                           && made OK button the default
            Text    "&OK",;
            Width    10  ,;
            OnClick "CloseMe"
RETURN
*******************
PROCEDURE CloseMe
    CLEAR
    * Get value user entered before closing form
    SearchFor = Search.Svalue.value
    SearchWidth = Search.Width  && See if size is Less than 50

    lVoid = Search.Close()
    * remove from memory
    lVoid = Search.Release()
    IF LEN(SearchFor) > 0
        *Now Search for value given - Exact match
        SEEK(TRIM(SearchFor))

        IF FOUND()
            Area.StatusMessage = "Found City = "+TRIM(SearchFor)
            * repaint the form with the current record
            lVoid = Area.Refresh()
        ELSE
            DO Errormsg WITH "City Not Found ..."+TRIM(SearchFor)
        ENDIF
    ENDIF
RETURN

******************
PROCEDURE PrevHand

    * Check to see that the record pointer is not at Beginning of File
    IF .NOT. BOF()
        lVoid = Form.Submit()
        SKIP -1
        IF BOF()

        ENDIF
        IF DELETED()
           Form.cStatus.Text = "DELETED"
        ELSE
           Form.cStatus.Text = ""
        Endif
        lVoid = Form.Refresh()
    ELSE
        DO ErrorMsg WITH "Top of file!"
    ENDIF
    Form.Action = .F.
RETURN

*******************
PROCEDURE SkipHand

    * Check to see that the record pointer is not end of file
    IF .NOT. EOF()
        lVoid = Form.Submit()
        SKIP
        IF STR(CODE)=' '
         SKIP -1
         DO ERRORMSG WITH "End of file encountered!"
        ENDIF
        * Show user if the record is marked for deletion
        IF DELETED()
           Form.cStatus.Text = "DELETED"
        ELSE
           Form.cStatus.Text = ""
        Endif
        lVoid = Form.Refresh()
    ELSE
        * Record pointer is at the end of file, tell user
        DO ErrorMsg WITH "End of file encountered!"
    ENDIF
    Form.Action = .F.

RETURN
******************
PROCEDURE Add_new
    NewRecord = .T.
    *Write data to disk
    lvoid = Form.submit()
    APPEND BLANK
    *Refresh Screen Data
    lvoid = Form.refresh()
    Form.cStatus.Text=""
RETURN
******************
PROCEDURE DelIt
    IF DELETED()
      Form.cStatus.Text = ""
      RECALL
    ELSE
      Form.cStatus.Text = "DELETED"
      DELETE
    ENDIF

RETURN
*****************
PROCEDURE CanHand
    Form.Action = .F.
    lVoid = Form.Close()
RETURN
******************
PROCEDURE PrintForm

DEFINE FORM Prt FROM 5,25 TO 16,50 ;
    PROPERTY ;
        TEXT "Print Form"

DEFINE TEXT t1 OF Prt AT 1,1 ;
    PROPERTY ;
        Text "Type :",;
        COLORNORMAL "R/W"

DEFINE RADIOBUTTON Rep OF Prt AT 2,1 ;
    PROPERTY ;
        Text "Report",;
        Group .T.,;
        COLORNORMAL "N/W",;
        WIDTH 15

DEFINE RADIOBUTTON Lab OF Prt AT 3,1 ;
    PROPERTY ;
        Text "Labels",;
        Group .F.,;
        COLORDISABLED "N+/W",;
        WIDTH 15,;
        ENABLED .F.,;
        TABSTOP .F.

DEFINE TEXT T3 OF Prt AT 9,5 ;
    PROPERTY ;
        TEXT "PRINTING ..." ,;
        VISIBLE .F.,;
        WIDTH 15

DEFINE PUSHBUTTON P1 OF Prt AT 8,12 ;
    PROPERTY ;
        TEXT "&Ok",;
        ONCLICK "RunRep",;
        Width 10

DEFINE PUSHBUTTON P2 OF Prt AT 8,2 ;
    PROPERTY ;
        TEXT "&Cancel",;
        ONCLICK "CanHand",;
        Width 10

lVoid = Prt.Open()

******************
PROCEDURE Runrep

* Check for Labels or Reports
DO CASE
    CASE Form.Rep.Value
         * display to user something is happening
         Form.T3.Visible = .t.
         REPORT FORM Codes TO PRINTER

ENDCASE
lVoid = Form.Close()
lVoid = Form.Release()
RETURN

