PROCEDURE Acct_Rec
    PRIVATE mFormOpen, lVoid, mDesk, mFormName, mActive, mClass

    IF TYPE("Acct.ClassName") # "C"    && Do only if form doesn't already exist
        mFormOpen=.F.
        DEFINE FORM mTemp PROPERTY VISIBLE .F.
        lVoid = mTemp.OPEN()
        mDesk = mTemp.PARENT
        lVoid = mTemp.CLOSE()

        mFormName=SPACE(8)
        mActive=mDesk.ActiveControl()
        IF TYPE("mActive.ClassName")="C"
            mClass=mActive.ClassName
            IF mClass="FORM"
                mFormName=mActive.Name
                mFormOpen=.T.
            ENDIF
        ENDIF

        #include "Acct_Rec.dfm"
        PUBLIC NewRecord

        NewRecord = .F.       && Initialize Global to form

        Acct.Action = .F.
        lVoid = Acct.Open()
    ELSE
        lVoid = Acct.SetFocus()     && Form exists, make active
    ENDIF
RETURN

PROCEDURE OpenAcct
    PRIVATE lAOpen, lCOpen

    lAOpen = .T.            && Assume ACCT_REC is open
    lCOpen = .T.            && Assume CUST is open

    IF SUBSTR(DBF(),3)<>"ACCT_REC.DBF"
        SELECT SELECT()
        USE Acct_rec ORDER Invoice_No
        lAOpen = .F.        && ACCT_REC was NOT open on startup
    ENDIF
    IF SUBSTR(DBF(),3)<>"CUST.DBF"
        SELECT SELECT()
        USE Cust ORDER Cust_ID ALIAS AcctCust
        lCOpen = .F.        && CUST was NOT open on startup
    ENDIF

    This.lAOpen = lAOpen    && save state of lAOpen in form
    This.lCOpen = lCOpen    && save state of lCOpen in form

    SEEK(Acct_Rec->Cust_Id)
    Acct.CustName.Text = AcctCust->Customer

    SELE Acct_rec

    lVoid = This.Refresh()

    IF .NOT. mFormOpen
        Main.F1.CloseAll.Enabled=.F.
        Main.S.Srch.Enabled=.T.
        Main.S.Tp.Enabled=.T.
        Main.S.Btm.Enabled=.T.
        Main.S.Pck.Enabled=.F.
        Main.S.Indx.Enabled=.F.
        Main.E.Undo.Enabled=.T.
        Main.E.Save.Enabled=.T.
        Main.V.Frm.Enabled=.F.
        Main.App.Cust.Enabled=.F.
        Main.F1.Bac.Enabled=.F.
        Main.App.Are.Enabled=.F.
        Main.App.Inv.Enabled=.F.
    ENDIF
    Main.App.Acc.Enabled=.F.

RETURN

******************
PROCEDURE PrevHand
       IF Form.Modified()
        lVoid = Form.Submit()
       ENDIF
    IF .NOT. BOF()
        SKIP -1
        IF BOF()
          DO ErrorMsg WITH "Top of file!"
        ENDIF
        * Look Up Cust Name
        SELE AcctCust
        SEEK(Acct_rec->Cust_ID)
        Acct.CustName.Text = AcctCust->Customer
        SELE Acct_Rec

        * Show user if the record is marked for deletion
        IF DELETED()
           Form.cStatus.Text = "DELETED"
        ELSE
           Form.cStatus.Text = ""
        Endif

        lVoid = Form.Refresh()
    ELSE
        DO ErrorMsg WITH "Top of file!"
    ENDIF
    Form.Action = .F.
RETURN
*******************
PROCEDURE SkipHand
    IF Form.Modified()
        lVoid = Form.Submit()
    ENDIF
    IF .NOT. EOF()
        SKIP
        IF CUST_ID=' '
         SKIP -1
         DO ERRORMSG WITH "End of file encountered!"
        ENDIF
        * Look Up Customer Name
        SELE AcctCust
        SEEK(Acct_Rec->Cust_ID)
        Acct.CustName.Text = AcctCust->Customer

        SELE Acct_rec

        * Show user if the record is marked for deletion
        IF DELETED()
           Form.cStatus.Text = "DELETED"
        ELSE
           Form.cStatus.Text = ""
        Endif

        lVoid = Form.refresh()
    ELSE
        DO ErrorMsg WITH "End of file encountered!"
    ENDIF
    Form.Action = .F.
RETURN
******************
PROCEDURE CloseAcct
    IF This.Action
        lVoid = This.Submit()
    ELSE
        IF This.Modified()
            DO ErrorMsg WITH "Exit Account Rec without saving ..."
        ENDIF
    ENDIF

    * Close Tables

    IF .NOT. This.lAOpen    && if file was not open when form was created
        USE IN acct_rec     && shut it down
    ENDIF
    IF .NOT. This.lCOpen    && if file was not open when form was created
        USE IN AcctCust     && shut it down
    ENDIF

    USE Acct_Rec EXCLUS
    DELE FOR Invoice_No=' '
    COUNT FOR DELETED() TO EmpRec
    IF EmpRec<>0
      PACK
    ENDIF
    USE

    LVoid = This.Release()
    mFormOpen=.F.
    DEFINE FORM mTemp PROPERTY VISIBLE .F.
    lVoid = mTemp.OPEN()
    mDesk = mTemp.PARENT
    lVoid = mTemp.CLOSE()

    mFormName=SPACE(8)
    mActive=mDesk.ActiveControl()
    IF TYPE("mActive.ClassName")="C"
        mClass=mActive.ClassName
        IF mClass="FORM"
            mFormName=mActive.Name
            mFormOpen=.T.
        ENDIF
    ENDIF

    IF .NOT. mFormOpen
        Main.F1.CloseAll.Enabled=.T.
        Main.S.Srch.Enabled=.F.
        Main.S.Tp.Enabled=.F.
        Main.S.Btm.Enabled=.F.
        Main.S.Pck.Enabled=.T.
        Main.S.Indx.Enabled=.T.
        Main.E.Undo.Enabled=.F.
        Main.E.Save.Enabled=.F.
        Main.V.Frm.Enabled=.T.
        Main.App.Cust.Enabled=.T.
        Main.F1.Bac.Enabled=.T.
        Main.App.Are.Enabled=.F.
        Main.App.Inv.Enabled=.T.
    ENDIF
   Main.App.Acc.Enabled=.T.
   Main.App.Are.Enabled = .T.   && Re-enable Area Codes

******************
FUNCTION DupCheck

    * Check for Duplicates

    If NewRecord
        ? "Checking for Duplicates ..."
        SEEK(This.Value)       && index is on Invoice_ID
        IF FOUND()
            DO ErrorMsg WITH "Duplicate Found, Enter Another ..."+This.Value
            RETURN .F.
        ELSE
            Newrecord = .f.
        ENDIF
    Endif
RETURN .T.

******************
FUNCTION FindPart
    * Generate a form that will can be used by other procedures
    DO GenForm

    * Make the user select Ok before moving on, Give focus
    lVoid = Search.sValue.Setfocus()
    lVoid = Search.ReadModal()
RETURN .T.
**********************
PROCEDURE GenForm
    * Define a search form
    DEFINE FORM Search FROM 5,10 TO 11,45 ;
        PROPERTY ;
            Text "Search"

    DEFINE TEXT sVal OF Search AT 1,5 ;
        PROPERTY ;
            Text "Inv No :"
    DEFINE ENTRYFIELD Svalue OF Search AT 1,14 ;
        PROPERTY ;
            Width 10

    DEFINE PUSHBUTTON sOk OF Search AT 3,12 ;
        PROPERTY ;
            Text "OK",;
				Default .T. ,;
            Width 10  ,;
            OnClick "CloseMe"
RETURN
***********************
PROCEDURE CloseMe
    CLEAR
    * Get value user entered before closing form
    SearchFor = Search.Svalue.value
    SearchWidth = Search.Width  && See if size is Less than 50

    lVoid = Search.Close()
    * remove from memory
    lVoid = Search.Release()

    * Note : If you place this code in the FindLast routine you will
    * have a timing problem where the variable SearchFor has not been
    * Defined before there is a call referencing it.

    IF LEN(SearchFor) > 0
        SEEK(TRIM(SearchFor))
        IF FOUND()
            * Look Up Customer Name
            SELE AcctCust
            SEEK(Acct_rec->Cust_Id)
            Acct.CustName.Text = AcctCust->Customer

            * Switch back to the Acct_rec
            SELE Acct_rec
            lVoid = acct.Refresh()
        ELSE
            DO Errormsg WITH "Invoice ID Not Found ..."+trim(SearchFor)
        ENDIF
    ENDIF


RETURN
******************
PROCEDURE Add_new
    NewRecord = .T.

    *Write data to disk
    lvoid = Form.submit()

    * Append a record
    APPEND BLANK

    * Set the Billing date to today

    Acct.DateOfBill.Value = DATE()

    *Refresh Screen Data
    lvoid = Form.refresh()
RETURN
*****************
PROCEDURE DelIt && Marks record for deletion
    IF DELETED()
      Form.cStatus.Text = ""
      RECALL
    ELSE
      Form.cStatus.Text = "DELETED"
      DELETE
    ENDIF

RETURN
******************
FUNCTION LookupId
    *
    * Validates user input, by bringing up a browse if we can't find
    *
    PRIVATE This, Form
    lReturn = .F.
    SELECT (This.ALIASNAME)  && Custom Property
    IF SEEK( This.Value )    && Value of the current object
    lReturn = .T.
    ELSE
    DEFINE BROWSE LookUp
    Lookup.Top           =  This.Top + 2
    Lookup.Left          =  This.Left
    Lookup.Key           =  "KeyHand"       && Key handlers for user
    Lookup.OnMouseDblClk =  "KeyHand"       && selection in browse
    Lookup.Sizeable      =  .T.
    Lookup.Moveable      =  .T.
    Lookup.MDI           =  .F.
    Lookup.Width         =  77 - This.Left
    Lookup.Alias         =  This.ALIASNAME
    Lookup.StatusMessage =  [Select the desired value and ] + ;
                [press Enter to choose it] ;

    Lookup.Action        = .F.

    lVoid = LookUp.ReadModal()
    IF LookUp.Action
        * Stuff value Field from browse into form, selected by user
        This.Value = acctCust->Cust_ID
        lReturn = .T.
    ELSE
        DO ErrorMsg WITH [Lookup failed: ] + LTRIM( STR( This.Value ) )
    ENDIF

    ENDIF

    * Bring back main dbf file
    SELECT acct_rec

RETURN lReturn
*****************
FUNCTION KeyHand
    IF Event.EventType = 16
    IF Event.KeyValue = 13
        Lookup.Action = .T.
        lVoid = Lookup.Close()
    ENDIF
    ELSE
    IF Event.EventType = 1
        Lookup.Action = .T.
        lVoid = Lookup.Close()
    ENDIF
    ENDIF

RETURN .T.

*****************
PROCEDURE CanHand
    Form.Action = .F.
    lVoid = Form.Close()
RETURN
*****************
PROCEDURE RePaint
    SELE acct_Rec
    lVoid = acct.Refresh()
RETURN
******************
PROCEDURE PrintForm

DEFINE FORM Prt FROM 5,25 TO 16,50 ;
    PROPERTY ;
        TEXT "Print Form"

DEFINE TEXT t1 OF Prt AT 1,1 ;
    PROPERTY ;
        Text "Type :",;
        COLORNORMAL "R/W"

DEFINE RADIOBUTTON Rep OF Prt AT 2,1 ;
    PROPERTY ;
        Text "Report",;
        Group .T.,;
        COLORNORMAL "N/W",;
        WIDTH 15

DEFINE RADIOBUTTON Lab OF Prt AT 3,1 ;
    PROPERTY ;
        Text "Labels",;
        Group .F.,;
        COLORNORMAL "N+/W",;
        WIDTH 15,;
        ENABLED .F.,;
        TABSTOP .F.

DEFINE TEXT T3 OF Prt AT 9,5 ;
    PROPERTY ;
        TEXT "PRINTING ..." ,;
        VISIBLE .F.,;
        WIDTH 15

DEFINE PUSHBUTTON P1 OF Prt AT 8,12 ;
    PROPERTY ;
        TEXT "&Ok",;
        ONCLICK "RunRep",;
        Width 10

DEFINE PUSHBUTTON P2 OF Prt AT 8,2 ;
    PROPERTY ;
        TEXT "&Cancel",;
        ONCLICK "CanHand",;
        Width 10

lVoid = Prt.Open()

******************
PROCEDURE Runrep

    * Check for Labels or Reports
    DO CASE
        CASE Form.Rep.Value
             * display to user something is happening
             Form.T3.Visible = .t.
             REPORT FORM acct_Rec TO PRINTER

    ENDCASE
    lVoid = Form.Close()
    lVoid = Form.Release()
RETURN

