;                      Tic-Tac-Toe
	org $8000
START   sei
	phk             ;GET THE CURRENT BANK AND STORE ON STACK
	plb             ;GET VALUE OFF STACK AND MAKE IT THE CURRENT
			;PRORAMMING BANK
	clc             ;CLEAR CARRY BIT
	xce             ;NATIVE 16 BIT MODE (NO 6502 EMULATION!)
	rep     #$30    ; all registers are 16 bits
	lda.v   #$0000
	tcd             ; clear the direct register (just to make sure)

starloc equ $00 ;w  - location (in vram) of flashing star or box
mode    equ $02 ;b  - game mode (0=easy 1=normal 2=hard)
holdbtn equ $03 ;b  - is a button being held?
staron  equ $04 ;b  - is flashing star or box currently lit up?
squaren equ $05 ;b  - square number (0-8) that cursor is currently on
cursor  equ $06 ;b  - y,x location of cursor (0yyy0xxx) one y and x will be on
aa      equ $07 ;b  - (if used), are these squares holding an X, or O?
ab      equ $08 ;b  - (used only for finding if anyone won yet)
ac      equ $09 ;b          .   .   .
ba      equ $0a ;b          .   .   .
bb      equ $0b ;b          .   .   .
bc      equ $0c ;b          .   .   .
ca      equ $0d ;b          .   .   .
cb      equ $0e ;b          .   .   .
cc      equ $0f ;b          .   .   .
rand    equ $10 ;b  - used to get a random number(where to place O)
winorow equ $11 ;b  - temporary byte to tell what winner sub checks for
playern equ $12 ;b  - which joypad to read from, 1 or 2?
save2p  equ $13 ;w  - place to save staron and cursor, for 2 player mode
won     equ $15 ;4b - score array (indexed by mode, 0-3)
lost    equ $19 ;4b - won, lost, and tied scores kept here
tied    equ $1d ;4b - easy=$1d,normal=$1e,hard=$1f,battle=$20
sfxtmp  equ $21 ;b  - flag used by sfx sub- load first or second sound effect
fade    equ $22 ;b  - how many vbl's for every shade changed, fadein/out loop


;==========================================================================
;=              START OF SNES REGISTER INITIALIZATION                     =
;==========================================================================
;

	   jsr lkm      ; load music into sound processor
	   SEP     #$30 ; X,Y,A are 8 bit numbers
	   ldx #$00     ; clear index x
cmlp       stz $00,x    ; clearing memory
	   inx          ; increment place in memory to write to
	   cpx #$ff     ; see if it cleared ff hex bytes of ram yet
	   bne cmlp     ; go back if not equal
	   LDA #$8F     ; screen off, full brightness
	   STA $2100    ; brightness + screen enable register
	   STZ $2101    ; Sprite register (size + address in VRAM)
	   STZ $2102    ; Sprite registers (address of sprite memory [OAM])
	   STZ $2103    ;    ""                       ""
	   LDA #$00     ; Mode 0
	   STA $2105    ; Graphic mode register
	   STZ $2106    ; Mosaic register
	   LDA #$10     ; Map data at $1000 in VRAM (plane 0)
	   STA $2107    ; Plane 0 map VRAM location
	   LDA #$30     ; Map data at $3000 in VRAM (plane 1)
	   STA $2108    ; Plane 1 map VRAM location
	   STZ $2109    ; Plane 2 map VRAM location
	   STZ $210A    ; Plane 3 map VRAM location
	   LDA #$22     ; Tile graphics for planes 0 and 1 at $2000 in VRAM
	   STA $210B    ; Plane 0+1 Tile data location
	   STZ $210C    ; Plane 2+3 Tile data location
	   STZ $210D    ; Plane 0 scroll x (first 8 bits)
	   STZ $210D    ; Plane 0 scroll x (last 3 bits) #$0 - #$07ff
	   STZ $210E    ; Plane 0 scroll y (first 8 bits)
	   STZ $210E    ; Plane 0 scroll y (last 3 bits) #$0 - #$07ff
	   STZ $210F    ; Plane 1 scroll x (first 8 bits)
	   STZ $210F    ; Plane 1 scroll x (last 3 bits) #$0 - #$07ff
	   STZ $2110    ; Plane 1 scroll y (first 8 bits)
	   STZ $2110    ; Plane 1 scroll y (last 3 bits) #$0 - #$07ff
	   STZ $2111    ; Plane 2 scroll x (first 8 bits)
	   STZ $2111    ; Plane 2 scroll x (last 3 bits) #$0 - #$07ff
	   STZ $2112    ; Plane 2 scroll y (first 8 bits)
	   STZ $2112    ; Plane 2 scroll y (last 3 bits) #$0 - #$07ff
	   STZ $2113    ; Plane 3 scroll x (first 8 bits)
	   STZ $2113    ; Plane 3 scroll x (last 3 bits) #$0 - #$07ff
	   STZ $2114    ; Plane 3 scroll y (first 8 bits)
	   STZ $2114    ; Plane 3 scroll y (last 3 bits) #$0 - #$07ff
	   LDA #$80     ; increase VRAM address after writing to $2119
	   STA $2115    ; VRAM address increment register
	   STZ $211A    ; Initial Mode 7 setting register
	   STZ $211B    ; Mode 7 matrix parameter A register (low)
	   LDA #$01
	   STA $211B    ; Mode 7 matrix parameter A register (high)
	   STZ $211C    ; Mode 7 matrix parameter B register (low)
	   STZ $211C    ; Mode 7 matrix parameter B register (high)
	   STZ $211D    ; Mode 7 matrix parameter C register (low)
	   STZ $211D    ; Mode 7 matrix parameter C register (high)
	   STZ $211E    ; Mode 7 matrix parameter D register (low)
	   STA $211E    ; Mode 7 matrix parameter D register (high)
	   STZ $211F    ; Mode 7 center position X register (low)
	   STZ $211F    ; Mode 7 center position X register (high)
	   STZ $2120    ; Mode 7 center position Y register (low)
	   STZ $2120    ; Mode 7 center position Y register (high)
	   STZ $2121    ; Color number register ($0-ff)
	   STZ $2123    ; BG1 & BG2 Window mask setting register
	   STZ $2124    ; BG3 & BG4 Window mask setting register
	   STZ $2125    ; OBJ & Color Window mask setting register
	   STZ $2126    ; Window 1 left position register
	   STZ $2127    ; Window 2 left position register
	   STZ $2128    ; Window 3 left position register
	   STZ $2129    ; Window 4 left position register
	   STZ $212A    ; BG1, BG2, BG3, BG4 Window Logic register
	   STZ $212B    ; OBJ, Color Window Logic Register (or,and,xor,xnor)
	   LDA #$03     ; Allow planes 0 and 1 to function
	   STA $212C    ; Main Screen designation (planes, sprites enable)
	   STZ $212D    ; Sub Screen designation
	   STZ $212E    ; Window mask for Main Screen
	   STZ $212F    ; Window mask for Sub Screen
	   LDA #$30
	   STA $2130    ; Color addition & screen addition init setting
	   STZ $2131    ; Add/Sub sub designation for screen, sprite, color
	   LDA #$E0
	   STA $2132    ; color data for addition/subtraction
	   STZ $2133    ; Screen setting (interlace x,y/enable SFX-data)
	   STZ $4200    ; Enable V-blank, interrupt, Joypad register
	   LDA #$FF
	   STA $4201    ; Programmable I/O port
	   STZ $4202    ; Multiplicand A
	   STZ $4203    ; Multiplier B
	   STZ $4204    ; Multiplier C
	   STZ $4205    ; Multiplicand C
	   STZ $4206    ; Divisor B
	   STZ $4207    ; Horizontal Count Timer
	   STZ $4208    ; Horizontal Count Timer MSB (most significant bit)
	   STZ $4209    ; Vertical Count Timer
	   STZ $420A    ; Vertical Count Timer MSB
	   STZ $420B    ; General DMA enable (bits 0-7)
	   STZ $420C    ; Horizontal DMA (HDMA) enable (bits 0-7)
	   STZ $420D    ; Access cycle designation (slow/fast rom)
	lda     #$01
	sta     $4200           ; ENABLE JOYPAD READ (which is bit one)
;===========================================================================
;=                       END OF INIT ROUTINE                              =
;===========================================================================
	rep     #$30    ; X,Y,A fixed -> 16 bit mode
	sep     #$20    ; Accumulator ->  8 bit mode
	stz     $2121           ; Set color number to 0 (background)
	stz     $2122           ; enter color value #$00 to color num. (low)
	stz     $2122           ; enter color value #$00 to color num. (high)
	lda     #$ff            ; white color, lower 8 bits
	sta     $2122           ; write to next color number (01)
	sta     $2122           ; enter same value to color number (01)
	lda     #$46            ; pretty blue color, lower 8 bits
	sta     $2122
	lda     #$60            ; pretty blue color, higher 8 bits
	sta     $2122
	lda     #$ff            ; white again
	sta     $2122
	sta     $2122


;==========================================================================
;=                      LOAD UP INTRO SCREEN                              =
;==========================================================================

	jsr     titlmus         ; start the title-screen music
	ldx.v   #$2000          ; Assign VRAM location $2000 to $2116/7
	stx     $2116           ; writing to $2118/9 will store data here!
	ldy.v   #$0000          ; clear the index
copychr lda     charset,y       ; Get CHARACTER SET DATA-(Font DATA)
	sta     $2118           ; store bitplane 1
	sta     $2119           ; store bitplane 2 and increase VRAM address
	iny
	cpy.v   #$0200          ; Transfer $0200 bytes
	bne     copychr         ; just a standard, uninteresting loop

	ldx.v   #$20d8          ; we're going to write to $20d8 in vram
	stx     $2116           ; tell the snes that
	ldy.v   #$0000
copyfix lda     chplan0,y       ; load tile data from data area #1
	sta     $2118           ; write to the vram
	lda     chplan1,y       ; second bitplane data
	sta     $2119
	iny                     ; increase the count of bytes written/read
	cpy.v   #$0070          ; did we write 70 tiles yet?
	bne     copyfix         ; nope?  branch back to write another

	ldx.v   #$3000          ; set 2118/9 to write to $3000 in vram
	stx     $2116           ; this is set to plane 1 map data
	ldy.v   #$0400          ; clearing 400hex tiles
	jsr     zero            ; subroutine to store zeroes (clearing plane)
	ldx.v   #$1000          ; Assign VRAM location $1000 to $2116/7
	stx     $2116
	ldy.v   #$012b          ; store zeroes to save space
	jsr     zero            ; store spaces on top part of screen, so this
	ldx.v   #$0000          ;  next text will write where the spaces stop
introsc lda     intmap,x        ; Get ASCII text data
	and     #$3f            ; we only want the first 64 characters(6 bits)
	sta     $2118           ; write the actual text data
	stz     $2119           ; clear unwanted bits, no H/V flipping
	inx
	cpx.v   #$00E9          ; transfer entire text (branch if not done)
	bne     introsc
	ldy.v   #$018c          ; more zeroes (to save space in map data)
	jsr     zero

	sep     #$30            ; all 3 registers are 8 bit
	lda     #$0e            ; play the title screen music
	sta     $2140           ;  if already playing, it will do nothing
	ldx     #$38
	jsr     waitasec        ; ~2 second pause, while scren is black
	
	lda     #$05            ; go through 6 vbl's before fading one shade
	sta     fade
	jsr     fadein          ; fade the screen in
	
	ldx     #$73           ; fine tune for maximum effect with music
	jsr     waitasec

	jsr     fadeout         ; fade the screen out (still at 6 vbl's/shade)


;==========================================================================
;=                      LOAD UP TITLE SCREEN                              =
;==========================================================================

gototit lda     #$80            ; turn screen off (artificial vertical blank)
	sta     $2100           ; screen control reg.
	rep     #$30            ; X,Y,A fixed -> 16 bit mode
	sep     #$20            ; Accumulator ->  8 bit mode
	ldx.v   #$3000
	stx     $2116
	ldy.v   #$0400          ; clear the top 160(hex) tiles of screen map
	jsr     zero            ; clear intro screen, also set y index to 0
	ldx.v   #$2000          ; we made $2000 vram the tile address
	stx     $2116
copytit lda     titlscn,y       ; copy title screen tile data (font) to vram
	sta     $2118           ; store bitplane 1
	stz     $2119           ; clear bitplane 2 and increase VRAM address
	iny
	cpy.v   #$0348          ; Transfer $0348 bytes, go back if not done
	bne     copytit

	ldx.v   #$1000          ; $1000 - location of plane 0 map data
	stx     $2116
	ldy.v   #$00c3          ; store zeroes to save space
	jsr     zero
	ldx.v   #$0000
titlepg lda     titltxt,x       ; Get text data (map), of title screen
	sta     $2118
	stz     $2119           ; clear unwanted bits, no H/V flipping
	inx
	cpx.v   #$01b9          ; transfer entire map data
	bne     titlepg
	ldy.v   #$006e          ; more zeroes to save space
	jsr     zero
pstart  lda     smtext,y        ; load data from smalltext
	sta     $2118           ; write message "Press START"
	stz     $2119
	iny
	cpy.v   #$000b          ; yes, it's 0b bytes long
	bne     pstart

	sep     #$30            ; all 3 registers are now 8 bit
	lda     #$03            ; fade the title screen in
	sta     fade
	jsr     fadein


;==========================================================================
;=               MAKE THE PRESS START MESSAGE FLASH                       =
;==========================================================================

	rep     #$30            ; X,Y,A fixed -> 16 bit mode
	sep     #$20            ; Accumulator ->  8 bit mode
	lda     #$0e            ; play the title screen music
	sta     $2140           ;  if already playing, it will do nothing
	stz     fade            ; fade is used as a temporary sync for music
	ldx.v   #$001e          ; fine tune for syncing to music
	bra     jmpin           ; used to help sync blinking to music
blinkst ldx.v   #$0022          ; tell jsstart to loop for 22 (hex) vbl's
jmpin   jsr     jsstart         ; routine to check joypad for start press
	cpy.v   #$6502          ; see if start was pressed on joypad
	beq     level           ; go select hardness level if yes
psoff   jsr     vbl             ; we can only write to vram during v-blank
	ldy.v   #$12ea          ; "Press START" message starts at $12ea vram
	sty     $2116
	ldy.v   #$000b          ; message is 0b bytes long
	jsr     zero            ; erase that message (after 22 vbl's)

blinks2 ldx.v   #$0022          ; the jsstart routine goes through x (22h)
	jsr     jsstart         ;  vbl's and detects pressing of start
	cpy.v   #$6502
	beq     level           ; must jump from outside of subroutine
pson    inc     fade            ; inc the count of blinks gone by
	lda     fade
	cmp     #$06            ; fine tune this value to sync to music
	beq     add1vbl         ; go delay another vbl if equal
	jsr     vbl
	ldy.v   #$12ea          ; this time we put the message up
	sty     $2116
	ldy.v   #$0000
psonl   lda     smtext,y
	sta     $2118
	stz     $2119
	iny
	cpy.v   #$000b
	bne     psonl
	bra     blinkst         ; after writing message, go back to the top
add1vbl jsr     vbl
	stz     fade
	bra     pson


;==========================================================================
;=                     LOAD UP LEVEL SELECT SCREEN                        =
;==========================================================================

level   lda     #$1c            ; explosion
	jsr     sfx             ; play sound effect
	lda     #$06            ; song titled ""
	sta     $2140           ; make it play that song now
	lda     #$02            ; change color #2 to bluegreen, #3 to red
	sta     $2121           ; color number register
	lda     #$47            ; bluegreen low byte
	sta     $2122
	lda     #$67            ; bluegreen high byte
	sta     $2122
	lda     #$1f            ; red color (0 b00000 g00000 r11111)
	sta     $2122           ; red low byte
	stz     $2122           ; red high byte

	sep     #$10
	lda     #$01            ; one shade darker every vbl (fast fade-out)
	sta     fade
	jsr     fadeout         ; fade out the title screen
	rep     #$10            ; make x and y 16 bit

	lda     #$80        
	sta     $2100           ; turn screen off to write to vram
	ldx.v   #$2000          ; Assign VRAM location $2000 to $2116/7
	stx     $2116           ; writing to $2118/9 will store data here!
	ldy.v   #$0000
loadcs1 lda     gameset,y       ; Get CHARACTER SET DATA-(Font DATA)
	sta     $2118           ; store bitplane 1
	stz     $2119           ; clear bitplane 2 and increase VRAM address
	iny
	cpy.v   #$0240          ; Transfer $0230 bytes
	bne     loadcs1         ; keep loadin' that charset until done
	
fixbm   lda     gameset,y
	stz     $2118           ; write this part to the bitplanes differently
	sta     $2119           ;  so it will be a different color
	iny
	cpy.v   #$0268
	bne     fixbm

fixsc   lda     gameset,y
	sta     $2118           ; same idea
	sta     $2119
	iny
	cpy.v   #$0340
	bne     fixsc
	
	
	ldx.v   #$21d8          ; the star is exactly at $21d8 in vram
	stx     $2116
	
	lda     #$18
	sta     $2118           ; Loading the star character on both
	sta     $2119           ; bitplanes, to save the trouble
	lda     #$18            ; of another loop. (doing it on both planes
	sta     $2118           ; so it will be color #4, red.)
	sta     $2119
	lda     #$ff
	sta     $2118
	sta     $2119
	lda     #$7e
	sta     $2118
	sta     $2119
	lda     #$3c
	sta     $2118
	sta     $2119
	lda     #$7e
	sta     $2118
	sta     $2119
	lda     #$66
	sta     $2118
	sta     $2119
	lda     #$81
	sta     $2118
	sta     $2119
	
	ldy.v   #$0110
	ldx.v   #$2110
	stx     $2116
fixxo   lda     gameset,y       ; this is writing the X, O, and cursor-box
	stz     $2118           ; to the bitplanes of the tile data as
	sta     $2119           ; color 01, which is yellow on plane 0 and
	iny                     ; white on plane 1
	cpy.v   #$01d8
	bne     fixxo

modesel ldx.v   #$1000          ; Assign VRAM location $1000 to $2116/7
	stx     $2116
	ldy.v   #$014b          ; store zeroes to save space
	jsr     zero
gamesc  lda     windowt,y       ; Get map data for the "game mode window"
	sta     $2118
	stz     $2119           ; clear unwanted bits, no H/V flipping
	iny
	cpy.v   #$00ec          ; transfer entire window
	bne     gamesc

	jmp     pastdat         ; Needed to jump past the data area


;============================================================================
;=                          DATA                                            =
;============================================================================

 dcb "<- End of code, beginning of tile data ->"

starchr dcb     $18,$18,$ff,$7e,$3c,$7e,$66,$81
charset dcb     $00,$00,$00,$00,$00,$00,$00,$00 ;'@'
	
	dcb     $18,$24,$66,$66,$7e,$66,$66,$00 ;A
	dcb     $7c,$66,$66,$7c,$66,$66,$7c,$00 ;B
	dcb     $3c,$66,$60,$60,$60,$66,$3c,$00 ;C
	dcb     $7c,$66,$66,$66,$66,$66,$7c,$00 ;D
	dcb     $7e,$60,$60,$7c,$60,$60,$7e,$00 ;E
	dcb     $7e,$60,$60,$7c,$60,$60,$60,$00 ;F
	dcb     $3c,$66,$60,$6e,$66,$66,$3a,$00 ;G
	dcb     $66,$66,$66,$7e,$66,$66,$66,$00 ;H
	dcb     $3c,$18,$18,$18,$18,$18,$3c,$00 ;I
	dcb     $1e,$0c,$0c,$0c,$0c,$6c,$38,$00 ;J
	dcb     $66,$6c,$78,$70,$78,$6c,$66,$00 ;K
	dcb     $60,$60,$60,$60,$60,$60,$7e,$00 ;L
	dcb     $46,$6e,$7e,$7e,$56,$46,$46,$00 ;M
	dcb     $62,$72,$7a,$5e,$4e,$46,$42,$00 ;N
	dcb     $3c,$66,$66,$66,$66,$66,$3c,$00 ;O
	dcb     $7c,$66,$66,$66,$7c,$60,$60,$00 ;P
	dcb     $3c,$66,$66,$66,$76,$6c,$3a,$00 ;Q
	dcb     $7c,$66,$66,$7c,$78,$6c,$66,$00 ;R
	dcb     $3c,$66,$60,$3c,$06,$66,$3c,$00 ;S
	dcb     $7e,$18,$18,$18,$18,$18,$18,$00 ;T
	dcb     $66,$66,$66,$66,$66,$66,$3c,$00 ;U
	dcb     $66,$66,$66,$66,$24,$3c,$18,$00 ;V
	dcb     $46,$56,$56,$56,$7e,$2c,$2c,$00 ;W
	dcb     $66,$66,$3c,$18,$3c,$66,$66,$00 ;X
	dcb     $66,$66,$66,$3c,$18,$18,$18,$00 ;Y
	dcb     $7e,$06,$0c,$18,$30,$60,$7e,$00 ;Z
	
chplan0 dcb     $00,$00,$00,$03,$04,$08,$10,$10 ;'[' 0:0
	dcb     $00,$00,$00,$FF,$00,$00,$00,$00 ;'\' 0:1,2
	dcb     $00,$00,$00,$40,$20,$10,$08,$08 ;']' 0:3
	dcb     $10,$13,$13,$10,$10,$10,$10,$10 ;'^' 1:0
	dcb     $00,$fc,$fc,$60,$60,$60,$60,$60 ;'_' 1:1
	dcb     $00,$0f,$1f,$38,$30,$30,$38,$3f ;' ' 1:2
	dcb     $08,$c8,$c8,$c8,$48,$08,$08,$88 ;'!' 1:3
	dcb     $10,$10,$10,$10,$10,$10,$10,$10 ;'"' 2:0
	dcb     $60,$60,$60,$60,$60,$60,$60,$00 ;'#' 2:1
	dcb     $1f,$01,$00,$20,$31,$3f,$3f,$00 ;'$' 2:2
	dcb     $c8,$c8,$c8,$c8,$c8,$88,$08,$08 ;'%' 2:3
	dcb     $10,$10,$08,$04,$03,$00,$00,$00 ;'&' 3:0
	dcb     $00,$00,$00,$00,$ff,$00,$00,$00 ;''' 3:1,2
	dcb     $08,$08,$10,$20,$c0,$00,$00,$00 ;'(' 3:3
	dcb     $00,$18,$00,$18,$18,$18,$18,$00 ;i ')'
	dcb     $00,$00,$7c,$56,$56,$56,$56,$00 ;m '*'
	dcb     $00,$00,$3c,$26,$26,$26,$26,$00 ;n '+'
	dcb     $00,$00,$7c,$66,$66,$7c,$60,$60 ;p ','
	dcb     $00,$00,$66,$66,$3e,$06,$3c,$00 ;y '-'
	dcb     $00,$00,$3c,$66,$66,$66,$3c,$00 ;o '.'
	dcb     $00,$0e,$18,$7e,$18,$18,$18,$00 ;f '/'
	dcb     $00,$00,$18,$7e,$18,$18,$18,$00 ;t '0'
	dcb     $00,$00,$2e,$38,$30,$30,$30,$00 ;r '1'
	dcb     $00,$00,$3c,$60,$3c,$06,$3c,$00 ;s '2'
	dcb     $00,$00,$3c,$66,$7e,$60,$3c,$00 ;e '3'
	
	dcb     $00,$0e,$1e,$36,$7f,$06,$06,$00 ;'4'
	dcb     $00,$7e,$60,$7c,$06,$66,$3c,$00 ;'5'
	dcb     $00,$3e,$60,$7c,$66,$66,$3c,$00 ;'6'
	dcb     $00,$7e,$06,$0c,$0c,$0c,$0c,$00 ;'7'
	dcb     $00,$3c,$66,$3c,$66,$66,$3c,$00 ;'8'
	dcb     $00,$3c,$66,$3e,$06,$66,$3c,$00 ;'9'
	dcb     $01,$01,$01,$01,$01,$01,$01,$01 ;':'
	dcb     $02,$01,$00,$00,$00,$00,$00,$00 ;';'
	dcb     $00,$00,$80,$40,$20,$18,$06,$01 ;'<'
	dcb     $00,$00,$01,$02,$04,$18,$60,$80 ;'='
	dcb     $40,$80,$00,$00,$00,$00,$00,$00 ;'>'
	dcb     $1F,$0F,$0F,$0F,$07,$03,$00,$00 ;'?'


chplan1 dcb     $00,$00,$00,$00,$03,$07,$0f,$0f ;0:0
	dcb     $00,$00,$00,$00,$ff,$ff,$ff,$ff ;0:1/2
	dcb     $00,$00,$00,$80,$c0,$e0,$f0,$f0 ;0:3
	dcb     $0f,$0a,$0a,$0f,$0f,$0f,$0f,$0f ;1:0
	dcb     $ff,$02,$02,$9f,$9f,$9f,$9f,$9f ;1:1
	dcb     $ff,$f0,$e0,$c7,$cf,$cf,$c7,$c0 ;1:2
	dcb     $f0,$30,$30,$30,$b0,$f0,$f0,$70 ;1:3
	dcb     $0f,$0f,$0f,$0f,$0f,$0f,$0f,$0f ;2:0
	dcb     $9f,$9f,$9f,$9f,$9f,$9f,$9f,$ff ;2:1
	dcb     $e0,$fe,$ff,$df,$ce,$c0,$c0,$ff ;2:2
	dcb     $30,$30,$30,$30,$30,$70,$f0,$f0 ;2:3
	dcb     $0f,$0f,$07,$03,$00,$00,$00,$00 ;3:0
	dcb     $ff,$ff,$ff,$ff,$00,$00,$00,$00 ;3:1/2
	dcb     $f0,$f0,$e0,$c0,$00,$00,$00,$00 ;3:3

titlscn dcb     $00,$00,$00,$00,$00,$00,$00,$00 ;0
	dcb     $ff,$ff,$ff,$ff,$ff,$ff,$ff,$ff ;1
	dcb     $01,$03,$07,$0f,$0f,$07,$03,$01 ;2
	dcb     $80,$c0,$e0,$f0,$f0,$e0,$c0,$80 ;3
	dcb     $07,$03,$01,$00,$00,$00,$00,$00 ;4
	dcb     $e0,$c0,$80,$00,$00,$00,$00,$00 ;5
	dcb     $ff,$ff,$ff,$ff,$ff,$7e,$3c,$18 ;6
	dcb     $00,$00,$00,$00,$00,$80,$c0,$e0 ;7
	dcb     $00,$00,$00,$00,$00,$01,$03,$07 ;8
	dcb     $00,$00,$00,$00,$00,$01,$01,$01 ;9
	dcb     $01,$0f,$3f,$7f,$ff,$ff,$ff,$ff ;10
	dcb     $80,$f0,$fc,$fe,$ff,$ff,$ff,$ff ;11
	dcb     $00,$00,$00,$00,$00,$80,$80,$c0 ;12
	dcb     $03,$07,$07,$07,$0f,$0f,$0f,$0f ;13
	dcb     $ff,$ff,$fe,$fc,$fc,$f8,$f8,$f0 ;14
	dcb     $c3,$00,$00,$00,$00,$00,$00,$00 ;15
	dcb     $ff,$ff,$7f,$3f,$0e,$00,$00,$00 ;16
	dcb     $c0,$c0,$80,$00,$00,$00,$00,$00 ;17
	dcb     $0f,$0f,$0f,$0f,$07,$07,$07,$03 ;18
	dcb     $f0,$f8,$f8,$fc,$fc,$fe,$ff,$ff ;19
	dcb     $00,$00,$00,$00,$00,$00,$00,$c3 ;20
	dcb     $00,$00,$00,$0e,$3f,$7f,$ff,$ff ;21
	dcb     $00,$00,$00,$00,$00,$80,$c0,$c0 ;22
	dcb     $01,$01,$01,$00,$00,$00,$00,$00 ;23
	dcb     $ff,$ff,$ff,$ff,$7f,$3f,$0f,$01 ;24
	dcb     $ff,$ff,$ff,$ff,$fe,$fc,$f0,$80 ;25
	dcb     $c0,$80,$80,$00,$00,$00,$00,$00 ;26
	dcb     $00,$00,$00,$00,$00,$80,$80,$80 ;27
	dcb     $ff,$ff,$7f,$3f,$3f,$1f,$1f,$0f ;28
	dcb     $c0,$e0,$e0,$e0,$f0,$f0,$f0,$f0 ;29
	dcb     $0f,$1f,$1f,$3f,$3f,$7f,$ff,$ff ;30
	dcb     $f0,$f0,$f0,$f0,$e0,$e0,$e0,$c0 ;31
	dcb     $ff,$ff,$ff,$ff,$fe,$fc,$f0,$80 ;32
	dcb     $80,$80,$80,$00,$00,$00,$00,$00 ;33
	dcb     $01,$03,$07,$07,$0f,$0f,$0f,$0f ;34
	dcb     $0f,$0f,$0f,$0f,$0f,$0f,$0f,$0f ;35
	dcb     $f8,$fc,$fe,$ff,$ff,$fe,$fc,$f8 ;36
	dcb     $f8,$f0,$f0,$f8,$ff,$ff,$ff,$ff ;37
	dcb     $00,$00,$00,$00,$ff,$ff,$ff,$ff ;38
	dcb     $ff,$ff,$ff,$ff,$00,$00,$00,$00 ;39
	dcb     $00,$00,$00,$00,$80,$c0,$e0,$f0 ;40
	dcb     $f0,$e0,$c0,$80,$00,$00,$00,$00 ;41
	dcb     $ff,$ff,$ff,$ff,$f8,$f0,$f0,$f8 ;42
	dcb     $0f,$0f,$0f,$0f,$07,$07,$03,$01 ;43
	dcb     $00,$00,$00,$01,$03,$03,$07,$07 ;44
	dcb     $3c,$7e,$ff,$ff,$ff,$ff,$ff,$ff ;45
	dcb     $00,$00,$00,$80,$c0,$c0,$e0,$e0 ;46
	dcb     $07,$0f,$0f,$0f,$1f,$1f,$1f,$3f ;47
	dcb     $ff,$ff,$ff,$ff,$ff,$ff,$e7,$e7 ;48
	dcb     $e0,$f0,$f0,$f0,$f8,$f8,$f8,$fc ;49
	dcb     $1f,$3f,$7f,$7f,$ff,$ff,$ff,$ff ;50
	dcb     $c3,$c3,$81,$81,$00,$ff,$ff,$ff ;51
	dcb     $fc,$fe,$fe,$fe,$ff,$ff,$ff,$ff ;52
	dcb     $01,$01,$01,$03,$03,$07,$07,$03 ;53
	dcb     $ff,$ff,$ff,$ff,$ff,$fc,$fc,$f8 ;54
	dcb     $ff,$ff,$ff,$ff,$ff,$00,$00,$00 ;55
	dcb     $ff,$ff,$ff,$ff,$ff,$3f,$3f,$1f ;56
	dcb     $80,$80,$80,$c0,$c0,$e0,$e0,$c0 ;57
	dcb     $00,$00,$00,$00,$3f,$7f,$ff,$ff ;58
	dcb     $00,$00,$00,$00,$fc,$fe,$ff,$ff ;59
	dcb     $ff,$ff,$7f,$3f,$00,$00,$00,$00 ;60
	dcb     $ff,$ff,$fe,$fc,$00,$00,$00,$00 ;61
	dcb     $00,$00,$3c,$66,$7e,$60,$3c,$00 ;e
	dcb     $00,$00,$00,$00,$00,$00,$00,$00 ;'@'
	dcb     $00,$00,$3c,$60,$3c,$06,$3c,$00 ;s
	dcb     $00,$00,$2e,$38,$30,$30,$30,$00 ;r
	
	dcb     $18,$24,$66,$66,$7e,$66,$66,$00 ;A
	dcb     $7c,$66,$66,$7c,$66,$66,$7c,$00 ;B
	dcb     $3c,$66,$60,$60,$60,$66,$3c,$00 ;C
	dcb     $7c,$66,$66,$66,$66,$66,$7c,$00 ;D
	dcb     $7e,$60,$60,$7c,$60,$60,$7e,$00 ;E
	dcb     $7e,$60,$60,$7c,$60,$60,$60,$00 ;F
	dcb     $3c,$66,$60,$6e,$66,$66,$3a,$00 ;G
	dcb     $66,$66,$66,$7e,$66,$66,$66,$00 ;H
	dcb     $3c,$18,$18,$18,$18,$18,$3c,$00 ;I
	dcb     $1e,$0c,$0c,$0c,$0c,$6c,$38,$00 ;J
	dcb     $66,$6c,$78,$70,$78,$6c,$66,$00 ;K
	dcb     $60,$60,$60,$60,$60,$60,$7e,$00 ;L
	dcb     $46,$6e,$7e,$7e,$56,$46,$46,$00 ;M
	dcb     $62,$72,$7a,$5e,$4e,$46,$42,$00 ;N
	dcb     $3c,$66,$66,$66,$66,$66,$3c,$00 ;O
	dcb     $7c,$66,$66,$66,$7c,$60,$60,$00 ;P
	dcb     $3c,$66,$66,$66,$76,$6c,$3a,$00 ;Q
	dcb     $7c,$66,$66,$7c,$78,$6c,$66,$00 ;R
	dcb     $3c,$66,$60,$3c,$06,$66,$3c,$00 ;S
	dcb     $7e,$18,$18,$18,$18,$18,$18,$00 ;T
	dcb     $66,$66,$66,$66,$66,$66,$3c,$00 ;U
	dcb     $66,$66,$66,$66,$24,$3c,$18,$00 ;V
	dcb     $46,$56,$56,$56,$7e,$2c,$2c,$00 ;W
	dcb     $66,$66,$3c,$18,$3c,$66,$66,$00 ;X
	dcb     $66,$66,$66,$3c,$18,$18,$18,$00 ;Y
	dcb     $7e,$06,$0c,$18,$30,$60,$7e,$00 ;Z

	

gameset dcb     $00,$00,$00,$00,$00,$00,$00,$00 ;0 $00
	dcb     $00,$00,$00,$01,$06,$08,$08,$10 ;1 - window tiles, not
	dcb     $00,$00,$00,$ff,$00,$00,$00,$00 ;2    actual numbers
	dcb     $00,$00,$00,$80,$60,$10,$10,$08 ;3
	dcb     $10,$10,$10,$10,$10,$10,$10,$10 ;4
	dcb     $08,$08,$08,$08,$08,$08,$08,$08 ;5
	dcb     $10,$08,$08,$06,$01,$00,$00,$00 ;6
	dcb     $00,$00,$00,$00,$ff,$00,$00,$00 ;7
	dcb     $08,$10,$10,$60,$80,$00,$00,$00 ;8
	 
	 
	dcb     $00,$00,$3c,$06,$3e,$66,$3b,$00 ;a $09
	dcb     $00,$06,$06,$3e,$66,$66,$3e,$00 ;d $0a
	dcb     $7e,$60,$60,$7c,$60,$60,$7e,$00 ;E
	dcb     $3c,$66,$60,$6e,$66,$66,$3a,$00 ;G
	dcb     $66,$66,$66,$7e,$66,$66,$66,$00 ;H
	dcb     $00,$18,$18,$18,$18,$18,$18,$00 ;l
	dcb     $00,$00,$7c,$56,$56,$56,$56,$00 ;m $0f
	dcb     $62,$72,$7a,$5e,$4e,$46,$42,$00 ;N $10
	dcb     $00,$00,$3c,$66,$66,$66,$3c,$00 ;o
	dcb     $00,$00,$2e,$38,$30,$30,$30,$00 ;r
	dcb     $3c,$66,$60,$3c,$06,$66,$3c,$00 ;S
	dcb     $66,$66,$66,$3c,$18,$18,$18,$00 ;Y
	dcb     $00,$00,$60,$60,$00,$60,$60,$00 ;:
	dcb     $00,$18,$3c,$7e,$7e,$7e,$7e,$7e ;22 $16
	dcb     $7e,$7e,$7e,$7e,$7e,$7e,$7e,$7e ;23
	dcb     $00,$1f,$3f,$7f,$7f,$3f,$1f,$00 ;24
	dcb     $00,$ff,$ff,$ff,$ff,$ff,$ff,$00 ;25
	dcb     $ff,$ff,$ff,$ff,$ff,$ff,$ff,$ff ;26
	dcb     $00,$f8,$fc,$fe,$fe,$fc,$f8,$00 ;27
	dcb     $7e,$7e,$7e,$7e,$7e,$3c,$18,$00 ;28
	dcb     $00,$00,$66,$66,$66,$66,$3e,$00 ;u $1d
	dcb     $00,$18,$00,$18,$18,$18,$18,$00 ;i
	dcb     $00,$00,$56,$56,$56,$56,$7c,$00 ;w
	dcb     $7c,$66,$66,$66,$7c,$60,$60,$00 ;P
	dcb     $3c,$66,$06,$0c,$18,$00,$18,$00 ;?
	dcb     $00,$1c,$3e,$7f,$7f,$7f,$3f,$1f ;34 upper left of X $22
	dcb     $00,$00,$00,$00,$81,$c3,$e7,$ff ;35  /
	dcb     $00,$38,$7c,$fe,$fe,$fe,$fc,$f8 ;36 /
	dcb     $0f,$07,$03,$01,$01,$03,$07,$0f ;37 left side of X
	dcb     $ff,$ff,$ff,$ff,$ff,$ff,$ff,$ff ;38  /
	dcb     $f0,$e0,$c0,$80,$80,$c0,$e0,$f0 ;39 /
	dcb     $1f,$3f,$7f,$7f,$7f,$3e,$1c,$00 ;40 lower row of X
	dcb     $ff,$e7,$c3,$81,$00,$00,$00,$00 ;41  /
	dcb     $f8,$fc,$fe,$fe,$fe,$7c,$38,$00 ;42 /
	dcb     $00,$01,$07,$0f,$1f,$3f,$3f,$7f ;43 upper left of O
	dcb     $7e,$ff,$ff,$ff,$ff,$ff,$81,$00 ;44  /
	dcb     $00,$80,$e0,$f0,$f8,$fc,$fc,$fe ;45 /
	dcb     $7e,$fc,$fc,$fc,$fc,$fc,$fc,$7e ;46 left side of O
	dcb     $7e,$3f,$3f,$3f,$3f,$3f,$3f,$7e ;47 /
	dcb     $7f,$3f,$3f,$1f,$0f,$07,$01,$00 ;48 lower row of O
	dcb     $00,$81,$ff,$ff,$ff,$ff,$ff,$7e ;49  /
	dcb     $fe,$fc,$fc,$f8,$f0,$e0,$80,$00 ;50 /
	dcb     $00,$00,$00,$00,$00,$00,$00,$00 ;51
	dcb     $00,$00,$00,$1f,$1f,$18,$18,$18 ;   52 $34
	dcb     $00,$00,$00,$f8,$f8,$18,$18,$18 ;   53
	dcb     $18,$18,$18,$ff,$ff,$18,$18,$18 ; +  54
	dcb     $18,$18,$18,$1f,$1f,$00,$00,$00 ;   55
	dcb     $18,$18,$18,$f8,$f8,$00,$00,$00 ;   56
	dcb     $18,$18,$18,$18,$18,$18,$18,$18 ; l   57
	dcb     $00,$00,$00,$ff,$ff,$00,$00,$00 ; --  58
	dcb     $ff,$ff,$ff,$ff,$ff,$ff,$ff,$ff ; leave for star $3b
	dcb     $00,$00,$3c,$66,$66,$3e,$06,$3c ;g
	dcb     $00,$00,$3c,$66,$7e,$60,$3c,$00 ;e
	dcb     $00,$00,$3c,$26,$26,$26,$26,$00 ;n
	dcb     $00,$00,$3c,$60,$3c,$06,$3c,$00 ;s
	dcb     $00,$00,$66,$66,$3e,$06,$3c,$00 ;y
	dcb     $18,$18,$18,$18,$18,$00,$18,$00 ;! $41
	dcb     $7c,$66,$66,$7c,$66,$66,$7c,$00 ;B
	dcb     $46,$6e,$7e,$7e,$56,$46,$46,$00 ;M
	dcb     $00,$00,$18,$7e,$18,$18,$18,$00 ;t
	dcb     $00,$75,$27,$25,$00,$00,$00,$00 ;<TM>
	dcb     $00,$00,$38,$18,$18,$18,$18,$00 ;1
	dcb     $00,$00,$3c,$66,$1c,$30,$7e,$00 ;2

	dcb     $7c,$66,$66,$7c,$66,$66,$7c,$00 ;B $46
	dcb     $00,$00,$3c,$06,$3e,$66,$3b,$00 ;a
	dcb     $00,$00,$18,$7e,$18,$18,$18,$00 ;t
	dcb     $00,$18,$18,$18,$18,$18,$18,$00 ;l
	dcb     $00,$00,$3c,$66,$7e,$60,$3c,$00 ;e $4a

	dcb     $7c,$66,$66,$66,$7c,$60,$60,$00 ;P $4d
	dcb     $00,$18,$18,$18,$18,$18,$18,$00 ;l
	dcb     $00,$00,$3c,$06,$3e,$66,$3b,$00 ;a $4f
	dcb     $00,$00,$66,$66,$3e,$06,$3c,$00 ;y $50
	dcb     $00,$00,$3c,$66,$7e,$60,$3c,$00 ;e
	dcb     $00,$00,$2e,$38,$30,$30,$30,$00 ;r
	dcb     $3c,$66,$60,$60,$60,$66,$3c,$00 ;C
	dcb     $00,$00,$3c,$66,$66,$66,$3c,$00 ;o
	dcb     $00,$00,$7c,$56,$56,$56,$56,$00 ;m
	dcb     $00,$00,$7c,$66,$66,$7c,$60,$60 ;p
	dcb     $00,$00,$66,$66,$66,$66,$3e,$00 ;u
	dcb     $00,$00,$18,$7e,$18,$18,$18,$00 ;t
	dcb     $00,$00,$60,$60,$00,$60,$60,$00 ;:
	dcb     $00,$00,$56,$56,$56,$56,$7c,$00 ;w $5a
	dcb     $00,$00,$3c,$26,$26,$26,$26,$00 ;n
	dcb     $00,$00,$3c,$60,$3c,$06,$3c,$00 ;s
	dcb     $00,$18,$00,$18,$18,$18,$18,$00 ;i
	dcb     $00,$06,$06,$3e,$66,$66,$3e,$00 ;d
	dcb     $00,$00,$3c,$66,$66,$66,$3c,$00 ;0 $5f  - actual numbers here
	dcb     $00,$00,$38,$18,$18,$18,$18,$00 ;1
	dcb     $00,$00,$3c,$66,$1c,$30,$7e,$00 ;2
	dcb     $00,$00,$7c,$06,$1c,$06,$7c,$00 ;3
	dcb     $00,$00,$1c,$2c,$4c,$7e,$0c,$00 ;4
	dcb     $00,$00,$7c,$60,$7c,$06,$7c,$00 ;5
	dcb     $00,$00,$3c,$60,$7c,$66,$3c,$00 ;6
	dcb     $00,$00,$7e,$66,$0c,$18,$18,$00 ;7
	dcb     $00,$00,$3c,$66,$3c,$66,$3c,$00 ;8
	dcb     $00,$00,$3c,$66,$3e,$06,$3c,$00 ;9

 dcb "<- End of tile data, beginning of map data ->"

TITLTXT dcb     $02,$01,$01,$01,$03,$02,$01,$01 ;TIC 1/4
	dcb     $01,$03,$09,$0a,$01,$0b,$0c
	dcb     "?????????????????"
	dcb     $00,$04,$01,$05,$00,$00,$04,$01 ;TIC 2/4
	dcb     $05,$00,$0d,$0e,$0f,$10,$11,$3a,$3b
	dcb     "???????????????"
	dcb     $00,$00,$01,$00,$00,$00,$08,$01 ;TIC 3/4
	dcb     $07,$00,$12,$13,$14,$15,$16,$3c,$3d
	dcb     "???????????????"
	dcb     $00,$00,$06,$00,$00,$02,$01,$01 ;TIC 4/4
	dcb     $01,$03,$17,$18,$01,$19,$1a
	dcb     "??????????????????????"
	dcb     "????????????????????????????????"
	dcb     $02,$01,$01,$01,$03,$00,$2c,$2d ;TAC 1/4
	dcb     $2e,$00,$09,$0a,$01,$0b,$0c
	dcb     "?????????????????"
	dcb     $00,$04,$01,$05,$00,$00,$2f,$30 ;TAC 2/4
	dcb     $31,$00,$0d,$0e,$0f,$10,$11,$3a,$3b
	dcb     "???????????????"
	dcb     $00,$00,$01,$00,$00,$00,$32,$33 ;TAC 3/4
	dcb     $34,$00,$12,$13,$14,$15,$16,$3c,$3d
	dcb     "???????????????"
	dcb     $00,$00,$06,$00,$00,$35,$36,$37 ;TAC 4/4
	dcb     $38,$39,$17,$18,$01,$19,$1a
	dcb     "??????????????????????"
	dcb     "????????????????????????????????"
	dcb     $02,$01,$01,$01,$03,$09,$0a,$01 ;TOE 1/4
	dcb     $0b,$1b,$22,$01,$01,$24,$00
	dcb     "?????????????????"
	dcb     $00,$04,$01,$05,$00,$0d,$0e,$0f ;TOE 2/4
	dcb     $1c,$1d,$23,$25,$26,$28,$00
	dcb     "?????????????????"
	dcb     $00,$00,$01,$00,$00,$12,$13,$14 ;TOE 3/4
	dcb     $1e,$1f,$23,$2a,$27,$29,$00
	dcb     "?????????????????"
	dcb     $00,$00,$06,$00,$00,$17,$18,$01 ;TOE 4/4
	dcb     $20,$21,$2b,$01,$01,$24,$00

intmap  dcb     "["
	dcb     $5c,$5c
	dcb     "]@@@@@@@@@@@@@@@@@"
	dcb     "@@@@@@@@@@@^_ !@@T)*@@@@@@@@@@@@"
	DCB     "@@@@@@@@@@@"
	dcb     $22
	dcb     "#$%@@S./0@@@@@@@@@@@"
	dcb     "@@@@@@@@@@@&''(@@@@@@@@@@@@@@@@@"
	DCB     "@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@"
	dcb     "@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@"
	DCB     "@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@"
	DCB     "@@@@@@@@@@@@,1323+02"

smtext  dcb     "QA>@@?TUBSU"

introt1 dcb     "ABCD@@@@@@@@@@@@@@@@@@@@@@@@@@@@"
	dcb     "EFGH@@@@@@@@@@@@@@@@@@@@@@@@@@@@"
	dcb     "IJKL@@@@@@@@@@@@@@@@@@@@@@@@@@@@"
	dcb     "MNOP"

windowt dcb     $01,$02,$02,$02,$02,$02,$02,$02,$02,$02,$02,$03
	dcb     "33333333333333333333"
	dcb     $04,$0c,$09,$0f,$3d
dmodet  dcb     $00,$0f,$11,$0a,$3d,$15,$05
	dcb     "33333333333333333333"
	dcb     $04,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$05
	dcb     "33333333333333333333"
	dcb     $04,$00
deasyt  dcb     $0b,$09,$3f,$40,$00,$00,$00,$00,$00,$05
	dcb     "33333333333333333333"
	dcb     $04,$3b
dnormt  dcb     $10,$11,$12,$0f,$09,$0e,$00,$00,$00,$05
	dcb     "33333333333333333333"
	dcb     $04,$00
dhardt  dcb     $0d,$09,$12,$0a,$00,$00,$00,$00,$00,$05
	dcb     "33333333333333333333"
	dcb     $04,$00,$48,$49,$4a,$4a,$4b,$4c,$00,$00,$00,$05
	dcb     "33333333333333333333"
	dcb     $06,$07,$07,$07,$07,$07,$07,$07,$07,$07,$07,$08

playtxt dcb     $33,$33,$33,$16,$33,$33,$33,$16,$33,$33,$33,$33
	dcb     "33333333333333333333"
	dcb     $33,$33,$33,$17,$33,$33,$33,$17,$33,$33,$33,$33
	dcb     "33333333333333333333"
	dcb     $33,$33,$33,$17,$33,$33,$33,$17,$33,$33,$33,$33
	dcb     "33333333333333333333"
	dcb     $18,$19,$19,$1a,$19,$19,$19,$1a,$19,$19,$1b,$33
	dcb     "33333333333333333333"
	dcb     $33,$33,$33,$17,$33,$33,$33,$17,$33,$33,$33,$33
	dcb     "33333333333333333333"
	dcb     $33,$33,$33,$17,$33,$33,$33,$17,$33,$33,$33,$33
	dcb     "33333333333333333333"
	dcb     $33,$33,$33,$17,$33,$33,$33,$17,$33,$33,$33,$33
	dcb     "33333333333333333333"
	dcb     $18,$19,$19,$1a,$19,$19,$19,$1a,$19,$19,$1b,$33
	dcb     "33333333333333333333"
	dcb     $33,$33,$33,$17,$33,$33,$33,$17,$33,$33,$33,$33
	dcb     "33333333333333333333"
	dcb     $33,$33,$33,$17,$33,$33,$33,$17,$33,$33,$33,$33
	dcb     "33333333333333333333"
	dcb     $33,$33,$33,$1c,$33,$33,$33,$1c,$33,$33,$33,$33
	dcb     "33333333333333333333"

box     dcb     $34,$3a,$35
	dcb     "33333333333333333333333333333"
	dcb     $39,$36,$39
	dcb     "33333333333333333333333333333"
	dcb     $37,$3a,$38

nwtxt   dcb     $10,$11,$33,$1f,$1e,$3e,$3e,$3d,$12  ;"No winner"
xwtxt   dcb     $14,$11,$1d,$33,$1f,$1e,$3e  ;"You win"
owtxt   dcb     $14,$11,$1d,$33,$0e,$11,$3f,$3d  ;"You lose"
platxt  dcb     $20,$0e,$09,$40,$3d,$12,$00  ;"Player"
winstxt dcb     $00,$1f,$1e,$3e,$3f  ;"wins"
battxt  dcb     $42,$09,$44,$44,$0e,$3d,$33,$43,$11,$0a,$3d,$45 ;"Battle Mode<TM>"

pl1txt  dcb     $4d,$4e,$4f,$50,$51,$52,$33,$60  ;"Player 1"
comptxt dcb     $53,$54,$55,$56,$57,$58,$51,$52  ;"Computer"
wontxt  dcb     $5a,$54,$5b,$59  ;"won:"
losttxt dcb     $4e,$54,$5c,$58,$59  ;"lost:"
tiedtxt dcb     $58,$5d,$51,$5e,$59  ;"tied:"

pagaint dcb     $01,$02,$02,$02,$02,$02,$02,$02,$02,$02,$02,$02,$03
	dcb     "3333333333333333333"
	dcb     $04,$20,$0e,$09,$40,$33,$09,$3c,$09,$1e,$3e,$21,$05
	dcb     "3333333333333333333"
	dcb     $04,$33,$33,$33,$33,$33,$33,$33,$33,$33,$33,$33,$05
	dcb     "3333333333333333333"
	dcb     $04,$3b,$14,$0b,$13,$41,$00,$00,$3e,$11,$00,$00,$05
	dcb     "3333333333333333333"
	dcb     $06,$07,$07,$07,$07,$07,$07,$07,$07,$07,$07,$07,$08 ;8b bytes

 dcb "<- End of map data, beginning of code ->"


;============================================================================
;=     CONTINUE WITH PROGRAM   (FLASH STAR AND DETECT JOYPAD MOVEMENT)      =
;============================================================================

pastdat ldy.v   #$0200          ; even more zeroes to save space
	jsr     zero
	sep     #$10
	jsr     fadein          ; fade in the difficulty select screen

	rep     #$10            ; put x and y index registers back to 16 bits
	ldx.v   #$0008          ; we'll be flashing the star on for 8 vbl's
	ldy.v   #$11cc          ; offset in vram of the flashing star
	sty     starloc         ; location in memory to keep that value 
	lda     #$01            ; the star starts out on normal mode (mode 1)
	sta     mode            ; location in memory to keep track of the mode
starlp  lda     #$04            ; put something in the "star on?" flag
	sta     staron          ; flag, tells if star is on (for moving it)
	jsr     jsupdn          ; check for up,down,a,x,b,y and come back
	cpy.v   #$6502
	beq     winfout         ; a,x,b,or y pressed? branch if yes
	dex
	bne     starlp          ; go thru 8 vbl's before turning star off
	jsr     vbl             ; can only write to vram in a vertical blank
	ldx     starloc         ; store a zero(space) in the star's location
	stx     $2116
	stz     $2118
	ldx.v   #$0005          ; wait time for second loop

starlp2 stz     staron          ; clear star-on flag
	jsr     jsupdn          ; check for joypad pressing
	cpy.v   #$6502          ;  (the joypad routine does most of the work)
	beq     winfout
	dex
	bne     starlp2         ; keep going back for 5 vbl's, then put
	jsr     vbl             ;  the star on again
	ldx     starloc
	stx     $2116           ; make video write start at starloc(ation)
	lda     #$3b            
	sta     $2118           ; write the character for star to vram
	ldx.v   #$0008          ; wait time for first loop
	bra     starlp          ; branch to first loop

winfout jsr     vbl
	ldx     starloc         ; put the red star back when button is
	stx     $2116           ;  pressed, so the scren will fade out
	lda     #$3b            ;  with it there.
	sta     $2118

	sep     #$30            ; all 8 bit
	lda     #$02            ; 2 vbl's per shade darker
	sta     fade
	jsr     fadeout
	ldy     #$80            ; turn screen off (just being dark won't work)
	sty     $2100
	rep     #$10

	ldx.v   #$1000          ; at $1000 vram,
	ldy.v   #$0400          ; clear 400h tiles
	stx     $2116           ; clear the window off plane 0 so it won't
	jsr     zero            ; be there during game play


;============================================================================
;=                LOAD AND FADE IN THE GAME PLAY SCREEN                     =
;============================================================================

	lda     #$01            ; color #1
	sta     $2121           ; color number register
	lda     #$ff
	sta     $2122           ; put white color in
	lda     #$ff
	sta     $2122           ; put white color in (plane 0,color 1)
	lda     #$ff
	sta     $2122           ; put lt.yellow color in, low byte (p 0, c 2)
	lda     #$3f
	sta     $2122           ; put lt.yellow color in, high byte

	lda     #$21            ; color #21 hex (plane 1,color 1)
	sta     $2121
	lda     #$f0
	sta     $2122           ; put brown color in, low (plane 1, color 1)
	stz     $2122           ; put brown color in, high {for playing grid}
	lda     #$ff
	sta     $2122           ; put white color in (plane 1, color 2)
	sta     $2122           ; put white color in {for X and O's}
	lda     #$98
	sta     $2122           ; put l.blue color in, low (plane 1, color 3)
	lda     #$7f
	sta     $2122           ; put l.blue color in, high {for score message}

	ldx.v   #$3000          ; this is plane 1 map data
	stx     $2116
	ldy.v   #$010b          ; store zeroes to save space
	jsr     zero
	ldx.v   #$0000
playsc  lda     playtxt,x       ; Get map data for the game screen
	sta     $2118
	stz     $2119           ; clear unwanted bits, no H/V flipping
	inx
	cpx.v   #$0160          ; transfer entire playing screen
	bne     playsc 
	ldy.v   #$0200          ; even more zeroes to save space
	jsr     zero

	ldx.v   #$12ab          ; location for mode message
	stx     $2116

	lda     mode            ; write what mode it's in to the screen
	cmp     #$01
	beq     wnor            ; normal mode?  branch to wnor
	cmp     #$03
	beq     wbat            ; battle mode? branch to wbat
	stz     $2118           ; put an extra space before easy or hard
	stz     $2119
	cmp     #$00
	bne     whar

	ldx.v   #deasyt         ; location of text (map data)
	ldy.v   #$0004          ; length of message 
	jsr     msg             ; write "Easy"
	lda     #$04            ; song titled ""
	sta     $2140           ; tell the sound processor to play that song
	bra     wmlcont         ; go to write second half of message

wbat    ldx.v   #battxt
	ldy.v   #$000c
	jsr     msg             ; write "Battle Mode<TM>"
	lda     #$0d            ; song titled ""
	sta     $2140           ; tell the sound processor to play that song
	bra     wbmcont

whar    ldx.v   #dhardt            
	ldy.v   #$0004
	jsr     msg             ; write "Hard"
	lda     #$09            ; song titled ""
	sta     $2140           ; tell the sound processor to play that song
	bra     wmlcont

wnor    ldx.v   #dnormt
	ldy.v   #$0006
	jsr     msg             ; write "Normal"   then continue on (no bra)
	lda     #$05            ; song titled ""
	sta     $2140           ; tell the sound processor to play that song

wmlcont ldx.v   #dmodet
	ldy.v   #$0005
	jsr     msg             ; write " mode"

wbmcont sep     #$30            ; make all 3 registers 8 bits wide
	ldy     #$00            ; fade in the game play screen
gamfi   jsr     vbl
	iny
	sty     $2100           ; store brightness value
	cpy     #$0f            ; check if screen is full brightness yet
	bne     gamfi           ; branch if not
	rep     #$10            ; end of  game(play screen) fade in

	stz     aa              ; clearing the "map" of whether
	stz     ab              ; an x, o, or nothing is in any one square.
	stz     ac              ; it is kept for all computer interaction,
	stz     ba              ; and winner checking  (nothing=0 x=1 o=2)
	stz     bb
	stz     bc
	stz     ca
	stz     cb
	stz     cc
	stz     playern         ; make sure that player 1 goes first
	jsr     dispsco         ; display the scores on the screen


;============================================================================
;=              DETECT DIRECTION MOVEMENT AND JUMP TO PUT AN X              =
;============================================================================

	rep     #$10       
	sep     #$20
pastsnd ldx.v   #$0008          ; load initial on-blink time
	ldy.v   #$110b          ; load initial location for cursor-box
	sty     starloc         ; starloc and cursor should both be updated
	lda     #$11            ; at the same time, in joypad subroutine.
	sta     cursor          ; put cursor in position 0  (0,0)
	stz     squaren         ; cursor's square no. is 0
	ldy     squaren         ; loads squaren as low byte, cursor as high
	sty     save2p
cursst  lda     #$04
	sta     staron          ; turn on box-on flag (cursor is on)
curslp  inc     rand            ; THIS is how the random number is obtained
	jsr     jsudlr          ; get joypad data (and move box position)
	cpy.v   #$6502          ; if a,b,x, or y pressed - put an X at cursor
	beq     putx
cursm1  dex
	bne     curslp          ; jump back if there's more box-time left
cursvb  jsr     vbl
	ldx     starloc         ; \
	stx     $2116           ;  \
	ldy.v   #$0060          ;  /  clear the box (turn cursor off)
	jsr     zero            ; /
	ldx.v   #$0005          ; load off-blink time

curslp2 inc     rand            ; THIS is how the random number is obtained
	stz     staron          ; turn off box-on flag (no cursor on now)
	jsr     jsudlr          ; get joypad data + do much more other stuff
	cpy.v   #$6502          ; if a,b,x, or y pressed - put an X at cursor
	beq     putx
cursm2  dex
	bne     curslp2         ; jump back if there's more non-box-time left
cursvb2 jsr     vbl
	jsr     prntbox         ; writes cursor-box to vram
	ldx.v   #$0008          ; load on-blink time
	bra     cursst          ; go back to start of blink-loop


;============================================================================
;=   PLACE AN X, CHECK FOR A WINNER, PLACE AN O, CHECK FOR A WINNER AGAIN   =
;============================================================================

putx    sep     #$10            ;  squaren = square number that the cursor
	ldy     squaren         ; is on (0-8)
	lda     aa,y            ; see what's there
	beq     putxc           ; if it's empty, go put an X
	rep     #$10
	lda     staron          ; if not, return to pick again.
	bne     cursm1          ; branch to 1 or 2, depending on if
	bra     cursm2          ;  the cursor-box is on or not
p2o     pha
	sep     #$30
	lda     #$22            ; lighter stomp
	jsr     sfx             ; play sound effect
	rep     #$20
	pla
	jmp     poend           ; jump to write an O to the screen
putxc   rep     #$10
	jsr     vbl
	ldx     starloc         ; \
	stx     $2116           ;  \
	ldy.v   #$0060          ;  /  clear the box (turn cursor off)
	jsr     zero            ; /
	rep     #$20
	sep     #$10
	lda     starloc
	clc                     ; add $2000 to cursor-box's location, so the
	adc.v   #$2000          ;  resulting address is on plane 1
	ldy     mode
	cpy     #$03            ; 2 player mode?
	bne     midsf           ; if not, jump past this
	ldy     playern         ; is it player 2's turn? (O's)
	bne     p2o             ; jump to write O on screen if it is
midsf   pha
	sep     #$30
	lda     #$20            ; solid stomp
	jsr     sfx             ; play sound effect
	rep     #$20
	pla
midx    phx                     ; this is called from other loops, so save x
	sta     $2116           ; write there
	ldx     #$22
	stx     $2118
	stz     $2119           ; over here,  the map data is being written
	ldx     #$23            ;  for X (being careful not to disturb
	stx     $2118           ;  the other map info around it)
	stz     $2119
	ldx     #$24
	stx     $2118
	stz     $2119
	clc
	adc.v   #$0020          ; advance to next line
	sta     $2116
	ldx     #$25
	stx     $2118
	stz     $2119
	ldx     #$26
	stx     $2118
	stz     $2119
	ldx     #$27
	stx     $2118
	stz     $2119
	clc
	adc.v   #$0020          ; advance to next line
	sta     $2116
	ldx     #$28
	stx     $2118
	stz     $2119
	ldx     #$29
	stx     $2118
	stz     $2119
	ldx     #$2a
	stx     $2118
	stz     $2119           ; finished writing X (map data) to vram
	plx                     ; restore x register
	cpy     #$bb            ; check for flag, this routine is also used
	bne     afterx          ; from gamover area code (need to return)
	rts

       sep     #$30        ; ** needed for some assemblers not to mess up
player2 sta     playern         ; a is a nonzero value (3)
	dec                     ; a will be 3, so dec to make it 2
	sta     $2121           ; change color of cursor-box for player 2
	lda     #$c7
	sta     $2122           ; put blue color in, low byte   (plane 0,
	lda     #$f9
	sta     $2122           ; put blue color in, high byte   color 2)
	rep     #$20
	lda.v   #$110b          ; starting v-ram address
	ldy     #$bb            ; tell mido to rts when done
	ldx     save2p          ; the squaren that player 2 used
				;   will be loaded into x here
	jsr     mido            ; turn that squaren(umber) into v-ram address
	sta     starloc         ; put player 2's cursor where it was
	rep     #$10            ;  before this player's turn
	sep     #$20
	ldx     save2p
	ldy     squaren
	sty     save2p          ; save player 1's current cursor-location
	stx     squaren         ; restore player 2's location

	ldx.v   #$0008
	jmp     cursst          ; start again


afterx  sep     #$30
	ldx     #$01            ; value for x is 01
	ldy     squaren         ; square number cursor is on
	stx     aa,y            ; write data to game-map
	stz     winorow         ; tell it to check for winner
	jsr     winner          ; (a,x,y=8bit)
	cpy     #$00            ; y will be 00 if there's no winner yet
	bne     gmvr            ; go to game over section if there is winner
	jsr     full            ; check if all squares used (no winner)
	cpy     #$65
	beq     gmvr            ; branch if it's full
	lda     mode            ; get what mode (easy,normal,hard,battle)
	beq     easymd          ; branch if easy mode
	cmp     #$03
	beq     player2         ; if 2player mode, go let player 2 play now
	cmp     #$02
	beq     hardmd          ; go if hard mode
; normal mode
	lda     #$08            ; winner routine now checks for 2 on a row
	sta     winorow         ;  instead of finding a winner
	jsr     winner
	stz     winorow         ; clear that flag
	cpy     #$00            ; is there a row to complete or block?
	bne     placeo          ; yes?  let's write it right away.
	jsr     getrand
	jsr     getsq           ; get a random, unused square
	bra     placeo          ; go write the O
gmvr    jmp     gamover         ; needed because a branch is out of range
easymd  jsr     getsq           ; get a random, unused square
	bra     placeo
getsq   lda     rand
	clc
	adc     #$05            ; add 5 (and if above 8, subtract 8 again
	sta     rand            ;  in getrand subroutine)
	jsr     getrand
	ldx     rand            ; this converts random number 0 to ff into
	lda     aa,x            ;  a random number 0 to 8
	beq     getsqe          ; is this square already used?  no?  branch.
	bra     getsq           ; make sure this one isn't used
getsqe  rts
hardmd  lda     mode
	sta     holdbtn         ; makes it check for O's in a row only, no X's
	lda     #$08            ; winner routine now checks for 2 on a row
	sta     winorow         ;  instead of finding a winner
	jsr     winner          ; check for only O's in a row/column
	stz     holdbtn         ; allow it to check for X's also
	cpy     #$00            ; is there a row to complete or block?
	bne     placeo          ; yes?  let's write it right away.
	jsr     winner          ; check for X's or O's (2 and an empty box)
	cpy     #$00            ; is there a row to complete or block?
	bne     placeo          ; yes?  let's write it right away.
	jsr     openco          ; finds x's in center of sides(forming angle)
	cpy     #$00            ; see if it found somewhere to block
	bne     placeo
	jsr     nside           ; a variant of the above (just as tricky)
	cpy     #$04
	beq     placeo
	jsr     ccorner         ; see if X is in corner, and center is open
	cpy     #$04
	beq     placeo          ; branch to place O in center
	jsr     getsq           ; nothing better found? then randomly place O

placeo  ldx     #$25            ; short delay before O is placed, for realism
	jsr     waitasec        ; (a=8bit,xy=anything)
	lda     #$22            ; lighter stomp
	jsr     sfx             ; play sound effect
	rep     #$20
	stz     winorow         ; clear this flag, from before
p2cont  ldx     rand
	lda.v   #$310b          ; setting up for this next part
mido    clc
	cpx     #$00            ; what is going on here:
	beq     poend           ; x will be a value from 0 to 8, referring
	cpx     #$01            ; to any of the 9 squares.  this simple
	beq     po1             ; number must be converted to a offset in
	cpx     #$02            ; video ram, and there's no short-cut for it.
	beq     po2             ; the result will be placed in accumulator.
	cpx     #$03
	beq     po3             ; this part is finding where to jump to
	cpx     #$04
	beq     po4
	cpx     #$05
	beq     po5
	cpx     #$06
	beq     po6
	cpx     #$07
	beq     po7
	adc.v   #$0107
	bra     poend
poretx  rts
po1     inc                     ; this part is making the v-ram offset
	inc                     ;  (value depends on where it jumps to)
	inc
	inc
	bra     poend
po2     adc.v   #$0007
	bra     poend
po3     adc.v   #$007f
	bra     poend
po4     adc.v   #$0083
	bra     poend
po5     adc.v   #$0087
	bra     poend
po6     adc.v   #$00ff
	bra     poend
po7     adc.v   #$0103


poend   cpy     #$bb            ; this video writing routine is also used by
	beq     poretx          ;  the game-over part, rts if it's from that
	phx                     ; protect loop count in gameover part
	pha                     ; protect v-ram offset
	sep     #$20
	jsr     vbl             ; must write during v blank
	rep     #$20
	pla                     ; restore it
	sta     $2116
	ldx     #$2b            ; this part is writing the O to video ram
	stx     $2118
	stz     $2119
	ldx     #$2c
	stx     $2118
	stz     $2119
	ldx     #$2d
	stx     $2118
	stz     $2119
	clc
	adc.v   #$0020          ; go to next line
	sta     $2116
	ldx     #$2e
	stx     $2118
	stz     $2119
	ldx     #$00
	stx     $2118
	stz     $2119
	ldx     #$2f
	stx     $2118
	stz     $2119
	clc
	adc.v   #$0020          ; go to next line
	sta     $2116
	ldx     #$30
	stx     $2118
	stz     $2119
	ldx     #$31
	stx     $2118
	stz     $2119
	ldx     #$32
	stx     $2118             ; / 2 lines down restores x (used for loop
	stz     $2119            ; /  count in game over part, won't hurt if
	plx                     ; <  not coming from game over part)
	cpy     #$aa            ; flag (if coming from game over part)
	bne     aftery          ; bra past and continue if flag is clear
	rts                     ; rts to game over section

aftery  ldy     playern         ; after player 2 moves, go read its position
	bne     pn2             ;  (pn2 loads the position)

	ldy     rand            ;  the game-play "map" and check for a winner
pn2cont ldx     #$02            ; after computer(O) takes its turn, update
	stx     aa,y            ; store O's value in the map
	sep     #$20
	jsr     winner
	cpy     #$00            ; y will be 0 if there is no winner yet
	bne     gamover         ; branch if not zero to game over part
	rep     #$10            ; no winner yet, time for X's turn
	php                     ; save the processor settings ($10)
	lda     playern         ; there's no winner, and O moved, so 
	beq     jcst            ;  if it was the computer - X's turn now

	stz     playern         ; clear this for next turn (player 1's)
	lda     #$02
	sta     $2121           ; change color of box back to yellow from blue
	lda     #$ff
	sta     $2122           ; put lt.yellow color in, low byte   (plane 0,
	lda     #$3f
	sta     $2122           ; put lt.yellow color in, high byte   color 2)
	rep     #$20
	sep     #$10
	lda.v   #$110b          ; topleft corner (base address)
	ldy     #$bb            ; tell mido routine to return
	ldx     save2p          ; this is the square chosen by O (player 2)
				;  x is 8 bits so it only loads one byte
	jsr     mido            ; get the v-ram offset of that square
	sta     starloc         ; and store it for later use (next turn)
	plp                     ; restore processor settings ($10)
       rep     #$10        ; ** needed for some assemblers not to mess up
	ldx     save2p          ; x is 16 bits so it loads 2 bytes
	ldy     squaren
	sty     save2p          ; save old player 1's cursor-location
	stx     squaren         ; restore player 2's location
	ldx.v   #$0008
jcst    jmp     cursst          ; Go all the way back to the beginning
pn2     ldy     squaren         ; load the location from squaren instead
	bra     pn2cont


;============================================================================
;=       FIND WHO WON, HIGHLIGHT THEIR WINNING ROW, ASK TO PLAY AGAIN       =
;============================================================================

       sep     #$20        ; ** needed for some assemblers not to mess up
gamover phy                     ; push the value of who won
	rep     #$10            ; we want x,y=16bit from now on
	jsr     vbl
	lda     #$02
	sta     $2121           ; change color #2 (yellow -> white)
	lda     #$ff
	sta     $2122           ; white color
	sta     $2122           ; white color
	lda     mode
	cmp     #$03            ; check if it's battle mode
	beq     battleg         ; go print 'player n wins'
	pla                     ; pull it back into accumulator
	ldx.v   #$10cc          ; get ready for video write coming up soon
	stx     $2116           ; make it start writing near top of screen
	cmp     #$02
	beq     owon            ; O won :-(
	cmp     #$01
	beq     xwj            ; X won :-)

nowin   ldy.v   #$0009          ; no winner :-/
	ldx.v   #nwtxt
	jsr     msg             ; write "No winner"
	sep     #$10
	ldy     mode            ; index it by what mode it's in
	lda     tied,y          ; load previous score
	jsr     add1            ; add one (in decimal) to the score
	sta     tied,y          ; store it
	rep     #$10
	jmp     againmg         ; jump to (play) again message

xwj     jmp     xwon            ; a branch would be out of range, so do this

battleg pla
	pha                     ; get who won (checking for no winner)
	cmp     #$01
	beq     bgcon           ; if x won, go say so
	cmp     #$02
	beq     bgcon           ; if y won , go say so
	ldx.v   #$10cc          ; get ready for video write coming up soon
	stx     $2116           ; make it start writing near top of screen
	bra     nowin           ; branch if no winner
bgcon   ldx.v   #$10ca
	stx     $2116           ; write player number text here
	ldx.v   #platxt
	ldy.v   #$0007
	jsr     msg             ; write "Player "
	pla                     ; get the who won value (0 or 1/X or O)
	pha                     ; and save it again
	clc
	adc     #$45            ; make the number into map data for the num.
	sta     $2118           ; write the number (1 or 2)
	stz     $2119
	ldx.v   #winstxt
	ldy.v   #$0005
	jsr     msg             ; write " wins"
	pla                     ; restore who won (x or o)
	cmp     #$02            ; did o win?  highlight its winning row
	beq     bmow
	bra     bmxw            ; if not, highlight x's winning row

owon    ldy.v   #$0008          ; length of message
	ldx.v   #owtxt          ; location of message
	jsr     msg             ; write "You lose"
bmow    sep     #$10            ; x,y = 8bit
	ldy     mode            ; \
	lda     lost,y          ;  \ update score
	jsr     add1            ;  /
	sta     lost,y          ; /

	rep     #$20            ; accumulator = 16bit
	ldx     #$00            ; start at first box
rolp    ldy     aa,x            ; the winning row was marked with ff, so it
	cpy     #$ff            ;  would be easy to highlight tthem
	beq     writero         ; is this square marked?  branch if yes
rolpc   inx                     ; go to the next square
	cpx     #$09            ; did we check all 9 boxes?
	bne     rolp
	jmp     againmg         ; all done, jump to "play again?" message

writero lda.v   #$110b          ; top left corner of plane 0 map data in vram
	ldy     #$aa            ; flag, so writing routine knows to rts back
				;  at the end of the vram write (not before)
	jsr     mido            ; translate box number to offset, and write O
	bra     rolpc           ; branch back into loop to find another

       rep     #$10        ; ** needed for some assemblers not to mess up
       sep     #$20        ; ** needed for some assemblers not to mess up
xwon    stz     $2118           ; move the "You win" message over one space
	stz     $2119
	ldy.v   #$0007
	ldx.v   #xwtxt
	jsr     msg             ; write the message
bmxw    sep     #$10            ; x,y = 8bit
	ldy     mode            ; update score
	lda     won,y
	jsr     add1
	sta     won,y

bmxl    rep     #$20            ; accumulator = 16bit
	ldx     #$00
rxlp    ldy     aa,x            ; this loop is just like the above one,
	cpy     #$ff
	beq     writerx
rxlpc   inx
	cpx     #$09
	bne     rxlp
	jmp     againmg
writerx lda.v   #$110b          ; with this difference.
	ldy     #$bb            ; flag means that we will do this:
	jsr     mido            ; translate box number into vram offset only
	jsr     midx            ; (and) write X to vram (rts'ing from both)
	bra     rxlpc

againmg rep     #$10            ; x,y = 16bit
	sep     #$20            ; accumulator = 8bit
	lda     #$21            ; color #1, plane 1
	sta     $2121
	lda     #$69            ; turn bright brown to dark brown
	sta     $2122           ; dk.brown, low byte
	stz     $2122           ; dk.brown, high byte
	lda     #$08            ; turn bright white to gray
	sta     $2122           ; gray, low byte
	lda     #$21
	sta     $2122           ; gray, high byte
	jsr     dispsco         ; display new scores on the screen
	ldx.v   #$00c0          ; this is a delay so that the player can see
	jsr     waitasec        ;  how they won or lost before going on

	ldx.v   #$110b          ; topleft corner of the playing part
	stx     $2116
	ldy.v   #$0160          ; because of waitasec, it is now vblank
	jsr     zero            ; clear off bright X/O's
	ldx.v   #$112a          ; location for play again window
	stx     $2116

	lda     #$18            ; cutting air/whip
	jsr     sfx             ; play sound effect
	jsr     vbl             ; for some odd reason,
	jsr     vbl             ;  just one wouldn't always work
wpt     lda     pagaint,y
	sta     $2118           ; write play again text (window) to screen
	stz     $2119
	iny
	cpy.v   #$008d          ; branch if it hasn't written 8d bytes yet
	bne     wpt

	ldx.v   #$0008          ; keep star lit for 8 vbl's
	ldy.v   #$118b          ; $118b is v-ram offset for YES!
	sty     starloc         ;    ($1191 is v-ram offset for no)

palp    lda     #$04            ; Play Again LooP, this part here flashes
	sta     staron          ;  the star (palp turns it on, palp2
	jsr     jsplr           ;  turns it off)
	cpy.v   #$6502
	beq     pafo            ; if button pressed, go to play again fadeout
	dex
	bne     palp            ; after the specified time,
	jsr     vbl
	ldx     starloc
	stx     $2116           ; make star's location the pointer, and
	stz     $2118           ; instantly make it a space (empty, nothing)
	ldx.v   #$0005          ; 5 vbl's of off-time

palp2   stz     staron          ; let it be known that the star is off
	jsr     jsplr
	cpy.v   #$6502          ; this loop is just like the one above
	beq     pafo
	dex
	bne     palp2
	jsr     vbl
	ldx     starloc
	stx     $2116
	lda     #$3b            ; put the star back on the screen
	sta     $2118
	ldx.v   #$0008          ; 8 vbl's of on-time
	bra     palp

morewai ldx.v   #$0052
	bra     mowa
pafo    jsr     vbl
	ldy     starloc         ; Play Again Fade-Out part
	cpy     #$1191          ; if star isn't on no,
	bne     jagain          ;  then jump (to play) again
	ldx     starloc         ; put the red star back when button is
	stx     $2116           ;  pressed, so the scren will fade out
	lda     #$3b            ;  with it there.
	sta     $2118
	lda     #$02            ; no song
	sta     $2140           ; play that silent song
	ldx.v   #$0040          ; short pause, wait for music to stop
	lda     mode
	beq     morewai
mowa    jsr     waitasec
	lda     #$0a            ; gulp
	jsr     sfx             ; play that sound effect
	ldx.v   #$0015          ; short pause
	jsr     waitasec
	lda     #$08            ; song titled ""
	sta     $2140           ; tell the sound processor to play that song
	ldx     #$0250          ; give the song a few seconds to play
	jsr     waitasec
	sep     #$30            ; all 8 bit
	lda     #$10            ; 10 vbl's for a shade darker
	sta     fade
	jsr     fadeout         ; fade out the window
	ldx     #$70
	jsr     waitasec        ; wait just a sec before fading in title
	jmp     gototit         ; no???  jump to title screen
jagain  lda     #$04            ; oh! sound
	jsr     sfx             ; play that sound effect
	jmp     winfout         ; yes!  fade out window, and continue


;============================================================================
;=          SUBROUTINES FOR BLOCKING MOVES, FINDING WINNER, ETC...          =
;============================================================================

full    ldx     #$08            ; subroutine used for checking if all squares
fulllp  lda     aa,x            ;  are being used (non-zero)
	beq     fullend         ; return quickly if there is a empty space
	dex
	bne     fulllp
	ldy     #$65            ; all are being used?  better report this
fullend rts

ccorner lda     bb              ; load center square
	beq     putcent         ; put O in center if empty
	cmp     #$01            ; if X in center, make sure that any one
	beq     ccent           ;  corner has an O in it
	rts
putcent lda     #$04
	sta     rand            ; store center address ( 04 )
	tay                     ; make y non-zero so O will be put next thing
ccente  rts
ccent   lda     bb              ; here, each corner is checked for the
	cmp     #$01            ;  presence of an O, and if one is found,
	bne     ccente          ;  it will return with nothing in y.
	lda     aa              ;  if not, an O is placed in a corner.
	cmp     #$02
	beq     ccente
	lda     ac
	cmp     #$02
	beq     ccente
	lda     ca
	cmp     #$02
	beq     ccente
	lda     cc
	cmp     #$02
	beq     ccente

cencrn  jsr     getsq           ; this is what happens when no O is found
	lda     rand            ;  in any corner (one corner is randomly
	beq     cengot          ;  chosen here)
	cmp     #$02
	beq     cengot
	cmp     #$06
	beq     cengot
	cmp     #$08
	beq     cengot
	bra     cencrn
cengot  ldy     #$04            ; hmm, looks like rand is a corner!
	rts

		    ; openco does this: if it finds  _ X _  or  . . _ ,etc.
		    ; then it puts O in the corner   . . X      . . X
		    ; to block it (for hard mode)    . . _      _ X _
openco  lda     aa              ; load upper left
	bne     openco1         ; branch if not empty
	lda     ab
	cmp     #$01            ; make sure top middle is a X
	bne     openco1
	lda     ac
	bne     openco1         ; and the top right corner is open
	lda     bc
	cmp     #$01
	bne     openco1         ; and the right-edge middle is a X
	lda     cc
	bne     openco1         ; and the lower right corner is open
	lda     #$02
	sta     rand            ; then, put a O in the top right corner.
	tay
	rts
openco1 lda     ca              ; load lower left
	bne     openco2         ; branch if not empty
	lda     cb
	cmp     #$01            ; make sure lower middle is a X
	bne     openco2
	lda     cc
	bne     openco2         ; and the lower right corner is open
	lda     bc
	cmp     #$01
	bne     openco2         ; and the right-edge middle is a X
	lda     ac
	bne     openco2         ; and the top right corner is open
	lda     #$08
	sta     rand            ; then, put a O in the lower right corner.
	tay
	rts
openco2 lda     aa              ; load upper left
	bne     openco3         ; branch if not empty
	lda     ba
	cmp     #$01            ; make sure left-edge middle is a X
	bne     openco3
	lda     ca
	bne     openco3         ; and the lower left corner is open
	lda     cb
	cmp     #$01
	bne     openco3         ; and the lower middle is a X
	lda     cc
	bne     openco3         ; and the lower right corner is open
	lda     #$06
	sta     rand            ; then, put a O in the lower left corner.
	tay
oc3r    rts
openco3 lda     aa              ; load upper left
	bne     oc3r            ; branch if not empty
	lda     ab
	cmp     #$01            ; make sure top middle is a X
	bne     oc3r
	lda     ac
	bne     oc3r            ; and the top right corner is open
	lda     ba
	cmp     #$01
	bne     oc3r            ; and the left-edge middle is a X
	lda     ca
	bne     oc3r            ; and the lower left corner is open
	stz     rand            ; then, put a O in the top left corner.
	ldy     #$04
	rts

nside   lda     aa              ; another possible way to win that must
	cmp     #$01            ; be checked for..(in hard mode)
	bne     nside1          ; this part (nside,nside1) check for:
	lda     bc              ;  X _ _         _ X _
	cmp     #$01            ;  ? ? X         ? ? _
	bne     nside1          ;  ? ? _   , or  ? ? X  ,etc...
	lda     ab              ;
	bne     nside1          ; X can easily win if placed in the
	lda     ac              ; upper right corner (provided that
	bne     nside1          ; the top and right rows/columns are
	lda     cc              ; free of O's).
	bne     nside1
	bra     grs1            ; get random (square on) side 1 [top right]
nside1  lda     ab
	cmp     #$01
	bne     nside2
	lda     cc
	cmp     #$01            ; this is all simple logic, anyone should
	bne     nside2          ;  be able to follow along and trace through
	lda     aa
	bne     nside2
	lda     ac
	bne     nside2
	lda     bc
	bne     nside2

grs1    jsr     getsq           
	lda     rand            ; get random square routine #1
	beq     grs1e
	cmp     #$01            ; get a random square, compare it with
	beq     grs1e           ; the squares that will work, if it isn't,
	cmp     #$02            ; then go back and get another random
	beq     grs1e           ; square until it gets a good one
	cmp     #$05
	beq     grs1e           ; any of these will do:
	cmp     #$08            ;    O O O
	beq     grs1e           ;    - - O
	bra     grs1            ;    - - O
grs1e   ldy     #$04
	rts

nside2  lda     ac              ; yep, this one is just like the one before
	cmp     #$01            ; it, only some addresses changed
	bne     nside3
	lda     cb
	cmp     #$01
	bne     nside3
	lda     bc
	bne     nside3
	lda     cc
	bne     nside3
	lda     ca
	bne     nside3
	bra     grs2            ; get random (square on) side 2 [lower right]
nside3  lda     bc
	cmp     #$01
	bne     nside4
	lda     ca
	cmp     #$01
	bne     nside4
	lda     ac
	bne     nside4
	lda     cc
	bne     nside4
	lda     cb
	bne     nside4

grs2    jsr     getsq
	lda     rand
	cmp     #$02
	beq     grs2e
	cmp     #$05
	beq     grs2e
	cmp     #$08
	beq     grs2e
	cmp     #$06
	beq     grs2e
	cmp     #$07
	beq     grs2e
	bra     grs2
grs2e   ldy     #$04
	rts

nside4  lda     cc
	cmp     #$01
	bne     nside5
	lda     ba
	cmp     #$01
	bne     nside5
	lda     cb
	bne     nside5
	lda     ca
	bne     nside5
	lda     aa
	bne     nside5
	bra     grs3            ; get random (square on) side 3 [lower left]
nside5  lda     cb
	cmp     #$01
	bne     nside6
	lda     aa
	cmp     #$01
	bne     nside6
	lda     cc
	bne     nside6
	lda     ca
	bne     nside6
	lda     ba
	bne     nside6

grs3    jsr     getsq
	lda     rand
	beq     grs3e
	cmp     #$07
	beq     grs3e
	cmp     #$06
	beq     grs3e
	cmp     #$03
	beq     grs3e
	cmp     #$08
	beq     grs3e
	bra     grs3
grs3e   ldy     #$04
	rts

nside6  lda     ca
	cmp     #$01
	bne     nside7
	lda     ab
	cmp     #$01
	bne     nside7
	lda     ba
	bne     nside7
	lda     aa
	bne     nside7
	lda     ac
	bne     nside7
	bra     grs4            ; get random (square on) side 3 [top left]
nside7  lda     ba
	cmp     #$01
	bne     hside1
	lda     ac
	cmp     #$01
	bne     hside1
	lda     ca
	bne     hside1
	lda     aa
	bne     hside1
	lda     ab
	beq     grs4

hside1  lda     bb              ; this part looks for this-
	cmp     #$01            ;  X . _      _ . X
	bne     hsidrts         ;  . X .  or  . X .
	lda     aa              ;  _ . .      . . _
	cmp     #$01            ;      (X is X, _ is blank, . is anything)
	bne     hside2          
	lda     ac              ; then it puts an O in either blank
	bne     hside2          ; place, randomly
	lda     ca
	bne     hside2

hscaac  jsr     getsq           ; get random square (number)
	lda     rand
	cmp     #$02            ; compare that number with topright square
	beq     hscaacy         ; if it is, branch out of loop
	cmp     #$06            ; compare that number with bottomleft square
	beq     hscaacy         ; if it is, branch out of loop
	bra     hscaac          ; not either one?  do the loop again then.
hscaacy ldy     #$04            ; flag saying place an O immediately on rts
	rts

grs4    jsr     getsq           ; randomly picking a square that is
	lda     rand            ; on the left side or the top
	beq     grs4e           ; NOTE: this is part of the nside loop,
	cmp     #$06            ; not the HScaac/acca loop above
	beq     grs4e
	cmp     #$03
	beq     grs4e
	cmp     #$01
	beq     grs4e
	cmp     #$02
	beq     grs4e
	bra     grs4
grs4e   ldy     #$04
hsidrts rts

hside2  lda     cc              ; just like hside1, but checks different side
	cmp     #$01
	bne     hside3
	lda     ac
	bne     hside3
	lda     ca
	bne     hside3
	bra     hscaac
hside3  lda     ac
	cmp     #$01
	bne     hside4
	lda     aa
	bne     hside4
	lda     cc
	bne     hside4
	bra     hsacca
hside4  lda     ca
	cmp     #$01
	bne     hsidrts
	lda     aa
	bne     hsidrts
	lda     cc
	bne     hsidrts
	bra     hsacca

hsacca  jsr     getsq
	lda     rand
	beq     hsaccay
	cmp     #$08
	beq     hsaccay
	bra     hsacca
hsaccay ldy     #$04
	rts


winner  ldx     #$00            ; this is used to see if there is a winner,
	ldy     #$00            ;  also for the computer to know where to
	jsr     winhorz         ;  block X or complete a row of O's
	cpy     #$00
	bne     who
	ldx     #$03            ; offset it by 3 squares (one row down)
	jsr     winhorz         ; look in the center horizontal row
	cpy     #$00            ; is there a winner yet?
	bne     who             ; branch if there is
	ldx     #$06            ; offset by 6 squares (bottom row)
	jsr     winhorz         ; check this new horiz. row
	cpy     #$00
	bne     who
	ldx     #$00            ; offset by 0 squares (leave as it is)
	jsr     winvert         ; look in left-side vertical column
	cpy     #$00            ; is there a winner yet?
	bne     who
	ldx     #$01            ; offset by 1 square (center vert. column)
	jsr     winvert
	cpy     #$00
	bne     who
	ldx     #$02
	jsr     winvert
	cpy     #$00
	bne     who
	jsr     wdiaglr         ; look in the diagonal line from top left to
	cpy     #$00            ;  lower right corners (passing thru center)
	bne     who
	jsr     wdiagrl         ; diagonal from top right to lower left
	cpy     #$00
	bne     who             ; branch if there is a winner
who     rts                     ; nothing?  return with y register still 0


winhorz lda     winorow         ; flag that tells if it checks for a winner,
	bne     rowhorz         ; or finds a row for O to complete or block
	lda     aa,x            ; check for Winner-
	beq     whret           ; load left box, go and rts if empty
	cmp     #$01            ; if O is in the left box, bra to whorzo
	bne     whorzo          ; not empty and not X means it's O
	lda     ab,x
	cmp     #$01            ; if X is not in center, bra to rts
	bne     whret
	lda     ac,x
	cmp     #$01            ; if X is not in right, bra to rts
	bne     whret
	lda     #$ff
	sta     aa,x            ; put ff in the winning row
	sta     ab,x            ;  for highlighting (see gameover part)
	sta     ac,x
	ldy     #$01            ; X is the winner
whret   rts

  ; this part is for the computer to see where to complete a row
  ;  (this will make O win, or block X from winning)
  ; note: if holdbtn is not zero, it will only check to complete a row of O's
rowhorz lda     aa,x            ; get left square
	beq     rowh00          ; if it's empty, bra to rowh00
	cmp     #$02
	beq     rowho           ; if it's O, bra to rowho
	lda     holdbtn
	bne     whret           ; it is X, so if holdbtn is nonzero then rts
	lda     ab,x
	beq     rowh3x          ; if middle square is empty, bra to rowh3x
	cmp     #$02
	beq     whret           ; if it's O, then rts
	lda     ac,x
	bne     whret           ; if right square isn't empty, then rts
	inx                     ; add 2 to left square no., make it the
	inx                     ;  right square of this row) - see winner part
	stx     rand            ; and store it
	txy                     ; on return, write O with no further checking
	rts
rowh3x  lda     ac,x
	cmp     #$01            ; if right square is not X, then rts
	bne     whret
	inx                     ; add 1 to left square number (of this row)
	stx     rand            ; and store it
	txy                     ; put nonzero value in y
	rts
rowho   lda     ab,x
	beq     rowh3o          ; if middle square is empty, bra to rowh3o
	cmp     #$01
	beq     whret           ; if it's X, then rts
	lda     ac,x
	bne     whret           ; if right square isn't empty, then rts
	inx                     ; add 2 to left square no., make it the
	inx                     ;  right square of this row) - see winner part
	stx     rand            ; and store it
	txy                     ; put nonzero value in y
	rts
rowh3o  lda     ac,x
	cmp     #$02            ; if right square isn't O, then rts
	bne     whret
	inx
	stx     rand            ; store location of empty square to put O in
	txy                     ; put nonzero value in y
	rts
rowh00  lda     ab,x            ; get middle square
	beq     whret           ; if it's empty, then rts
	cmp     #$02            ; if it's O, bra to rowh23
	beq     rowh23
	lda     holdbtn         ; it must be an X to get this far
	bne     whret           ; rts if flag is set (check only for O's)
	lda     ac,x
	cmp     #$01            ; if the right square isn't X, then bra to rts
	bne     whret
	stx     rand            ; store the starting square number (0,3,6)
				;  remember, the left square is empty
	ldy     #$01            ; put nonzero value in y
	rts
rowh23  lda     ac,x
	cmp     #$02            ; if right square isn't an O, branch
	bne     whret
	stx     rand            ; store the starting square number (0,3,6)
	ldy     #$02            ; put nonzero value in y
	rts                     ; end of row-completing part

whorzo  lda     ab,x
	cmp     #$02            ; if O is not in center, bra to rts
	bne     whret
	lda     ac,x
	cmp     #$02            ; if O is not in center, bra to rts
	bne     whret
	lda     #$ff
	sta     aa,x            ; put ff in the winning row
	sta     ab,x            ;  for highlighting (see gameover part)
	sta     ac,x
	ldy     #$02            ; O is the winner
	rts


winvert lda     winorow         ; this is just like the one above,
	bne     rowvert         ;  with aa,ba,ca instead of aa,ab,ac
	lda     aa,x
	beq     wvret
	cmp     #$01
	bne     wvertoj
	lda     ba,x
	cmp     #$01
	bne     wvret
	lda     ca,x
	cmp     #$01
	bne     wvret
	lda     #$ff
	sta     aa,x
	sta     ba,x
	sta     ca,x
	ldy     #$01
wvret   rts

rowvert lda     aa,x
	beq     rowv00
	cmp     #$02
	beq     rowvo
	lda     holdbtn
	bne     wvret
	lda     ba,x
	beq     rowv3x
	cmp     #$02
	beq     wvret
	lda     ca,x
	bne     wvret
	inx
	inx
	inx
	inx
	inx
	inx
	stx     rand
	txy
	rts
rowv3x  lda     ca,x
	cmp     #$01
	bne     wvret
	inx
	inx
	inx
	stx     rand
	txy
	rts
rowvo   lda     ba,x
	beq     rowv3o
	cmp     #$01
	beq     wvret
	lda     ca,x
	bne     wvret
	inx
	inx
	inx
	inx
	inx
	inx
	stx     rand
	txy
	rts
rowv3o  lda     ca,x
	cmp     #$02
	bne     wvret
	inx
	inx
	inx
	stx     rand
	txy
	rts
wvertoj bra     wverto
rowv00  lda     ba,x
	beq     wvret
	cmp     #$02
	beq     rowv23
	lda     holdbtn
	bne     wvret
	lda     ca,x
	cmp     #$01
	bne     wvret
	stx     rand
	ldy     #$02
	rts
rowv23  lda     ca,x
	cmp     #$02
	bne     wvret
	stx     rand
	ldy     #$02
	rts

wverto  lda     ba,x
	cmp     #$02
	bne     wvret
	lda     ca,x
	cmp     #$02
	bne     dlr
	lda     #$ff
	sta     aa,x
	sta     ba,x
	sta     ca,x
	ldy     #$02
	rts


wdiaglr lda     winorow         ; this is just like winhorz,
	bne     wdlr            ;  with aa,bb,cc instead of aa,ab,ac
	lda     aa
	beq     dlr
	cmp     #$01
	bne     wdialoj
	lda     bb
	cmp     #$01
	bne     dlr
	lda     cc
	cmp     #$01
	bne     dlr
	lda     #$ff
	sta     aa
	sta     bb
	sta     cc
	ldy     #$01
dlr     rts

wdlr    lda     aa
	beq     dlr0
	cmp     #$02
	beq     dlro
	lda     holdbtn
	bne     dlr
	lda     bb
	beq     dlr3x
	cmp     #$02
	beq     dlr
	lda     cc
	bne     dlr
	ldx     #$08
	stx     rand
	txy
	rts
wdialoj bra     wdialo
dlr3x   lda     cc
	cmp     #$01
	bne     dlr
	ldx     #$04
	stx     rand
	txy
	rts
dlro    lda     bb
	beq     dlr3o
	cmp     #$01
	beq     dlr
	lda     cc
	bne     dlr
	ldx     #$08
	stx     rand
	txy
	rts
dlr3o   lda     cc
	cmp     #$02
	bne     dlr
	ldx     #$04
	stx     rand
	txy
	rts
dlr0    lda     bb
	beq     dlr
	cmp     #$02
	beq     dlr23
	lda     holdbtn
	bne     dlr
	lda     cc
	cmp     #$01
	bne     dlr
	stz     rand
	ldy     #$65
	rts
dlr23   lda     cc
	cmp     #$02
	bne     dlr
	stz     rand
	ldy     #$65
	rts

wdialo  lda     bb
	cmp     #$02
	bne     dlr
	lda     cc
	cmp     #$02
	bne     dlr
	lda     #$ff
	sta     aa
	sta     bb
	sta     cc
	ldy     #$02
	rts


wdiagrl lda     winorow         ; this is just like winhorz,
	bne     wdrl            ;  with cc,bb,aa instead of aa,ab,ac
	lda     ac
	beq     wdret
	cmp     #$01
	bne     wdiaroj
	lda     bb
	cmp     #$01
	bne     wdret
	lda     ca
	cmp     #$01
	bne     wdret
	lda     #$ff
	sta     ac
	sta     bb
	sta     ca
	ldy     #$01
wdret   rts

wdrl    lda     ac
	beq     drl0
	cmp     #$02
	beq     drlo
	lda     holdbtn
	bne     wdret
	lda     bb
	beq     drl3x
	cmp     #$02
	beq     wdret
	lda     ca
	bne     wdret
	ldx     #$06
	stx     rand
	txy
	rts
wdiaroj bra     wdiaro
drl3x   lda     ca
	cmp     #$01
	bne     wdret
	ldx     #$04
	stx     rand
	txy
	rts
drlo    lda     bb
	beq     drl3o
	cmp     #$01
	beq     wdret
	lda     ca
	bne     wdret
	ldx     #$06
	stx     rand
	txy
	rts
drl3o   lda     ca
	cmp     #$02
	bne     wdret
	ldx     #$04
	stx     rand
	txy
	rts
drl0    lda     bb
	beq     wdret
	cmp     #$02
	beq     drl23
	lda     holdbtn
	bne     wdret
	lda     ca
	cmp     #$01
	bne     wdret
	ldx     #$02
	stx     rand
	ldy     #$65
	rts
drl23   lda     ca
	cmp     #$02
	bne     wdret
	ldx     #$02
	stx     rand
	ldy     #$65
	rts

wdiaro  lda     bb
	cmp     #$02
	bne     wdret
	lda     ca
	cmp     #$02
	bne     wdret
	lda     #$ff
	sta     ac
	sta     bb
	sta     ca
	ldy     #$02
	rts


;============================================================================
;=                          MUSIC LAODING ROUTINE                           =
;============================================================================

lkm     ldx.v   #$8000          ; Load Kingarthur Music
lkcopy1 lda     $018000,x       ; I don't know why this music loading part
	sta     $7e2000,x       ; does much of what it does, so commenting
	dex                     ; really wouldn't do much good...
	dex
	bpl     lkcopy1         ; This music was ripped from
	ldx.v   #$8000          ; King Arthur's World (by Jaleco)
lkcopy2 lda     $028000,x
	sta     $7ea000,x
	dex
	dex
	bpl     lkcopy2
	lda.v   #$2000
	sta     $00
	sep     #$20
	lda     #$7e
	sta     $02
	jsr     loadsnd
	stz     $2140
	stz     $2141
	stz     $2142
	stz     $2143
	stz     $00
	stz     $01
	stz     $02
	rts

loadsnd rep     #$30
	ldy.v   #$0000
	lda.v   #$bbaa
lkwait1 cmp     $2140
	bne     lkwait1
	sep     #$20
	lda     #$cc
	bra     lkjmp1
lkjmp4  lda     [$00],y
	iny
	xba
	lda     #$00
	bra     lkjmp2
lkjmp3  xba
	lda     [$00],y
	iny
	xba
lkwait2 cmp     $2140
	bne     lkwait2
	inc
lkjmp2  rep     #$20
	sta     $2140
	sep     #$20
	dex
	bne     lkjmp3
lkwait3 cmp     $2140
	bne     lkwait3
lkloop1 adc     #$03
	beq     lkloop1
lkjmp1  pha
	rep     #$20
	lda     [$00],y
	iny
	iny
	tax
	lda     [$00],y
	iny
	iny
	sta     $2142
	sep     #$20
	cpx.v   #$0001
	lda     #$00
	rol
	sta     $2141
	adc     #$7f
	pla
	sta     $2140
lkwait4 cmp     $2140
	bne     lkwait4
	bvs     lkjmp4
	rts


;============================================================================
;=                       SUBROUTINES                                        =
;============================================================================

zero    stz     $2118           ; store 2 zeroes into vram (clear one tile)
	stz     $2119
	dey                     ; reduce remaining tiles by 1
	bne     zero            ; branch if not done
	rts                     ; return from subroutine short(in-bank)

vbl     lda     $4210
	and     #$80            ; check the highest bit
	beq     vbl             ; see if vertical blank is going on now
	rts

waitasec lda    $4210           ;\
	and     #$80            ; > check for vbl
	beq     waitasec        ;/
	dex                     ; go around the loop for x vbl's
	bne     waitasec        ; when done, x will be 0
	rts

msg     lda     $0000,x         ; x will be the address of data ($8xxx-$fxxx)
	sta     $2118           ; write it to v-ram ($2116 already written)
	stz     $2119
	inx                     ; increase read offset by one
	dey                     ; this is how many bytes to read+write
	bne     msg             ; branch if some still left
	rts

titlmus ldx     #$0000          ; clear index
noppo   nop
	nop
	inx                     ; small delay (needed after loading music)
	cpx     #$fa00          ; done with delay?
	bne     noppo           ; no?  go back
	lda     #$0f            ; play this one so sound effects will work
	sta     $2140
	ldx.v   #$001a          ; give it time to load/play before the
	jsr     waitasec        ; title-screen song starts
	lda     #$04
	sta     $2140         ;\
	ldx.v   #$001a         ;> this gives perfect timing for the intro song
	jsr     waitasec      ;/
	rts

       sep     #$30        ; ** needed for some assemblers not to mess up
fadein  ldy     #$00
fadein1 ldx     fade            ; get how fast to fade in
	iny                     ; increase brightness by 1
	sty     $2100           ; screen brightness control register/port
waitst  jsr     vbl             ; wait till the vertical blank
	dex                     ; dec the number of vbl's until next change
	bne     waitst          ; go through (fade) vbls per one shade lighter
	cpy     #$0f            ; check if screen is bright, then bra if not
	bne     fadein1
	rts

fadeout ldy     #$0f
fadout1 ldx     fade            ; get how fast to fade out
	dey                     ; decrease brightness by 1
	sty     $2100           ; screen brightness control register/port
waitsto jsr     vbl             ; wait till the vertical blank
	dex                     ; dec the number of vbl's until next change
	bne     waitsto         ; go through (fade) vbls per one shade darker
	cpy     #$00            ; check if screen is dark, then bra if not
	bne     fadout1
	rts

putb    lda     staron          ; check if box is supposed to be lit up
	beq     boxrts          ; just another rts
prntbox ldy.v   starloc         ; get current location of box (topleft byte)
	sty     $2116           ; write to there in vram
	ldy.v   #$0000          ; clear index
boxlp   lda     box,y           ; load box's map data
	sta     $2118           ; write it to vram
	stz     $2119           ; clear high byte
	iny                     ; increase index
	cpy.v   #$0043          ; box is 43h bytes, did it read+write em all?
	bne     boxlp
boxrts  rts

sfx     pha                     ; save the sound effect number
	lda     sfxtmp          ; load the flag
	eor     #$ff            ; change the byte from 00->ff, or ff->00
	sta     sfxtmp          ; store it for next time sfx is called
	bne     sfpart2         ; if ff, play second sound effect
	lda     #$aa            ; \  not sure exactly what it does beyond
	sta     $2142           ; /  the obvious (play sound effect)
	pla                     ; restore the sound effect number
	sta     $2141           ; tell the sound processor what sound effect
	rts
sfpart2 lda     #$aa            ; see above
	sta     $2142
	pla
	inc
	sta     $2141
	rts

add1    php                     ; save the processor settings
	sep     #$10            ; x,y = 8bit
	tax                     ; copy contents of a to x
	and     #$0f            ; leave only the least significant nibble
	cmp     #$09            ; see if it's 9 (to carry)
	beq     resadd          ; branch to add 10 and clear lower half
	inx                     ; add one to x
addr    txa                     ; copy x to a
	plp                     ; restore processor settings
	rts
resadd  txa                     ; copy x to a
	and     #$f0            ; chop off lower nibble
	cmp     #$90            ; the lower number is 9, is the high one also?
	beq     addr            ; if it is, branch to restore a and rts
	clc
	adc     #$10            ; add 10 to the number
	plp                     ; restore processor settings
	rts

getrand lda     rand            ; load unrefined random value
	bit     #$f0            ; check to see if it is over 0f hex
	bne     grsub
	bit     #$08            ; branch to end if it's less than 07 hex
	beq     grend
	bit     #$07            ; if > 7, make sure it's 8, no greater
	beq     grend
grsub   clc
	sbc     #$08            ; subtract 08, so it will be a random
	sta     rand            ; number from 0-8
	bra     getrand         ; go back and see if it's 8 or less yet
grend   rts


;============================================================================
;=                            JOYPAD SUBROUTINES                            =
;============================================================================

       rep     #$10        ; ** needed for some assemblers not to mess up
jsstart ldy.v   #$0000          ; clear y so it wont be 6502
	lda     $4210           ; check for Vertical blank
	and     #$80
	beq     jsstart         ; no blank..  jump back!
joypa   lda     $4212           ; is joypad ready to be read?
	bit     #$80
	bne     joypa           ; no? go back until it is!
	lda     $4219           ; read joypad high byte
	and     #$10            ; leave only "start" bit
	bne     jsend           ; start pressed?  load y with the good stuff.
	dex
	bne     jsstart         ; more vbl's to do before returning?
	rts
jsend   ldy.v   #$6502          ; on return, jmp out of the loop
	rts

jsupdn  ldy.v   #$0000          ; clear it to only go once from that flag
	lda     $4210           ; check for Vertical blank
	and     #$80
	beq     jsupdn          ; no blank..  jump back!
joyupdn lda     $4212           ; is joypad ready to be read?
	bit     #$80
	bne     joyupdn         ; no? go back until it is!
	lda     $4218           ; read joypad low byte
	and     #$c0            ; leave a and x bits
	bne     udabxy          ; branch if pressed (bits exist)
	lda     $4219           ; read joypad high byte
	bit     #$c0            ; check to see if b or y is pressed
	bne     udabxy          ; a, b, x, or y pressed? go to udabxy
	bit     #$08
	bne     udup            ; bra if up pressed
	bit     #$04
	bne     uddownj         ; bra if down pressed
	stz     holdbtn         ; going through joy-check routine with
	rts                     ; nothing pressed clears this flag
uddownj jmp     uddown          ; branch is too far, so must use jump
udabxy  ldy.v   #$6502          ; after returning, it will jump when it
	lda     #$08            ; laser shot
	jsr     sfx             ; play sound effect
	rts                     ; sees this. (can't jump out of subroutine!)
udup    lda     holdbtn         ; check and see if a direction was already
	bne     uduend          ; pressed (holding down a direction)
	lda     #$d0
	sta     holdbtn         ; no?  then set this flag to yes.
	ldy.v   starloc
	cpy.v   #$11ac          ; see if already in the top position
	beq     uduend
	lda     #$18            ; cutting air/whip
	jsr     sfx             ; play sound effect
	cpy.v   #$11cc          ; branch to udup1 if in second position
	beq     udup1
	cpy.v   #$11ec          ; branch to udup2 if in third position
	beq     udup2
	lda     staron          ; assume in bottom, move up to third
	beq     udupn
	jsr     vbl             ; write to v-ram during vbl
	sty     $2116           ; writing to position of old star (starloc)
	stz     $2118           ; erase that old star
	ldy.v   #$11ec          ; this is the new location
	sty     $2116
	lda     #$3b            ; write the new star
	sta     $2118
udupn   ldy.v   #$11ec          ; assume bottom position and move up one
	sty     starloc         ; store this new position
	lda     #$02            ; store which mode to run (mode 02)
	sta     mode
uduend  rts

udup1   lda     staron          ; go here if in the second spot (move to top)
	beq     udup1n          ; if the star's off, dont turn it on
	jsr     vbl
	sty     $2116           ; writing to position of old star
	stz     $2118           ; erase that old star
	ldy.v   #$11ac          ; new star location
	sty     $2116
	lda     #$3b            ; write that new star
	sta     $2118
udup1n  ldy.v   #$11ac          ; new location (at top)
	sty     starloc
	stz     mode            ; store which mode to run (mode 00)
	rts

udup2   lda     staron          ; go here if its in the third spot (move to 2)
	beq     udup2n          ; if the star's off, dont turn it on
	jsr     vbl
	sty     $2116           ; writing to position of old star
	stz     $2118           ; erase that old star
	ldy.v   #$11cc
	sty     $2116
	lda     #$3b            ; write that new star
	sta     $2118
udup2n  ldy.v   #$11cc
	sty     starloc
	lda     #$01            ; store which mode to run (mode 00)
	sta     mode
	rts


uddown  lda     holdbtn         ; check and see if a direction was already
	bne     uddend          ; pressed (holding down a direction)
	lda     #$d0
	sta     holdbtn         ; no?  then set this flag to yes.
	ldy.v   starloc
	cpy.v   #$120c          ; see if already in the bottom position
	beq     uddend
	lda     #$18            ; cutting air/whip
	jsr     sfx             ; play sound effect
	cpy.v   #$11ac          ; branch to uddown1 if in top position
	beq     uddown1
	cpy.v   #$11cc          ; branch to uddown2 if in second position
	beq     uddown2
	lda     staron          ; assume third position and move down one
	beq     uddownn
	jsr     vbl
	sty     $2116           ; writing to position of old star
	stz     $2118           ; erase that old star
	ldy.v   #$120c
	sty     $2116
	lda     #$3b
	sta     $2118
uddownn ldy.v   #$120c
	sty     starloc
	lda     #$03
	sta     mode            ; store which mode to run (mode 03) battle
uddend  rts

uddown1 lda     staron          ; jump here if in top pos., move down to 2nd
	beq     uddwn1n
	jsr     vbl
	sty     $2116           ; writing to position of old star
	stz     $2118           ; erase that old star
	ldy.v   #$11cc
	sty     $2116
	lda     #$3b
	sta     $2118
uddwn1n ldy.v   #$11cc
	sty     starloc
	lda     #$01
	sta     mode            ; store which mode to run (mode 01) normal
	rts

uddown2 lda     staron          ; jump here if in 2nd pos., move down to third
	beq     uddwn2n
	jsr     vbl
	sty     $2116           ; writing to position of old star
	stz     $2118           ; erase that old star
	ldy.v   #$11ec
	sty     $2116
	lda     #$3b
	sta     $2118
uddwn2n ldy.v   #$11ec
	sty     starloc
	lda     #$02
	sta     mode            ; store which mode to run (mode 02) hard
	rts

jsudlr  rep     #$10
	sep     #$20
	ldy.v   #$0000   ; clear it to only go once from a/b/x/y pressed flag
udlrvbl lda     $4210           ; check for Vertical blank
	and     #$80
	beq     udlrvbl         ; no blank..  jump back!
joyudlr lda     $4212           ; is joypad ready to be read?
	and     #$80
	bne     joyudlr         ; no? go back until it is!
	cmp     playern         ; is it player 2's turn? 
	bne     pla2joy         ; yes? read from joypad 2
	lda     $4218           ; read joypad 1 low byte
	xba
	lda     $4219           ; read joypad 1 high byte
	bra     compjoy
pla2joy lda     $421a           ; read joypad 2 low byte
	xba
	lda     $421b           ; read joypad 2 high byte
compjoy bit     #$04
	bne     cdown           ; bra if down pressed
	bit     #$01
	bne     crightb         ; bra if right pressed
	bit     #$08
	bne     cupb            ; bra if up pressed
	bit     #$02
	bne     cleftb          ; bra if down pressed
	bit     #$c0            ; check to see if b or y is pressed
	bne     cabxy           ; a, b, x, or y pressed? go to udabxy
	xba                     ; compare joypad low byte
	and     #$c0            ; leave a and x bits
	bne     cabxy           ; branch if pressed (bits exist)
	stz     holdbtn         ; going through joy-check routine with
	rts                     ; nothing pressed clears this flag
cabxy   ldy.v   #$6502          ; after returning, it will jump when it
	rts                     ; sees this. (can't jump out of subroutine!)
crightb jmp     cright          ; a branch would be out of range
cupb    jmp     cup             ; a branch would be out of range
cleftb  jmp     cleft           ; a branch would be out of range

cdown   lda     holdbtn
	bne     cdown1          ; if hold-button flag is nonzero, then rts
	lda     #$04
	sta     holdbtn         ; store something nonzero in holdbtn flag
	lda     cursor          ; load cursor-map
	and     #$40            ; check if already on the bottom (see equ's)
	bne     cdown1          ; if yes, then rts
	lda     #$26            ; light tap
	jsr     sfx             ; play sound effect
	jsr     vbl             ; write to vram during vbl
	ldy.v   starloc         ; \
	sty     $2116           ;  \
	ldy.v   #$0060          ;  /  clear the box (turn cursor off)
	jsr     zero            ; /
	rep     #$20
	lda.v   starloc         ; get cursor-box's location
	clc
	adc.v   #$0080          ; move down 4 lines
	sta     starloc         ; store cursor's new location
	sep     #$20
	lda     squaren         ; move square number down a line (add 3)
	inc
	inc
	inc
	sta     squaren
	lda     cursor          ; get cursor's map
	bit     #$10            ; see if is on the top row
	bne     cdown2          ; if it is, move to center
	and     #$07            ; clear vertical bits
	ora     #$40            ; set bit for bottom row
	sta     cursor
	jsr     putb            ; put the box in its new place
cdown1  rts
cdown2  and     #$07            ; clear vertical bits
	ora     #$20            ; set bit for center row
	sta     cursor          ; store its new value(location)
	jsr     putb            ; put the box in its new place
	rts

cright  lda     holdbtn         ; if hold-button flag is nonzero, then rts
	bne     cright1
	lda     #$04
	sta     holdbtn         ; store something nonzero in holdbtn flag
	lda     cursor          ; load cursor-map
	and     #$04
	bne     cright1         ; check if already on the right (see equ's)
	lda     #$26            ; light tap
	jsr     sfx             ; play sound effect
	jsr     vbl             ; write to vram during vbl
	ldy.v   starloc         ; \
	sty     $2116           ;  \
	ldy.v   #$0060          ;  /  clear the box (turn cursor off)
	jsr     zero            ; /
	rep     #$20
	lda.v   starloc         ; get cursor-box's location
	inc
	inc
	inc
	inc                     ; move right 4 tiles
	sta     starloc         ; store cursor's new location
	sep     #$20
	lda     squaren         ; move square number right a square (add 1)
	inc
	sta     squaren
	lda     cursor          ; get cursor's map
	bit     #$01            ; see if is on the left column
	bne     cright2         ; if it is, move to center
	and     #$70            ; clear horizontal bits
	ora     #$04            ; set bit for right column
	sta     cursor
	jsr     putb            ; put the box in its new place
cright1 rts
cright2 and     #$70            ; clear horizontal bits
	ora     #$02            ; set bit for center column
	sta     cursor          ; store its new value(location)
	jsr     putb            ; put the box in its new place
	rts

cup     lda     holdbtn
	bne     cup1            ; if hold-button flag is nonzero, then rts
	lda     #$04
	sta     holdbtn         ; store something nonzero in holdbtn flag
	lda     cursor          ; load cursor-map
	and     #$10
	bne     cup1            ; check if already on the top (see equ's)
	lda     #$26            ; light tap
	jsr     sfx             ; play sound effect
	jsr     vbl             ; write to vram during vbl
	ldy.v   starloc         ; \
	sty     $2116           ;  \
	ldy.v   #$0060          ;  /  clear the box (turn cursor off)
	jsr     zero            ; /
	rep     #$20
	lda.v   starloc         ; get cursor-box's location
	clc
	sbc.v   #$007f          ; move up 4 lines
	sta     starloc         ; store cursor's new location
	sep     #$20
	lda     squaren         ; move square number up a line (subtract 3)
	dec
	dec
	dec
	sta     squaren
	lda     cursor          ; get cursor's map
	bit     #$40            ; see if is on the bottom row
	bne     cup2            ; if it is, move to center
	and     #$07            ; clear vertical bits
	ora     #$10            ; set bit for top row
	sta     cursor
	jsr     putb            ; put the box in its new place
cup1    rts
cup2    and     #$07            ; clear vertical bits
	ora     #$20            ; set bit for center row
	sta     cursor          ; store its new value(location)
	jsr     putb            ; put the box in its new place
	rts

cleft   lda     holdbtn
	bne     cleft1          ; if hold-button flag is nonzero, then rts
	lda     #$04
	sta     holdbtn         ; store something nonzero in holdbtn flag
	lda     cursor          ; load cursor-map
	and     #$01
	bne     cleft1          ; check if already on the left (see equ's)
	lda     #$26            ; light tap
	jsr     sfx             ; play sound effect
	jsr     vbl             ; write to vram during vbl
	ldy.v   starloc         ; \
	sty     $2116           ;  \
	ldy.v   #$0060          ;  /  clear the box (turn cursor off)
	jsr     zero            ; /
	rep     #$20
	lda.v   starloc         ; get cursor-box's location
	dec
	dec
	dec
	dec                     ; move left 4 tiles
	sta     starloc         ; store cursor's new location
	sep     #$20
	lda     squaren         ; move square number left a square(subtract 1)
	dec
	sta     squaren
	lda     cursor          ; get cursor's map
	bit     #$04            ; see if is on the right column
	bne     cleft2          ; if it is, move to center
	and     #$70            ; clear horizontal bits
	ora     #$01            ; set bit for left column
	sta     cursor
	jsr     putb            ; put the box in its new place
cleft1  rts
cleft2  and     #$70            ; clear horizontal bits
	ora     #$02            ; set bit for left column
	sta     cursor          ; store its new value(location)
	jsr     putb            ; put the box in its new place
	rts

jsplr   jsr     vbl
joyplr  lda     $4212           ; is joypad ready to be read?
	bit     #$80
	bne     joyplr          ; no? go back until it is!
	lda     $4218           ; read joypad low byte
	and     #$c0            ; leave a and x bits
	bne     lrabxy          ; branch if pressed (bits exist)
	lda     $4219           ; read joypad high byte
	bit     #$c0            ; check to see if b or y is pressed
	bne     lrabxy          ; a, b, x, or y pressed? go to lrabxy
	bit     #$02            ; is left pressed?
	bne     lrleft          ; yes -> branch
	bit     #$01            ; is right pressed?
	bne     lrright
	rts
lrabxy  ldy.v   #$6502          ; after returning, it will jump when it
	rts                     ; sees this. (can't jump out of subroutine!)

lrleft  ldy.v   starloc         ; location of star (video ram offset)
	cpy.v   #$118b
	beq     lrlend          ; branch if already at left
	lda     #$2a            ; metallic tap
	jsr     sfx             ; play sound effect
	ldy.v   #$118b
	sty     starloc         ; store the new location of the star
	lda     staron
	beq     lrlend          ; jump to rts if star is not on(lit)
	jsr     vbl
	ldy.v   #$1191
	sty     $2116           ; writing to position of old star
	stz     $2118           ; erase that old star
	ldy.v   #$118b
	sty     $2116           ; write where new star is
	lda     #$3b
	sta     $2118           ; write star(map data) to vram
lrlend  rts

lrright ldy.v   starloc         ; location of star (video ram offset)
	cpy.v   #$1191
	beq     lrlend          ; branch if already at left
	lda     #$2a            ; metallic tap
	jsr     sfx             ; play sound effect
	ldy.v   #$1191
	sty     starloc         ; store the new location of the star
	lda     staron
	beq     lrlend          ; jump to rts if star is not on(lit)
	jsr     vbl
	ldy.v   #$118b
	sty     $2116           ; writing to position of old star
	stz     $2118           ; erase that old star
	ldy.v   #$1191
	sty     $2116           ; write where new star is
	lda     #$3b
	sta     $2118           ; write star(map data) to vram
	rts


;============================================================================
;=                             DISPLAY THE SCORES                           =
;============================================================================

p2msg   ldx.v   #pl1txt         ; load location of message
	ldy.v   #$0007          ; message length
	jsr     msg             ; writes "Player "
	ldx.v   #$0061          ; 61 is map value for it
	stx     $2118           ; writes "2"
	bra     plcontu         ; jump back in to write the next message

dispsco ldx.v   #$3102          ; location of msg (just left of game squares)
	stx     $2116
	ldx     #pl1txt
	ldy.v   #$0008
	jsr     vbl             ; make sure it's vbl time
	jsr     msg             ; writes "Player 1"

	ldx.v   #$3117
	stx     $2116
	lda     mode
	cmp     #$03            ; if battle mode,
	beq     p2msg           ;  write player 2 instead of computer
	ldx.v   #comptxt
	ldy.v   #$0008
	jsr     msg             ; writes "Computer"

plcontu ldx.v   #$3163          ; upper left side of screen
	stx     $2116
	ldx.v   #wontxt
	ldy.v   #$0004
	jsr     msg             ; writes "won:", for player 1
	ldx.v   #$3179          ; upper right side of screen
	stx     $2116
	ldx.v   #wontxt
	ldy.v   #$0004
	jsr     msg             ; writes "won:", for player 2

	ldx.v   #$31c3          ; center left side of screen
	stx     $2116
	ldx.v   #losttxt
	ldy.v   #$0005
	jsr     msg             ; writes "lost:", for player 1
	ldx.v   #$31d9          ; center right side of screen
	stx     $2116
	ldx.v   #losttxt
	ldy.v   #$0005
	jsr     msg             ; writes "lost:", for player 2

	ldx.v   #$3223          ; lower left side of screen
	stx     $2116
	ldx.v   #tiedtxt
	ldy.v   #$0005
	jsr     msg             ; writes "tied:", for player 1
	ldx.v   #$3239          ; lower right side of screen
	stx     $2116
	ldx.v   #tiedtxt
	ldy.v   #$0005
	jsr     msg             ; writes "tied:", for player 2
	
	
	ldx.v   #$3184          ; writes player 1's won, 2's lost (numbers)
	stx     $2116           ; player 1's won position
	sep     #$10
	ldx     mode            ; the score is indexed by the mode
	lda     won,x           ; load player 1's won score
	clc                     ; absolutely necessary!  very odd
	jsr     dec2chr         ; change decimal to character (and write)
	rep     #$10
	ldx.v   #$31fa          ; player 2's lost position
	stx     $2116
	sta     $2118           ; most significant digit of p2's lost score
	stz     $2119
	xba                     ; trade top/bottom bytes of a
	sta     $2118           ; least significant digit
	stz     $2119
	
	ldx.v   #$319a          ; writes player 1's lost, 2's won
	stx     $2116           ; player 1's lost position
	sep     #$10
	ldx     mode            ; the score is indexed by the mode
	lda     lost,x          ; load player 1's lost score
	jsr     dec2chr         ; change decimal to character (and write)
	rep     #$10
	ldx.v   #$31e4          ; player 2's won position
	stx     $2116
	sta     $2118           ; most significant digit of p2's won score
	stz     $2119
	xba                     ; trade top/bottom bytes of a
	sta     $2118           ; least significant digit
	stz     $2119
	
	ldx.v   #$3244          ; writes player 1's tied, 2's tied
	stx     $2116           ; player 1's tied position
	sep     #$10
	ldx     mode            ; the score is indexed by the mode
	lda     tied,x          ; load how many times tied
	jsr     dec2chr         ; change decimal to character (and write)
	rep     #$10
	ldx.v   #$325a          ; player 2's tied position
	stx     $2116
	sta     $2118           ; most significant digit of p2's tied score
	stz     $2119
	xba                     ; trade top/bottom bytes of a
	sta     $2118           ; least significant digit
	stz     $2119
	rts


dec2chr pha                     ; save a for later
	and     #$f0            ; take the high nibble (tens digit)
	ror
	ror
	ror
	ror                     ; put it in the lower position
	clc
	adc     #$5f            ; the characters for 0-9 start at tile 5d/vram
	sta     $2118           ; write that number (map) to v-ram
	stz     $2119
	xba                     ; save it for later writing on opponent's side
	pla                     ; restore a
	and     #$0f            ; leave only lower nibble (1's digit)
	clc
	adc     #$5f            ; turn number into corresponding map data
	sta     $2118           ; write it
	stz     $2119
	xba                     ; put 10's digit first (for writing again)
	rts






	;ds      $fffc-*
	;dw      $8000
	;dw      $0000
	pad
	bin m1.bin
	bin m2.bin
