START   sei
	phk             ;GET THE CURRENT BANK AND STORE ON STACK
	plb             ;GET VALUE OFF STACK AND MAKE IT THE CURRENT
			;PROGRAMMING BANK
	clc             ;CLEAR CARRY BIT
	xce             ;NATIVE 16 BIT MODE (NO 6502 EMULATION!)

;==========================================================================
;               START OF SNES REGISTER INITIALIZATION
;==========================================================================
;
	   SEP #$30     ; X,Y,A are 8 bit numbers
	   LDA #$8F     ; screen off, full brightness
	   STA $2100    ; brightness + screen enable register
	   LDA #$00     ;
	   STA $2101    ; Sprite register (size + address in VRAM)
	   LDA #$00
	   STA $2102    ; Sprite registers (address of sprite memory [OAM])
	   STA $2103    ;    ""                       ""
	   LDA #$00     ; Mode 0
	   STA $2105    ; Graphic mode register
	   LDA #$00     ; no planes, no mosaic
	   STA $2106    ; Mosaic register
	   LDA #$00     ;
	   STA $2107    ; Plane 0 map VRAM location
	   LDA #$00
	   STA $2108    ; Plane 1 map VRAM location
	   LDA #$00
	   STA $2109    ; Plane 2 map VRAM location
	   LDA #$00
	   STA $210A    ; Plane 3 map VRAM location
	   LDA #$00
	   STA $210B    ; Plane 0+1 Tile data location
	   LDA #$00
	   STA $210C    ; Plane 2+3 Tile data location
	   LDA #$00
	   STA $210D    ; Plane 0 scroll x (first 8 bits)
	   STA $210D    ; Plane 0 scroll x (last 3 bits) #$0 - #$07ff
	   STA $210E    ; Plane 0 scroll y (first 8 bits)
	   STA $210E    ; Plane 0 scroll y (last 3 bits) #$0 - #$07ff
	   STA $210F    ; Plane 1 scroll x (first 8 bits)
	   STA $210F    ; Plane 1 scroll x (last 3 bits) #$0 - #$07ff
	   STA $2110    ; Plane 1 scroll y (first 8 bits)
	   STA $2110    ; Plane 1 scroll y (last 3 bits) #$0 - #$07ff
	   STA $2111    ; Plane 2 scroll x (first 8 bits)
	   STA $2111    ; Plane 2 scroll x (last 3 bits) #$0 - #$07ff
	   STA $2112    ; Plane 2 scroll y (first 8 bits)
	   STA $2112    ; Plane 2 scroll y (last 3 bits) #$0 - #$07ff
	   STA $2113    ; Plane 3 scroll x (first 8 bits)
	   STA $2113    ; Plane 3 scroll x (last 3 bits) #$0 - #$07ff
	   STA $2114    ; Plane 3 scroll y (first 8 bits)
	   STA $2114    ; Plane 3 scroll y (last 3 bits) #$0 - #$07ff
	   LDA #$80     ; increase VRAM address after writing to $2119
	   STA $2115    ; VRAM address increment register
	   LDA #$00
	   STA $2116    ; VRAM address low
	   STA $2117    ; VRAM address high
	   STA $211A    ; Initial Mode 7 setting register
	   STA $211B    ; Mode 7 matrix parameter A register (low)
	   LDA #$01
	   STA $211B    ; Mode 7 matrix parameter A register (high)
	   LDA #$00
	   STA $211C    ; Mode 7 matrix parameter B register (low)
	   STA $211C    ; Mode 7 matrix parameter B register (high)
	   STA $211D    ; Mode 7 matrix parameter C register (low)
	   STA $211D    ; Mode 7 matrix parameter C register (high)
	   STA $211E    ; Mode 7 matrix parameter D register (low)
	   LDA #$01
	   STA $211E    ; Mode 7 matrix parameter D register (high)
	   LDA #$00
	   STA $211F    ; Mode 7 center position X register (low)
	   STA $211F    ; Mode 7 center position X register (high)
	   STA $2120    ; Mode 7 center position Y register (low)
	   STA $2120    ; Mode 7 center position Y register (high)
	   STA $2121    ; Color number register ($0-ff)
	   STA $2123    ; BG1 & BG2 Window mask setting register
	   STA $2124    ; BG3 & BG4 Window mask setting register
	   STA $2125    ; OBJ & Color Window mask setting register
	   STA $2126    ; Window 1 left position register
	   STA $2127    ; Window 2 left position register
	   STA $2128    ; Window 3 left position register
	   STA $2129    ; Window 4 left position register
	   STA $212A    ; BG1, BG2, BG3, BG4 Window Logic register
	   STA $212B    ; OBJ, Color Window Logic Register (or,and,xor,xnor)
	   LDA #$01
	   STA $212C    ; Main Screen designation (planes, sprites enable)
	   LDA #$00
	   STA $212D    ; Sub Screen designation
	   LDA #$00
	   STA $212E    ; Window mask for Main Screen
	   STA $212F    ; Window mask for Sub Screen
	   LDA #$30
	   STA $2130    ; Color addition & screen addition init setting
	   LDA #$00
	   STA $2131    ; Add/Sub sub designation for screen, sprite, color
	   LDA #$E0
	   STA $2132    ; color data for addition/subtraction
	   LDA #$00
	   STA $2133    ; Screen setting (interlace x,y/enable SFXdata)
	   LDA #$00
	   STA $4200    ; Enable V-blank, interrupt, Joypad register
	   LDA #$FF
	   STA $4201    ; Programmable I/O port
	   LDA #$00
	   STA $4202    ; Multiplicand A
	   STA $4203    ; Multiplier B
	   STA $4204    ; Multiplier C
	   STA $4205    ; Multiplicand C
	   STA $4206    ; Divisor B
	   STA $4207    ; Horizontal Count Timer
	   STA $4208    ; Horizontal Count Timer MSB (most significant bit)
	   STA $4209    ; Vertical Count Timer
	   STA $420A    ; Vertical Count Timer MSB
	   STA $420B    ; General DMA enable (bits 0-7)
	   STA $420C    ; Horizontal DMA (HDMA) enable (bits 0-7)
	   STA $420D    ; Access cycle designation (slow/fast rom)
;===========================================================================
;                        END OF INIT ROUTINE
;===========================================================================
	rep     #$30    ; X,Y,A fixed -> 16 bit mode
	lda     #$0000
	tcd
	sep     #$20    ; Accumulator ->  8 bit mode
	lda     #$10            ; Screen map data @ VRAM location $1000
	sta     $2107           ; Plane 0 Map location register
	lda     #$02            ; Plane 0 Tile graphics @ $2000
	sta     $210b           ; Plane 0 Tile graphics register
	lda     #$00            ; MODE 0 value
	sta     $2105           ; Graphics mode register
	lda     #$01            ; Plane 0 value (bit one)
	sta     $212c           ; Plane enable register
	lda     #$00
	sta     $2121           ; Set color number to 0 (background)
	stz     $2122           ; BLACK lo byte
	stz     $2122           ; BLACK hi byte
	lda     #$46            ; white color, lower 8 bits
	sta     $2122           ; write to next color number (01)
	lda     #$60
	sta     $2122           ; enter same value to color number (01)
	lda     #$ff
	sta     $2122           ; write to next color number (01)
	sta     $2122           ; enter same value to color number (01)
	sta     $2122           ; write to next color number (01)
	sta     $2122           ; enter same value to color number (01)
	lda     #$01
	sta     $4200           ; ENABLE JOYPAD READ (bit one)
;==========================================================================
;                      Start transfer of graphics to VRAM
;==========================================================================
	ldx     #$2000          ; Assign VRAM location $2000 to $2116/7
	stx     $2116           ; writing to $2118/9 will store data here!
	ldy     #$0000
loadtile lda    charset,y        ; Get CHARACTER SET DATA (Font DATA)
	sta     $2118           ; store bitplane 1
	sta     $2119           ; clear bitplane 2 and increase VRAM address
	iny
	cpy     #$0200          ; Transfer $0200 bytes
	bne     loadtile

	ldx     #$2000
	stx     $2116
	ldx     #$000f
ffloop  lda     #$ff
	sta     $2118
	stz     $2119
	dex
	bne     ffloop
	ldx     #$1000          ; Assign VRAM location $1000 to $2116/7
	stx     $2116
	ldx     #$0000
text    lda     screen,x        ; Get ASCII text data
	and     #$3f            ; we only want the first 64 characters
				; convert ascii to C64 screen code
	sta     $2118
	stz     $2119           ; clear unwanted bits, no H/V flipping
	inx
	cpx     #$0400          ; transfer entire screen
				; $20*$20=$0400  (1024 bytes)
	bne     text

	lda     #$0f            ; SCREEN ENABLED, FULL BRIGHTNESS
	sta     $2100           ;
	cli                     ; Clear interrupt bit
	lda     #$41            ; ** change this to change the starting
	sta     $00
	lda     #$f4            ; ** color. (high byte=$00 low=$01)
	sta     $01

run     jsr     loop
	jsr     joyp
	bra     run

joyp    lda     $4210           ; check for Vertical blank
	and     #$80
	beq     joyp            ; no blank..  jump back!
joyp2   lda     $4210           ; check for Vertical blank
	and     #$80
	beq     joyp2           ; no blank..  jump back!
joyp3   lda     $4210           ; check for Vertical blank
	and     #$80
	beq     joyp3           ; no blank..  jump back!
	
	lda     $4212           ; is joypad ready to be read?
	and     #$01
	bne     joyp            ; no? go back until it is!
	lda     $4219           ; read joypad high byte
	bit     #$08
	bne     incred
	bit     #$04
	bne     decred
	bit     #$01
	bne     incgrn
	bit     #$02
	bne     decgrn
	bit     #$80
	bne     incblu
	bit     #$40
	bne     decblu
	bra     joyp

incred  lda     $01
	and     #$1f
	cmp     #$1f
	beq     increde
	inc     $01
increde rts

decred  lda     $01
	and     #$1f
	beq     decrede
	dec     $01
decrede rts

incgrn  lda     $00
	and     #$03
	cmp     #$03
	beq     incgrn1
incgrn2 lda     $01
	and     #$e0
	cmp     #$e0
	beq     incgrn3
	lda     #$20
	clc
	adc     $01
	sta     $02
	lda     $01
	and     #$1f
	ora     $02
	sta     $01
	rts
incgrn1 lda     $01
	and     #$e0
	cmp     #$e0
	bne     incgrn2
	rts
incgrn3 inc     $00
	lda     $01
	and     #$1f
	sta     $01
	rts

decblu  bra     decbluj

decgrn  lda     $01
	and     #$e0
	beq     decgrn2
decgrn1 rol
	rol
	rol
	rol
	dec
	ror
	ror
	ror
	ror
	sta     $02
	lda     $01
	and     #$1f
	ora     $02
	sta     $01
decgrn3 rts
decgrn2 lda     $00
	and     #$03
	beq     decgrn3
	dec     $00
	lda     #$e0
	ora     $01
	sta     $01
	rts

incblu  lda     $00
	and     #$7c
	cmp     #$7c
	beq     incblu1
	lda     $00
	ror
	ror
	inc
	rol
	rol
	sta     $00
incblu1 rts

decbluj lda     $00
	bit     #$7c
	beq     decblu1
	ror
	ror
	dec
	rol
	rol
	sta     $00
decblu1 rts

loop    lda     $4210
	and     #$80
	beq     loop
	
	lda     #$80
	sta     $2100
	ldx     #$1243
	stx     $2116
	lda     $00
	ror
	ror
	ror
	ror
	and     #$0f
	clc
	adc     #$30
	sta     $2118
	stz     $2119
	lda     $00
	and     #$0f
	clc
	adc     #$30
	sta     $2118
	stz     $2119
	
	lda     $01
	ror
	ror
	ror
	ror
	and     #$0f
	clc
	adc     #$30
	sta     $2118
	stz     $2119
	lda     $01
	and     #$0f
	clc
	adc     #$30
	sta     $2118
	stz     $2119
	lda     #$20
	sta     $2118
	stz     $2119
	sta     $2118
	stz     $2119
	
	
	lda     $00
	and     #$80
	rol
	clc
	adc     #$30
	sta     $2118
	stz     $2119
;        
	lda     #$20
	sta     $2118
	stz     $2119
;

	lda     $00
	and     #$40
	rol
	rol
	adc     #$30
	sta     $2118
	stz     $2119

	lda     $00
	and     #$20
	rol
	rol
	rol
	adc     #$30
	sta     $2118
	stz     $2119

	lda     $00
	and     #$10
	rol
	rol
	rol
	rol
	adc     #$30
	sta     $2118
	stz     $2119

	lda     $00
	and     #$08
	ror
	ror
	ror
	adc     #$30
	sta     $2118
	stz     $2119

	lda     $00
	and     #$04
	ror
	ror
	adc     #$30
	sta     $2118
	stz     $2119
;
	lda     #$20
	sta     $2118
	stz     $2119
;
	lda     $00
	and     #$02
	ror
	adc     #$30
	sta     $2118
	stz     $2119

	lda     $00
	and     #$01
	adc     #$30
	sta     $2118
	stz     $2119


	lda     $01
	and     #$80
	rol
	adc     #$30
	sta     $2118
	stz     $2119
	
	lda     $01
	and     #$40
	rol
	rol
	adc     #$30
	sta     $2118
	stz     $2119

	lda     $01
	and     #$20
	rol
	rol
	rol
	adc     #$30
	sta     $2118
	stz     $2119
;
	lda     #$20
	sta     $2118
	stz     $2119
;
	lda     $01
	and     #$10
	rol
	rol
	rol
	rol
	adc     #$30
	sta     $2118
	stz     $2119

	lda     $01
	and     #$08
	ror
	ror
	ror
	adc     #$30
	sta     $2118
	stz     $2119

	lda     $01
	and     #$04
	ror
	ror
	adc     #$30
	sta     $2118
	stz     $2119

	lda     $01
	and     #$02
	ror
	adc     #$30
	sta     $2118
	stz     $2119

	lda     $01
	and     #$01
	adc     #$30
	sta     $2118
	stz     $2119

	lda     #$01
	sta     $2121
	lda     $01
	sta     $2122
	lda     $00
	sta     $2122
	lda     #$0f
	sta     $2100
	rts

;============================================================================
;= Cyber Font-Editor V1.4  Rel. by Frantic (c) 1991-1992 Sanity Productions =
;============================================================================
charset 
	dcb     $ff,$ff,$ff,$ff,$ff,$ff,$ff,$ff ;'@'
	dcb     $00,$3c,$66,$7e,$66,$66,$66,$00 ;'A'
	dcb     $00,$7c,$66,$7c,$66,$66,$7c,$00 ;'B'
	dcb     $00,$3c,$66,$60,$60,$66,$3c,$00 ;'C'3
	dcb     $00,$78,$6c,$66,$66,$6c,$78,$00 ;'D'
	dcb     $00,$7e,$60,$78,$60,$60,$7e,$00 ;'E'
	dcb     $00,$7e,$60,$78,$60,$60,$60,$00 ;'F'
	dcb     $00,$3c,$66,$60,$6e,$66,$3c,$00 ;'G'7
	dcb     $00,$66,$66,$7e,$66,$66,$66,$00 ;'H'
	dcb     $00,$3c,$18,$18,$18,$18,$3c,$00 ;'I'
	dcb     $00,$1e,$0c,$0c,$0c,$6c,$38,$00 ;'J'
	dcb     $00,$6c,$78,$70,$78,$6c,$66,$00 ;'K'
	dcb     $00,$60,$60,$60,$60,$60,$7e,$00 ;'L'
	dcb     $00,$63,$77,$7f,$6b,$63,$63,$00 ;'M'
	dcb     $00,$66,$76,$7e,$7e,$6e,$66,$00 ;'N'
	dcb     $00,$3c,$66,$66,$66,$66,$3c,$00 ;'O'f
	dcb     $00,$7c,$66,$66,$7c,$60,$60,$00 ;'P'
	dcb     $00,$3c,$66,$66,$66,$3c,$0e,$00 ;'Q'
	dcb     $00,$7c,$66,$66,$7c,$6c,$66,$00 ;'R'
	dcb     $00,$3e,$60,$3c,$06,$66,$3c,$00 ;'S'
	dcb     $00,$7e,$18,$18,$18,$18,$18,$00 ;'T'
	dcb     $00,$66,$66,$66,$66,$66,$3c,$00 ;'U'
	dcb     $00,$66,$66,$66,$66,$3c,$18,$00 ;'V'
	dcb     $00,$63,$63,$6b,$7f,$77,$63,$00 ;'W'17
	dcb     $00,$66,$3c,$18,$3c,$66,$66,$00 ;'X'
	dcb     $00,$66,$66,$3c,$18,$18,$18,$00 ;'Y'
	dcb     $00,$7e,$0c,$18,$30,$60,$7e,$00 ;'Z'
	dcb     $00,$00,$FF,$00,$00,$00,$00,$0F ;'['
	dcb     $00,$00,$FF,$00,$00,$00,$00,$00 ;'\'
	dcb     $03,$1D,$E1,$01,$01,$01,$01,$01 ;']'
	dcb     $80,$80,$80,$80,$80,$80,$80,$80 ;'^'
	dcb     $07,$03,$03,$07,$07,$0F,$0F,$1F ;'_'1f
	dcb     $00,$00,$00,$00,$00,$00,$00,$00 ;' '
	dcb     $C0,$E0,$F0,$F0,$F0,$F8,$F8,$F8 ;'!'
	dcb     $01,$01,$01,$01,$01,$01,$01,$01 ;'"'
	dcb     $80,$80,$80,$81,$87,$8F,$9F,$9F ;'#'
	dcb     $1F,$1F,$0F,$C0,$E1,$F3,$F7,$F7 ;'$'
	dcb     $F8,$F0,$E0,$06,$8F,$CF,$EF,$EF ;'%'
	dcb     $01,$01,$01,$09,$99,$F9,$F9,$F9 ;'&'
	dcb     $9F,$99,$50,$40,$40,$40,$40,$20 ;'''27
	dcb     $F3,$F1,$60,$07,$0F,$1F,$1F,$1F ;'('
	dcb     $CF,$87,$03,$F0,$F8,$F8,$F8,$F0 ;')'
	dcb     $F1,$E1,$82,$02,$02,$02,$02,$04 ;'*'
	dcb     $20,$20,$10,$10,$08,$08,$04,$04 ;'+'
	dcb     $00,$00,$00,$00,$00,$18,$18,$30 ;','
	dcb     $F0,$E0,$E0,$C0,$C0,$E0,$F0,$00 ;'-'
	dcb     $00,$00,$00,$00,$00,$18,$18,$00 ;'.'
	dcb     $04,$04,$08,$08,$10,$10,$20,$20 ;'/'2f

	dcb     $00,$3c,$66,$6e,$76,$66,$3c,$00 ;'0'30
	dcb     $00,$18,$38,$18,$18,$18,$7e,$00 ;'1'31
	dcb     $00,$7c,$06,$0c,$30,$60,$7e,$00 ;'2'
	dcb     $00,$7e,$06,$1c,$06,$66,$3c,$00 ;'3'
	dcb     $00,$0e,$1e,$36,$7f,$06,$06,$00 ;'4'
	dcb     $00,$7e,$60,$7c,$06,$66,$3c,$00 ;'5'
	dcb     $00,$3e,$60,$7c,$66,$66,$3c,$00 ;'6'
	dcb     $00,$7e,$06,$0c,$0c,$0c,$0c,$00 ;'7'
	dcb     $00,$3c,$66,$3c,$66,$66,$3c,$00 ;'8'
	dcb     $00,$3c,$66,$3e,$06,$66,$3c,$00 ;'9'39
	dcb     $00,$3c,$66,$7e,$66,$66,$66,$00 ;'A'3a
	dcb     $00,$7c,$66,$7c,$66,$66,$7c,$00 ;'B'
	dcb     $00,$3c,$66,$60,$60,$66,$3c,$00 ;'C'
	dcb     $00,$78,$6c,$66,$66,$6c,$78,$00 ;'D'
	dcb     $00,$7e,$60,$78,$60,$60,$7e,$00 ;'E'
	dcb     $00,$7e,$60,$78,$60,$60,$60,$00 ;'F'3f


;               ;12345678901234567890123456789012
screen  dcb     "                                "
	dcb     "                                "
	dcb     "                                "
	dcb     "                                "
	dcb     "                                "
	dcb     "                                "
	dcb     "                                "
	dcb     "                                "
	dcb     "     HERE IS THE COLOR          "
	dcb     "                                "
	DCB     "            @@@                 "
	DCB     "            @@@                 "
	dcb     "            @@@                 "
	DCB     "                                "
	DCB     "   Y DEC B INC  BLUE            "
	dcb     "   L DEC R INC  GREEN           "
	dcb     "   D DEC U INC  RED             "
	DCB     "                                "
	DCB     "                                "
	dcb     "           BLUE  GREEN RED      "
	dcb     "                                "
	dcb     "                                "
	DCB     "                                "
	dcb     "                                "
	dcb     "                                "
	DCB     "                                "
	DCB     "                                "
	DCB     "                                "
	DCB     "                                "
