{.PL61}
program Promac15;

{.PA}
{.L-}
{$IASYNC.INC}
{.L+}

const
  XON  = 17;
  XOFF = 19;
  EOT  = 04;
  ESC  =$1B;

var
  prom_type : string[8];
  start_addr : integer;
  prom_size: integer;
  serial_number : integer;
  vectors: array[0..$f] of byte;
  chksum : integer;
  hex : array[0..15] of char;
  prom_obj : file of byte;
  temp_byte: byte;
  c : char;
  baud,comm : Integer;
  loop_var : integer;
  Result : record
             ax,bx,cx,dx,bp,si,di,ds,es,flags: Integer;
           end;

{ Returns false then error }
Function Get_responce(t:integer):boolean;
Var
  temp_c : char;
  time_out : integer;
Begin
Get_responce := true;
For time_out := 1 to (t) do
Begin
  Delay(200);
  if keypressed then read(kbd,c);
  if c = chr(ESC) then
  begin
    Async_send('@'); { reset }
    Close(prom_obj);
    Async_close;
    Halt;
  End;
  if async_buffer_check(temp_c) then
  Begin
    if temp_c = 'E' then get_responce := false;
    write(temp_c);
    time_out := time_out - 1;
  End;
End;
End;

begin
  hex := '0123456789ABCDEF';
  C := ' ';
  ClrScr;
  baud := 9600;
  comm := 1;
  Async_Init;  { initialize variables }
  if not Async_Open(comm, baud, 'N', 8, 1) then  { open the communications port }
  begin
    writeln('**ERROR: Async_Open failed');
    halt;
  end;

  Writeln('This program will burn Eproms, on the Promac15.');
  Writeln;

  Write('Enter Object filename : ');
  readln(prom_type);
  Assign(prom_obj,prom_type + '.obj');
  Reset(prom_obj);
  Write('Enter start address : ');
  readln(start_addr);
  Write('Enter length of code : ');
  readln(prom_size);
  Write('Enter prom type : ');
  readln(prom_type);
  Writeln('Enter prom(s) into the sockets.');
  Writeln('Press any key to CONTINUE or ESC key aborts.');
  Repeat Until Keypressed;
  Read(kbd,c);
  If c = chr(ESC) then halt;
  Writeln;
  Writeln('Programming proms....');
  Writeln('Press ESC key to abort.');
  { Reset }
  Writeln('Resetting...');
  Async_send('@');
  if not(get_responce(10)) then
  Begin
    Writeln('********Error*********');
    Async_send('@'); { reset }
    Close(prom_obj);
    Async_close;
    Halt;
  End;
  Writeln('Selecting prom type....');
  { Prom type }
  Async_send('R');
  For loop_var := 1 to length(prom_type) do
    async_send(prom_type[loop_var]);
  Async_send(chr(13));

  if not(get_responce(10)) then
  Begin
    Writeln('********Error*********');
    Async_send('@'); { reset }
    Close(prom_obj);
    Async_close;
    Halt;
  End;
  Writeln('Setting up recieve....');
  Async_send('P'); Async_send('5'); Async_send(chr(13));
  if not(get_responce(10)) then
  Begin
    Writeln('********Error*********');
    Async_send('@'); { reset }
    Close(prom_obj);
    Async_close;
    Halt;
  End;

  Writeln;
  Writeln('Burning in....');
  for loop_var := $0000 to Prom_size do
  begin
    if Async_Buffer_Check(c) then
      if ord(c) = XOFF then
        Repeat if Async_buffer_check(c) then write(c); Until ord(c) = XON;

    if KeyPressed then
    begin
      Read(Kbd, c);
      If c = chr(ESC) then
      Begin
        Async_send('@'); { reset }
        Close(prom_obj);
        Async_close;
        Halt;
      End;
    end;

    { send next character }
    if ((Loop_var and $f) = 0) then
    Begin
      chksum := 0;
      { Send address }
      Async_send(':'); write(':');
      Async_send('1'); write('1');
      c := '0';
      Async_send(c); write(c);
      c :=  hex[(Start_addr+loop_var) shr 12];
      Async_send(c); write(c);
      c := hex[((Start_addr + loop_var) and $fff) shr 8];
      Async_send(c); write(c);
      c := hex[((Start_addr + loop_var) and $ff) shr 4];
      Async_send(c); write(c);
      c := hex[(Start_addr + loop_var) and $f];
      Async_send(c); write(c);
      c := '0';
      Async_send(c); write(c);
      Async_send(c); write(c);
      chksum := $10 + ((start_addr + loop_var) shr 8) + ((start_addr + loop_var) and $ff);
    End;

    { Send next byte }
    read(prom_obj,temp_byte);
    chksum := chksum + temp_byte;
    Async_send(hex[temp_byte shr 4]); write(hex[temp_byte shr 4]);
    Async_send(hex[temp_byte and $f]); write(hex[temp_byte and $f]);

    if (loop_var and $f) = $f then
    begin
     { send check sum }
      chksum := -chksum and $ff;
      async_send(hex[chksum shr 4]); write(hex[chksum shr 4]);
      async_send(hex[chksum and $f]); write(hex[chksum and $f]);
      async_send(chr(13));
      writeln;
    end;
  End;
  Async_send(chr(EOT));
  Writeln('Done....');
  if get_responce(200) then writeln('All proms burnt successfully...')
  else writeln('Remove proms that did not program');
  Writeln;
  Async_close;
end.
