{*      MEM.PAS
 *
 * MIDAS Memory handling routines
 *
 * MIDAS Sound System v0.10, Copyright 1994 Petteri Kangaslampi
 * and Jarno Paananen
*}

unit Mem;


interface


function memAlloc(len : word) : pointer;
procedure memFree(blk : pointer);



implementation



function memAlloc(len : word) : pointer;
var
  wordp : ^word;
begin
asm
        push    di              { _ALL_ routines called from assembly are }
        push    si              { assumed to preserve ds, si, di and bp }
end;
  if len < 65530 then
  begin
    GetMem(wordp, len+2);
    wordp^ := len;
    memAlloc := ptr(seg(wordp^), ofs(wordp^)+2);
  end
  else
    memAlloc := NIL;
asm
        pop     si
        pop     di
end;
end;


procedure memFree(blk : pointer);
var
  wordp : ^word;
begin
asm
        push    di
        push    si
end;
  wordp := ptr(seg(blk^), ofs(blk^)-2);;
  FreeMem(wordp, wordp^ + 2);
asm
        pop     si
        pop     di
end;
end;



END.
