#include <string.h>
#include "windows.h"

BOOL FAR PASCAL EnumFunc( HWND hWnd_in, DWORD lParam_in );

HANDLE hInstance_g;

int PASCAL
WinMain( HANDLE hInstance_in, HANDLE hPrevInstance_in, LPSTR lpCmdLine_in,
    int nCmdShow_in )
{
    int argc = 0;
    char far *argv[ 25 ];
    char szArgs[ 25 ][ 128 ];
    int i1;
    int iStartArg = 0;

    // Save app instance handle.
    hInstance_g = hInstance_in;

    // Preset argv pointers.
    for ( i1 = 0; i1 < sizeof( argv ) / sizeof( argv[ 0 ] ); i1++ )
    {
        argv[ i1 ] = szArgs[ i1 ];
    }

    // Piece together argv[ 0 ] (whole command line).
    GetModuleFileName( hInstance_g, szArgs[ 0 ], sizeof( szArgs[ 0 ] ) );
    lstrcat( szArgs[ 0 ], " " );
    lstrcat( szArgs[ 0 ], lpCmdLine_in );

    // Enumerate over command line.
    i1 = 0;
    while ( TRUE )
    {
        // Search for dividing white space or end of command line.
        if ( lpCmdLine_in[ i1 ] == ' ' || lpCmdLine_in[ i1 ] == '\0' )
        {
            // Increment number of arguments found.
            argc++;

            // Copy out an argument string.
            _fmemcpy( szArgs[ argc ], &lpCmdLine_in[ iStartArg ],
                i1 - iStartArg );
            szArgs[ argc ][ i1 - iStartArg + 1 ] = '\0';

            // Step to end of white space.
            while ( lpCmdLine_in[ i1++ ] == ' ' );

            // Point at beginning of next argument.
            iStartArg = i1;

            // Exit loop at end of command line.
            if ( lpCmdLine_in[ i1 ] == '\0' )
            {
                break;
            }
        }

        // Step to next character.
        i1++;
    }

    // Call standard C main() function.
    return main( argc, (char far * far *)argv );
}

int
main( int argc, char far * far *argv )
{
    // KILL takes one argument
    if ( argc != 1 )
    {
        return 0;
    }

    // Enumerate over all open windows on screen, killing the screen whose
    // title matches first argument passed in by user.
    EnumWindows( MakeProcInstance( EnumFunc, hInstance_g ),
        (DWORD)argv[ 1 ] );

    return 0;
}

BOOL FAR PASCAL
EnumFunc( HWND hWnd_in, DWORD lParam_in )
{
    char szTest[ 200 ];

    // Get title of enumerated window.
    GetWindowText( hWnd_in, szTest, sizeof( szTest ) );

    // Did we find the window title of the window we wish to kill?
    if ( _fmemcmp( szTest, (LPSTR)lParam_in, lstrlen( (LPSTR)lParam_in ) )
        == 0 )
    {
        // Kill the window.
        PostMessage( hWnd_in, WM_SYSCOMMAND, SC_CLOSE, 0L );

        // Terminate enumeration.
        return 0;
    }

    // Window not found yet...continue enumeration.
    return 1;
}
