#include <string.h>
#include "windows.h"

/* prototype */
WORD Say( LPSTR );

int FAR PASCAL
WinMain( hInstance_in, hPrevInstance_in, lpszCmdLine_in, wCmdShow_in )
HANDLE hInstance_in;
HANDLE hPrevInstance_in;
LPSTR lpszCmdLine_in;
WORD wCmdShow_in;
{
	char szCmdLine[256];
	char szSpeech[200];
	char szDate[16];
	char szTime[12];
	char szDevType[26];
	char szNetwork[16];
	char szAddress[24];
	char szEvent[26];
	char szLabel[10];
	char szPort[8];
	char *token;
	WORD wRtn;

	/***************************************************
	 *	Make local copy of command line
	 **************************************************/

	lstrcpy( (LPSTR)szCmdLine, lpszCmdLine_in );

	/***************************************************
	 *	Get current date
	 **************************************************/

	token = strtok( szCmdLine, " " );
	strcpy( szDate, token );

	/***************************************************
	 *	Get current time
	 **************************************************/

	token = strtok( NULL, " " );
	strcpy( szTime, token );

	/***************************************************
	 *	Get event name
	 **************************************************/

	token = strtok( NULL, " " );
	strcpy( szEvent, token );

	/***************************************************
	 *	Get device type
	 **************************************************/

	token = strtok( NULL, " " );
	strcpy( szDevType, token );

	/***************************************************
	 *	Get device label
	 **************************************************/

	token = strtok( NULL, " " );
	strcpy( szLabel, token );

	/***************************************************
	 *	Get network number (for Novell)
	 **************************************************/

	token = strtok( NULL, " " );
	strcpy( szNetwork, token );

	/***************************************************
	 *	Get IPX station (or IP network) address
	 **************************************************/

	token = strtok( NULL, " " );
	strcpy( szAddress, token );

	/***************************************************
	 *	Get port name
	 **************************************************/

	token = strtok( NULL, " " );
	strcpy( szPort, token );

	/***************************************************
	 *	Build string to speak
	 **************************************************/

	if ( szPort[0] != '-' )
	{
		wsprintf( (LPSTR)szSpeech, 
			(LPSTR)"Alarm at %s; %s on port %s; device is %s of type %s",
			(LPSTR)szTime, (LPSTR)szEvent, (LPSTR)szPort,
			(LPSTR)szLabel, (LPSTR)szDevType );
	}
	else
	{
		wsprintf( (LPSTR)szSpeech, 
			(LPSTR)"Alarm at %s; %s; device is %s of type %s",
			(LPSTR)szTime, (LPSTR)szEvent,
			(LPSTR)szLabel, (LPSTR)szDevType );
	}

	MessageBox( NULL, (LPSTR)szSpeech, (LPSTR)"DEBUG", MB_OK );

#ifdef SAY

	wRtn = Say( (LPSTR)szSpeech );

#endif

}
