ECHO OFF
REM =======================================================
REM  AOETEST.BAT
REM
REM  Sample batch file for Actions on Events.  This file
REM  demonstrates how a DOS batch file can do additional
REM  filtering of events before determining what action to
REM  take.
REM =======================================================

REM -------------------------------------------------------
REM  Print all of the command line parameters to show
REM  what's available.
REM -------------------------------------------------------
echo File    = %0
echo Date    = %1
echo Time    = %2
echo Event   = %3
echo DevType = %4
echo Label   = %5
echo Network = %6
echo Address = %7
echo Port    = %8

REM -------------------------------------------------------
REM  The third parameter always contains the name of the
REM  event which occurred.
REM -------------------------------------------------------
if %3 == Bytes_received goto bytes_received
if %3 == Warm_reset goto warm_reset
goto ending

:bytes_received

REM -------------------------------------------------------
REM  The fifth parameter always contains the label of the
REM  device on which the event occurred.
REM -------------------------------------------------------

if %5 == Mktg_Hub goto MktgHub
if %5 == Acct_Hub goto AcctHub
goto ending

:MktgHub

echo Help, I'm receiving too many bytes on the Marketing hub
goto ending

:AcctHub

echo Too many bytes received on the Accounting hub
goto ending

:warm_reset

REM -------------------------------------------------------
REM  The second parameter is the time of day (in 24 hour
REM  notation).  Since MS-DOS batch files do only "equals"
REM  comparisons of parameters, you will need a program,
REM  e.g. "compare" to do the kind of "less than" and
REM  "greater than" testing required for the time of day.
REM -------------------------------------------------------

compare %2 17:00:00
if errorlevel 2 goto afterhours

compare %2 07:00:00
if errorlevel 2 goto workhours

:afterhours
echo Warm reset on device %5 between 5:00 PM and 7:00 AM
goto ending

:workhours
echo Warm reset on device %5 during working hours
goto ending

:ending

pause So window stays open

echo on
