//
// Cthugha - Audio Seeded Image Processing
//
// Zaph, Digital Aasvogel Group, Torps Productions 1993-1994
//


// Why PETE.C ??
// 'cause late one Saturday night, Pete wanted to write some code
// and I let him do a couple of functions (only one survives, I 
// took over the others :-)


#include <stdio.h>
#include <dos.h>
#include <io.h>
#include <fcntl.h>
#include <stdlib.h>
#include <math.h>
#include <conio.h>

#include "cthugha.h"
#include "charset.h"
#include "pete.h"

/* Defines for Soundblaster and Soundblaster Pro IO address */

int sine[320];

void init_pete(void)
{
	int i;

	for (i=0; i<320; i++)
		sine[i]=(int)(128*sin((float)i*0.03927));

}
void pete_0(void)
{
	int temp,temp2,x;
	static int xoff0=BUFF_WIDTH+30,yoff0=BUFF_HEIGHT-30;
	static int xoff1=BUFF_WIDTH-30,yoff1=BUFF_HEIGHT+30;

	xoff0 += stereo[0][0]%9-4;
	yoff0 += stereo[1][0]%9-4;

	xoff1 += stereo[0][1]%9-4;
	yoff1 += stereo[1][1]%9-4;

	if (xoff0<0)
		xoff0+=BUFF_WIDTH;
	if (yoff0<0)
		yoff0+=BUFF_BOTTOM;

	if (xoff1<0)
		xoff1+=BUFF_WIDTH;
	if (yoff1<0)
		yoff1+=BUFF_BOTTOM;

	xoff0=xoff0%BUFF_WIDTH;
	xoff1=xoff1%BUFF_WIDTH;

	yoff0=yoff0%BUFF_HEIGHT;
	yoff1=yoff1%BUFF_HEIGHT;

	for (x=0; x<BUFF_WIDTH; x++) {
		temp=stereo[x][0];
		temp2=stereo[(x+80)%BUFF_WIDTH][0];

		buff[((temp>>2)+yoff0)%BUFF_BOTTOM][((temp2>>2)+xoff0)%BUFF_WIDTH]=table[curtable][temp];

		temp=stereo[x][1];
		temp2=stereo[(x+80)%BUFF_WIDTH][1];

		buff[((temp>>2)+yoff1)%BUFF_BOTTOM][((temp2>>2)+xoff1)%BUFF_WIDTH]=table[curtable][temp];

	}

}

void pete_1(void)
{
	int temp,x,left=0,right=0;

	for (x=0; x<BUFF_WIDTH; x++) {
		left += abs(stereo [x][0] - 128);
		right += abs(stereo [x][1] - 128);
	}

	left = left / (160);
	right = right / (160);

	left=min(left,199);
	right=min(right,199);

	for (x=0; x<160; x++) {
		temp=stereo[x][0];
		buff[200-(abs((left)*sine[x])>>8)][(x)]=table[curtable][temp];
	}
	for	(x=160; x<320; x++) {
		temp=stereo[x][1];
		buff[200-(abs((right)*sine[x])>>8)][(x)]=table[curtable][temp];
	}

}

void pete_2(void)
{
	int temp,x;

	for (x=0; x<200; x++) {
		temp=stereo[x][0];
		buff[x][160-(temp>>2)]=table[curtable][sine[temp]];
		temp=stereo[x][1];
		buff[x][160+(temp>>2)]=table[curtable][sine[temp]];
	}

}

