//
// Cthugha - Audio Seeded Image Processing
//
// Zaph, Digital Aasvogel Group, Torps Productions 1993-1994
//


#include <stdio.h>
#include <stdlib.h>
#include <conio.h>
#include <time.h>
#include <dos.h>
#include <signal.h>
#include <memory.h>

#include "cthugha.h"
#include "initscrn.h"
#include "patch.h"

#include "banner.c"
#include "cthu_hlp.c"
#include "cdmix.c"

#define color_char(x,y,c,a) poke(0xb800,160*(y)+2*(x),((a)<<8)|(c));

void scroll_up(int x1, int y1, int x2,int y2,int lines,unsigned char color)
{
	union REGS r;

	r.h.ah=0x06;
	r.h.al=lines;
	r.h.bh=color;
	r.h.cl=x1;
	r.h.dl=x2;
	r.h.ch=y1;
	r.h.dh=y2;

	int86(0x10,&r,&r);
}

void gotoxy(int x1, int y1)
{
	union REGS r;

	r.x.ax=0x0200;
	r.h.bh=0x00;
	r.h.dl=x1;
	r.h.dh=y1;
	int86(0x10,&r,&r);
}

void quit_screen(void)
{
	int x,y,i;

	x=0; y=0;
	for (i=0; i<IMAGEDATA_LENGTH; i+=2) {
		color_char(x,y,IMAGEDATA[i],IMAGEDATA[i+1]);
		x++;
		if (x>79) {
			x=0; y++;
		}
	}

	for( y=23; y < 25; y++ )
		for( x=0; x < 80; x++ )
			color_char(x,y,' ',7);

	gotoxy(0,23);
}

void cdmix_screen(int ok)
{
	int x,y,i;

	x=0; y=0;
	for (i=0; i< (ok ? CDMIX_LENGTH : 2560); i+=2) {
		color_char(x,y,CDMIX[i],CDMIX[i+1]);
		x++;
		if (x>79) {
			x=0; y++;
		}
	}
	gotoxy(0,23);
}


void help_screen(void)
{
	int x,y,i;

	x=0; y=0;
	for (i=0; i<HELPDATA_LENGTH; i+=2) {
		color_char(x,y,HELPDATA[i],HELPDATA[i+1]);
		x++;
		if (x>79) {
			x=0; y++;
		}
	}
	gotoxy(0,23);

}

