//
// Cthugha - Audio Seeded Image Processing
//
// Zaph, Digital Aasvogel Group, Torps Productions 1993-1994
//


#include <stdio.h>
#include <dos.h>
#include <io.h>
#include <fcntl.h>
#include <stdlib.h>
#include <math.h>
#include <conio.h>
#include <bios.h>
#include <memory.h>

#include "cthugha.h"
#include "charset.h"
#include "zorilkey.h"

void display_up(void)
{
	char *screen;

	FP_SEG(screen)=0xa000;
	FP_OFF(screen)=0;

	memcpy(screen,buff,64000);
}


void display_dn(void)
{
	char *screen;
	int i;

	FP_SEG(screen)=0xa000;
	FP_OFF(screen)=0;

	for (i=199; i>=0; i--) {
		memcpy(screen,buff[i],320);
		screen+=320;
	}
}


void draw_text(int xpos, int ypos, int size, int colour, char *tbuf)
{
	int    x,y,i,j;
	unsigned char                   mask;
	unsigned char *cdef_ptr;

	if (size<=0)
   		return;

	while (*tbuf) {
	   	cdef_ptr = charset[*tbuf];
   		for (y=ypos; y<=ypos+(size*char_height)-1; y+=size) {
			mask=0x80;
			for (x=xpos; x<xpos+(size*(char_width+1)); x+=size) {
				if ((*cdef_ptr)&mask) {
					if (size==1)
						if (curdisplay)
							buff[199-y][x]=colour;
						else
							buff[y][x]=colour;
					else
						for (i=0; i<size; i++)
							for (j=0; j<size; j++)
								if (curdisplay)
									buff[199-(y+i)][(x+j)]=colour;
								else
									buff[y+i][x+j]=colour;
				}
				mask>>=1;
				}
			cdef_ptr++;
		}
   		tbuf++;
		xpos+=size*(char_width+1);
  	}
}

