:UPGRADE FROM LANDESK MANAGER VERSION 1.5 TO VERSION 1.51
:
:
@ECHO OFF
CLS

IF %1 !==! GOTO HELPME
IF %1 == ? GOTO HELPME
IF %1 == /? GOTO HELPME
IF %1 == -? GOTO HELPME
IF %1 == \? GOTO HELPME
IF NOT %2 !==! GOTO HELPME

ECHO *******************************************************************************
ECHO                   INTEL LANDESK MANAGER VERSION 1.51 UPGRADE
ECHO *******************************************************************************
:----------------------------------------------------------------------------
:CHECK FOR ALL NECESSARY FILES BEFORE CONTINUING
:----------------------------------------------------------------------------
ECHO.
ECHO Checking for necessary upgrade files....
:CHECK1
IF EXIST LDM151-1.EXE GOTO CHECK2
ECHO LDM151-1.EXE must be in the same directory as UPGRADE.BAT.
ECHO Please correct the problem and try running UPGRADE again.
ECHO.
ECHO You may refer to the file UPGRADE.TXT for more information.
GOTO README

:CHECK2
IF EXIST LDM151-2.EXE GOTO CHECK3
ECHO.
ECHO LDM151-2.EXE must be in the same directory as UPGRADE.BAT.
ECHO Please correct the problem and try running UPGRADE again.
ECHO.
ECHO You may refer to the file UPGRADE.TXT for more information.
GOTO README

:CHECK3
IF EXIST LDM151-3.EXE GOTO CHECK4
ECHO.
ECHO LDM151-3.EXE must be in the same directory as UPGRADE.BAT.
ECHO You may still need to download and\or run 151UP2.EXE.
ECHO Please correct the problem and try running UPGRADE again.
ECHO.
ECHO You may refer to the file UPGRADE.TXT for more information.
GOTO README

:CHECK4
IF EXIST LDM151-4.EXE GOTO CHECK5
ECHO.
ECHO LDM151-4.EXE must be in the same directory as UPGRADE.BAT.
ECHO You may still need to download and\or run 151UP2.EXE.
ECHO Please correct the problem and try running UPGRADE again.
ECHO.
ECHO You may refer to the file UPGRADE.TXT for more information.
GOTO README

:CHECK5
IF EXIST LDM151-5.EXE GOTO ENDCHECK
ECHO.
ECHO LDM151-5.EXE must be in the same directory as UPGRADE.BAT.
ECHO You may still need to download and\or run 151UP2.EXE.
ECHO Please correct the problem and try running UPGRADE again.
ECHO.
ECHO You may refer to the file UPGRADE.TXT for more information.
GOTO README

:ENDCHECK
ECHO All necessary files are present. Proceeding with upgrade....
ECHO.
ECHO ************  This upgrade requires you to have disks 1 through 5 of Intel
ECHO INFORMATION!  LANDesk Manager version 1.5. The upgrade process modifies or
ECHO ************  deletes some of the files on your original floppy diskettes.

:----------------------------------------------------------------------------
:DISK1
:----------------------------------------------------------------------------
ECHO. 
ECHO PLEASE INSERT LANDESK MANAGER V1.5 DISK 1 OF 5 IN DRIVE %1
PAUSE
ECHO Checking disk 1....
IF EXIST %1MSCUISTF.DL_ GOTO COPY1
ECHO.
ECHO *****************************
ECHO.  DISK 1 OF 5 NOT DETECTED!
ECHO *****************************
ECHO.
GOTO DISK1

:COPY1
ECHO Preparing to extract new files....
ATTRIB %1*.* -r -s -h -a
IF EXIST %1_SETUP.EX_ DEL %1_SETUP.EX_
IF EXIST %1_SETUP.EX_ GOTO ERROR1
IF EXIST %1NWNETAPI.DL_ DEL %1NWNETAPI.DL_
IF EXIST %1NWNETAPI.DL_ GOTO ERROR1
LDM151-1.EXE -n %1
GOTO TEST1

:ERROR1
ECHO.
ECHO FAILURE! Please try the upgrade again or contact Intel Technical Support.
GOTO README

:TEST1
IF EXIST %1_SETUP.EX_ GOTO SUCCEED1
ECHO.
ECHO FAILURE! Please try the upgrade again or contact Intel Technical Support.
GOTO README

:SUCCEED1
ECHO.
ECHO Disk 1 of LANDesk Manager is now upgraded to version 1.51....
ECHO You may wish to write "Version 1.51" on your disk label at this time.

:----------------------------------------------------------------------------
:DISK2
:----------------------------------------------------------------------------
ECHO. 
ECHO PLEASE INSERT LANDESK MANAGER V1.5 DISK 2 OF 5 IN DRIVE %1
PAUSE
ECHO Checking disk 2....
IF EXIST %1WFILEXFR.EX_ GOTO COPY2
ECHO.
ECHO *****************************
ECHO.  DISK 2 OF 5 NOT DETECTED!
ECHO *****************************
ECHO.
GOTO DISK2

:COPY2
ECHO Preparing to extract new files....
ATTRIB %1*.* -r -s -h -a
IF EXIST %1BEEP.EX_ DEL %1BEEP.EX_
IF EXIST %1BEEP.EX_ GOTO ERROR2
IF EXIST %1WUSER.EX_ DEL %1WUSER.EX_
IF EXIST %1_WUSER.EX_ GOTO ERROR2
LDM151-2.EXE -n %1
GOTO TEST2

:ERROR2
ECHO.
ECHO FAILURE! Please try the upgrade again or contact Intel Technical Support.
GOTO README

:TEST2
IF EXIST %1WUSER.EX_ GOTO SUCCEED2
ECHO.
ECHO FAILURE! Please try the upgrade again or contact Intel Technical Support.
GOTO README

:SUCCEED2
ECHO.
ECHO Disk 2 of LANDesk Manager is now upgraded to version 1.51....
ECHO You may wish to write "Version 1.51" on your disk label at this time.

:----------------------------------------------------------------------------
:DISK3
:----------------------------------------------------------------------------
ECHO. 
ECHO PLEASE INSERT LANDESK MANAGER V1.5 DISK 3 OF 5 IN DRIVE %1
PAUSE
ECHO Checking disk 3....
IF EXIST %1TM.EX_ GOTO COPY3
ECHO.
ECHO *****************************
ECHO.  DISK 3 OF 5 NOT DETECTED!
ECHO *****************************
ECHO.
GOTO DISK3

:COPY3
ECHO Preparing to extract new files....
ATTRIB %1*.* -r -s -h -a
IF EXIST %1LPT$VPN.03_ DEL %1LPT$VPN.03_
IF EXIST %1LPT$VPN.03_ GOTO ERROR3
IF EXIST %1USER.CO_ DEL %1USER.CO_
IF EXIST %1USER.CO_ GOTO ERROR3
LDM151-3.EXE -n %1
GOTO TEST3

:ERROR3
ECHO.
ECHO FAILURE! Please try the upgrade again or contact Intel Technical Support.
GOTO README

:TEST3
IF EXIST %1USER.CO_ GOTO SUCCEED3
ECHO.
ECHO FAILURE! Please try the upgrade again or contact Intel Technical Support.
GOTO README

:SUCCEED3
ECHO.
ECHO Disk 3 of LANDesk Manager is now upgraded to version 1.51....
ECHO You may wish to write "Version 1.51" on your disk label at this time.

:----------------------------------------------------------------------------
:DISK4
:----------------------------------------------------------------------------
ECHO. 
ECHO PLEASE INSERT LANDESK MANAGER V1.5 DISK 4 OF 5 IN DRIVE %1
PAUSE
ECHO Checking disk 4....
IF EXIST %1APPVIEW.EX_ GOTO COPY4
ECHO.
ECHO *****************************
ECHO.  DISK 4 OF 5 NOT DETECTED!
ECHO *****************************
ECHO.
GOTO DISK4

:COPY4
ECHO Preparing to extract new files....
ATTRIB %1*.* -r -s -h -a
IF EXIST %1VSCAND.EX_ DEL %1VSCAND.EX_
IF EXIST %1VSCAND.EX_ GOTO ERROR4
LDM151-4.EXE -n %1
GOTO TEST4

:ERROR4
ECHO.
ECHO FAILURE! Please try the upgrade again or contact Intel Technical Support.
GOTO README

:TEST4
IF EXIST %1VSCAND.EX_ GOTO SUCCEED4
ECHO.
ECHO FAILURE! Please try the upgrade again or contact Intel Technical Support.
GOTO README

:SUCCEED4
ECHO.
ECHO Disk 4 of LANDesk Manager is now upgraded to version 1.51....
ECHO You may wish to write "Version 1.51" on your disk label at this time.

:----------------------------------------------------------------------------
:DISK5
:----------------------------------------------------------------------------
ECHO. 
ECHO PLEASE INSERT LANDESK MANAGER V1.5 DISK 5 OF 5 IN DRIVE %1
PAUSE
ECHO Checking disk 5....
IF EXIST %1LDINV.EX_ GOTO COPY5
ECHO.
ECHO *****************************
ECHO.  DISK 5 OF 5 NOT DETECTED!
ECHO *****************************
ECHO.
GOTO DISK5

:COPY5
ECHO Preparing to extract new files....
ATTRIB %1*.* -r -s -h -a
IF EXIST %1WBTRCALL.DL_ DEL %1WBTRCALL.DL_
IF EXIST %1WBTRCALL.DL_ GOTO ERROR5
IF EXIST %1WBTRV61X.DL_ DEL %1WBTRV61X.DL_
IF EXIST %1WBTRV61X.DL_ GOTO ERROR5
LDM151-5.EXE -n %1
GOTO TEST5

:ERROR5
ECHO.
ECHO FAILURE! Please try the upgrade again or contact Intel Technical Support.
GOTO README

:TEST5
IF EXIST %1WBTRV61X.DL_ GOTO SUCCEED5
ECHO.
ECHO FAILURE! Please try the upgrade again or contact Intel Technical Support.
GOTO README

:SUCCEED5
ECHO.
ECHO Disk 5 of LANDesk Manager is now upgraded to version 1.51....
ECHO You may wish to write "Version 1.51" on your disk label at this time.

:----------------------------------------------------------------------------
:SUCCESS
:----------------------------------------------------------------------------
ECHO.
ECHO *******************************************************************************
ECHO                            SUCCESSFUL UPGRADE!!!
ECHO *******************************************************************************
ECHO.
ECHO At this point you should read 151CHECK.TXT (installation checklist) and
ECHO 151SETUP.TXT (setup notes).
ECHO. 
ECHO When you are ready to install LANDesk Manager v1.51 to your network insert
ECHO disk 1 and run SETUP.EXE from within Windows. Refer to UPGRADE.TXT for more
ECHO information.
GOTO EXIT

:----------------------------------------------------------------------------
:HELPME
:----------------------------------------------------------------------------
ECHO *******************************************************************************
ECHO                                 UPGRADE.BAT
ECHO *******************************************************************************
ECHO.
ECHO  Upgrades Intel LANDesk Manager version 1.5 disks to version 1.51.
ECHO.
ECHO  USAGE:      UPGRADE [3.5" floppy drive letter]:
ECHO.
ECHO  EXAMPLE:    upgrade a:
IF EXIST UPGRADE.TXT GOTO README
GOTO EXIT

:----------------------------------------------------------------------------
:README
:----------------------------------------------------------------------------
ECHO.
ECHO ----------------------------------------------------------------------------
ECHO Press a key to view the upgrade README file (UPGRADE.TXT).
ECHO Press CTRL+C to break.
ECHO ----------------------------------------------------------------------------
PAUSE
TYPE UPGRADE.TXT | MORE
ECHO.
ECHO.
ECHO Type UPGRADE [3.5" floppy drive letter]: when you are ready to upgrade...
:EXIT
ECHO.
