/***************************************************************************
*	NAME:  VOLRATE.C
**	COPYRIGHT:
**	"Copyright (c) 1992, by FORTE
**
**       "This software is furnished under a license and may be used,
**       copied, or disclosed only in accordance with the terms of such
**       license and with the inclusion of the above copyright notice.
**       This software or any other copies thereof may not be provided or
**       otherwise made available to any other person. No title to and
**       ownership of the software is hereby transfered."
****************************************************************************
*  CREATION DATE: 11/18/92
*--------------------------------------------------------------------------*
*     VERSION	DATE	   NAME		DESCRIPTION
*>	1.0	11/18/92		Original
***************************************************************************/
#include <dos.h>

#include "forte.h"
#include "gf1proto.h"
#include "osproto.h"
#include "gf1hware.h"
#include "gf1os.h"

extern ULTRA_DATA _gf1_data;

static unsigned int vol_rates[19] = {
23 , /* 14 voices */
24 , /* 15 voices */
26 , /* 16 voices */
28 , /* 17 voices */
29 , /* 18 voices */
31 , /* 19 voices */
32 , /* 20 voices */
34 , /* 21 voices */
36 , /* 22 voices */
37 , /* 23 voices */
39 , /* 24 voices */
40 , /* 25 voices */
42 , /* 26 voices */
44 , /* 27 voices */
45 , /* 28 voices */
47 , /* 29 voices */
49 , /* 30 voices */
50 , /* 31 voices */
52   /* 32 voices */
};

unsigned char
UltraCalcRate(unsigned int start,unsigned int end,unsigned long mil_secs)
{
unsigned long gap;
unsigned long mic_secs;
unsigned int i;
unsigned int range;
unsigned int increment;
unsigned char rate_val;
unsigned int value;

if (start > end)
	gap = start - end;
else
	gap = end - start;

mic_secs = (mil_secs * 1000L)/gap;

/* OK. We now have the # of microseconds for each update to go from */
/* A to B in X milliseconds. See what the best fit is in the table */

range = 4;
value = vol_rates[_gf1_data.voices-14];

for (i=0;i<3;i++)
	{
	if (mic_secs < value)
		{
		range = i;
		break;
		}
	else
		value = value << 3;
	}

if (range == 4)
	{
	range = 3;
	increment = 1;
	}
else
	{
	/* calculate increment value ... (round it up ?) */
	increment = (unsigned int)((value + (value>>1)) / mic_secs);
	}

rate_val = range<<6;
rate_val |= (increment & 0x3F);

return(rate_val);
}


