/***************************************************************************
*	NAME:  VOCLOOP.C
**	COPYRIGHT:
**	"Copyright (c) 1992, by FORTE
**
**       "This software is furnished under a license and may be used,
**       copied, or disclosed only in accordance with the terms of such
**       license and with the inclusion of the above copyright notice.
**       This software or any other copies thereof may not be provided or
**       otherwise made available to any other person. No title to and
**       ownership of the software is hereby transfered."
****************************************************************************
*  CREATION DATE: 11/18/92
*--------------------------------------------------------------------------*
*     VERSION	DATE	   NAME		DESCRIPTION
*>	1.0	11/18/92		Original
***************************************************************************/

#include <dos.h>
#include <conio.h>

#include "forte.h"
#include "gf1proto.h"
#include "osproto.h"
#include "gf1hware.h"
#include "gf1os.h"

extern ULTRA_DATA _gf1_data;

void
UltraSetLoopMode(int voice,unsigned char mode)
{
unsigned char data;
unsigned char vmode;

	ENTER_CRITICAL;

	outp(_gf1_data.voice_select,voice);

	/* set/reset the rollover bit as per user request */
	outp(_gf1_data.reg_select,GET_VOLUME_CONTROL);
	vmode = inp (_gf1_data.data_hi);

	if (mode & USE_ROLLOVER)
		{
		vmode |= VC_ROLLOVER;
		}
	else
		{
		vmode &= ~VC_ROLLOVER;
		}
	outp(_gf1_data.reg_select,SET_VOLUME_CONTROL);
	outp(_gf1_data.data_hi,vmode);
	gf1_delay();

	outp(_gf1_data.data_hi,vmode);

	outp(_gf1_data.reg_select,GET_CONTROL);
	data = inp(_gf1_data.data_hi);

	data &= ~(VC_WAVE_IRQ|VC_BI_LOOP|VC_LOOP_ENABLE);	/* isolate the bits */
	mode &= VC_WAVE_IRQ|VC_BI_LOOP|VC_LOOP_ENABLE;	/* no bad bits passed in */
	data |= mode;		/* turn on proper bits ... */

	outp(_gf1_data.reg_select,SET_CONTROL);
	outp(_gf1_data.data_hi,data);
	gf1_delay();

	outp(_gf1_data.reg_select,SET_CONTROL);
	outp(_gf1_data.data_hi,data);

	LEAVE_CRITICAL;
}

