#ifndef __HDR3D_H__
#define __HDR3D_H__

/***************************************************************************
*	NAME:  HDR3D.H
**	COPYRIGHT:
**	"Copyright (c) 1992, by FORTE
**
**       "This software is furnished under a license and may be used,
**       copied, or disclosed only in accordance with the terms of such
**       license and with the inclusion of the above copyright notice.
**       This software or any other copies thereof may not be provided or
**       otherwise made available to any other person. No title to and
**       ownership of the software is hereby transfered."
****************************************************************************
*  CREATION DATE: 02/01/93
*--------------------------------------------------------------------------*
*     VERSION	DATE	   NAME		DESCRIPTION
*>	1.0	02/01/93		Original
***************************************************************************/

/* Bit definitions for tracks that are in a 3D file ... */
#define FRONT_TRACK		0x01
#define RIGHT_TRACK		0x02
#define REAR_TRACK		0x04
#define LEFT_TRACK		0x08
#define ABOVE_TRACK		0x10
#define BELOW_TRACK		0x20

#define FBLOCK_3D		0x01		/* File data is blocked, not interleaved */
#define F16BIT_3D		0x02		/* 16 bit data */
#define FTWOS_CMP_3D	0x04		/* sound is in twos complement form */
#define FLOOPED_3D		0x08		/* sound is looped , not one shot*/
#define FBI_LOOP_3D		0x10		/* sound is bi-directional */
#define F3D_TYPE		0x60		/* Type of 3D sound */

/* types (F3D_TYPE) of 3D sound (only binaural currently supported) */
#define F_BINAURAL		0x20		/* Binaural representation */
#define F_SURROUND		0x40		/* Surround sound */
#define F_QSOUND		0x60		/* Q sound */

/* this structure is exactly 256 bytes long ... */

typedef struct {
	char id[10];				/* 3D FILE tag */
	short major;					/* major version # */
	short minor;					/* minor version # */
	char description[80];
	unsigned short type;			/* See above .... */
	short tracks;					/* tracks included in this file ... */
	short reserve1[24];			/* for expansion */
	short maxvol;					/* volume can range from 0 to maxvol */
	short reserve2[10];			/* for expansion */
	unsigned long blocksize;	/* # of bytes in block data */
	unsigned long loop_offset;	/* offset to where loop begins (bytes) ... */
	unsigned long reserve3[9];	/* for expansion */
	unsigned long frequency;	/* inital playback frequency */
	unsigned long reserve4[10];	/* for expansion */
} FILEHDR_3D;

#endif

