;/* filename: VIDCARD.ASM
;
;: T O P A Z for C :Ŀ
;                          Version 4.5  05/16/93                              
;                                                                             
; Copyright (c) 1988,1994 Software Science Inc. All Rights Reserved Worldwide.
; Unauthorized distribution or disclosure of this source code or modification 
;  or removal of this notice  constitutes a breach of the license agreement.  
;
;*/
; VIDCARD.ASM  -- tests for type of video card

; modified 8/12/90 to distinguish EGA.MONO from EGA.COLOR
; 9/13/90 test 40h:87h for EGA active
; 3/4/92 corrected bug reporting Hercules cards
; use TASM to assemble to an OBJ file.
; no input parameters
; output: returns a word (in AX)
;         hi byte represents main card type, lo byte represents subcategory
; Turbo Pascal declaration:
;     Function VIDEOCARD : Word;

        .MODEL LARGE, PASCAL
        .CODE

VIDEOCARD  PROC FAR
PUBLIC  VIDEOCARD

mono_scrn    equ 0b000h                  ; video segment address
color_scrn   equ 0b800h
status_port  equ 03bah
id_mask      equ 00110000b              ; for HGC +
id_code      equ 00010000b
id_mask_222  equ 01110000b              ; for InColor card (GB222)
id_code_222  equ 01010000b

COLOR       equ 0
MONO        equ 1
HERC        equ 2
CGA         equ 3
EGA         equ 4
VGA         equ 5
MCGA        equ 6

HGCPLUS     equ 1
INCOLOR     equ 2

;1.0 - MONO         25 lines
;2.0 - HERC         25 lines
;2.1 - HGCPLUS      25 lines
;2.2 - INCOLOR      25 lines
;3.0 - CGA          25 lines;
;3.1 - COMPAQ   cga w/no snow            25 lines
;4.0 - EGA    color monitor              43 lines
;4.1 - EGA    w/monochrome monitor       43 lines
;4.3 - EGA    w/cga monitor              25 lines
;5.0 - VGA    color monitor              50 lines
;5.1 - VGA    w/ monochrome monitor      50 lines
;6.0 - MCGA                              50 lines
;6.1 - MCGA   if monochrome monitor      50 lines

vc:
        push bx
        push dx
        push es

        mov  ax,1a00h
        int  10h
        cmp  al,1ah                     ; is VGA or MCGA present?
        jne  no_vga
                                        ;  MCGA
        mov  ah,MCGA
        cmp  bl,0ch                     ; model 30 with color?
        jne  mcga_mono
        mov  al,COLOR
        jmp  done

mcga_mono:
        cmp  bl,0bh                     ; model 30 with mono?
        jne  vga_card
        mov  al,MONO
        jmp  done

vga_card:                                        ; VGA
        mov  ah,VGA
        cmp  bl,7                       ; is it VGA mono?
        jne  vga_color
vga_mono:
        mov  al,MONO
        jmp  short done

vga_color:
        cmp  bl,8                       ; VGA with color monitor?
        jne  vga_unknown
        mov  al,COLOR
        jmp  short done
vga_unknown:
        mov  al,COLOR                  ; looks like VGA or MCGA, but can't
        jmp  short done                ; identify it further

no_vga:

        mov  ah,12h                     ; check for EGA
        mov  bl,10h
        int  10h
        cmp  bl,10h
        je   no_ega
        mov  ax,40h                     ; is EGA active?
        mov  es,ax
        test byte ptr es:[87h],8        ; EGA info byte, bit 3
        jnz  no_ega                     ; 1 = not active, 0 = active

        mov  ah,EGA
        ;  distinguish whether the EGA has a color or monochrome monitor
        cmp  bh,0
        jne  ega_mono
        mov  al,COLOR               ; EGA in color mode
        jmp  short done

ega_mono:
        mov  al,MONO             ;  bh =1 means mono 
        jmp  short done

no_ega:
        ; not EGA, is it CGA?
        ; word at 40:63h stores the port address of the 6845 video
        ; controller - 3D4 for color, 3B4 for monochrome
        mov  ax,40h                     ; bios data area
        mov  es,ax
        mov  ax,ES:[63h]
        test al,40h
        je  no_cga
        mov  ah,CGA
        mov  al,0
        jmp  short done

no_cga:
        ; monochrome

        ; test for Hercules card
        mov  dx,status_port
        in   al,dx
        and  al,80h
        mov  ah,al
        mov  cx,4000h

examine:
        in   al,dx
        and  al,80h
        cmp  al,ah
        jne  herc_card
        loop examine
        mov  ax,MONO shl 8      ; 100h means plain monochrome (MDA) card
        jmp  short done

herc_card:
        ; test for HGC +
        in   al,dx
        and  al,id_mask
        cmp  al,id_code
        jne  test_failed
        mov  ax,(HERC shl 8)+ HGCPLUS
        jmp  short done
                                           ; this isn't right
                                           ; doesn't InColor pass the HGC+ test?
        ; test for Hercules InColor card
        in   al,dx
        and  al,id_mask_222
        cmp  al,id_code_222
        jne  test_failed
        mov  ax,(HERC shl 8) + INCOLOR
        jmp  short done

test_failed:
        mov  ax,HERC shl 8          ; plain Hercules card
        ;jmp  short done


done:
        pop  es
        pop  dx
        pop  bx
        ret

VIDEOCARD  endp
;code    ends
        end





