/* filename: SQUEEZE.C

: T O P A Z for C :Ŀ
                          Version 4.5  05/16/93                              
                                                                             
 Copyright (c) 1988,1994 Software Science Inc. All Rights Reserved Worldwide.
 Unauthorized distribution or disclosure of this source code or modification 
  or removal of this notice  constitutes a breach of the license agreement.  

*/
#include <stdio.h>
#include <dos.h>
#include <stdlib.h>
#include <string.h>
#include <vidpop.h>
  
#define FULLSCREEN  1920
#define BUFSIZE     2000
#define CHARBUFSIZE BUFSIZE * 2
#define MINCHARS    3
  
void Squeeze(char x1, char y1, char x2, char y2, const char * Filename)
{
  V3HeaderType Header;
  FILE     *sqzFile;
  int      i, j, k;
  int      XORtest;
  char     linelength, TotalRows, row;
  int      *buffer, *b_ptr, far *VideoPage;
  unsigned TotalBytes;
  char     *FilenamePtr, FilenameBuf[80], namebuf[80];
  
  VideoPage = (int*) MK_FP(BaseSeg, VideoOffset+160);
  
  if ((buffer = (int *) malloc(CHARBUFSIZE)) == NULL) {
    SetError(217, 1, Not_enough_memory, " [Squeeze()]");
    return;
  }
  memset(buffer, 0, CHARBUFSIZE);
  TotalBytes = 0;
  
  if (x1 == 0) x1 = 1; // no less than one column
  if (x1 > 80) x1 = 80;
  if (x2 > 80) x2 = 80; // no more than 80 columns
  if (x2 < x1) x2 = x1;
  if (x2 == 0) x2 = 1;
  
  if (y1 < 1)  y1 = 1; // never save the top line of screen
  if (y1 > 25) y1 = 25;
  if (y2 < 1)  y2 = 1;
  if (y2 > 25) y2 = 25; // no more than 24 rows
  if (y2 < y1) y2 = y1;
  
  Header.HeaderID.ID = 'S';
  Header.HeaderID.Version = 3;
  Header.ScreenCoord.C1 = x1;
  Header.ScreenCoord.R1 = y1;
  Header.ScreenCoord.C2 = x2;
  Header.ScreenCoord.R2 = y2;
  Header.MenuColor = 0;   //  no menu
  Header.BorderColor = 0; // border_color
  Header.Spare1 = 0;
  Header.MovingBarMenu = 0;
  Header.BrightEnable = 0x29;
  Header.Spare2 = 0;
  
  memcpy(buffer, &Header, sizeof(Header));
  (char *) b_ptr = (char *) buffer + sizeof(Header);
  i = 0;
  linelength = x2 - x1 + 1;
  TotalRows = y2 - y1 + 1;
  
  if ((linelength * TotalRows) == FULLSCREEN) {
    while (i < FULLSCREEN) {
      /* process all integers in the screen image count the non-redundant
      chars--the string of integers up to but not including the first
      occurance of MINCHARS number of identical integers */
      j = XORtest = 1;
      while ((j < 255) && XORtest && ((i + j) < FULLSCREEN)) {
        XORtest = 0;
        for (k = 0; k < MINCHARS; k++)
          XORtest |=  ( *(VideoPage + i+j+k-1)
          ^ *(VideoPage + i+j+k));
        j++;
      }
      j--;
      if (j > 0) {
        b_ptr[TotalBytes++] = (j & 0xff);
        for (k = 0; k < j; k++)
          b_ptr[TotalBytes++] = *(VideoPage + i+k);
        i += j;
      }
      // count the redundant chars/attributes
      j = 1;
      while (( *(VideoPage + i+j) == *(VideoPage + i) ) &&
        ((i + j) < FULLSCREEN) && (j < 255))
        j++;
      if (j >= MINCHARS) { // there are enough characters to squeeze...
        b_ptr[TotalBytes++] = 0xff00 + (j & 0xff);
        b_ptr[TotalBytes++] = *(VideoPage + i);
      }
      else // just put the next j characters into the file
        for (k = 0; k < j; k++)
          b_ptr[TotalBytes++] = *(VideoPage + i+k);
      i += j;
    }
  }
  else { // for sub-screens only
    for (row = y1; row <= y2; row++) {
      i = x1;
      while (i <= x2) { // process all integers in the line
        /* count the non-redundant chars--the string of integers up to
        but not including the first occurance of MINCHARS number of
        identical integers */
        j = 1;
        XORtest = 1;
        while (((i + j + MINCHARS - 2) <= x2) && XORtest) { // new line
          XORtest = 0;
          for (k = 1; k <= MINCHARS; k++)
            XORtest |= (*(VideoPage + 80*(row - 2) + (i + j + k - 3)) ^
            *(VideoPage + 80*(row - 2) + (i + j + k - 2)));
          j++;
        }
        j -= MINCHARS - 1;
        if (j > 0) {
          b_ptr[TotalBytes++] = (j & 0xff);
          for (k = 1; k <= j; k++)
            b_ptr[TotalBytes++] = *(VideoPage+80*(row-2)+(i+k-2));
          i += j;
        }
        // count the redundant chars
        j = 1;
        while ((*(VideoPage+80*(row-2) + (i+j-1)) ==
          *(VideoPage + 80*(row - 2) + (i - 1))) &&
          ((i + j) < x2) && (j < linelength))
          j++;
        if (j >= MINCHARS) { // there are enough characters to squeeze...
          b_ptr[TotalBytes++] = 0xff00 + (j & 0xff);
          b_ptr[TotalBytes++] = *(VideoPage+80*(row-2)+(i-1));
        }
        else // just put the next j words into the file as is
          for (k = 1; k <= j; k++)
            b_ptr[TotalBytes++] = *(VideoPage+80*(row-2)+(i+k-2));
        i += j;
      }
    }
  }
  // strip off any characters after a blank
  FilenamePtr = strchr(Filename, ' ');
  if (FilenamePtr)
    *FilenamePtr = 0;
  // strip off any extension
  FilenamePtr = strchr(Filename, '.');
  if (FilenamePtr)
    *FilenamePtr   = 0;
  sprintf(FilenameBuf, "%s.sqz", Filename);
  TotalBytes = (TotalBytes << 2) + sizeof(Header);
  if ((sqzFile = fopen(FilenameBuf, "wb")) != NULL) {
    fwrite(buffer, TotalBytes, 1, sqzFile);
    fclose(sqzFile);
  }
  else {
    sprintf(namebuf, "Error writing SQZ file: %s", FilenameBuf);
    SetError(errno, 1, namebuf);
  }
  free(buffer);
}
