/* filename: POPSCREN.C

: T O P A Z for C :Ŀ
                          Version 4.5  05/16/93                              
                                                                             
 Copyright (c) 1988,1994 Software Science Inc. All Rights Reserved Worldwide.
 Unauthorized distribution or disclosure of this source code or modification 
  or removal of this notice  constitutes a breach of the license agreement.  

*/
#include <stdio.h>
#include <dos.h>
#include <string.h>
#include <vidpop.h>

#define color 0x8000

extern char ScreenType;
extern unsigned char OneLineLength;
typedef unsigned ImageData[10000];

static unsigned ThisCharOffset(int y, int x)
{
  return OneLineLength * (y - 1) + ((x - 1) << 1);
}

static void RemapOrDecolor(char *p)
{
  if (ColorMap)
    ReMap(p);
  else
    if (BW)
      Decolor(p);
}

static void WriteToScreen(int * ImageIndex, unsigned int * DataPointer, int * ScreenLoc,
unsigned VirtualOffset)
{
  union {
    unsigned Buffer[STRSIZ];
    struct {
      char    lo;
      char    hi;
    } HiLo[STRSIZ];
  } v;
  int Count;
  union {
    unsigned ImageWord;
    struct {
      char    lo;
      char    hi;
    } HiLo;
  } x;
  int Index;
  int i;
  char *ptr;

  Count = (DataPointer[*ImageIndex] & 0xff);
  ptr = (char*) MK_FP(BaseSeg, VirtualOffset + (*ScreenLoc << 1));
  switch (DataPointer[*ImageIndex] >> 8) {
    case 0xFF: // Send a repeating set of byte/attrs to the screen
      x.ImageWord = DataPointer[*ImageIndex+1];
      RemapOrDecolor(&x.HiLo.hi);
      for (i=0; i < Count; ++i)
        v.Buffer[i] = x.ImageWord;
      MoveScreenData(v.Buffer, ptr, Count);
      *ImageIndex += 2;
      *ScreenLoc += Count; // count = "words" displayed
      break;
    case 0x00: // Send a block of non-repeating byte/attrs to the screen
      if (BW || ColorMap) { // put the characters in a buffer
        // de-color & move to the screen
        memcpy(v.Buffer, &DataPointer[*ImageIndex + 1], Count << 1);
        if (ColorMap)
          for (Index = 0; Index < Count; Index++)
            ReMap(&v.HiLo[Index].hi);
        else
          DecolorA((void far*) v.Buffer, Count);
        MoveScreenData(v.Buffer, ptr, Count);
      }
      else { // we're not de-coloring, so move directly from ImageData
        MoveScreenData(&DataPointer[*ImageIndex + 1], ptr, Count);
      }
      *ImageIndex += (Count + 1);
      *ScreenLoc += Count;
      break;
    default: // Send a single unique byte/attribute to the screen
      x.ImageWord = DataPointer[*ImageIndex];
      RemapOrDecolor(&x.HiLo.hi);
      MoveScreenData(&x.ImageWord, ptr, 1);
      ++ *ImageIndex;
      ++ *ScreenLoc;
      break;
  }
}

static void DisplayBorderColor(char TheColor)
{
  unsigned Buffer[AbsoluteMaxCols];
  char     BWattr;
  int      Offset, i;
  unsigned TopLineAttr;
  struct   REGPACK cpu;

  memset(&cpu, 0, sizeof(cpu)); // for Windows compatibility

  // paint top line with border color on 24 line full screens only
  // and only if the screen has not been repositioned (43/50 line mode)
  if ((NewRow == 255) && (NewCol == 255)) { // Only do this if the screen has
    // NOT been repositioned ! First, deal with the Border Color
    TopLineAttr = 0x0720; // attribute/character = LightGray on Black space
    i = VideoCard() >> 8;
    if ((i == 3) ||(i == 5) ||(i == 6)) { // CGA, VGA, MCGA
      // first set the border color (on full screens only)
      cpu.r_ax = 0x0b00;
      cpu.r_bx = TheColor;
      intr(0x10, &cpu);
      TopLineAttr = (TheColor << 12) + 0x20;
      if (TheColor > 7)
        TopLineAttr |= color; // 0x8000
    }
    // Then, deal with the Top Line on 24 line screens only.
    if ((ScreenType == Full24) && ClearTopLine) {
      BWattr = TopLineAttr >> 8;
      RemapOrDecolor(&BWattr);
      TopLineAttr = (BWattr << 8) | (TopLineAttr & 0x00FF);
      for (i=0; i < AbsoluteMaxCols; ++i)
        Buffer[i] = TopLineAttr;

      /*  The value of SHIFT is either 0 or OneLineLength,
      indicating how far to offset the screen.  0 means don't
      offset the screen at all, therefore, the status line is
      at the bottom of the screen.  OneLineLength means offset
      the screen by one line, therefore, the status line is at
      the top of the screen.  We calculate an appropriate offset
      and fill in the border color.

      NOTE: this only happens with 24 line "full" screens.  */

      Offset = Shift ? 0 : (OneLineLength * 24);
      MoveScreenData(Buffer, MK_FP(BaseSeg, VideoOffset+Offset),MaxCols);
    }
  }
}

void DisplayFullScreen(int * BufferIndex, void * DataPointer)

/*  The VAR BufferIndex is only needed as a "return" value for displaying
Version 3 screens.  It is needed so that the menu coordinates can be
located at then end of the SQZ data.  After we drop support for Version 3
Saywhat screens, we can make BufferIndex a local variable.  */

{
  int      ScreenLoc;
  int      ScreenSize;
  unsigned VirtualOffset;

  *BufferIndex = 0;
  ScreenLoc = 0;
  VirtualOffset = VideoOffset + Shift;
  switch (ScreenType) {
    case Full24: ScreenSize = 1920; break;
    case Full25: ScreenSize = 2000; break;
    case Full43: ScreenSize = 3440; break;
    case Full50: ScreenSize = 4000; break;
    case Full66: ScreenSize = 5280; break;
    default:
      SetError(ScreenType, 1, Unknown_screen_type_in_sqz_file);
      return;
  }
  while (ScreenLoc < ScreenSize)
    WriteToScreen(BufferIndex,DataPointer,&ScreenLoc,VirtualOffset);
}

void DisplaySubScreen(int * BufferIndex, void * DataPointer, int SubX1,
int SubY1, int SubX2, int SubY2)
/*  The VAR BufferIndex is only needed as a "return" value for displaying
Version 3 screens.  It is needed so that the menu coordinates can be
located at then end of the SQZ data.  After we drop support for Version 3
Saywhat screens, we can make BufferIndex a local variable.  */
{
  int      LineLength;
  int      Row;
  int      ScreenLoc;
  unsigned VirtualOffset;

  LineLength = SubX2 - SubX1 + 1;
  *BufferIndex = 0;
  for (Row = SubY1; Row <= SubY2; Row++) { // process a line at a time
    ScreenLoc = 0;
    VirtualOffset = VideoOffset + ThisCharOffset(Row,SubX1) + Shift;
    while (ScreenLoc < LineLength)
      WriteToScreen(BufferIndex,DataPointer,&ScreenLoc,VirtualOffset);
  }
}

void PaintShadow(char C1, char R1, char C2, char R2)
/*  Be sure to add the shadow BEFORE displaying the screen, because if the sub-
screen is in column MaxCols or Maxcols-1 or in MaxRows, PaintShadow will
shadow OVER the screen... so paint the shadow first, then pop up the screen.  */
{
  char Bottom;
  int Index;
  char Right;
  char Width;


  if (!Shift) { // then we have a "bottom of screen" status line, and
    // everything is going to move up one line on the screen.
    --R1;
    --R2;
  }
  if ((R2 + 1) <= (char) MaxRows) {
    Right = C2;
    if (Right > MaxCols - 2)
      Right = MaxCols - 2;
    ChangeAttribute(Right-C1+1, R2+1, C1+2, ShadowColor);
  }
  Bottom = R2;
  if (Bottom > (char) MaxRows)
    Bottom = MaxRows;
  if (C2 == (char) MaxCols)
    Width = 0;
  else
    if (C2 == (MaxCols - 1))
      Width = 1;
    else
      Width = 2;
  if (Width > 0)
    for (Index = R1 + 1; Index <= Bottom; Index++)
      ChangeAttribute(Width,Index,C2 + 1, ShadowColor);
}

/* ==============================================*/
/*           PopScreen Support Routines          */
/* ==============================================*/

void SaveTheScreen(char WindX1, char WindY1, char WindX2, char WindY2)
{
  if (AutoSaveMode)
    if ((ScreenType == SubScreen) && AddShadow)
      PushWindow(WindX1, WindY1, (char) (WindX2+2), (char) (WindY2+1));
    else
      PushWindow(WindX1, WindY1, WindX2, WindY2);
}

void SetupMenuCoordinates(char WindowX1, char WindowY1, char * MenuC1,
char * MenuR1, char * MenuC2, char * MenuR2)
{
  unsigned char Xsize, Xoffset, Ysize, Yoffset;

  // if it's a sub-screen and it has been repositioned, then we need to
  // recalculate the menu corner coordinates prior to running the menu

  if ((ScreenType == SubScreen) && (NewRow != 255) && (NewCol != 255)) {
    // find the size of the menu
    Xsize = *MenuC2 - *MenuC1;
    Ysize = *MenuR2 - *MenuR1;
    // determine the difference between the old position and the new
    Xoffset = NewCol - WindowX1;
    Yoffset = NewRow - WindowY1;
    // correct the 4 corner positions of the menu
    *MenuC1 = *MenuC1 + Xoffset;
    *MenuR1 = *MenuR1 + Yoffset; // Adjust these by the Offset
    *MenuC2 = *MenuC1 + Xsize;
    *MenuR2 = *MenuR1 + Ysize;   // Adjust these by the size
  }
}

void SetupScreenCoordinates(char * X1, char * Y1, char * X2, char * Y2)
{
  unsigned char Xsize, Ysize;

  if ((NewRow != 255) && (NewCol != 255)) {
    Xsize = *X2 - *X1;
    Ysize = *Y2 - *Y1;
    *X1 = NewCol;
    *Y1 = NewRow;
    *X2 = *X1 + Xsize; // ??? what if this results in "Off
    *Y2 = *Y1 + Ysize; // the screen" coordinates  ????
  }
}
/* ========================================= */
/*          PopScreen Version Routines       */
/* ========================================= */

void LoadCurrentVersionScreen(SqzHeaderType * DataPointer)
{
  char    BorderColor;
  int     BufferIndex;
  char    MenuC1, MenuC2, MenuR1, MenuR2;
  int     ScreenSize;
  void *  SqzData;
  char    Window_X1, Window_X2, Window_Y1, Window_Y2;
  char    CreateMode;
  struct  REGPACK cpu;

  MenuBarAttr = DataPointer->MenuColor;
  if (ColorMap) //  We don't need to handle BW here, because it is
    ReMap(&MenuBarAttr); // handled at the point where the Highlight is
  // setup.  If BW is on, the highlight is XOR'd.
  MovingBarMenu = DataPointer->MovingBarMenu;
  MenuC1 = DataPointer->MenuCoord.C1;
  MenuR1 = DataPointer->MenuCoord.R1;
  MenuC2 = DataPointer->MenuCoord.C2;
  MenuR2 = DataPointer->MenuCoord.R2;

  BorderColor = DataPointer->BorderColor;

  Window_X1 = DataPointer->ScreenCoord.C1;
  Window_Y1 = DataPointer->ScreenCoord.R1;
  Window_X2 = DataPointer->ScreenCoord.C2;
  Window_Y2 = DataPointer->ScreenCoord.R2;
  ScreenSize = (Window_X2 - Window_X1 + 1) * (Window_Y2 - Window_Y1 + 1);
  ScreenType = DataPointer->ScreenType;
  if (ScreenType != Full24)
    Shift = 0;
  SetupScreenCoordinates(&Window_X1, &Window_Y1, &Window_X2, &Window_Y2);
  SaveTheScreen(Window_X1, Window_Y1, Window_X2, Window_Y2);
  CreateMode = DataPointer->ScreenSize;
  switch (CreateMode) {
    case 24:
    case 25: CreateMode = 25; break;
    case 43:
    case 50:
    case 60:
    case 66: // nothing to do, the value doesn't change
      break;
    default: CreateMode = 25; break;
  }
  // set the video card screen size mode
  HandleLineMode(Window_Y2, CreateMode); // version 4 screens

  /*  We add the shadow before displaying the screen, because if the sub screen
  is in column MaxCols-1 or MaxCols or in MaxRows, the PaintShadow will shadow OVER the
  screen... so we paint the shadow first, then pop up the screen over it.  */

  if (AddShadow && (ScreenType == SubScreen))
    PaintShadow(Window_X1, (char) (Window_Y1 + 1), Window_X2, (char) (Window_Y2 + 1));      /* +1 due to gbr */
  SqzData = (void *) ((long) DataPointer + DataPointer->SqzOffset);
  if (ScreenType == SubScreen)
    DisplaySubScreen(&BufferIndex,SqzData,Window_X1,Window_Y1,Window_X2,Window_Y2);
  else  {
    DisplayFullScreen(&BufferIndex,SqzData);
    DisplayBorderColor(BorderColor);
    SetBrightBackground((char)(DataPointer->BrightEnable ? 0x09 : 0x29));
  }
  // tell TopView/DESQview that we changed the screen
  if (TopView) {
    memset(&cpu, 0, sizeof(cpu)); // for Windows compatibility
    cpu.r_ax = 0xff00;
    cpu.r_cx = ScreenSize;
    intr(0x10, &cpu);
  }
  if (MovingBarMenu && GetMenuResponse) { //  get the menu coordinates
    SetupMenuCoordinates(DataPointer->ScreenCoord.C1,
    DataPointer->ScreenCoord.R1, &MenuC1, &MenuR1, &MenuC2, &MenuR2);
    HandleMovingBarMenu(MenuC1, MenuR1, MenuC2, MenuR2);
  }
}

void LoadVersion3Screen(V3HeaderType * DataPointer)
{
  char   BorderColor;
  int    BufferIndex;
  char   MenuC1, MenuC2, MenuR1, MenuR2;
  char   OriginalX1, OriginalY1;
  int    ScreenSize;
  void * SqzData;
  char   Window_X1, Window_X2, Window_Y1, Window_Y2;
  struct REGPACK cpu;

  memset(&cpu, 0, sizeof(cpu)); // for Windows compatibility
  MovingBarMenu = (DataPointer->MovingBarMenu & 0x01);
  MenuBarAttr = DataPointer->MenuColor;
  if (ColorMap) // We don't need to handle BW here, because it is
    ReMap(&MenuBarAttr); // handled at the point where the Highlight is
  // setup.  If BW is on, the highlight is XOR'd.
  BorderColor = DataPointer->BorderColor;

  Window_X1 = DataPointer->ScreenCoord.C1;
  Window_Y1 = DataPointer->ScreenCoord.R1;
  Window_X2 = DataPointer->ScreenCoord.C2;
  Window_Y2 = DataPointer->ScreenCoord.R2;
  ScreenSize = (Window_X2 - Window_X1 + 1) * (Window_Y2 - Window_Y1 + 1);
  OriginalX1 = Window_X1;
  OriginalY1 = Window_Y1;

  if (ScreenSize == 1920)
    ScreenType = Full24;
  else
    ScreenType = (ScreenSize == 2000) ? Full25 : SubScreen;

  SetupScreenCoordinates(&Window_X1,&Window_Y1,&Window_X2,&Window_Y2);
  SaveTheScreen(Window_X1,Window_Y1,Window_X2,Window_Y2);

  // set the video card screen size mode
  HandleLineMode(Window_Y2,25); // version 3 screens are always 25 line mode

  /*  We add the shadow before displaying the screen, because if the sub screen
  is in column 79 or 80 or in row 25, the PaintShadow will shadow OVER the
  screen... so we paint the shadow first, then pop up the screen over it.  */

  if (AddShadow && (ScreenType == SubScreen))
    PaintShadow(Window_X1,Window_Y1,Window_X2,Window_Y2);
  SqzData = (void *) ((long) DataPointer + sizeof(V3HeaderType));
  /*  We need to adjust the value of Shift for a Sub Screen (below) because at
  this point, Shift is the number of bytes to ADD to the current position
  in order to account for the position of the Status Line.  But, in a sub
  screen, we know the starting point if the status line is on top, so we
  need to subtract OneLineLength if the Status line is on the bottom of
  the screen (pushing the SubScreen UP one row).  Likewise, if we are
  dealing with the "neither fish nor fowl" version 3 screen created by
  the new IMPORT routine that creates 25 line version 3 screens, then
  we also want Shift to be 0 so it does not bump the screen down 1 line.  */

  if (ScreenType == SubScreen) {
    Shift -= OneLineLength;
    DisplaySubScreen(&BufferIndex,SqzData,Window_X1,Window_Y1,Window_X2,Window_Y2);
  }
  else {
    if (ScreenType == Full25)
      Shift -= OneLineLength;
    DisplayFullScreen(&BufferIndex,SqzData);
    DisplayBorderColor(BorderColor);
    SetBrightBackground(DataPointer->BrightEnable);
  }
  // tell TopView/DESQview that we changed the screen
  if (TopView) {
    cpu.r_ax = 0xff00;
    cpu.r_cx = ScreenSize;
    intr(0x10, &cpu);
  }
  if (MovingBarMenu && GetMenuResponse) {
    /*  If there is a moving bar menu in a version 3 screen, then the last
    four bytes of the SQZ file are the moving bar coordinates.

    The BufferIndex value returned by the Display Routines above,
    points to the NEXT "word" location PAST the end of the compressed SQZ
    data.  The conversion done below is because BufferIndex is counting
    the WORDS that have been processed.  This value must be converted
    to the number of BYTES to increment the pointer.      */
    SqzData = (void *)((char *) SqzData + (BufferIndex << 1));
    MenuR1 = *((char *) SqzData);
    ((char *) SqzData)++;
    MenuC1 = *((char *) SqzData);
    ((char *) SqzData)++;
    MenuR2 = *((char *) SqzData);
    ((char *) SqzData)++;
    MenuC2 = *((char *) SqzData);
    // adjust if screen has been repositioned
    SetupMenuCoordinates(OriginalX1,OriginalY1,&MenuC1,&MenuR1,&MenuC2,&MenuR2);
    HandleMovingBarMenu(MenuC1,MenuR1,MenuC2,MenuR2);
  }
}

int ScreenVersion(HeaderIDType * DataPointer)
{
  if (DataPointer->ID == 'S')
    return DataPointer->Version;
  else
    return 0;
}
/* =================================== */
/*       Get Record Routines           */
/* =================================== */

void SetUserGetProcTo(void (* UserProcedure)(GetRecord * ptr))
{
  UserGetProc = UserProcedure;
}

static void Pascal2C(char *s)  // converts a Pascal-style string to a C-string
{                       // added by gbr 5/31/93
  char L;
  L = s[0];             // save the length byte
  memcpy(s, &s[1], L);  // move all bytes over to the left one
  s[L] = 0;             // put the zero byte in and we are done
}

void LoadGets(SqzHeaderType * DataPointer)
{
  int Count;
  int GetOffset;
  int GetSize;
  int i;
  GetRecord SqzGet;

  if (DataPointer->GetSize > 0) {
    if (DataPointer->GetSize % sizeof(GetRecord))
      SetError(13, 2, SQZ_File, Has_wrong_size_get_area);
    else {
      // store the values of GetOffset and GetSize before advancing the pointer
      GetOffset = DataPointer->GetOffset;
      GetSize   = DataPointer->GetSize;
      (long) DataPointer += GetOffset;
      Count = GetSize / sizeof(GetRecord);
      for (i = 0; i < Count; i++) {
        memcpy(&SqzGet, DataPointer, sizeof(SqzGet));
        (long) DataPointer += sizeof(SqzGet);
        if (UserGetProc) {
          //strings in the SqzGet structure are Pascal type
          //meaning their is length byte at the front.
          //we need convert them to ascii-z c-style strings
          Pascal2C(SqzGet.DBFAlias);
          Pascal2C(SqzGet.FieldName);
          Pascal2C(SqzGet.PictureClause);
          Pascal2C(SqzGet.FieldType);
          Pascal2C(SqzGet.RangeLower);
          Pascal2C(SqzGet.RangeUpper);
          Pascal2C(SqzGet.ValidClause);
          Pascal2C(SqzGet.WhenClause);
          Pascal2C(SqzGet.FutureUse);
          UserGetProc(&SqzGet);
        }
      }
    }
  }
}

/* ==================================== */
/*            PopScreen Routine         */
/* ==================================== */

void PopScreen(void * DataPointer)
{

  /*  So, here's more than you ever wanted to know about the value of Shift !!
  It contains the number of bytes to shift the screen image on the screen, so,
  if the status line is on the top of the screen, it's equal to OneLineLength.
  The problem arises with SubScreens.  Since the SubScreen is already
  shifted from the top of the screen, we need to shift it negatively if
  there's a Bottom status line.  Here's a chart of the possible values
  of Shift:
  Status Line Position
  ---ScreenType---        --TOP--   --BOTTOM--

  Version 3 Full24          160           0       NOTE: 160 is really
  Version 3 SubScr            0        -160             the value in
  Version 4 Full              0           0             OneLineLength,
  Version 4 Full24          160           0             which could
  Version 4 SubScr            0           0             change.....

  The concept of a "Shift" doesn't apply to Version 4 screens, unless they're
  Full24 type screens.  The above leads to code that looks like the following
  in the horizontal and vertical menu handling routines:

  if (((ScreenType == Full24) && (Shift == 0)) ||
  ((ScreenType == SubScreen) && (Shift < 0)))
  y1--;      to account for SET STATUS BOTTOM condition

  There are also comments above where Shift is set.  */


  Shift = TopStatusLine ? OneLineLength : 0;

  if (InhibitSnow && !UseSnowInhibition)
    InhibitSnow = FALSE;

  switch (ScreenVersion(DataPointer)) {
    case 3:
      if (!SuppressDisplay)
        LoadVersion3Screen(DataPointer);
      ScreenFound = TRUE;
      break;

    case 4:
      if (!SuppressDisplay)
        LoadCurrentVersionScreen(DataPointer);
      if (UserGetProc)
        LoadGets(DataPointer);
      ScreenFound = TRUE;
      break;

    default:
      SetError(13,1, Invalid_saywhat_sqz_format);
      ScreenFound = FALSE;
      break;
  }
  NewRow = 255;  // always reset newcol and newrow
  NewCol = 255;
}
