/* filename: OPENLIBR.C

: T O P A Z for C :Ŀ
                          Version 4.5  05/16/93                              
                                                                             
 Copyright (c) 1988,1994 Software Science Inc. All Rights Reserved Worldwide.
 Unauthorized distribution or disclosure of this source code or modification 
  or removal of this notice  constitutes a breach of the license agreement.  

*/
#include <stdio.h>
#include <dos.h>
#include <share.h>
#include <stdlib.h>
#include <string.h>
#include <vidpop.h>

static char _tzfar funcname[] = { " [OpenLibrary]" };

void OpenLibrary(char which, char * newfilename, BOOL stayopen)
{
  int             i;
  library_array_record *v;

  if (LibraryArray[--which] == NULL) {
    if ((LibraryArray[which] = malloc(sizeof(library_array_record))) == NULL) {
      LibraryArray[which] = NULL;
      goto error_opening;
    }
    memset(LibraryArray[which], 0, sizeof(library_array_record));
  }
  v = LibraryArray[which];
  if (v->LibraryOpen)
    CloseLibrary(which);
  strcpy(v->Filename, newfilename);
  v->KeepOpen = stayopen;
  v->LibraryOpen =
  ((v->LibraryFile = _fsopen(v->Filename, "rb", SH_DENYWR)) != NULL) ?
             TRUE : FALSE;
  if (v->LibraryOpen) {
    if ((v->Header = malloc(sizeof(LibraryHeader)
    + sizeof(directory_record))) == NULL) {
      fclose(v->LibraryFile);
      v->LibraryOpen = FALSE;
      goto error_opening;
    }
    if (sizeof(LibraryHeader) != fread(v->Header, 1, sizeof(LibraryHeader), v->LibraryFile)) {
      fclose(v->LibraryFile);
      v->LibraryOpen = FALSE;
      goto error_reading;
    }
    // just take enough memory for the number of screens in directory
    // and not space for empty directory records
    for (i = 0; i < v->Header->NumberOfScreens; i++) {
      if ((v->LibraryDirectory[i] = malloc(sizeof(directory_record))) == NULL) {
        v->LibraryDirectory[i] = NULL;
        goto error_opening;
      }
    }
    // fill array with data from library directory
    for (i = 0; i < v->Header->NumberOfScreens; i++) {
      if (sizeof(directory_record) != fread(v->LibraryDirectory[i], 1, sizeof(directory_record), v->LibraryFile)) {
        CloseLibrary(which);
        goto error_reading;
      }
    }
    if (!stayopen)
      fclose(v->LibraryFile);
  }
  else {
    SetError(errno, 3, newfilename, not_found, funcname);
    return;
  }

error_reading:
  SetError(errno, 3, error_reading_screen_library, newfilename, funcname);
  return;

error_opening:
  SetError(217, 4, Insufficient_memory, to_open_screen_library,
  newfilename, funcname);
  return;
}
