/* filename: MVBARMEN.C

: T O P A Z for C :Ŀ
                          Version 4.5  05/16/93                              
                                                                             
 Copyright (c) 1988,1994 Software Science Inc. All Rights Reserved Worldwide.
 Unauthorized distribution or disclosure of this source code or modification 
  or removal of this notice  constitutes a breach of the license agreement.  

*/
#include <stdio.h>
#include <stdlib.h>
#include <dos.h>
#include <conio.h>
#include <string.h>
#include <vidpop.h>

// Flags used for manipulating the character sets
#define CH32      1  // #32
#define CH33_168  2  // #33..#168
#define CH169_175 4  // #169..#175
#define CH224_240 8  // #224..#240
#define CH241_254 16 // #241..#254
#define CH255     32 // #255

extern unsigned char MaxCols;
extern unsigned char MaxRows;

extern void  (* MenuHelpProc)(void);
extern char  FKeyExit[41];
extern void  (* MenuFKeyProc)(void);

void  SaveCursor(unsigned *cursor);
void  RestoreCursor(unsigned cursor);
BOOL  CursorVisible(void);
void _CursorOff(void);
char  MaxAvailCols(void);
char  UpCase(char c);

extern char  MenuTimeOutValue;
extern int   BW;
extern char  MenuBarAttr;
extern int   Shift;
//  Either 0 or OneLineLength depending on whether using top status line.
//  This is different from how it was being used!
//  It is now the Amount To Shift, instead of a multiplier used to calculate
//  the shift. ALSO, it can now be negative!!

extern int  MovingBarMenu;
extern int  CallUserProc;
extern char ScreenType;

typedef struct choice_type {
  int  left;
  int  right;
  char letter;
} choice_type;

typedef struct menu_data {
  char hot_key[AbsoluteMaxRows];
  int  CR_flag;
  int  hit_escape;
  int  menu_saved;
  char TotalChoices;
  int  HighLightbuffer[AbsoluteMaxCols];
} menu_data;

static menu_data *MBM = NULL;

static void PopMenuHelp(void)
{
  char saved;

  if (MenuHelpProc) {
    saved = MenuBarAttr;
    MenuHelpProc(); // call users routine
    MenuBarAttr = saved;
  }
}

static char get_request(int CurrentItem, char direction, int * NewItem)
{
  char  Key, x, Key1;
  long  EndTime;
  long  StartTime;
  long  Timedout;
  char  SaveMenuBarAttr;
  int   KeyPress;
  ActivityType SaveActivity;
  EventRec e;

  x = 'x';
  if (MenuTimeOutValue > 0) {
    StartTime = *((long *) MK_FP(0x40,0x6C));
    EndTime = StartTime + MenuTimeOutValue * 18;
  }
  Timedout = KeyPress = FALSE;
  do {
    if (ClockPtr) {
      SaveMenuBarAttr = MenuBarAttr;
      ClockPtr();
      MenuBarAttr = SaveMenuBarAttr;
    }
    if (!IgnoreNumLock) // clear bit 5, 0010000
      *((char *) MK_FP(0x40,0x17)) &= 0xDF;
    if (MenuTimeOutValue > 0) {
      if (*(long *)MK_FP(0x40,0x6C) < StartTime)
        Timedout = ((*(long *) MK_FP(0x40,0x6C) + TicksAtMidnight) > EndTime);
      else
        Timedout = ((*(long *) MK_FP(0x40,0x6C)) > EndTime);
    }
    SaveActivity = Activity;
    Activity = _Menu;
    KeyPress = EventPending(); // with mouse
    Activity = SaveActivity;
  }  while (!(KeyPress || Timedout));
  if (Timedout) // this only works if MenuEscapeEnable = True
    Key = '\x1B';
  else
    GetEvent(&e);
  switch (e.WhichEvent) {
    case Mouse:
      if (e.v.sMouse.TargetID == ReservedID)
        Key = '\x1B';
      else  {
        *NewItem = e.v.sMouse.TargetID;
        if (e.v.sMouse.ButtonMask & LeftButtonReleased)
          Key =  '\xFE';
        else Key = '\xFF'; // signal for mouse event
      }
      break;
    case Keyboard:
      Key = e.v.sKeyboard.Key;
      break;
  }
  CallUserProc = MBM->CR_flag = MBM->hit_escape = FALSE;
  switch (Key) {
    case ZERO:
      Key1 = e.v.sKeyboard.ScanCode & 0xff;
      if (direction == 'V') { // vertical motion
        switch (Key1) {
          case 'H':
          case 15 : x = 'u'; break; // up or shift-tab
          case 'P': x = 'd'; break; // down
          case 'K':
            if (EnableLeftRightMenuExit)
              x = '\x13'; // left
            break;
          case 'M':
            if (EnableLeftRightMenuExit)
              x = '\x04'; // right
            break;
        }
      }
      else { // horizontal motion
        if (EnableUpDownMenuExit) {
          switch (Key1) {
            case 'H': x = '\x05'; break; // up
            case 'P': x = '\x18'; break; // down
            case 'I': x = '\x12'; break; // Page Up
            case 'Q': x = '\x03'; break; // Page Dn
            case 'G': x = '\x01'; break; // Home
            case 'O': x = '\x1A'; break; // End
          }
        }
        switch (Key1) {
          case 'K':
          case 15 : x = 'l'; break; // left or shift-tab
          case 'M': x = 'r';  break; // right
        }
      }
      if (strchr(FKeyExit, Key1)) {
        CallUserProc = TRUE;
        x = Key1;
      }
      break;
    case carriage_return:
      x = MBM->hot_key[CurrentItem-1];
      MBM->CR_flag = TRUE;
      break;
    case escape:
      if (MenuEscapeEnable) {
        MBM->hit_escape = TRUE;
        x = Key;
      }
      break;
    case ' ':
    case '\t': // advance to next choice when space bar or TAB is pressed
      x = (direction == 'V') ? 'd' : 'r';
      break;
    default: // any other key pressed gets passed through
      x = UpCase(Key);
  }
  return x;
}

static int inset(register unsigned char ch, register int set)
{
#ifdef RUSSIAN
  // added for future localization just to mark the spot
#endif
  return (((set & CH32) && (ch == 0x20U)) ||
  ((set & CH33_168) && (ch >= 0x21U) && (ch <= 0xa8U)) ||
  ((set & CH169_175) && (ch >= 0xa9U) && (ch <= 0xafU))||
  ((set & CH224_240) && (ch >= 0xe0U) && (ch <= 0xf0U))||
  ((set & CH241_254) && (ch >= 0xf1U) && (ch <= 0xfeU))||
  ((set & CH255) && (ch == 0xffU)));
}

static void far * scr_dot(int row, int col, int offset)
{
  return (void far*) MK_FP(BaseSeg,
  VideoOffset+OneLineLength*(row-1)+((col-1)<<1) + offset);
}

static void vertical_get_letter_choices
(int * top, int * bottom, char x1, char y1, char x2, char y2)
// look at screen and determine what letters are the trigger keys for this
// menu (this is for vertical motion menus)
{
  int col, row;
  int FoundFirstLetter;
  unsigned char character;
  unsigned char firstattr = 0, nextattr;
  unsigned char OddManOutColor;
  unsigned char OddManOutChar;
  unsigned char NChars;
  unsigned char FirstLetter;
  int ColorDif;
  int CharSet = 0;
  char *lc_ptr;

  for (row = 0; (unsigned) row < MaxRows; row++)
    MBM->hot_key[row] = blankline;
  MBM->hot_key[row] = '\0';
  for (row = y1; row <= y2; row++) { // step through the rows of the menu

    /*  Before we start scanning the row for the first character and
    the trigger key, we scan the row to identify 1 special case.
    If there are only 2 non-blank characters in the row, and if
    they are different colors, then we alter the character
    set used to identify the significant characters in the row
    so that it includes spaces.  That way, when we scan the row
    looking for the odd color trigger key, we will be able to tell
    which one is actually different from the rest.  */

    NChars = 0;
    col = x1;
    FoundFirstLetter = ColorDif = FALSE;
    lc_ptr = &MBM->hot_key[row-1];
    do {
      character = *(char*) scr_dot(row, col, 0);
      if (inset(character, CH33_168|CH224_240|CH255)) {
        if (FoundFirstLetter) {
          if (firstattr != *(unsigned char*) scr_dot(row, col, 1))
            ColorDif = TRUE;
        }
        else {
          FirstLetter = UpCase(character);
          FoundFirstLetter = TRUE;
          firstattr = *(unsigned char*) scr_dot(row, col, 1);
        }
        ++NChars;
      }
      col++;
    }  while (!(col > x2));
    CharSet = (((NChars == 2) && ColorDif) ? CH32 : 0) |
    CH33_168 | CH224_240 | CH255;
    FoundFirstLetter = FALSE;
    col = x1; // first column of menu area
    do { // scan for the first letter in a menu choice
      character = UpCase(*(unsigned char*) scr_dot(row, col, 0));
      // [#16, #33..#168, #224..#240]
      if (inset(character,CharSet)) {
        FoundFirstLetter = TRUE;
        *lc_ptr = character; // we found the first letter of a menu choice
        firstattr = *(unsigned char*) scr_dot(row, col, 1);
      }
      col++; // advance a column to the right
    }  while (!((col > x2) || FoundFirstLetter));

    if (FoundFirstLetter) { // look for a special attribute
      /*  Note: Col is now positioned PAST the first letter that
      we just found above.  */
      FoundFirstLetter = FALSE;
      OddManOutColor = 0;
      do {
        nextattr = *(unsigned char*) scr_dot(row, col, 1);
        if (nextattr != firstattr) {
          character = UpCase(*(unsigned char*) scr_dot(row, col, 0));
          // [#33..#168, #224..#240, #255]
          if (inset(character,CharSet)) {
            if ((OddManOutColor == 0)) {
              OddManOutChar = character;
              OddManOutColor = nextattr;
              FoundFirstLetter = TRUE;
            }
            else  { // the gig is up
              FoundFirstLetter = FALSE;
              col = x2; // exit the loop
            }
          }
        }
        col++;
      }  while (!((col > x2)));

      /*  Finally, we set the trigger key for the row.  If we did not
      FoundFirstLetter, and there are exactly 2 characters in the
      row, then it means that the row contains more than 2 colors,
      so we default to using the first of the 2 characters as the
      trigger key.  If we did not FoundFirstLetter, and there are
      NOT exactly 2 characters in the row, then the trigger key
      was set to the first character in the row above. Finally,
      if we "think" we FoundFirstLetter, but the bar area is
      only 2 characters wide, and the 2 characters in the bar
      are different colors, then use the first one.  */

      if (FoundFirstLetter)
        *lc_ptr = ((NChars == 2) && ((x2 - x1) == 1) && ColorDif) ?
        FirstLetter : OddManOutChar;
      else
        if (NChars == 2)
          *lc_ptr = FirstLetter;
    }
    else
      *lc_ptr = blankline; // no word on this row within the menu
  } // step through rows
  // determine the real top row of the menu
  row = *top = 0;
  while ((unsigned char) row != MaxRows) {
    if (MBM->hot_key[row++] != blankline) {
      *top = row;
      break;
    }
  }
  MBM->TotalChoices = *top;
  if (MBM->TotalChoices == 0) {
    SetError(254, 1, No_menu_choices_found);
    return; // there is nothing on the screen to make a menu from
  }
  *bottom = MaxRows - 1;
  // determine the real bottom row of the menu
  row = MaxRows;
  while (--row) {
    if (MBM->hot_key[row-1] != blankline) {
      *bottom = row;
      break;
    }
  }
}

static void Vertical_HighLight(int i, int x1, int x2)// now snowless, regardless of video card
{
  if (MBM->menu_saved) { // save the menu item for later restore
    // put the menu item into a buffer
    MoveScreenData(scr_dot(i, x1, 0), MBM->HighLightbuffer, (x2-x1+1));
    ChangeAttribute(x2 - x1 + 1, i, x1,
    ((MenuBarAttr == 0) || BW) ? // if MenuBarAttr = 0 then
    // get the current color and xor it for the highlight
    // or use the pre-defined color for highlights
    (*(unsigned char*) scr_dot(i, x1, 1)) ^ 0x77 : MenuBarAttr);
  }
  else  // restore the old menu item text in it's original form
    MoveScreenData(MBM->HighLightbuffer, scr_dot(i, x1, 0), (x2-x1+1));
  MBM->menu_saved = !MBM->menu_saved;
}

static char * first_word(int col, int row) // local procedure
{
  int got_letter, i;
  char character;
  static char _tzfar temp[STRSIZ] = "";

  got_letter = FALSE;
  do {
    character = UpCase(*(unsigned char*) scr_dot(row, col, 0));
    if (inset(character, CH33_168 | CH224_240))
      got_letter = TRUE;
    col++;
  }  while (!(((unsigned) col > MaxCols) || got_letter));
  // found the first char. save it, and start looking for the first space
  temp[0] = character;
  i = 0;
  do {
    character = UpCase(*(unsigned char*) scr_dot(row, col, 0));
    col++;
    i++;
    temp[i] = character;
  } while (!((character == ' ') || ((unsigned) i > MaxCols)));
  temp[i] = '\0'; // terminate the line anyway
  return temp;
}

static void vertical_moving_bar_menu(char x1, char y1, char x2, char y2)
//  x1 - starting column
//  y1 - starting row
//  x2 - ending column
//  y2 - ending row
{
  int  i, x;   //  i = row
  int  choice;
  int  top, bottom;
  int  NewItem;
  char saveattr;
  char request, Count;
  char *p;

  saveattr = MenuBarAttr;
  MenuChoice = 0;
  MenuChar = ' ';
  MenuString[0] = '\0';
  ExitMenu = FALSE;
  if (((ScreenType == Full24) && (Shift == 0)) ||
  ((ScreenType == SubScreen) && (Shift < 0))) {
    y1--; // account for SET STATUS BOTTOM condition
    y2--;
  }
  vertical_get_letter_choices(&top, &bottom, (char) x1, (char) y1, (char) x2, (char) y2);
  MBM->TotalChoices = top;
  if (top == 0)
    return; // no choices in menu
  //      PushMouse();
  for (i = top; i <= bottom; i++) {
    if (MBM->hot_key[i-1] != blankline)
      AddTarget(x1,i,x2,i,i,LeftButtonReleased | LeftButtonDown);
  }
  AddTarget(1,1,MaxAvailCols(),MaxAvailRows(),ReservedID,RightButtonReleased);
  if (MenuSeed > 0) {
    if (MenuSeed > bottom)
      MenuSeed = bottom;
    Count = 0; // find out where to start in the menu
    i = 0;
    do {
      do {
        i++;
      }  while (!((MBM->hot_key[i-1] != blankline) || (i>(MaxRows-1))));
      Count++;
    }  while (!((Count == MenuSeed) || (i == bottom)));
  }
  else
    i = top; // no seed specified
  Vertical_HighLight(i, x1, x2);
  Count = 0;
  for (x = 0; x < i; x++)
    if (MBM->hot_key[x] != blankline)
      Count++;
  MenuChoice = Count;
  MenuChar = MBM->hot_key[i-1];
  strcpy(MenuString, first_word(x1,i));
  PopMenuHelp();
  EnableMouse();
  do {
    request = get_request(i,'V',&NewItem); // vertical motion
    MenuKey = request;
    choice = 0;
    Vertical_HighLight(i, x1, x2);
    switch (request) {
      case '\xFF': // single mouse click
        i = NewItem;
        break;
      case '\xFE':  // left button released
        i = NewItem;
        MBM->CR_flag = TRUE;
        break;
      case 'd': // down
        do {
          i++;
        }  while (!((i > y2) || (MBM->hot_key[i-1] != blankline)));
        if (i > y2)
          i = top;
        break;
      case 'u': // up
        do {
          i--;
        }  while (!((i < y1) || (MBM->hot_key[i-1] != blankline)));
        if (i < y1)
          i = bottom;
        break;
    }
    Vertical_HighLight(i, x1, x2);
    if (MBM->CR_flag) {
      choice = i;
      MenuKey = '\r';
    }
    else {
      switch (request) {
        case  19: // left and right arrow keys
        case   4: choice = i; break;
        case 'u': // only bar was moved
        case 'd':    choice = 0; break;
        default:
          if (!CallUserProc)
            if((p = strchr(MBM->hot_key, request)) == NULL)
              choice = 0;
            else
              choice = (int) (p - MBM->hot_key + 1);
          break;
      }
    }
    // which menu item was chosen - to be used by help procedure
    Count = 0;
    for (x = 1; x <= i; x++)
      if (MBM->hot_key[x-1] != '\x01')
        Count++;
    MenuChoice = Count;
    MenuChar = MBM->hot_key[i-1]; // trigger key
    strcpy(MenuString, first_word(x1,i));
    if ((choice == 0) && (!MBM->hit_escape)) { // only bar was moved
      PopMenuHelp();
      saveattr = MenuBarAttr;
      if (CallUserProc && MenuFKeyProc) {
        // ExitMenu = False;
        PushMouse();
        MenuFKeyProc();
        PopMouse();
        if (ExitMenu)
          choice = i;
        // if (ExitMenu) Hit_Escape = True;
      }
      MenuBarAttr = saveattr;
    }
  }  while (!((choice != 0) || MBM->hit_escape || ExitMenu));
  DisableMouse();
  //      PopMouse();
  if (MBM->hit_escape)
    choice = 0;
  // if (request == 1) choice = i; // how would this happen?
  Vertical_HighLight(i, x1, x2); // erase the menu bar and restore prior attributes
  switch (request) {
    case escape:
      MenuChoice = 0;
      MenuChar = ' ';
      MenuString[0] = '\0';
      break;
    default: // case otherwise
      Vertical_HighLight(choice, x1, x2); // highlight the menu choice
      // choice is the physical line number on the screen, convert it to the logical line
      Count = 0;
      for (i = 0; i < choice; i++)
        if (MBM->hot_key[i] != '\x01')
          Count++;
      MenuChoice = Count;
      MenuChar = MBM->hot_key[choice-1];
      strcpy(MenuString, first_word(x1,choice));
      MenuSeed = Count;
      PopMenuHelp();
      break;
  }
}

static void horizontal_get_letter_choices(int x1, int y1, int x2, int * max_choice,
choice_type *choice_array)
{
  int menuitem, col, Pos;
  int got_letter;
  char character;
  char firstattr, secondattr;
  char OddManOutColor;
  char OddManOutChar;
  choice_type *m_ptr;

  MBM->hot_key[24] = 0;
  for (menuitem = 0; menuitem < 24; menuitem++) {
    m_ptr = &choice_array[menuitem];
    MBM->hot_key[menuitem] = m_ptr->letter = 1;
    m_ptr->left = m_ptr->right = 0;
  }
  got_letter = FALSE;
  col = x1;
  menuitem = *max_choice = 0;
  do {
    do { // get the first letter
      character = UpCase(*(unsigned char*) scr_dot(y1, col, 0));
      got_letter = inset(character, CH33_168 | CH224_240);
      col++;
    }  while (!((col > x2) || got_letter));
    m_ptr = &choice_array[menuitem];
    if (got_letter && (col <= x2 + 1)) {
      m_ptr->left = col - 1;
      m_ptr->letter = character;
      MBM->hot_key[menuitem] = character;
      *max_choice = menuitem + 1;
    }
    if (col == (x2 + 1))
      col = x2;
    do { // find the last letter of the word
      //  here's what it was...   in [33..168, 224..240];
      got_letter = inset(*(unsigned char*) scr_dot(y1, col, 0),
      CH33_168 | CH169_175 | CH224_240 | CH241_254 | CH255);
      col++;
    }  while (!((col > x2) || !got_letter));
    m_ptr->right = col - 1 - (got_letter ? 0 : 1);

    if ((col <= x2 + 1) && (m_ptr->right > m_ptr->left)) {
      //  scan for different attribute within a word
      OddManOutColor = 0;
      Pos = m_ptr->left;
      firstattr = *(unsigned char*) scr_dot(y1, Pos, -1);
      //  start at column of first letter in row
      character = ' ';
      got_letter = FALSE;
      do {
        Pos++;
        secondattr = *(unsigned char*) scr_dot(y1, Pos, -1);
        if (secondattr != firstattr) {
          character = UpCase(*(unsigned char*) scr_dot(y1, Pos, -2));
          if (inset(character, CH33_168 | CH224_240)) {
            if (OddManOutColor == 0) {
              OddManOutColor = secondattr;
              OddManOutChar = character;
              got_letter = TRUE;
            }
            else { // too many different attributes
              got_letter = FALSE;
              character = 'x'; // exit loop now
            }
          }
        }
        // or (character > ' ')
      }  while (!((Pos == m_ptr->right + 1)));
      if (got_letter) {
        m_ptr->letter = OddManOutChar;
        MBM->hot_key[menuitem] = OddManOutChar;
      }
    }
    menuitem++;
  }  while (!((col > x2) || (menuitem > (MaxRows - 1))));
  MBM->TotalChoices = menuitem;
}

static void HighLight(unsigned char x1,  unsigned char x2,
unsigned char y1, choice_type *c_ptr)
// Highlight FROM one column to the left of the choice, (UNLESS the choice
// is at the left edge of the menu area) TO one column to the right of the
// choice, (UNLESS the choice is at the right edge of the menu area).
{
  char left;
  char right;

  left = c_ptr->left;
  if ((unsigned) left != x1)
    left--;
  right = c_ptr->right;
  if ((unsigned) right == x2)
    right--;
  if (MBM->menu_saved) {
    MoveScreenData(scr_dot(y1, left-1, 0), MBM->HighLightbuffer, (right-left+3));
    ChangeAttribute(right - left + 2, y1, left,
    (!MenuBarAttr || BW) ?
    (*(unsigned char*) scr_dot(y1, left+1, 1)) ^ 0x77 : MenuBarAttr);
  }
  else // put back the original menu item
    MoveScreenData(MBM->HighLightbuffer, scr_dot(y1, left-1, 0),(right - left + 3));
  MBM->menu_saved = !MBM->menu_saved;
}

static char * BQ_Word(unsigned char y1, choice_type *choice_array_i)
{
  static char _tzfar temp[81] = "";
  int col,i;

  col = choice_array_i->left;
  for (i=0; col <= choice_array_i->right; i++, col++)
    temp[i] = UpCase(*(unsigned char*) scr_dot(y1, col, 0));
  temp[i] = '\0';
  return temp;
}

static void horizontal_moving_bar_menu(char x1, char y1, char x2)
//  x1 -  menu starting column
//  x2 -  ending column
//  y1 -  starting row
{
  unsigned    char i, choice;
  char    request, *p;
  choice_type choice_array[24];
  int     max_choice;
  int     Count;
  char    saveattr;
  int     NewItem;
  char    left, right;

  if (((ScreenType == Full24) && (Shift == 0)) ||
    ((ScreenType == SubScreen) && (Shift < 0)))
    y1--; // account for SET STATUS BOTTOM condition
  horizontal_get_letter_choices((int) x1, (int) y1, (int) x2, &max_choice, choice_array);
  ExitMenu = FALSE;
  if (MBM->TotalChoices == 0) {
    SetError(254, 1, No_menu_choices_found);
    return;
  }
  //      PushMouse();
  for (i = 0; i < (unsigned char) max_choice; i++) {
    left = choice_array[i].left;
    if (left != x1)
      left--;
    right = choice_array[i].right;
    if (right == x2)
      right--;
    AddTarget(left+1, y1, right, y1, i+1,
    LeftButtonDown | LeftButtonReleased);
  }
  AddTarget(1,1,MaxAvailCols(),MaxAvailRows(),ReservedID,RightButtonReleased);
  if (MenuSeed > 0) {
    Count = 0; // find out where to start in the menu
    i = 0;
    do {
      do {
        i++;
      }  while (!((MBM->hot_key[i-1] != '\x01') || (i > (unsigned char)(MaxRows - 1))));
      Count++;
    }  while (!((Count == MenuSeed) || (i == (unsigned char)max_choice)));
  }
  else
    i = 1;
  HighLight(x1, x2, y1, &choice_array[i-1]);
  MenuChoice = i;
  MenuChar = MBM->hot_key[i-1];
  strcpy(MenuString, BQ_Word(y1, &choice_array[i-1]));
  PopMenuHelp();
  EnableMouse();
  do {
    request = get_request(i,'H',&NewItem); // horizontal motion = 'H'
    choice = 0;
    MenuKey = request;
    HighLight(x1,x2,y1, &choice_array[i-1]);
    switch (request) {
      case '\xFF': // single mouse click
        i = NewItem;
        break;
      case '\xFE': // left button released
        i = NewItem;
        MBM->CR_flag = TRUE;
        break;
      case 'r': // right arrow
        i++;
        if (i > (unsigned char) max_choice)
          i = 1;
        break;
      case 'l': // left arrow
        i--;
        if (i < 1)
          i = max_choice;
        break;
    }
    HighLight(x1,x2,y1, &choice_array[i-1]);
    if (MBM->CR_flag) {
      choice = i;
      MenuKey = '\r';
    }
    else {
      switch (request) {
        case '\x05':
        case '\x18':
        case '\x12':
        case '\x03':
        case '\x01':
        case '\x1A':
          choice = i; // up, down arrow keys, or PgUp, PgDn, Home, or End
          break;
        case 'u':
        case 'd':
          choice = 0; // only bar was moved
          break;
        default:
          if (!CallUserProc) {
            if((p = strchr(MBM->hot_key, request)) == NULL)
              choice = 0;
            else
              choice = (int) (p - MBM->hot_key + 1);
          }
      } // case
    }
    MenuChoice = i;
    MenuChar = MBM->hot_key[i-1];
    strcpy(MenuString, BQ_Word(y1, &choice_array[i-1]));
    if ((!MBM->hit_escape)) {
      saveattr = MenuBarAttr;
      PopMenuHelp();
      if (CallUserProc && MenuFKeyProc) {
        PushMouse();
        MenuFKeyProc();
        PopMouse();
        _CursorOff(); //  turn cursor off, this won't hurt...
        //  if ExitMenu then Hit_Escape := True;
        if (ExitMenu)
          choice = i;
      }
      MenuBarAttr = saveattr;
    }

  }  while (!(choice || MBM->hit_escape));
  DisableMouse();
  //      PopMouse();
  if (MBM->hit_escape)
    choice = 0;
  HighLight(x1,x2,y1, &choice_array[i-1]); // restore prior attributes at light bar
  switch (request) {
    case escape:
      MenuChoice = 0; // default value
      MenuChar = ' ';
      *MenuString = 0; // MenuSeed not changed
      break;
    case '\x05':
    case '\x18':
    case '\x12':
    case '\x03':
    case '\x01':
    case '\x1A':
      MenuKey = request; // up, down arrows, PgUp, PgDn, Home or End
      HighLight(x1,x2,y1, &choice_array[choice-1]); // highlight the actual choice
      break;
    default: // case otherwise
      HighLight(x1,x2,y1, &choice_array[choice-1]); // highlight the actual choice
      MenuChoice = choice;
      MenuChar = MBM->hot_key[choice-1];
      strcpy(MenuString, BQ_Word(y1, &choice_array[choice-1]));
      MenuSeed = choice;
      // if user has a menu, call it when the choice is made
      PopMenuHelp();
      break;
  } // case
} // horizontal menu

void HandleMovingBarMenu(char start_menu_x, char start_menu_y,
                         char stop_menu_x, char stop_menu_y)
{
  BOOL cursorVisible;
  unsigned cursor;
  char keys;
  menu_data CurrentMBM, *SaveMBM;

  SaveMBM = MBM;
  MBM = &CurrentMBM;
  if (MovingBarMenu) {
    cursorVisible = CursorVisible();
    if (cursorVisible) {
      SaveCursor(&cursor);
      _CursorOff();
    }
    ExitMenu = FALSE; // reset every time a menu is activated
    CurrentMBM.menu_saved = TRUE;
    keys = *(unsigned char*) MK_FP(0x40,0x17) & 0xF0; // save old value .. but just the upper 4 bits
    if (start_menu_y == stop_menu_y) // if starting row is same as ending row
      horizontal_moving_bar_menu(start_menu_x, start_menu_y, stop_menu_x);
    else
      vertical_moving_bar_menu(start_menu_x, start_menu_y,
                               stop_menu_x, stop_menu_y);
    if (!IgnoreNumLock)
      *(unsigned char*) MK_FP(0x40,0x17) = keys;  // restore numlock if set
    if (cursorVisible)
      RestoreCursor(cursor);
    MovingBarMenu = FALSE;
  }
  MBM = SaveMBM;
}
