/* filename: SORTVFIL.C

: T O P A Z for C :Ŀ
                          Version 4.5  05/16/93                              
                                                                             
 Copyright (c) 1988,1994 Software Science Inc. All Rights Reserved Worldwide.
 Unauthorized distribution or disclosure of this source code or modification 
  or removal of this notice  constitutes a breach of the license agreement.  

*/
#include <vfiles.h>

char far *WhichMemoryType(unsigned char area)
{
  switch(WorkArea[area]->Handle.v.strue.DataLoc) {
    case Heap: return " TO HEAP";
    case Ems:  return " TO EMS";
    case Ext:  return " TO EXT";
    case Disk: return " TO DISK";
    default:   return "UNKNOWN";
  }
}

void SortVFile(LStatusType SortMode)
{
  unsigned char SaveArea;
#ifndef WINDOWS
  int Toggle = TRUE;
#endif
  WorkAreaType *was;
  dbfRecord    *rs, *rx;
  char local_str[STRSIZ];

  was = WorkArea[Selected];

  if(NotInUseError("SortVFile")) // check current area
    return;
  if(NotAVirtualFile("SortVFile"))
    return;
  if(!was->Handle.v.strue.KeyMaker) {
    SetError(InvalidLLOperation, 2, was->Alias, Has_No_Key_Maker_Specified);
    return;
  }

  if((SortMode != ASCENDING) && (SortMode != DESCENDING)) {
    SetError(InvalidParameter, 3, Invalid_Sort_Mode,
             was->Alias, " [(SortVFile) VFILES]");
    return;
  }

  // At this point, we have a Virtual File, and the SortMode is valid, so:
  // Open WorkArea [AbsoluteMaxWorkAreas]
  // Set the mode to SortMode
  // for each record in the Selected area:
  // append it to the new area
  // snip it out of the Selected area
  // advance the rotor
  // Free the memory for WorkArea [Selected]
  // move the relevant WorkArea info from AbsoluteMaxWorkArea to SaveArea
  // .... and we're done !!
  SaveArea = Selected;
  Selected = AbsoluteMaxWorkareas - 1;
  // added call to WhichMemoryType()
  sprintf(local_str, "**__**__** LINKED LIST %s", WhichMemoryType(SaveArea));
  Use(local_str, was->UserRec, was->UserRecSize);

  rx = &WorkArea[AbsoluteMaxWorkareas - 1]->Handle;

  rx->v.strue.LStatus = SortMode;
  rx->v.strue.KeyMaker = was->Handle.v.strue.KeyMaker;
  Selected = SaveArea;
  GoTop();
  while(!WorkArea[SaveArea]->Handle.EOFile) {
    Selected = AbsoluteMaxWorkareas - 1;
    Append();
    Selected = SaveArea;
    SnipRec();
    if(RecCount > 0) GoTop();

#ifndef WINDOWS
    AdvanceRotor();

    if((ProgressPtr != NULL) && (RecCount > 0)) {
      if(Toggle) {
        Skip(1);
        (*ProgressPtr)();
        GoTop();
      } else
        (*ProgressPtr)();
      Toggle = !Toggle;
    }
#endif // {{ WINDOWS }}
  }

  // Now, move the relevant information from the AbsoluteMaxWorkArea to the
  // SaveArea so the original list now points to the sorted list.

  rs = &WorkArea[SaveArea]->Handle;

  rs->v.strue.LLHeadPtr   = rx->v.strue.LLHeadPtr;
  rs->v.strue.LLTailPtr   = rx->v.strue.LLTailPtr;
  rs->v.strue.CurrentPtr  = rx->v.strue.CurrentPtr;
  rs->v.strue.LStatus     = rx->v.strue.LStatus;
  rs->v.strue.TargetRecNo = rx->v.strue.TargetRecNo;
  rs->v.strue.DataLoc     = rx->v.strue.DataLoc;
  rs->v.strue.KeyMaker    = rx->v.strue.KeyMaker;
  rs->NumRecs             = rx->NumRecs;
  rs->CurRecNo            = rx->CurRecNo;
  rs->EOFile              = rx->EOFile;
  rs->BOFile              = rx->BOFile;

  // Now, we must clear the data in AbsoluteMaxWorkAreas so that when it is
  // closed below, the link data isn't automatically returned.

  rx->v.strue.LLHeadPtr  = NULL;
  rx->v.strue.LLTailPtr  = NULL;
  rx->v.strue.CurrentPtr = NULL;
  rx->NumRecs    = 0L;
  rx->CurRecNo   = 0L;
  rx->EOFile     = TRUE;
  rx->BOFile     = TRUE;

  Selected = AbsoluteMaxWorkareas - 1;
  Use("", NULL, 0);
  Selected = SaveArea;
  GoTop();
}
