/* filename: MEMMNGRT.C

: T O P A Z for C :Ŀ
                          Version 4.5  05/16/93                              
                                                                             
 Copyright (c) 1988,1994 Software Science Inc. All Rights Reserved Worldwide.
 Unauthorized distribution or disclosure of this source code or modification 
  or removal of this notice  constitutes a breach of the license agreement.  

*/
#include <sayget.h>
#include <vfiles.h>

extern unsigned int       CurrentEmsPage;
extern unsigned char      EmsError;
extern EmsFreeListBuffer *EmsFreeList;
extern int                EmsFreeListCount;
extern unsigned int       EmsFreeListHandle;
extern ArrayOfEmsPages   *EmsPageArray;
extern char              *EmsPageBuffer;
extern int                EmsPageCount;
extern void              *EmsPagePointer;
extern int                EmsPagesAllowed;
extern int                MaxEmsFreeList;
extern unsigned int       NextFreeEmsByte;
extern unsigned int       WorkingEmsPage;

extern unsigned int       CurrentExtPage;
extern unsigned char      ExtError;
extern ExtFreeListBuffer *ExtFreeList;
extern int                ExtFreeListCount;
extern unsigned int       ExtFreeListPage;
extern ExtMoveParams     *ExtMoveInfo;
extern LLItemPtr          ExtPackList;
extern ArrayOfExtPages   *ExtPageArray;
extern char              *ExtPageBuffer;
extern int                ExtPageCount;
extern int                ExtPageModified;
extern int                ExtPagesAllowed;
extern int                ExtWasSetup;
extern int                MaxExtFreeList;
extern unsigned int       NextFreeExtByte;
extern unsigned int       WorkingExtPage;

extern int                AlreadyExited;
extern int                ClosingFile;
extern LLItemPtr          CurrentRecPtr;
extern DataStorageType    DataLocation;
extern LLItemPtr          HeadPtr;
extern LLItemPtr          TailPtr;
extern void              *UserRecPtr;
extern int                VariableLength;

static LLItemPtr          NewRecPtr, SaveNextPtr;
static char  _tzfar       ThisKey[101]="", NewKey[101]="";
static unsigned int       NewRecSize;

// The following block of routines are for internal use only
//              by the Memory Management routines.

void DetermineStorageType(void)
{
  char BestLocation[11];

  if(DataLocation == Best) {
    strcpy(BestLocation, EvaluateBest());
    if(strstr(BestLocation, "EMS"))
      DataLocation = Ems;
    else
      if(strstr(BestLocation, "EXT"))
        DataLocation = Ext;
      else
        DataLocation = Heap;
  } else
    if(DataLocation == Biggest) {
      strcpy(BestLocation, EvaluateBiggest());
      if(strstr(BestLocation, "EMS"))
        DataLocation = Ems;
      else
        if(strstr(BestLocation, "EXT"))
          DataLocation = Ext;
        else
          DataLocation = Heap;
    }
    // The following SWITCH statement simply performs one final check on the
    // availability of the choosen type of memory prior to actually using it.
    switch(DataLocation) {
      case Heap:  // no action necessary
        break;

      case Ems:
        if(!EmsInstalled) {
          SetError(MemoryManagement, 2, EMS_Not_Installed, " [VFILES]");
          return;
        } else
          if(GetEMSstatus()) {
            SetError(MemoryManagement, 3,
                    EMS_Status_Error, SInteger(GetEMSstatus(), 0),
                    " [(DetermineStorageType) VFILES]");
            return;
          } else
            if(GetAvailEmsPages() <= 0) {
              SetError(InsufficientMemory, 3, EMS_Empty_Cannot_Open,
                       WorkArea[Selected]->Alias, " [VFILES]");
              return;
            } else // no action necessary, its installed
              ;    // its OK, and there is some available
        break;

      case Ext:
        if(!ExtInstalled) {
          SetError(MemoryManagement, 2, EXT_Not_Installed, " [VFILES]");
          return;
        } else
          if((long) GetAvailExtKbytes() * 1024L <= (long) EXTPAGESIZE) {
            SetError(InsufficientMemory, 3, EXT_Empty_Cannot_Open,
                     WorkArea[Selected]->Alias, " [VFILES]");
            return;
          } else // no action necessary, its installed
            ;    // and there at least one page available
        break;
    }
}

//  The following block of routines are the Memory Management routines.
//          They are used internally by the Linked List routines.

void FreeStorage(DataPointerType *DataPtr, unsigned int FreeDataSize)
{
  switch (DataLocation) {
    case Heap:
      free(DataPtr->v.sHeap.DataPtr);
      break;

    case Ems:
      if(EmsFreeListCount < EMSFREELISTSIZE) {
        EmsFreeListCount++;
        if((EmsFreeListCount > MaxEmsFreeList) && !ClosingFile)
          MaxEmsFreeList = EmsFreeListCount;
        (*EmsFreeList)[EmsFreeListCount].DataSize = FreeDataSize;
        memcpy(&(*EmsFreeList)[EmsFreeListCount].FreeDataLoc, DataPtr, sizeof(DataPointerType));
      } else
        ; // no action necessary ??? - Free list is full !!!
      break;

    case Ext:
      if(ExtFreeListCount < EXTFREELISTSIZE) {
        WritePage(CurrentExtPage);
        ReadPage(ExtFreeListPage);
        ExtFreeListCount++;
        if((ExtFreeListCount > MaxExtFreeList) && !ClosingFile)
          MaxExtFreeList = ExtFreeListCount;
        (*ExtFreeList)[ExtFreeListCount].DataSize = FreeDataSize;
        memcpy(&(*EmsFreeList)[EmsFreeListCount].FreeDataLoc, DataPtr, sizeof(DataPointerType));
        ExtPageModified = TRUE;
        WritePage(ExtFreeListPage);
        ReadPage(CurrentExtPage);
      } else
        ; // no action necessary ??? - Free list is full !!!
      break;
  }
}

void GetStorage(DataPointerType *DataPtr, unsigned int DataSize)
{
  FreeListElement FreeListData;
  ExtHandleType   NewPagePtr;
  int             FreeListIndex, FreeListPage;
  int             ReusingSpace, FreeListByte;

  switch(DataLocation) {
    case Heap:
      if((DataPtr->v.sHeap.DataPtr = malloc(DataSize)) == NULL) {
        SetError(InsufficientMemory, 3, Heap_Append_Error,
                 WorkArea[Selected]->Alias, " [VFILES]");
        return;
      }
      break;

    case Ems:
      if(EmsFreeListSpaceAvailable(DataSize, &FreeListIndex)) {
        FreeListPage = EmsFreeList[FreeListIndex]->FreeDataLoc.v.sEms.EmsHandle;
        FreeListByte = EmsFreeList[FreeListIndex]->FreeDataLoc.v.sEms.EmsOffset;

        ClearEmsFreeListSpace(FreeListIndex);
        // First, see if the page currently in memory is the
        // desired page - the page from the Free List with the hole.
        if(CurrentEmsPage != (unsigned) FreeListPage) {
          CurrentEmsPage = FreeListPage;
          if(!MapEmsPage(CurrentEmsPage, 0, 0)) {
            SetError(MemoryManagement, 3,
                     EMS_Page_Re_Mapping_Error, SInteger(EmsError, 0),
                     " [VFILES]");
            return;
          }
        }
        // Initialize the storage record for this line
        DataPtr->v.sEms.EmsHandle = CurrentEmsPage;
        DataPtr->v.sEms.EmsOffset = FreeListByte;
      } else {
        // There are no free list entries for a record this
        // size, so create a new one on the working page
        // First, see if the page currently in memory is the
        // "working" page - the page we are working on filling up.
        if(CurrentEmsPage != WorkingEmsPage) {
          CurrentEmsPage = WorkingEmsPage;
          if(!MapEmsPage(CurrentEmsPage, 0, 0)) {
            SetError(MemoryManagement, 3,
                     EMS_Page_Mapping_Error, SInteger(EmsError, 0),
                     " [VFILES]");
            return;
          }
        }
        // Next, see if there is room on the "working" page for
        // the buffer we want to add.
        if(NextFreeEmsByte + DataSize - 1 > EMSPAGESIZE) {
          // If the next Buffer won't fit into the current page, get
          // a new one.  Since EMS is a "Window" to the actual storage,
          // we don't need to "store" the data in the current page.
          if(EmsPageCount >= EmsPagesAllowed) {
            SetError(InsufficientMemory, 3, EMS_Memory_Full,
                     WorkArea[Selected]->Alias, " [VFILES]");
            return;
          }

          CurrentEmsPage = GetEmsHandle(1);
          if(CurrentEmsPage == 0xFFFF) {
            SetError(MemoryManagement, 2, EMS_Page_Allocation_Error,
                     " [(GetStorage) VFILES]");
            return;
          }
          // Maintain the page array so we can deallocate
          // what we just allocated.
          (*EmsPageArray)[EmsPageCount++] = CurrentEmsPage;
          // Map the page window (0) to point to new page
          if(!MapEmsPage(CurrentEmsPage, 0, 0)) {
            SetError(MemoryManagement, 1, EMS_Page_Map_Failed);
            return;
          }
          WorkingEmsPage = CurrentEmsPage;
          NextFreeEmsByte = 0;
        }
        // Initialize the storage record for this line
        DataPtr->v.sEms.EmsHandle = CurrentEmsPage;
        DataPtr->v.sEms.EmsOffset = NextFreeEmsByte;
        // Update the next free index
        NextFreeEmsByte += DataSize;
      }
      break;

    case Ext:
      // First, see if the page currently in memory is the
      // "working" page - the page we are working on filling up.
      ReusingSpace = FALSE;

      if(CurrentExtPage != WorkingExtPage) {
        WritePage(CurrentExtPage);
        if(DBFError)
          return;

        ReadPage(WorkingExtPage);
        if(DBFError)
          return;

        CurrentExtPage = WorkingExtPage;
      }
      // Next, see if there is room on the "working" page for
      // the buffer we want to add.
      if(NextFreeExtByte + DataSize - 1 > EXTPAGESIZE) {
        // If the next Buffer won't fit into the current page,
        // then put the current page away, and get a new one.
        // First, though, check to see if there's any space
        // available from the free list.
        WritePage(CurrentExtPage);
        if(DBFError)
          return;

        if(ExtFreeListSpaceAvailable(DataSize, &FreeListData))
          ReusingSpace = TRUE;
        else {
          // Since there's nothing on the free list to
          // use, start with a whole new page.
          GetExtHandle(&NewPagePtr);

          if(ExtError) {
            SetError(InsufficientMemory, 3, EXT_Empty_Cannot_Append,
                     WorkArea[Selected]->Alias, " [VFILES]");
            return;
          }
          // Set values & read in the new page
          ExtPageCount++;
          WorkingExtPage = ExtPageCount;
          CurrentExtPage = ExtPageCount;
          (*ExtPageArray)[ExtPageCount] = NewPagePtr;
          ReadPage(ExtPageCount);
          NextFreeExtByte = 0;
        }
        if(DBFError)
          return;
      }

      if(ReusingSpace) {
        DataPtr->v.sExt.ExtIndex  = FreeListData.FreeDataLoc.v.sExt.ExtIndex;
        DataPtr->v.sExt.ExtOffset = FreeListData.FreeDataLoc.v.sExt.ExtOffset;
      } else {
        // Initialize the data pointer for this record
        DataPtr->v.sExt.ExtIndex  = CurrentExtPage;
        DataPtr->v.sExt.ExtOffset = NextFreeExtByte;
        // Update the next free index
        NextFreeExtByte += DataSize;
      }
      break;
  }
}

void MemoryManagementExitProc(void)
// When the program terminates, any EXT or EMS memory that was
// allocated must be specifically returned by this routine.
{
  int i;

  if(EmsInstalled) {
#ifndef WINDOWS
  #ifdef DEBUG
    printf("EMS Free List Entries = %d\n", MaxEmsFreeList);
  #endif
#endif // not Windows
    ReleaseEmsHandle(EmsFreeListHandle);
    if(EmsPageArray)
      for(i = 0; i < EmsPageCount; i++)
        ReleaseEmsHandle((*EmsPageArray)[i]);
  }
  if (ExtWasSetup) {
#ifndef WINDOWS
  #ifdef DEBUG
    printf("EXT Free List Entries = %d\n", MaxExtFreeList);
  #endif
#endif
    if(ExtPageArray)
      for(i = 0; i <= ExtPageCount; i++)
        ReleaseExtHandle(&(*ExtPageArray)[i]);
  }
  AlreadyExited = TRUE;
}

void MoveData(TypeOfMove Direction, void *UserRecPtr, DataPointerType *DataRecPtr, unsigned int DataSize)
{
  unsigned int PageOffset;
  unsigned int TargetPage;

  switch(DataLocation) {
    case Heap:
      if(Direction == FROMUSERTOMEMORY)
        memcpy(DataRecPtr->v.sHeap.DataPtr, UserRecPtr, DataSize);
      else
        memcpy(UserRecPtr, DataRecPtr->v.sHeap.DataPtr, DataSize);
      break;

    case Ems:
      TargetPage = DataRecPtr->v.sEms.EmsHandle;
      PageOffset = DataRecPtr->v.sEms.EmsOffset;

      if(CurrentEmsPage != TargetPage) {
        CurrentEmsPage = TargetPage;
        if(!MapEmsPage(TargetPage, 0, 0)) {
          SetError(MemoryManagement, 1, EMS_Paging_Error);
          return;
        }
      }

      if(Direction == FROMUSERTOMEMORY)
        memcpy(EmsPageBuffer + PageOffset, UserRecPtr, DataSize);
      else
        memcpy(UserRecPtr, EmsPageBuffer + PageOffset, DataSize);
      break;

    case Ext:
      TargetPage = DataRecPtr->v.sExt.ExtIndex;
      PageOffset = DataRecPtr->v.sExt.ExtOffset;

      if(CurrentExtPage != TargetPage) {
        WritePage(CurrentExtPage);
        if(DBFError)
          return;

        ReadPage(TargetPage);
        if(DBFError)
          return;

        CurrentExtPage = TargetPage;
      }

      if(Direction == FROMUSERTOMEMORY) {
        memcpy(&ExtPageBuffer[PageOffset], UserRecPtr, DataSize);
        ExtPageModified = TRUE;
      } else
        memcpy(UserRecPtr, &ExtPageBuffer[PageOffset], DataSize);
      break;
  }
}

void OpenStorage(void)
{
  long AvailablePages;

  DetermineStorageType();
  if(DBFError)
    return;

  switch(DataLocation) {
    case Heap: // no initialization necessary
      break;

    case Ems: // Redundant check. Should already
      if(!EmsInstalled) { // be caught by this point !!
        SetError(MemoryManagement, 2, EMS_Not_Installed, " [(OpenStorage) VFILES]");
        return;
      }
      // ...then EMS is not in use yet
      if(!EmsPageArray) {
        NextFreeEmsByte = EMSPAGESIZE;
        EmsPageCount    = 0;
        EmsPageBuffer   = EmsPagePointer;

        if(MAXEMSPAGES > GetAvailEmsPages())
          EmsPagesAllowed = GetAvailEmsPages();
        else
          EmsPagesAllowed = MAXEMSPAGES;

        EmsPageArray = (ArrayOfEmsPages *) malloc(EmsPagesAllowed * 2);

        if(!EmsPageArray) {
          SetError(InsufficientMemory, 1, EMS_Heap_Setup);
          return;
        }
      }
      break;

    case Ext: // Redundant check. Should already
      if(!ExtInstalled) { // be caught by this point !!
        SetError(MemoryManagement, 2, EXT_Not_Installed, " [(OpenStorage) VFILES]");
        return;
      }
      if(!ExtPageBuffer) { // ... then EXT is not in use yet
        NextFreeExtByte = EXTPAGESIZE;
        ExtPageCount = 0;
        AvailablePages = ((long) GetAvailExtKbytes() * 1024L) / (long) EXTPAGESIZE;
        if((long) MAXEXTPAGES > AvailablePages)
          ExtPagesAllowed = (int) AvailablePages;
        else
          ExtPagesAllowed = MAXEXTPAGES;
        ExtPageBuffer = (char            *) malloc(EXTPAGESIZE);
        ExtPageArray  = (ArrayOfExtPages *) malloc(ExtPagesAllowed * sizeof(ExtHandleType));
        ExtMoveInfo   = (ExtMoveParams   *) malloc(sizeof(ExtMoveParams));

        if(!ExtPageBuffer || !ExtPageArray || !ExtMoveInfo) {
          if(ExtPageBuffer)
            free(ExtPageBuffer);
          if(ExtPageArray)
            free(ExtPageArray);
          if(ExtMoveInfo)
            free(ExtMoveInfo);

          SetError(InsufficientMemory, 1, EXT_Heap_Setup);
          return;
        }
        memset(ExtPageArray, 0, ExtPagesAllowed * sizeof(ExtHandleType));
        SetupExtFreeList();
      }
      break;
  }
}

//  The following block of routines are for internal use only
//        by the Linkled List Management routines.
void AddNewHead(dbfRecord *Handle)
{
  NewRecPtr->NextRecPtr = HeadPtr;
  HeadPtr->LastRecPtr   = NewRecPtr;
  HeadPtr               = NewRecPtr;
  CurrentRecPtr         = NewRecPtr;
  Handle->CurRecNo      = 1L;
  Handle->NumRecs++;
}

void AddNewTail(dbfRecord *Handle)
{
  NewRecPtr->LastRecPtr = TailPtr;
  TailPtr->NextRecPtr   = NewRecPtr;
  TailPtr               = NewRecPtr;
  CurrentRecPtr         = NewRecPtr;
  Handle->CurRecNo      = Handle->NumRecs;
  Handle->NumRecs++;
}

void InsertNewRecord(dbfRecord *Handle)
{
  SaveNextPtr = CurrentRecPtr->NextRecPtr;
  NewRecPtr->LastRecPtr = CurrentRecPtr; // Set links in the
  NewRecPtr->NextRecPtr = SaveNextPtr;   // new record
  // if we are inserting after
  if(TailPtr == CurrentRecPtr)           // the Tail of the list...
    TailPtr = NewRecPtr;
  CurrentRecPtr->NextRecPtr = NewRecPtr; // Set "forward" link
  CurrentRecPtr = NewRecPtr;             // update Current pointer
  if(SaveNextPtr) // Set the "back" link
    SaveNextPtr->LastRecPtr = NewRecPtr;
  Handle->NumRecs++;
  Handle->CurRecNo++;
}

char *UsersKeyMaker(void)
{
  return (*WorkArea[Selected]->Handle.v.strue.KeyMaker)();
}

void LocateInsertLink(LStatusType SortMode, char *NewKey, dbfRecord *Handle)
{
  int CheckNode, CorrectRec, Found, High, Low;

  Low        = 1;
  High       = (int) Handle->NumRecs;
  CheckNode  = (High + Low) >> 1;
  CorrectRec = 1;
  Found      = FALSE;

  do {
    Handle->v.strue.TargetRecNo = (long) CheckNode;
    SeekItem(Handle);
    MoveData(FROMMEMORYTOUSER, UserRecPtr, (DataPointerType *) &(CurrentRecPtr->DataPtr), CurrentRecPtr->RecordSize);
    strcpy(ThisKey, UsersKeyMaker());

    if(((SortMode == ASCENDING)  && (strcmp(ThisKey, NewKey) > 0)) ||
       ((SortMode == DESCENDING) && (strcmp(ThisKey, NewKey) < 0)))
      High = CheckNode;
    else
      if(!strcmp(ThisKey, NewKey)) {
        Found = TRUE;
        CorrectRec = CheckNode;
      } else
        Low = CheckNode;

    if(High == Low + 1) {
      Found = TRUE;
      Handle->v.strue.TargetRecNo = (long) High;
      SeekItem(Handle);
      MoveData(FROMMEMORYTOUSER, UserRecPtr, (DataPointerType *) &(CurrentRecPtr->DataPtr), CurrentRecPtr->RecordSize);
      strcpy(ThisKey, UsersKeyMaker());

      if(((SortMode == ASCENDING)  && (strcmp(NewKey, ThisKey) >= 0)) ||
         ((SortMode == DESCENDING) && (strcmp(NewKey,ThisKey) <= 0)))
        CorrectRec = High;
      else
        CorrectRec = Low;
    } else
      CheckNode = Low + (High - Low) / 2;
  } while(!Found);

  if(Handle->CurRecNo != CorrectRec) {
    Handle->v.strue.TargetRecNo = (long) CorrectRec;
    SeekItem(Handle);
    // Don't need to do the MoveData here, because the calling
    // routine is just going to move the new record as soon as this
    // procedure returns.  Only the CurrentPtr needs to be correct.
  }
}

void AddLL(dbfRecord *Handle) // equivalent to an APPEND
{
  if(VariableLength)
    NewRecSize = *(unsigned int *) (Handle->CurRecord) + 2;
  else
    NewRecSize = Handle->RecLen;

  if((NewRecPtr = (LLItemPtr) malloc(sizeof(LLItem))) == NULL) {
    SetError(InsufficientMemory, 3, Pointer_Allocation_Error,
             WorkArea[Selected]->Alias, " [VFILES]");
    return;
  }

  NewRecPtr->LastRecPtr = NULL;
  NewRecPtr->NextRecPtr = NULL;
  NewRecPtr->DataPtr    = NULL;
  NewRecPtr->RecordSize = NewRecSize;

  GetStorage((DataPointerType *) &(NewRecPtr->DataPtr), NewRecSize);
  if(DBFError)
    return;
  MoveData(FROMUSERTOMEMORY, UserRecPtr, (DataPointerType *) &(NewRecPtr->DataPtr), NewRecPtr->RecordSize);
  if(DBFError)
    return;
  Handle->EOFile = FALSE;
  // Handle the first record separately.
  if(!Handle->NumRecs) { // This greatly simplifies the following
    HeadPtr = NewRecPtr; // code. It doesn't have to deal with
    TailPtr = NewRecPtr; // all the possible Head & Tail = NULL situations !!
    CurrentRecPtr    = NewRecPtr;
    Handle->NumRecs  = 1;
    Handle->CurRecNo = 1;
  } else
    if(Handle->v.strue.LStatus == LIFO) // Create a new Head of the list
      AddNewHead(Handle);
    else
      if(Handle->v.strue.LStatus == INSERTION) // Insert after the current record
        InsertNewRecord(Handle);
      else
        if(Handle->v.strue.LStatus == FIFO) // Create a new Tail of the list
          AddNewTail(Handle);
        else // Insert into a sorted list
          if((Handle->v.strue.LStatus == ASCENDING) || (Handle->v.strue.LStatus == DESCENDING)) {
            if(!WorkArea[Selected]->Handle.v.strue.KeyMaker) {
              SetError(InvalidLLOperation, 2, WorkArea[Selected]->Alias,
                       Sorted_Mode_Has_No_Keymaker);
              return;
            }
            strcpy(NewKey, UsersKeyMaker()); // Save New Record Key
            MoveData(FROMMEMORYTOUSER, UserRecPtr, (DataPointerType *) &(HeadPtr->DataPtr), HeadPtr->RecordSize);
            CurrentRecPtr = HeadPtr;
            Handle->CurRecNo = 1;
            strcpy(ThisKey, UsersKeyMaker());

            if(((Handle->v.strue.LStatus == ASCENDING)  && (strcmp(NewKey, ThisKey) <= 0)) ||
               ((Handle->v.strue.LStatus == DESCENDING) && (strcmp(NewKey, ThisKey) >= 0))) {
              // Insert before Head
              MoveData(FROMMEMORYTOUSER, UserRecPtr, (DataPointerType *) &(NewRecPtr->DataPtr), NewRecPtr->RecordSize);
              AddNewHead(Handle);
            } else
              if(HeadPtr == TailPtr) { // Insert after the ONLY record
                MoveData(FROMMEMORYTOUSER,UserRecPtr,(DataPointerType *) &(NewRecPtr->DataPtr),NewRecPtr->RecordSize);
                AddNewTail(Handle);
              } else {
                MoveData(FROMMEMORYTOUSER, UserRecPtr, (DataPointerType *) &(TailPtr->DataPtr), TailPtr->RecordSize);
                CurrentRecPtr = TailPtr;
                Handle->CurRecNo = Handle->NumRecs;

                strcpy(ThisKey, UsersKeyMaker());
                if(((Handle->v.strue.LStatus == ASCENDING)  && (strcmp(NewKey, ThisKey) >= 0)) ||
                   ((Handle->v.strue.LStatus == DESCENDING) && (strcmp(NewKey, ThisKey) <= 0))) {
                  // Insert after Tail
                  MoveData(FROMMEMORYTOUSER,UserRecPtr,(DataPointerType *) &(NewRecPtr->DataPtr),NewRecPtr->RecordSize);
                  AddNewTail(Handle);
                } else { // Search for the insertion point
                  LocateInsertLink(Handle->v.strue.LStatus, NewKey, Handle);
                  MoveData(FROMMEMORYTOUSER, UserRecPtr, (DataPointerType *) &(NewRecPtr->DataPtr), NewRecPtr->RecordSize);
                  InsertNewRecord(Handle);
                }
              }
          } else {
            SetError(InvalidLLOperation, 4,
                     SInteger(Handle->v.strue.LStatus, 0), Invalid_LStatus_Value,
                     WorkArea[Selected]->Alias, " [(AddLL) VFILES]");
          }
}

void SavePointers(dbfRecord *Handle)
{
  Handle->v.strue.LLHeadPtr  = HeadPtr;
  Handle->v.strue.LLTailPtr  = TailPtr;
  Handle->v.strue.CurrentPtr = CurrentRecPtr;
  Handle->v.strue.DataLoc    = DataLocation;
}

void SetupPointers(dbfRecord *Handle)
{
  HeadPtr        = Handle->v.strue.LLHeadPtr;
  TailPtr        = Handle->v.strue.LLTailPtr;
  CurrentRecPtr  = Handle->v.strue.CurrentPtr;
  UserRecPtr     = Handle->CurRecord;
  VariableLength = Handle->RecLen == 0;
  DataLocation   = Handle->v.strue.DataLoc;
}

int Smaller(int I, int J, long *Values)
{
  return (*(Values + I) < *(Values + J)) ? I : J;
}

int Smallest(long One, long Two, long Three)
{
  long Values[3];

  Values[0] = One;
  Values[1] = Two;
  Values[2] = Three;
  return Smaller(0, Smaller(1, 2, Values), Values);
}

int SearchFrom(dbfRecord *Handle)
// This function returns a value that indicates how the search
// to TargetRecNo should proceed from the current position.
{
  int res;

  if(Handle->NumRecs < 2000)
    return SearchTop;

  res = Smallest(Handle->v.strue.TargetRecNo,
  Handle->NumRecs - Handle->v.strue.TargetRecNo,
  labs(Handle->CurRecNo - Handle->v.strue.TargetRecNo));

  switch(res) {
    case 1:
      return SearchTop;

    case 2:
      return SearchBottom;

    case 3:
      if(Handle->v.strue.TargetRecNo > Handle->CurRecNo)
        return SearchForward;
      else
        return SearchBackward;
  }

  return SearchTop;
}

void SeekItem(dbfRecord *Handle)
// This procedure moves the CurrentRecPtr to TargetRecNo. The move is
// optimized according to the number of records in the list and the
// the current position.
{
  long i;

  if(Handle->v.strue.TargetRecNo == Handle->CurRecNo)
    return;

  switch(SearchFrom(Handle)) {

    case SearchTop:
      CurrentRecPtr = HeadPtr;
      for(i = 2; i <= Handle->v.strue.TargetRecNo; i++)
        CurrentRecPtr = CurrentRecPtr->NextRecPtr;
      break;

    case SearchBottom:
      CurrentRecPtr = TailPtr;
      for(i = 1; i <= Handle->NumRecs - Handle->v.strue.TargetRecNo; i++)
        CurrentRecPtr = CurrentRecPtr->LastRecPtr;
      break;

    case SearchForward:
      for(i = 1; i <= Handle->v.strue.TargetRecNo - Handle->CurRecNo; i++)
        CurrentRecPtr = CurrentRecPtr->NextRecPtr;
      break;

    case SearchBackward:
      for(i = 1; i <= Handle->CurRecNo - Handle->v.strue.TargetRecNo; i++)
        CurrentRecPtr = CurrentRecPtr->LastRecPtr;
      break;
  }

  Handle->CurRecNo = Handle->v.strue.TargetRecNo;
}

//  The following routine is the interface between VFILES and the DBF unit.
void ActionLL(dbfRecord *Handle)
{
  SetupPointers(Handle);
  switch(Handle->v.strue.Action) {
    case doCloseLL:  CloseLL(Handle);  break;
    case doDeleteLL: DeleteLL(Handle); break;
    case doGetLL:    GetLL(Handle);    break;
    case doOpenLL:   OpenLL(Handle);   break;
    case doPackLL:   PackLL(Handle);   break;
    case doPopLL:    PopLL(Handle);    break;
    case doPushLL:   PushLL(Handle);   break;
    case doPutLL:    PutLL(Handle);    break;
    case doRecallLL: RecallLL(Handle); break;
    case doSnipLL:   SnipLL(Handle);   break;
    case doZapLL:    ZapLL(Handle);    break;
  }
  SavePointers(Handle);
}

void CloseLL(dbfRecord *Handle) // called during CLOSE
{
  if(AlreadyExited)
    return;

  ClosingFile = TRUE;
  ZapLL(Handle);
  ClosingFile = FALSE;
  FreePtrClear((void*) &Handle->Fields);
}

#ifndef _MSC_VER
# pragma argsused
#endif
void DeleteLL(dbfRecord *Handle)
{
  unsigned char One = 1;
  DataPointerType *NewDataPtr;

  if(VariableLength) {
    // Figure out where the offset is to the stored data record. The
    // first data byte is 2 bytes past the beginning of the actual record
    // because the record starts with a length "word".
    switch(DataLocation) {
      case Heap:
        (char *) NewDataPtr = (char *) (CurrentRecPtr->DataPtr) + 2;
        break;

      case Ems:
        NewDataPtr = (DataPointerType *) CurrentRecPtr->DataPtr;
        NewDataPtr->v.sEms.EmsOffset += 2;
        break;

      case Ext:
        NewDataPtr = (DataPointerType *) CurrentRecPtr->DataPtr;
        NewDataPtr->v.sExt.ExtOffset += 2;
        break;
    }
    // Move the byte to the stored data record
    MoveData(FROMUSERTOMEMORY, &One, NewDataPtr, 1);
    if(DBFError)
      return;
    // Finally, set the corresponding byte in the user's data record
    *((char *) UserRecPtr + 2) = 1;
    return;
  } else {
    MoveData(FROMUSERTOMEMORY, &One, (DataPointerType *) &(CurrentRecPtr->DataPtr), 1);
    if(DBFError)
      return;
    *((char *) UserRecPtr) = 1;
  }
}

void GetLL(dbfRecord *Handle) // equivalent to a GO
{
  DBFError = 0;
  if((Handle->v.strue.TargetRecNo > 0L) && (Handle->v.strue.TargetRecNo <= Handle->NumRecs)) {
    SeekItem(Handle);
    MoveData(FROMMEMORYTOUSER, UserRecPtr, (DataPointerType *) &(CurrentRecPtr->DataPtr), CurrentRecPtr->RecordSize);
    if(DBFError)
      return;
  } else {
    SetError(OutOfRange, 6, Attempt_to_position_to_bad_record,
             SInteger(Handle->v.strue.TargetRecNo, 0), Database_Record_Count,
             SInteger(Handle->NumRecs, 0), WorkArea[Selected]->Alias, " [VFILES]");
  }
}

void OpenLL(dbfRecord *Handle) // called during a USE
{
  HeadPtr = NULL;
  TailPtr = NULL;
  CurrentRecPtr = NULL;

  Handle->CurRecNo = 0L;
  Handle->NumRecs  = 0L;
  Handle->BOFile   = TRUE;
  Handle->EOFile   = TRUE;

  DataLocation = Handle->v.strue.DataLoc;

  OpenStorage();

  if(!DBFError)
    Handle->v.strue.DataLoc = DataLocation;
}

void AddPackedNodesToExtFreeList(void)
// This code is essentially a duplicate of the code in the ZapThisExtStorage
// routine. The difference is that we are freeing from a different linked list.
{
  LLItemPtr TempPtr;

  // First, get the Free List page, and move all the record data to it
  WritePage(CurrentExtPage);
  ReadPage(ExtFreeListPage);

  TempPtr = ExtPackList;
  while((ExtFreeListCount < EXTFREELISTSIZE) && TempPtr) {
    ExtFreeListCount++;
    ExtFreeList[ExtFreeListCount]->DataSize = TempPtr->RecordSize;
    memcpy(&ExtFreeList[ExtFreeListCount]->FreeDataLoc, ((DataPointerType *) TempPtr)->v.sHeap.DataPtr, sizeof(DataPointerType));
    TempPtr = TempPtr->NextRecPtr;
  }

  if(ExtFreeListCount > MaxExtFreeList)
    MaxExtFreeList = ExtFreeListCount;
  ExtPageModified = TRUE;
  WritePage(ExtFreeListPage);
  ReadPage(CurrentExtPage);

  // Then, free up all the HEAP list nodes
  TempPtr = ExtPackList;
  while(TempPtr) {
    TempPtr = ExtPackList->NextRecPtr;
    free(ExtPackList);
    ExtPackList = TempPtr;
  }
}

void SaveExtNodeData(void)
{
  LLItemPtr TempPtr;

  TempPtr = ExtPackList;
  if(!TempPtr)
    ExtPackList = CurrentRecPtr;
  else {
    while(TempPtr->NextRecPtr)
      TempPtr = TempPtr->NextRecPtr;

    TempPtr->NextRecPtr = CurrentRecPtr;
  }
}

void SnipExtNodePointers(dbfRecord *Handle)
// This is essentially the same code as in the SnipLL procedure,
// without the FreeStorage and FreeMem calls.
{
  LLItemPtr SavePtr;

  SaveExtNodeData(); // Not part of SNIPLL !!
  SavePtr = CurrentRecPtr->NextRecPtr;

  // Attach the Last Link to the Next one
  if(!CurrentRecPtr->LastRecPtr) // we're at the Head of the list
    HeadPtr = SavePtr;
  else
    CurrentRecPtr->LastRecPtr->NextRecPtr = SavePtr;

  // Attach the Next link to the Last one
  if(!SavePtr) { // ... we are at the Tail
    SavePtr = CurrentRecPtr->LastRecPtr;
    TailPtr = SavePtr;
    // This is the only time the Current Record No changes
    Handle->CurRecNo = Handle->NumRecs - 1;
  } else
    CurrentRecPtr->NextRecPtr->LastRecPtr = CurrentRecPtr->LastRecPtr;
  // At this point, the CurrentRecPtr node has been linked into the
  // ExtPackList (by SaveExtNodeData routine), and Snipped out of the
  // database linked list.  The only thing left to do before updating
  // the CurrentRecPtr is to set the NextRecPtr to NULL in order to
  // indicate the end of the ExtPackList chain.
  CurrentRecPtr->NextRecPtr = NULL; // Not part of SNIPLL !!

  CurrentRecPtr = SavePtr;
  Handle->NumRecs--;

  if(!Handle->NumRecs)
    Handle->EOFile = TRUE;
}

void PackLL(dbfRecord *Handle)
{
  DataPointerType *NewDataPtr;
  int              PackedExt, RecordDeleted;

  CurrentRecPtr = HeadPtr;
  PackedExt     = FALSE;
  ExtPackList   = NULL;

  while(CurrentRecPtr) {
    if(VariableLength) {
      // Figure out where the offset is to the stored data record.  The
      // first data byte is 2 bytes past the beginning of the actual
      // record, because the record starts with a length "word".
      switch(DataLocation) {

        case Heap:
          (char *) NewDataPtr = (char *) CurrentRecPtr->DataPtr + 2;
          break;

        case Ems:
          NewDataPtr = (DataPointerType *) CurrentRecPtr->DataPtr;
          NewDataPtr->v.sEms.EmsOffset += 2;
          break;

        case Ext:
          NewDataPtr = (DataPointerType *) CurrentRecPtr->DataPtr;
          NewDataPtr->v.sExt.ExtOffset += 2;
          break;
      }
      MoveData(FROMMEMORYTOUSER, &RecordDeleted, (DataPointerType *) &NewDataPtr, 1);
    } else
      MoveData(FROMMEMORYTOUSER, &RecordDeleted, (DataPointerType *) &(CurrentRecPtr->DataPtr), 1);

    if(DBFError)
      return;

    if(RecordDeleted)
      if(DataLocation == Ext) {
        PackedExt = TRUE;
        SnipExtNodePointers(Handle);
      } else
        SnipLL(Handle);
      else
        CurrentRecPtr = CurrentRecPtr->NextRecPtr;
  }

  Handle->CurRecNo = !HeadPtr ? 0 : 1;

  CurrentRecPtr = HeadPtr;

  if(PackedExt)
    AddPackedNodesToExtFreeList();
}

void PopLL(dbfRecord *Handle)
{
  if(!Handle->NumRecs) {
    SetError(InvalidLLOperation, 3, Cannot_POP_At_End_Of_File,
             WorkArea[Selected]->Alias, " [(PopRec) VFILES]");
    return;
  }

  if(Handle->v.strue.LStatus == INSERTION) {
    SetError(InvalidLLOperation, 3, Cannot_POP_A_Record_In_INSERTION,
             WorkArea[Selected]->Alias, " [(PopRec) VFILES]");
    return;
  }
  // When the Record was originally "Pushed", it was added to the correct
  // end of the list, based on the mode at the time (LIFO or FIFO).  That
  // means that when we Pop the record, we always pop it off the top.
  Handle->v.strue.TargetRecNo = 1;
  SeekItem(Handle);
  MoveData(FROMMEMORYTOUSER,UserRecPtr,(DataPointerType *) &(CurrentRecPtr->DataPtr),CurrentRecPtr->RecordSize);
  if(DBFError)
    return;

  SnipLL(Handle);

  if(!Handle->NumRecs) {
    Handle->BOFile = TRUE;
    Handle->EOFile = TRUE;
  }
}

void PutLL(dbfRecord *Handle) // equivalent to a REPLACE
{
  LStatusType OldMode;

  if(Handle->v.strue.TargetRecNo > Handle->NumRecs) {
    AddLL(Handle); // Caution: this may abort, InsufficientMemory
    if(DBFError)
      return;
    // Handle->CurRecNo = Handle->TargetRecNo;   This is handled  by
    // AddLL, because it may be a LIFO or a FIFO list !!
  } else {
    SeekItem(Handle);
    OldMode = Handle->v.strue.LStatus;
    if((OldMode == ASCENDING) || (OldMode == DESCENDING)) {
      // If the list is Sorted, then
      SnipLL(Handle); // Snip out the old version of the
      AddLL(Handle);  // record, and Add back the new.
    } else
      if(VariableLength && ((*(unsigned int *) UserRecPtr) + 2 != CurrentRecPtr->RecordSize)) {
        Handle->v.strue.LStatus = INSERTION;
        AddLL(Handle);
        if(DBFError)
          return;
        CurrentRecPtr = CurrentRecPtr->LastRecPtr;
        SnipLL(Handle);
        Handle->v.strue.LStatus = OldMode;
      } else
        MoveData(FROMUSERTOMEMORY, UserRecPtr, (DataPointerType *) &(CurrentRecPtr->DataPtr), CurrentRecPtr->RecordSize);
  }
}

void PushLL(dbfRecord *Handle)
{
  AddLL(Handle); // Caution: this may abort, InsufficientMemory
  Handle->EOFile = FALSE;
}

#ifndef _MSC_VER
 #pragma argsused
#endif
void RecallLL(dbfRecord *Handle)
{
  unsigned char Zero  = 0;
  DataPointerType *NewDataPtr;

  if(VariableLength) {
    // Figure out where the offset is to the stored data record.  The
    // first data byte is 2 bytes past the beginning of the actual record
    // because the record starts with a length "word".
    switch (DataLocation) {
      case Heap:
        (char *) NewDataPtr = (char *) CurrentRecPtr->DataPtr + 2;
        break;

      case Ems:
        NewDataPtr = (DataPointerType *) CurrentRecPtr->DataPtr;
        NewDataPtr->v.sEms.EmsOffset += 2;
        break;

      case Ext:
        NewDataPtr = (DataPointerType *) CurrentRecPtr->DataPtr;
        NewDataPtr->v.sExt.ExtOffset += 2;
        break;
    }
    // Move the byte to the stored data record
    MoveData(FROMUSERTOMEMORY, &Zero, (DataPointerType *) &NewDataPtr, 1);
    if(DBFError)
      return;
    // Finally, set the corresponding byte in the user's data record
    *((char *) UserRecPtr + 2) = 0;
  } else {
    MoveData(FROMUSERTOMEMORY, &Zero, (DataPointerType *) &(CurrentRecPtr->DataPtr), 1);
    if(DBFError)
      return;
    *((char *) UserRecPtr) = 0;
  }
}

void SnipLL(dbfRecord *Handle)
// This routine deletes the Current Record from the linked list.
// >>> NOTE <<<
// This code is essentially duplicated in the PackLL routine. If you decide
// to make any changes here, be sure to check that routine's procedure called
// SnipNodePointers to see if your changes should happen there too !!........
// >>> NOTE <<<
{
  LLItemPtr SavePtr;

  if(!Handle->NumRecs || !CurrentRecPtr)
    return;

  SavePtr = CurrentRecPtr->NextRecPtr;

  // Attach the Last link to the Next one
  if(!CurrentRecPtr->LastRecPtr) // ... we are at the Head of the list
    HeadPtr = SavePtr;
  else
    CurrentRecPtr->LastRecPtr->NextRecPtr = SavePtr;

  // Attach the Next link to the Last one
  if(!SavePtr) { // ... we are at the Tail of the list
    SavePtr = CurrentRecPtr->LastRecPtr;
    TailPtr = SavePtr;
    Handle->CurRecNo = Handle->NumRecs - 1; // This is the only time the
  } else // Current Record No changes
    CurrentRecPtr->NextRecPtr->LastRecPtr = CurrentRecPtr->LastRecPtr;

  FreeStorage((DataPointerType *) &CurrentRecPtr->DataPtr, CurrentRecPtr->RecordSize);
  free(CurrentRecPtr);

  CurrentRecPtr = SavePtr;
  Handle->NumRecs--;

  if(!Handle->NumRecs) {
    Handle->EOFile = TRUE;
    Handle->BOFile = TRUE;
  }
}

void ZapAllEmsStorage(void)
{
  int i;

  // First, return all EMS page handles and clear the free list entries.
  for(i = 0; i < EmsPageCount; i++) {
    ReleaseEmsHandle((*EmsPageArray)[i]);
    (*EmsPageArray)[i] = 0;
  }

  EmsPageCount    = 0;
  CurrentEmsPage  = 0;
  WorkingEmsPage  = 0;
  NextFreeEmsByte = EMSPAGESIZE;
  ClearEmsFreeList();
  // Then, free up all the HEAP list nodes
  TailPtr = HeadPtr;
  while(TailPtr) {
    TailPtr = HeadPtr->NextRecPtr;
    free(HeadPtr);
    HeadPtr = TailPtr;
  }
}

void ZapAllExtStorage(void)
{
  int i;

  // First, return all the EXT page handles and clear the Free List entries
  for(i = 1; i <= ExtPageCount; i++) {
    ReleaseExtHandle(&(*ExtPageArray)[i]);
    (*ExtPageArray)[i].HandleLoc = NOTASSIGNED;
    (*ExtPageArray)[i].Handle    = 0;
  }

  ExtPageCount    = 0;
  CurrentExtPage  = 0;
  WorkingExtPage  = 0;
  NextFreeExtByte = EXTPAGESIZE;
  ClearExtFreeList();
  // Then, free up all the HEAP list nodes
  TailPtr = HeadPtr;
  while(TailPtr) {
    TailPtr = HeadPtr->NextRecPtr;
    free(HeadPtr);
    HeadPtr = TailPtr;
  }
}

void ZapThisExtStorage(void)
// >>> NOTE <<<
// This code is essentially duplicated in the PackLL routine. If you decide
// to make any changes here, be sure to check that routine's procedure called
// AddPackedNodesToExtFreeList to see if your changes should happen there
// too !!...........
// >>> NOTE <<<
{
  // First, get the Free List page, and move all the record data to it
  WritePage(CurrentExtPage);
  ReadPage(ExtFreeListPage);

  TailPtr = HeadPtr;
  while((ExtFreeListCount < EXTFREELISTSIZE) && TailPtr) {
    ExtFreeListCount++;
    ExtFreeList[ExtFreeListCount]->DataSize = TailPtr->RecordSize;
    memcpy(&ExtFreeList[ExtFreeListCount]->FreeDataLoc, ((DataPointerType *) TailPtr)->v.sHeap.DataPtr, sizeof(DataPointerType));
    TailPtr = TailPtr->NextRecPtr;
  }

  if(!ClosingFile && (ExtFreeListCount > MaxExtFreeList))
    MaxExtFreeList = ExtFreeListCount;

  ExtPageModified = TRUE;
  WritePage(ExtFreeListPage);
  ReadPage(CurrentExtPage);

  // Then, free up all the HEAP list nodes
  TailPtr = HeadPtr;
  while(TailPtr) {
    TailPtr = HeadPtr->NextRecPtr;
    free(HeadPtr);
    HeadPtr = TailPtr;
  }
}

void ZapLL(dbfRecord *Handle)
{
  int AreaNo;
  int OtherEmsInUse;
  int OtherExtInUse;

  // First, check to see if there are any other linked lists open, and if so,
  // what kind of memory they are using.  We do this for 2 reasons.  There are
  // a limited number of EMS page handles available, and we want to give them
  // all back (free everything up) if possible.  Also, if possible, we want
  // to reduce the amount of FreeList overhead time.  This is especially
  // important when using EXT memory, because freeing up 1 node of storage
  // involves 2 complete page swaps - Write the current page if necessary, Read
  // in the Free List page, Record the free'd node's information, Write out
  // the Free List page, and re-read the current page.  If we are zapping the
  // whole data structure, the ZapThisExtStorage routine does it all in 1
  // operation.

  OtherEmsInUse = FALSE;
  OtherExtInUse = FALSE;

  for(AreaNo = 0; AreaNo < MaxWorkAreas; AreaNo++)
    if(WorkArea[AreaNo])
      if(WorkArea[AreaNo]->Handle.v.strue.LinkedList && (AreaNo != Selected))
        if((WorkArea[AreaNo]->Handle.v.strue.DataLoc == Ems) &&
          (WorkArea[AreaNo]->Handle.NumRecs > 0L))
          OtherEmsInUse = TRUE;
        else
          if((WorkArea[AreaNo]->Handle.v.strue.DataLoc == Ext) &&
            (WorkArea[AreaNo]->Handle.NumRecs > 0L))
            OtherExtInUse = TRUE;

  if((Handle->v.strue.DataLoc == Ems) && !OtherEmsInUse)
    ZapAllEmsStorage();
  else
    if(Handle->v.strue.DataLoc == Ext)
      if(OtherExtInUse)
        ZapThisExtStorage();
      else
        ZapAllExtStorage();
      else {
        // .. else, we are either zapping from the HEAP, so the Heap Manager
        // is keeping track of the free storage, or we are zapping from
        // EMS and there is another EMS list open & in use, so we can't
        // return all EMS.  In either case, maintenance of the free list
        // is painless in terms of overhead time, so we do 'em 1 at a time.
        TailPtr = HeadPtr;
        while(TailPtr) {
          TailPtr = HeadPtr->NextRecPtr;
          FreeStorage((DataPointerType *) &HeadPtr->DataPtr, HeadPtr->RecordSize);
          free(HeadPtr);
          HeadPtr = TailPtr;
        }
      }

  Handle->CurRecNo = 0;
  Handle->NumRecs  = 0;
  Handle->BOFile   = 0;
  Handle->EOFile   = 0;
  CurrentRecPtr    = NULL;
}
