/* filename: FREESPAC.C

: T O P A Z for C :Ŀ
                          Version 4.5  05/16/93                              
                                                                             
 Copyright (c) 1988,1994 Software Science Inc. All Rights Reserved Worldwide.
 Unauthorized distribution or disclosure of this source code or modification 
  or removal of this notice  constitutes a breach of the license agreement.  

*/
#ifdef WINDOWS
#include <windows.h>
#endif
#include <vfiles.h>

extern unsigned int NextFreeEmsByte;
extern unsigned int NextFreeExtByte;

long FreeSpace(void)
// This function returns the amount of storage available for the type of
// memory in the current working area, if it's a Linked List. If the current
// working area is not a Linked List, then the available disk storage space
// is returned.
{
  if(!WorkArea[Selected])
    return 0L;
  else {
    if(WorkArea[Selected]->Handle.v.strue.LinkedList) {
      switch(WorkArea[Selected]->Handle.v.strue.DataLoc) {
        case Heap:
#ifdef WINDOWS
          return (long) GetFreeSpace(0);
#else
          return (long) coreleft();
#endif
        case Ems:
          if(EmsInstalled)
            return (long) GetAvailEmsPages() *
                   ((long) EMSPAGESIZE * 2 - (long) NextFreeEmsByte + 1L);
          else
            return 0L;

        case Ext:
          if(ExtInstalled)
            return (long) GetAvailExtKbytes() * 1024L +
                   (long) (EXTPAGESIZE - NextFreeExtByte + 1);
          else
            return 0L;
      }
    } else
      return _wm_getdiskfreespace(0);

    return 0L;
  }
}
