/* filename: EXTMEM.C

: T O P A Z for C :Ŀ
                          Version 4.5  05/16/93                              
                                                                             
 Copyright (c) 1988,1994 Software Science Inc. All Rights Reserved Worldwide.
 Unauthorized distribution or disclosure of this source code or modification 
  or removal of this notice  constitutes a breach of the license agreement.  

*/
#include <sayget.h>
#include <vfiles.h>

extern unsigned char      EmsError;
extern EmsFreeListBuffer *EmsFreeList;
extern int                EmsFreeListCount;
extern unsigned int       EmsFreeListHandle;
extern void              *EmsPagePointer;

extern unsigned int       CurrentExtPage;
extern void              *ExtDriver;
extern unsigned char      ExtError;
extern ExtFreeListBuffer *ExtFreeList;
extern int                ExtFreeListCount;
extern unsigned int       ExtFreeListPage;
extern ExtMoveParams     *ExtMoveInfo;
extern ArrayOfExtPages   *ExtPageArray;
extern char              *ExtPageBuffer;
extern int                ExtPageModified;
extern int                ExtWasSetup;

// The following block of routines are the EXT interface routines.

// First, the low level Ext routines

// This routine calls an ASM routine that does the following:
//
// Save the contents of the System's DS register
// Move the following register values from REGS to the System registers:
//            AH, BX, DX, DS, SI
// Do a far call to the address contained in the ExtDriver pointer
// Move the following register values from the System registers to REGS:
//            AX, BH, BL, BX, DX
// Restore the contents of the System's DS register
void CallExtDriver(struct REGPACK far *Regs)
{
#ifdef _MSC_VER
  CallXmsDriver(Regs, ExtDriver, 1);
#else
  CallXmsDriver(Regs, ExtDriver, 0);
#endif
}

int ExtPresent(void)
{
  struct REGPACK Regs;

  if(_osmajor < 3)
    return FALSE;
  else {
    memset(&Regs, 0, sizeof(Regs)); // for Windows compatibility
    Regs.r_ax = 0x4300;
    intr(0x2F, &Regs);
    if((Regs.r_ax & 0xff) == 0x80) {
      memset(&Regs, 0, sizeof(Regs)); // for Windows compatibility
      Regs.r_ax = 0x4310;
      intr(0x2F, &Regs);
      ExtDriver = MK_FP(Regs.r_es, Regs.r_bx);
      return TRUE;
    } else {
      ExtDriver = NULL;
      return FALSE;
    }
  }
}

unsigned int GetAvailExtKbytes(void)
{
  struct REGPACK Regs;

  memset(&Regs, 0, sizeof(Regs)); // for Windows compatibility
  Regs.r_ax = 0x0800;
  CallExtDriver(&Regs);
  if(!Regs.r_ax) {
    ExtError = LO(Regs.r_bx);
    return 0;
  } else {
    ExtError = 0;
    return Regs.r_dx;
  }
}

void GetExtHandle(ExtHandleType *ExtHandle)
{
  struct REGPACK Regs;
  // Of the 2 kinds of Extended memory we intend to use, attempt to use the
  // lower 384K first. It's between 640K and 1 MEG, & is called "upper" memory.
  // If that's all gone, then try to use true "extended" memory.  It's above
  // 1088K.  There's 64K (between 1 meg and 1088K, called "high" memory) that
  // we are completly ignoring... as it's likely to be used by others often. */
  ExtError = 0;
  memset(&Regs, 0, sizeof(Regs)); // for Windows compatibility
  Regs.r_ax = 0x0900;
  Regs.r_dx = KBPEREXTPAGE;
  CallExtDriver(&Regs);
  if(Regs.r_ax == 0x01) {
    ExtHandle->Handle    = Regs.r_dx;
    ExtHandle->HandleLoc = EXTENDED;
  } else {
    ExtError = LO(Regs.r_bx);
    ExtHandle->Handle = 0;
  }
}

int MoveExtData(void)
{
  struct REGPACK Regs;

  memset(&Regs, 0, sizeof(Regs));   // for Windows compatibility
  ExtError  = 0;
  Regs.r_ax = 0x0B00;
  Regs.r_ds = FP_SEG(ExtMoveInfo);  // Address of the block of info
  Regs.r_si = FP_OFF(ExtMoveInfo);  // describing what to move where
  CallExtDriver(&Regs);
  if(Regs.r_ax == 0x01)
    return TRUE;
  else {
    ExtError = LO(Regs.r_bx);
    return FALSE;
  }
}

void ReleaseExtHandle(ExtHandleType *ExtHandle)
{
  struct REGPACK Regs;

  memset(&Regs, 0, sizeof(Regs));   // for Windows compatibility
  ExtError = 0;
  if(ExtHandle->HandleLoc == UPPER) // First, set the AH register
    Regs.r_ax = 0x1100;             // depending on what kind of memory
  else                              // we are returning.
    if(ExtHandle->HandleLoc == EXTENDED)
      Regs.r_ax = 0x0A00;
    else {
      if(ExtHandle->HandleLoc != NOTASSIGNED)
        ExtError = 99; // Unknown Handle Loc value ???
      return;
    }
  Regs.r_dx = ExtHandle->Handle; // Then, return the memory.
  CallExtDriver(&Regs);
  if(Regs.r_ax != 0x01)
    ExtError = LO(Regs.r_bx);
}

// The fundamental Read & Write Ext routines

void ReadPage(unsigned int PageNumber)
// Read the indicated Extended Memory page number from memory into the buffer
{
  if((*ExtPageArray)[PageNumber].HandleLoc == NOTASSIGNED)
    SetError(MemoryManagement, 4, EXT_Reading_Non_Allocated_Page, " (", WorkArea[Selected]->Alias, ") [VFILES]");
  else {
    ExtMoveInfo->LengthOfBlock = EXTPAGESIZE;
    ExtMoveInfo->SourceHandle  = (*ExtPageArray)[PageNumber].Handle;
    ExtMoveInfo->SourceOffset  = NULL;
    ExtMoveInfo->DestHandle    = 0;
    ExtMoveInfo->DestOffset    = ExtPageBuffer;
    if(MoveExtData())
      ExtPageModified = FALSE;
    else {
      SetError(MemoryManagement, 3, EXT_Reading_Error, SInteger(ExtError, 0), " [VFILES]");
    }
  }
}

void WritePage(unsigned int PageNumber)
// Write the indicated Extended Memory page number from the buffer to memory
{
  if(ExtPageModified)
    if((*ExtPageArray)[PageNumber].HandleLoc == NOTASSIGNED)
      SetError(MemoryManagement, 2, EXT_Writing_Non_Allocated_Page, " [VFILES]");
    else {
      ExtMoveInfo->LengthOfBlock = EXTPAGESIZE;
      ExtMoveInfo->SourceHandle  = 0;
      ExtMoveInfo->SourceOffset  = ExtPageBuffer;
      ExtMoveInfo->DestHandle    = (*ExtPageArray)[PageNumber].Handle;
      ExtMoveInfo->DestOffset    = NULL;
      if(MoveExtData())
        ExtPageModified = FALSE;
      else {
        SetError(MemoryManagement, 3, EXT_Writing_Error, SInteger(ExtError, 0), " [VFILES]");
      }
    }
}

// The "Higher" level Ext routines

void ClearExtFreeList(void)
{
  ReadPage(ExtFreeListPage);
  memset(ExtFreeList, 0, (size_t) EXTPAGESIZE);
  ExtFreeListCount = 0;
  ExtPageModified  = TRUE;
  WritePage(ExtFreeListPage);
}

void ClearExtFreeListSpace(int FreeListIndex)
{
  if(ExtFreeListCount > FreeListIndex) {
    // should only be equal when there's only one free list element left
    (*ExtFreeList)[FreeListIndex].DataSize    = (*ExtFreeList)[ExtFreeListCount].DataSize;
    (*ExtFreeList)[FreeListIndex].FreeDataLoc = (*ExtFreeList)[ExtFreeListCount].FreeDataLoc;
    ExtPageModified = TRUE;
  }
  ExtFreeListCount--;
}

int ExtFreeListSpaceAvailable(int NeededSize, FreeListElement *FreeListData)
// This function searches the EXT free list for an entry that's the right
// size (same as NeededSize).  If one is found, the function returns true,
// and the Page with the free space is read into memory, otherwise, the
// function returns false, and the CurrentExtPage is restored.
{
  int FreeListIndex;

  if(!ExtFreeListCount)
    return FALSE;

  WritePage(CurrentExtPage); // Put away the current page, and
  if(DBFError)               // read in the free list page.
    return FALSE;
  ReadPage(ExtFreeListPage); // This is element 0 of the
  if(DBFError)               // ExtPageArray
    return FALSE;

  FreeListIndex = 0;

  // search for an entry the right size
  while((FreeListIndex < ExtFreeListCount) ||
    ((*ExtFreeList)[FreeListIndex].DataSize != (unsigned int) NeededSize))
    FreeListIndex++;

  if(FreeListIndex <= ExtFreeListCount) {
    // If we found one, update the free list & pass the found data back
    *FreeListData = (*ExtFreeList)[FreeListIndex];
    ClearExtFreeListSpace(FreeListIndex);
    WritePage(ExtFreeListPage);
    if(DBFError)
      return FALSE;
    CurrentExtPage = FreeListData->FreeDataLoc.v.sExt.ExtIndex;
    ReadPage(CurrentExtPage);  // Read in the page
    return TRUE;               // with the free area
  } else {
    ReadPage(CurrentExtPage);  // Re-read the current data
    return FALSE;              // page (not sure why ???)
  }
}

void SetupExtFreeList(void)
{
  // Setup the EXT free list by allocating 1 EXT page to hold the data.
  if(!ExtInstalled)
    SetError(MemoryManagement, 2, EXT_Not_Installed, " [(SetupExtFreeList) VFILES]");
  else {
    GetExtHandle(&(*ExtPageArray)[ExtFreeListPage]);
    if(ExtError)
      SetError(InsufficientMemory, 2, EXT_Free_List_Error, " [USE(<VFile>)]");
    else {
      // Set values & read in the new page
      ExtFreeList = (ExtFreeListBuffer *) ExtPageBuffer;
      ClearExtFreeList();
      ExtWasSetup = TRUE;
    }
  }
}

// The following block of routines are the EMS interface routines.

void ClearEmsFreeList(void)
{
  if(!EmsInstalled)
    SetError(MemoryManagement, 2, EMS_Not_Installed, " [(ClearEmsFreeList) VFILES]");
  else {
    memset(EmsFreeList, 0, sizeof(EmsFreeListBuffer));
    EmsFreeListCount = 0;
  }
}

void ClearEmsFreeListSpace(int FreeListIndex)
{
  if(!EmsInstalled)
    SetError(MemoryManagement, 2, EMS_Not_Installed, " [(ClearEmsFreeListSpace) VFILES]");
  else {
    if(EmsFreeListCount > FreeListIndex) {
      // should only happen when there's only one free list element left
      (*EmsFreeList)[FreeListIndex].DataSize    = (*EmsFreeList)[EmsFreeListCount].DataSize;
      (*EmsFreeList)[FreeListIndex].FreeDataLoc = (*EmsFreeList)[EmsFreeListCount].FreeDataLoc;
    }
    EmsFreeListCount--;
  }
}

int EmsFreeListSpaceAvailable(int NeededSize, int *FreeListIndex)
{
  if(!EmsInstalled) {
    SetError(MemoryManagement, 2, EMS_Not_Installed, " [(EmsFreeListSpaceAvailable) VFILES]");
    return FALSE;
  } else {
    *FreeListIndex = 0;
    if(!EmsFreeListCount)
      return FALSE;

    while((*FreeListIndex < EmsFreeListCount) ||
          ((*EmsFreeList)[*FreeListIndex].DataSize != (unsigned int) NeededSize))
      (*FreeListIndex)++;

    return *FreeListIndex <= EmsFreeListCount;
  }
}

unsigned char GetEMSstatus(void)
{
  struct REGPACK Regs;

  memset(&Regs, 0, sizeof(Regs)); // for Windows compatibility
  Regs.r_ax = 0x4000;
  intr(0x67, &Regs);
  return EmsError = HI(Regs.r_ax);
}

void far *GetEmsPagePointer(unsigned char Page)
{
  char *temp;

  if(!EmsInstalled) {
    SetError(MemoryManagement, 2, EMS_Not_Installed, " [(GetEmsPagePointer) VFILES]");
    return NULL;
  } else {
    temp = (char *) EmsPagePointer;
    temp += Page * 16384;
    return temp;
  }
}

unsigned int GetAvailEmsPages(void)
{
  struct REGPACK Regs;

  if(!EmsInstalled) {
    SetError(MemoryManagement, 2, EMS_Not_Installed, " [(GetAvailEmsPages) VFILES]");
    return 0xFFFF;
  } else {
    memset(&Regs, 0, sizeof(Regs)); // for Windows compatibility
    Regs.r_ax = 0x4200;
    intr(0x67, &Regs);
    EmsError = HI(Regs.r_ax);
    return !EmsError ? Regs.r_bx : 0xFFFF;
  }
}

unsigned int GetEmsHandle(unsigned int PagesDesired)
{
  struct REGPACK Regs;

  if(!EmsInstalled) {
    SetError(MemoryManagement, 2, EMS_Not_Installed, " [(GetEmsHandle) VFILES]");
    return 0xFFFF;
  } else {
    memset(&Regs, 0, sizeof(Regs)); // for Windows compatibility
    Regs.r_ax = 0x4300;
    Regs.r_bx = PagesDesired;
    intr(0x67, &Regs);
    EmsError = HI(Regs.r_ax);
    return !EmsError ? Regs.r_dx : 0xFFFF;
  }
}

int MapEmsPage(unsigned int Handle, unsigned int LogicalPage, unsigned int PhysicalPage)
{
  struct REGPACK Regs;

  if(!EmsInstalled) {
    SetError(MemoryManagement, 2, EMS_Not_Installed, " [(MapEmsPage) VFILES]");
    return FALSE;
  } else {
    memset(&Regs, 0, sizeof(Regs)); // for Windows compatibility
    Regs.r_ax = 0x4400 | PhysicalPage;
    Regs.r_bx = LogicalPage;
    Regs.r_dx = Handle;
    intr(0x67, &Regs);
    return (EmsError = HI(Regs.r_ax)) == 0;
  }
}

int ReleaseEmsHandle(unsigned int Handle)
{
  struct REGPACK Regs;

  if (!EmsInstalled) {
    SetError(MemoryManagement, 2, EMS_Not_Installed, " [(ReleaseEmsHandle) VFILES]");
    return FALSE;
  } else {
    memset(&Regs, 0, sizeof(Regs)); // for Windows compatibility
    Regs.r_ax = 0x4500;
    Regs.r_dx = Handle;
    intr(0x67, &Regs);
    return (EmsError = HI(Regs.r_ax)) == 0;
  }
}

int EmsPresent(void) // must be called before any other routines
{
  int   Detected;
  FILE *EmsDevice;
  struct REGPACK Regs;

  Detected = FALSE;

  if((EmsDevice = fopen("EMMXXXX0", "r")) != NULL) {
    Detected = TRUE;
    fclose(EmsDevice);
  }

  if(Detected) { // get the page frame pointer
    memset(&Regs, 0, sizeof(Regs)); // for Windows compatibility
    Regs.r_ax = 0x4100;
    intr(0x67, &Regs);
    EmsError = HI(Regs.r_ax);
    EmsPagePointer = !EmsError ? MK_FP(Regs.r_bx, 0x0000) : NULL;
  }
  return Detected;
}

void SetupEmsFreeList(void)
{
  // Setup the EMS free list by allocating 3 EMS pages and mapping them into
  // physical pages #1, #2 and #3 so they can be accessed as one structure.
  if(!EmsInstalled) {
    SetError(MemoryManagement, 2, EMS_Not_Installed, " [(SetupEmsFreeList) VFILES]");
    return;
  }

  EmsFreeListHandle = GetEmsHandle(3);
  if(EmsFreeListHandle == 0xFFFF) {
    SetError(MemoryManagement, 2, EMS_Page_Allocation_Error, " [(SetupEmsFreeList) VFILES]");
    return;
  }

  if(!MapEmsPage(EmsFreeListHandle, 0, 1)) {
    SetError(MemoryManagement, 2, EMS_Page_Mapping_Error, " [(SetupEmsFreeList-0) VFILES]");
    return;
  }

  if(!MapEmsPage(EmsFreeListHandle, 1, 2)) {
    SetError(MemoryManagement, 2, EMS_Page_Mapping_Error, " [(SetupEmsFreeList-1) VFILES]");
    return;
  }

  if(!MapEmsPage(EmsFreeListHandle, 2, 3)) {
    SetError(MemoryManagement, 2, EMS_Page_Mapping_Error, " [(SetupEmsFreeList-1) VFILES]");
    return;
  }

  EmsFreeList = GetEmsPagePointer(1);
  ClearEmsFreeList();
}
