/* filename: COPYSTRU.C

: T O P A Z for C :Ŀ
                          Version 4.5  05/16/93                              
                                                                             
 Copyright (c) 1988,1994 Software Science Inc. All Rights Reserved Worldwide.
 Unauthorized distribution or disclosure of this source code or modification 
  or removal of this notice  constitutes a breach of the license agreement.  

*/
#include <sayget.h>
#include <vfiles.h>

static char funcname[] = " [CopyStruFrom]";

void CopyStruFrom(unsigned char WhichArea)
{
  WorkAreaType *was, *waf;
  dbfRecord    *rs, *rf;
  FieldRecord *f;
  char err[30];
  int i;

  if(NotInUseError(funcname)) // check current area
    return;
  sprintf(err, " [CopyStruFrom (%d)]", WhichArea);
  if(!WorkArea[--WhichArea]) { // check the other workarea
    SetError(InvalidLLOperation, 2, From_Area_Not_In_Use, err);
    return;
  }
  was = WorkArea[Selected];
  rs = &was->Handle;
  waf = WorkArea[WhichArea];
  rf = &waf->Handle;

  if(rs->v.strue.LinkedList) {
    // Ensure that the area we are copying from has a structure in it!
    if(!rf->Fields) {
      SetError(InvalidLLOperation, 3, No_Structure_In_Work_Area, waf->Alias,
               err);
      return;
    } // If there's already a structure defined, freemem it
    if(rs->Fields) {
      FreePtrClear((void*) &WorkArea[Selected]->Handle.Fields);
      rs->NumFields = 0;
    }
    rs->Fields = (FieldRecord *) malloc(rf->NumFields * sizeof(FieldRecord));
    if(!rs->Fields) {
      SetError(InsufficientMemory, 3, Not_Enough_Memory_To_Create_Stru,
               was->Alias, funcname);
      return;
    }
    memcpy(rs->Fields, rf->Fields, rf->NumFields * sizeof(FieldRecord));
    rs->NumFields = rf->NumFields;
    // if field list has memo field(s) then convert them to long fields
    for (i = 0; i < (int) rs->NumFields; i++)
      f = &rs->Fields[i];
      if(f->Typ == 'M') {
        f->Typ = 'N';
        f->Len = 10;
        f->Dec = 0;
      }
  } else
    SetError(InvalidLLOperation, 3, was->Alias, is_not_a_virtual_file, funcname);
}
