/* filename: REPLCSTR.C

: T O P A Z for C :Ŀ
                          Version 4.5  05/16/93                              
                                                                             
 Copyright (c) 1988,1994 Software Science Inc. All Rights Reserved Worldwide.
 Unauthorized distribution or disclosure of this source code or modification 
  or removal of this notice  constitutes a breach of the license agreement.  

*/
#include <stdio.h>
#include <string.h>
#include <sayget.h>
#include <utils.h>

//  oldstr      - string to search for
//  newstr      - replacement string
//  s           - subject string
//  CaseSens    - if True, search is case sensitive
//  WordOnly    - if True, only words are replaced
//  CloneCase   - if True, replacement will have same case as OldStr in s
//  MaxLen      -
//  count       - number of replacements made
void ReplaceStr(char *oldstr, char *newstr, char *s, int CaseSens,
                int WordOnly, int CloneCase, int MaxLen, int *count)
{
  int   i, j, k;
  char  TestS[STRSIZ];   // for upper casing
  char  OrigS[STRSIZ];   // original copy
  char  buf1[STRSIZ], buf2[STRSIZ];
  int   IsAWord;
  char *p;
  char  ProperSet[] = " \",.\\/:*$-()[]";

  *count = 0;
  strcpy(TestS,s);
  strcpy(OrigS,s);
  if(!CaseSens) {
    strcpy(oldstr, Upper(oldstr));
    strcpy(TestS, Upper(TestS));
  }

  p = strstr(TestS,oldstr);
  i = (int)(p - TestS); // position in s of start of search string
  if(i < 0)
    return; // can't find it, so exit
  j = i + strlen(oldstr) - 1; // position in s of the end of search string
  IsAWord = TRUE;

  while((i >= 0) && (i <= (int) strlen(s))) {
    if(WordOnly)
      if(((i == 1) && strchr(ProperSet, TestS[j])) ||
         (strchr(ProperSet, TestS[i-2]) && strchr(ProperSet, TestS[j])) ||
         (strchr(ProperSet, TestS[i-2]) && ((unsigned int) j == strlen(TestS))))
        IsAWord = TRUE;
    if(IsAWord) { // 255(FF) says "replace me"
      for(k = i; k <= j; k++) {
        TestS[k] = s[k] = '\xFF'; // put in place holders
      }
    } else { // 254(FE) says "skip over me"
      for (k = i; k <= j; k++) {
        TestS[k] = s[k] = '\xFE'; // put in place holders
      }
    }
    p = strstr(TestS, oldstr);
    i = (int)( p - TestS);
    j = i + strlen(oldstr) - 1;
  }
  // put in the original string in place of 254s
  while(strchr(s, '\xFE')) {
    p = strchr(s, '\xFE');
    i = (int)( p - s);
    Delete(s, i, strlen(oldstr));
    sprintf(s, "%s%s%s", Copy(s, 1, i-1), Copy(OrigS, i, strlen(oldstr)), Copy(s, i, STRSIZ-1));
  }
  // put in the new string in place of 255s
  while(strchr(s, '\xFF')) {
    p = strchr(s, '\xFF');
    i = (int)( p - s);
    Delete(s, i, strlen(oldstr));
    if (CloneCase) {
      // duplicate the case of the string found in S
    }
    strcpy(buf1, Copy(s, 0, i));
    strcpy(buf2, Copy(s, i, STRSIZ-1));
    sprintf(s, "%s%s%s", buf1, newstr, buf2);
    ++(*count);
  }
  if(MaxLen && ((int) strlen(s) > MaxLen)) {
    strcpy(s, OrigS); // don't replace anything if MaxLen exceeded
    *count = -*count;
  }
}
