/* filename: PARSEFN.C

: T O P A Z for C :Ŀ
                          Version 4.5  05/16/93                              
                                                                             
 Copyright (c) 1988,1994 Software Science Inc. All Rights Reserved Worldwide.
 Unauthorized distribution or disclosure of this source code or modification 
  or removal of this notice  constitutes a breach of the license agreement.  

*/
#include <stdio.h>
#include <string.h>
#include <sayget.h>
#include <dbf.h>

#define PARSECLAUSE(source, clause) (int)(strstr((char *)(source), (char *)(clause)) == NULL)

extern char _tzfar _tz_buffer[STRSIZ];
extern char _tzfar _tz_FieldName[11];
extern int  _tz_CaseSensitive;
extern int  _tz_Exact;
extern int  _tz_Contained;

static const char _tzfar funcname[] =  { " [LOCATE/COUNT/SUM]" };

void ParseFieldName(char *s)
{
  char Clause[STRSIZ], *p;

  strcpy(_tz_buffer, Ltrim(Trim(s)));
  strupr(_tz_buffer);

  if(!*_tz_buffer) {
    SetError(InvalidParameter, 2, No_field_name_specified, funcname);
    return;
  }

  if(!*DBF()) {
    SetError(NotInUse, 2, _tz_buffer, funcname);
    return;
  }

  p = strchr(_tz_buffer, ' ');
  if(p) {
    *p = 0;
    strcpy(Clause, p + 1);
    strcpy(_tz_FieldName, _tz_buffer);
    *p = ' ';
  } else {
    strcpy(_tz_FieldName, _tz_buffer);
    *Clause = 0;
  }

  if(!FieldNo(_tz_FieldName)) {
    SetError(InvalidParameter, 2, Unrecognized_field_name,  funcname);
    return;
  }

  _tz_CaseSensitive = PARSECLAUSE(Clause, "NOCASE");
  _tz_Exact         = PARSECLAUSE(Clause, "EXACT");
  _tz_Contained     = PARSECLAUSE(Clause, "CONTAINED");
}
