/* filename: FRACTSTR.C

: T O P A Z for C :Ŀ
                          Version 4.5  05/16/93                              
                                                                             
 Copyright (c) 1988,1994 Software Science Inc. All Rights Reserved Worldwide.
 Unauthorized distribution or disclosure of this source code or modification 
  or removal of this notice  constitutes a breach of the license agreement.  

*/
#include <stdio.h>
#include <string.h>
#include <math.h>
#include <dbf.h>
#include <sayget.h>
#include <utils.h>

static unsigned int CommonDivisor(long a, long b) // (c) 300 BC, Euclid Inc
{
  long r; // remainder

  do {         // assumes b is greater than a
    r = b % a; // any divisor of a and b will be a divisor of r
    b = a;
    a = r;
  } while (r); // keep reducing til it can't be done further
  return (unsigned int) b; // b is the last non-zero remainder
}

char *FractString(double Value, int Divisor) // based on code written by Robert Cowan
{
  static char _tzfar Res[STRSIZ] = "";
  long  WholeNumber, Numerator, Temp;
  char  SWholeNumber[30], SNumerator[30], SDenominator[30], Sign[2];
  unsigned int CD; // common divisor

  strcpy(Sign, IIF(Value < 0.0, "-", " "));
  if(!Divisor) {
    WholeNumber = labs(Round(Value));
    Numerator   = 0L;
  } else {
    Temp        = Round(fabs(Value) * (double) Divisor);
    WholeNumber = Temp / Divisor;
    Numerator   = Temp % Divisor;
    CD          = Numerator ? CommonDivisor(Numerator, (long) Divisor) : 1;
  }
  sprintf(SWholeNumber, "%4ld", WholeNumber);
  if(Numerator) {
    sprintf(SNumerator, "%.0f", (double) Numerator / (double) CD);
    sprintf(SDenominator, "%.0f", (double) Divisor / (double) CD);// Denominator
    sprintf(Res, "%s%s %s/%s", Sign, SWholeNumber, SNumerator, SDenominator);
  } else {
    sprintf(Res, "%s%s", Sign, SWholeNumber);
  }
  return Res;
}
