/* filename: FBLDSTR.C

: T O P A Z for C :Ŀ
                          Version 4.5  05/16/93                              
                                                                             
 Copyright (c) 1988,1994 Software Science Inc. All Rights Reserved Worldwide.
 Unauthorized distribution or disclosure of this source code or modification 
  or removal of this notice  constitutes a breach of the license agreement.  

*/
#include <stdio.h>
#include <stdarg.h>
#include <dos.h>
#include <time.h>
#include <string.h>
#include <common.h>
#include <timedate.h>

static char _tzfar f_buf__[STRSIZ] = "";

char *fBuildStr(char *fmt, ...)
{
  va_list argptr;

  *f_buf__ = 0;
  va_start(argptr, fmt);
  vsprintf(f_buf__, fmt, argptr);
  va_end(argptr);
  return f_buf__;
}

static void converttime(unsigned int date, unsigned int time, struct tm *tmstruct)
{
  struct {
    unsigned int mday  : 5;
    unsigned int month : 4;
    unsigned int year  : 7;
  } *_pdate;

  struct {
    unsigned int halfsec : 5;
    unsigned int min     : 6;
    unsigned int hour    : 5;
  } *_ptime;

  _pdate = (void *) &date;
  _ptime = (void *) &time;

  tmstruct->tm_sec  = _ptime->halfsec * 2;
  tmstruct->tm_min  = _ptime->min;
  tmstruct->tm_hour = _ptime->hour;
  tmstruct->tm_mday = _pdate->mday;
  tmstruct->tm_mon  = _pdate->month;
  tmstruct->tm_year = _pdate->year + (CenturyOn ? 1980 : 80);
}

char *FileDate(const char *filename)
{
  static char _tzfar filedate[20];
  struct find_t      ff;
  struct tm          dt;
  int                SaveAutoHalt;

  SaveAutoHalt = AutoHalt;
  AutoHalt     = 0;
  *filedate    = 0;

  if (!filename || !*filename)
    return "";
  if (!_dos_findfirst(filename, _A_RDONLY | _A_HIDDEN | _A_SYSTEM | _A_ARCH, &ff)) {
    converttime(ff.wr_date, ff.wr_time, &dt);
    sprintf(filedate, "%s %02d:%02d:%02d",
                      DateFrom(dt.tm_year, dt.tm_mon, dt.tm_mday),
                      dt.tm_hour, dt.tm_min, dt.tm_sec);
  }
  AutoHalt = SaveAutoHalt;
  return filedate;
}
