/* filename: DOLLARS.C

: T O P A Z for C :Ŀ
                          Version 4.5  05/16/93                              
                                                                             
 Copyright (c) 1988,1994 Software Science Inc. All Rights Reserved Worldwide.
 Unauthorized distribution or disclosure of this source code or modification 
  or removal of this notice  constitutes a breach of the license agreement.  

*/
#include <stdio.h>
#include <string.h>
#include <sayget.h>

#define MILLION     0
#define THOUSAND    1
#define HUNDRED     2
#define ONES        3
#define TENS        4
#define TEENS       5
#define AddSpace()  strcat(WordAmt, " ")

static long     amount;
static char _tzfar WordAmt[STRSIZ] = "";
static char _tzfar ones[9][6] = {
  "One", "Two", "Three", "Four", "Five",
  "Six", "Seven", "Eight", "Nine"
};
static char _tzfar teens[10][10] = {
  "Ten", "Eleven", "Twelve", "Thirteen", "Fourteen", "Fifteen",
  "Sixteen", "Seventeen", "Eighteen", "Nineteen"
};
static char _tzfar tens[9][8] = {
  "Ten", "Twenty", "Thirty", "Forty", "Fifty",
  "Sixty", "Seventy", "Eighty", "Ninety"
};
static char _tzfar OrderWord[3][10] = {
  "Million ", "Thousand ", "Hundred "
};

static void AddOrder(int order, int withspace)
{
  if(withspace)
    AddSpace();
  strcat(WordAmt, OrderWord[order]);
}

static void AddWord(int order, int type)
{
  long  divider = 1L;
  int   i;
  char *p;

  while (order--)
    divider *= 10;
  i = (int)(amount / divider)-1;

  switch (type) {
    case ONES:
      p = ones[i];
      break;

    case TENS:
      p = tens[i];
      break;

    case TEENS:
      p = teens[i];
      break;
  }
  strcat(WordAmt, p);

  if(divider != 1L)
    amount -= (amount / divider) * divider;
  else
    amount = 0;
}

char *Dollars(double Amt)
/*
  Given a numeric value of type Real, this function returns a string
  containing the number expressed as dollars and cents (in English).
  Largest number is $999,999,999.99
*/
{
  int cents;

  amount   = (long) Amt; // get rid of pennies
  *WordAmt = 0;
  cents    = (int) ((Amt - (double) amount) * 100.0); // here are the pennies

  if(!amount) {
    if(cents) {
      sprintf(WordAmt, "Zero and %d/100", cents);
      return WordAmt;
    } else
      return "Zero and NO/100";
  }
  // check for hundreds of millions
  if((amount / 100000000L) > 0L) { // 100,000,000's
    AddWord(8, ONES);
    AddOrder(HUNDRED, 1);
    if(!amount)
      AddOrder(MILLION, 0);
  }
  if((amount / 10000000L) > 0L) {
    if(amount > 19999999L) { // >19,999,999's
      AddWord(7, TENS);
      if(!amount)
        AddOrder(MILLION, 0);
    } else { // 10,000,000's
      AddWord(6, TEENS);
      AddOrder(MILLION, 1);
    }
  }
  if((amount / 1000000L) > 0L) { // 1,000,000's
    AddWord(6, ONES);
    AddOrder(MILLION, 1);
  }
  // check for hundreds of thousands
  if((amount / 100000L) > 0L) { // 100,000's
    AddWord(5, ONES);
    AddOrder(HUNDRED, 1);
    if(!amount)
      AddOrder(THOUSAND, 0);
  }
  if((amount / 10000L) > 0L) {
    if(amount > 19999L) { // >19,999's
      AddWord(4, TENS);
      AddSpace();
      if(!amount)
        AddOrder(THOUSAND, 0);
    } else { // 10,000's
      AddWord(3, TEENS);
      AddOrder(THOUSAND, 1);
    }
  }
  if((amount / 1000L) > 0L) { // 1,000's
    AddWord(3, ONES);
    AddOrder(THOUSAND, 1);
  }
  if((amount / 100L) > 0L) { // 100's
    AddWord(2, ONES);
    AddOrder(HUNDRED, 1);
  }
  if((amount / 10L) > 0L) {
    if((amount > 19) || (amount == 10)) {
      AddWord(1, TENS);
      AddSpace();
    } else {
      AddWord(0, TEENS);
      AddSpace();
    }
  }
  if(amount > 0L) {
    AddWord(0, ONES);
    AddSpace();
  }

  strcat(WordAmt, "and ");
  strcat(WordAmt, cents ? SInteger(cents, 1) : "NO");
  strcat(WordAmt, "/100");

  return WordAmt;
}
