/* filename: WRITOALT.C

: T O P A Z for C :Ŀ
                          Version 4.5  05/16/93                              
                                                                             
 Copyright (c) 1988,1994 Software Science Inc. All Rights Reserved Worldwide.
 Unauthorized distribution or disclosure of this source code or modification 
  or removal of this notice  constitutes a breach of the license agreement.  

*/
#include <stdio.h>
#include <conio.h>
#include <stdlib.h>
#include <stdarg.h>
#include <setjmp.h>
#include <sayget.h>
#include <tzprint.h>
  
// Report needs its own check routine
void (*ReportCheckPrinterStatusPtr)(void) = NULL;
#ifndef WINDOWS
int DisplayPageLength = 0;
int LineNumberCounter = 1;
jmp_buf ReportJmp;
#endif
  
int WriteToAlt(char * control, ...)
{
#ifndef WINDOWS
  char waitflag = 0;
#endif
  int i;
  int  bit3, bit4, bit5;
  
  va_list args;
  char buf[STRSIZ*4];
  char *ptr = &buf[1]; // for a little trick when "\n" -> "\r\n"
  
  va_start(args, control); // get variable arg pointer
  vsprintf(ptr,control,args); // format into buf with variable args
  va_end(args);               // finish the arglist
  
#ifndef WINDOWS
  if (ConsoleOn) {
    printf(ptr);
    if (ReportCheckPrinterStatusPtr) {
      if (LineNumberCounter == DisplayPageLength) {
        if (PrintOn || AlternateOn) {
          LineNumberCounter = 0;
          // to make your screens scroll up uncomment
          // lines 1, 3 and comment lines 2, 4
          // printf("\n\n");             // 1
          gotoxy(1, DisplayPageLength+2);// 2
          WaitTo(ReportPressAnyKey, &waitflag );
          if (waitflag == 0x1B)
            longjmp(ReportJmp, 1);
          // putchar('\n');  // 3
          gotoxy(1,1);       // 4
        }
      }
    }
  }
#endif
  if (AlternateOn) {
    if (fprintf(Alt, ptr) == EOF) {
      SetError(_doserrno, 2, Output_error_alternate_file, AlternateName);
      return -1;
    }
  }
  if (PrintOn) {
    if (DBFError == 160)
      return 1;
    for (i = 0; ptr[i] != '\0'; i++) {
      // check the printer status before sending a char
      PrinterError = (RPrinterStatus(PrintDevice) == 0x10) ? 0 : 160;
      // if 160 - force notice to appear
      do {
        if (ReportCheckPrinterStatusPtr) // if Report
          ReportCheckPrinterStatusPtr();
        else
          CheckPrinterStatus();
        // if the user bailed out with the ESCape key, and autohalt is OFF,
        // dbfError will be 160. We can test for this and exit here:
        if (DBFError == 160)
          return 1;
        // otherwise, all is well and we can continue to send
        // the char to the printer
        if( (buf[i] = ptr[i]) == '\n' ) {
          ptr[i] = '\r';
          --i;
        }
        PrinterError = CallInt17(ptr[i], PrintDevice); // 0 means LPT1
        if (UserPrinterCheck)
          PrinterError = 0;
        else { // detect any printer errors
          bit3 = PrinterError & 0x08; // error
          bit4 = PrinterError & 0x10; // select
          bit5 = PrinterError & 0x20; // paper out
          PrinterError = 160; // Undetermined..offline or paper out
          if (bit4 && !bit3 && !bit5)
            PrinterError = 0x0; // on-line
          if (bit3 && !bit5)
            PrinterError = 160; // off-line
          if (bit3 && bit5)
            PrinterError = 159; // Paper is out
        }
      } while (PrinterError);
    }
  }
  return 0; // success
}
