/* filename: EJECT.C

: T O P A Z for C :Ŀ
                          Version 4.5  05/16/93                              
                                                                             
 Copyright (c) 1988,1994 Software Science Inc. All Rights Reserved Worldwide.
 Unauthorized distribution or disclosure of this source code or modification 
  or removal of this notice  constitutes a breach of the license agreement.  

*/
#include <stdio.h>
#include <conio.h>
#include <stdlib.h>
#include <string.h>
#include <sayget.h>
#include <tzprint.h>
#ifdef WINDOWS
#include <windows.h>
#endif

void Eject(void)
{
  int retry;
  unsigned char ErrorCode;
#ifdef WINDOWS
  int reply;
#else
  int saveX, saveY;
  int c;
  unsigned char buffer[160];
#endif

  if (PageBuffer) {
    PrintPage();
    // now deallocate the linked list of printer control codes
    ReleaseCommands();
    // now throw away page buffer
    FreePtrClear((void*) &PageBuffer);
    PMaxRows = 0;
    return;
  }
  do {
    ErrorCode = CallInt17('\f',PrintDevice);
    if ((ErrorCode & 0x38) != 0x10) { // printer is not ready unless
      // bit3 and bit5 are low, and bit4 is hi
#ifdef WINDOWS
      reply = WDialogBox("","Printer Not Ready",MB_ABORTRETRYIGNORE | MB_ICONEXCLAMATION);
      switch (reply) {
        case IDABORT:
          SetError(ErrorCode,1,"[EJECT]");
          return;
        case IDRETRY:   // "Retry"
          DBFError = 0;
          retry = TRUE;
          break;
        case IDIGNORE:  // "Ignore"
          DBFError = 0;
          return;
      }
#else
      saveX = wherex();
      saveY = wherey();
      memcpy(buffer,(unsigned char *)MK_FP(VideoSegment(),0),160);
      gotoxy(1,1);
      printf("\a[%d] %s",ErrorCode,Printer_is_not_available_Abort_Ignore_Retry);
      c = getch();
      if (c == '\0') getch();
      gotoxy(saveX,saveY);
      switch (UpCase(c)) {
        case 'A':
          SetError(ErrorCode,1,"[EJECT]");
          retry = FALSE;
          break;// let it restore the screen image
#ifdef GERMAN
        case 'W':  // "Retry"
#else
        case 'R':  // "Retry"
#endif
          DBFError = 0;
          retry = TRUE;
          break;
        case 'I': //  "Ignore"
          DBFError = 0;
          return;
      }
      memcpy((unsigned char *)MK_FP(VideoSegment(),0),buffer,160);
#endif
    }
    else
      retry = FALSE;
  }  while (retry);
}
