/* filename: ATPLINE.C

: T O P A Z for C :Ŀ
                          Version 4.5  05/16/93                              
                                                                             
 Copyright (c) 1988,1994 Software Science Inc. All Rights Reserved Worldwide.
 Unauthorized distribution or disclosure of this source code or modification 
  or removal of this notice  constitutes a breach of the license agreement.  

*/
#include <tzprint.h>

void AtPrintLine(DirectionType Direction, int col,
int row, int len, int LineStyle)
{
  char *SymbolSet[5] = {
    "\xDA\xC4\xC4\xBF\xB3\xC0\xD9\xC5\xC2\xC1\xB4\xC3",   //  single line box chars
    "\xC9\xCD\xCD\xBB\xBA\xC8\xBC\xCE\xCB\xCA\xB9\xCC",   //  double line box chars
    "\xDB\xDC\xDF\xDB\xDB\xDB\xDB\xDB\xDB\xDB\xDB\xDB",   //  solid line box chars
    "\xD6\xC4\xC4\xB7\xBA\xD3\xBD\xD7\xD2\xD0\xB6\xC7",   //  double sides, single top/bottom
    "\xD5\xCD\xCD\xB8\xB3\xD4\xBE\xD8\xD1\xCF\xB5\xC6"  //  single sides, double top/bottom
  };
  unsigned char i;
  char part, *ss;

  if ((LineStyle < 1) || (LineStyle > 5))
    LineStyle = 1;
  MakePageBuffer();
  ss = SymbolSet[LineStyle-1];
  if (Direction == Vertical) {
    // if first position is a horizontal box part then change it to a "T"
    switch (GetChar( col, row )) {
      case '\xC4':
      case '\xCD':
      case '\xDF': part = ss[TDeadEnd]; break;
      case '\xC1':
      case '\xCA':
      case '\xDB': part = ss[Cross];   break;
      default:     part = ss[VerticalLine];
    }
    PutChar(col,row,part);
    //if last position is a horizontal box part then change it to a "T"
    switch (GetChar(col,row + len - 1)) {
      case '\xC4':
      case '\xCD':
      case '\xDC':   part = ss[BDeadEnd]; break;
      case '\xC2':
      case '\xCB':
      case '\xDB':   part = ss[Cross];  break;
      default: part = ss[VerticalLine];
    }
    PutChar(col,row + len - 1,part);
    for (i = 1; (int)i < len - 1; i++) {
      if (GetChar(col,row + i) == ss[THorizontal])
        part = ss[Cross];
      else
        part = ss[VerticalLine];
      PutChar(col,row + i,part);
    }
  }
  else {   //  horizontal line ...
    // if first position is a vertical box part then change it to a "T"
    switch (GetChar(col,row)) {
      case '\xDB':
        part = '\xDB'; // Don't overwrite bold line
        break;
      case '\xB3':
      case '\xBA':
        part = ss[LDeadEnd];
        break;
      case '\xB4':
      case '\xB9':
      case '\xB6':
      case '\xB5':
        part = ss[Cross];
        break;
      default:
        part = ss[THorizontal];
    }
    PutChar(col,row,part);
    //  if last position is a vertical box part then change it to a "T"
    switch (GetChar(col + len - 1,row)) {
      case '\xDB':
        part = '\xDB'; // Don't overwrite bold line
        break;
      case '\xB3':
      case '\xBA': part = ss[RDeadEnd]; break;
      case '\xC3':
      case '\xCC':
      case '\xC7':
      case '\xC6': part = ss[Cross]; break;
      default:     part = ss[THorizontal];
    }
    PutChar(col + len - 1,row,part);
    for (i = 1; (int)i < len - 1; i++) {
      if (GetChar(col + i,row) == ss[VerticalLine])
        part = ss[Cross];
      else
        part = ss[THorizontal];
      PutChar(col + i,row,part);
    }
  }
}
