/* filename: TZMENU.C

: T O P A Z for C :Ŀ
                          Version 4.5  05/16/93                              
                                                                             
 Copyright (c) 1988,1994 Software Science Inc. All Rights Reserved Worldwide.
 Unauthorized distribution or disclosure of this source code or modification 
  or removal of this notice  constitutes a breach of the license agreement.  

*/
#include <stdio.h>
#include <conio.h>
#include <ctype.h>
#include <string.h>
#include <stdlib.h>
#include <fcntl.h>
#include <sys\types.h>
#include <sys\stat.h>
#include <share.h>
#include <io.h>
#include <common.h>
#include <vidpop.h>
#include <sayget.h>
#include <utils.h>
#include "tzmenu.h"

static Table table;
static int handle;

// disable warning message for typecasting for both MS 7.0 and 8.0
#pragma warning( disable : 4243 4248 )

static TableType getTable(void)
{
  lseek(handle, table.NextTableOffset, SEEK_SET);
  read(handle, &table, sizeof(Table));
  return table.Type;
}

static void ReadAThing(void *ptr, unsigned size)
{
  read(handle, ptr, size);
}

static void CleanUp(char *buffer)
{
  char *one, *two, *prev;
  int  quoted;

  if (!buffer)
    return;
  // "expand" tabs into single space char and remove extra white spaces
  for (prev = one = two = buffer, quoted = 0; *two; two++) {
    if (isspace(*two))  *two = ' ';
    if (*two == '"') quoted = !quoted;
    if ((*prev != ' ') || (*two != ' ') || quoted) {
      prev = one;
      *one++ = *two;
    }
  }
  *one = 0;
  strcpy(buffer, Ltrim(Trim(buffer)));
}

///////////////////////////// MenuItem Methods /////////////////////////////

MenuItem::MenuItem(PageType *ptype, PMenuItem parent, PMenuItem previous)
{
   ItemPage page;
   BOOL same_level;
   int nameLen;

   // initialize
   ChildMenu = 0;
   RememberLastSelected = 0;
   ParentMenu = parent;
   PrevItem = previous ? previous : this;
   NextItem = this;

   Separator = 0;
   hotkeys[++TotalItemNo] = 0;
   ID = ptype->ID;
   Name = Help = IDString = CustomString = EmptyString;
   Selected = Enabled = Checked = FALSE;
   UserID = AcceleratorKey = nameLen = 0;
   HotKeyOfs = -1;
   pool = 0;

   if (ptype->type != MenuBreak) {
     ReadAThing(&page, sizeof(ItemPage));
     if (page.StrSize) {
       pool = (char *) new char[page.StrSize];
       if (pool == 0)
         SetError(InsufficientMemory, "Not enough memory to add a new menu item  [tzMenu]");
       ReadAThing(pool, page.StrSize);
       Name = pool + page.NameOffset;
       Help = pool + page.HelpOffset;
       IDString = pool + page.IDStringOffset;
       CustomString = pool + page.CustomStringOffset;
     }
     Selected = page.iv.Selected;
     Enabled = page.iv.Enabled;
     Checked = page.iv.Checked;
     UserID = page.iv.UserID;
     HotKeyOfs = page.iv.HotKeyOfs;
     AcceleratorKey = page.iv.AcceleratorKey;
     hotkeys[TotalItemNo] = page.Hotkey;
     nameLen = strlen(Name);
   }
   else
     Separator = TRUE;

   // set coordinates
   if (ParentMenu) { // vertical menu
     if (PrevItem == this) {
       Row = ParentMenu->Row + 2;
       Col = ParentMenu->Col + 1;
     }
     else {
       Row = PrevItem->Row + 1;
       Col = PrevItem->Col;
     }
   }
   else { // horizontal menu, top level
     if (PrevItem == this) {
       Row = MenuRow;
       Col = MenuCol;
     }
     else {
       Row = MenuRow;
       Col = PrevItem->Col + strlen(PrevItem->Name) + 2;
     }
     if (Col+nameLen + 3 > MenuWidth + MenuCol)
       SetError(11, "Menu too wide to fit user defined MenuWidth. [tzMenu]");
   }

   same_level = (ptype->type != Group);

   while (TRUE) {
     do {
       ReadAThing(ptype, sizeof(PageType));
     } while (ptype->type == Begin);

     if (ptype->type == Group) {
       if (same_level) {
         NextItem = (MenuItem *) new MenuGroup(ptype, parent, this);
         break;
       }
       else {
         ChildMenu= (MenuItem *) new MenuGroup(ptype, this, 0);
         same_level = TRUE;
       }
     }
     else
       if ((ptype->type == Item) || (ptype->type == MenuBreak)) {
         if (same_level) {
           NextItem = new MenuItem(ptype, parent, this);
           break;
         }
         else {
           ChildMenu= new MenuItem(ptype, this, 0);
           same_level = TRUE;
         }
       }
       else
         break;
   }
}

MenuItem::~MenuItem()
{
  PMenuItem next, prev;

  next = NextItem;
  prev = PrevItem;
  next->PrevItem = prev;
  prev->NextItem = next;
  // deallocate memory
  delete[] pool;

  if (ChildMenu)
    delete ChildMenu;

  if (this != next)
    delete next;
}

const MenuItem * MenuItem::TopParent() const
{
  return (MenuItem *) Start;
}

void MenuItem::RepaintItem(void) const
{
  int cwidth, color, len, has_children;
  char paint_buffer[MAX_AVAIL_COLS-1];

  has_children = 0;
  if (Visible) {
    if (ParentMenu) {
      cwidth = ((MenuGroup *)ParentMenu)->GetCursorWidth();
      if (ChildMenu)
        has_children = 1;
    }
    else
      cwidth = strlen(Name) + 3 + GetCustomStringLen();
    if (cwidth > (MAX_AVAIL_COLS-2))
      cwidth = MAX_AVAIL_COLS-2;

    if (Separator) {
      color = GetColor(NORMAL);
      memset(paint_buffer, 196, cwidth);
    }
    else {
      if (!Enabled)
        color = GetColor(DISABLED);
      else
        if (Selected)
          color = GetColor(SELECTED);
        else
          color = GetColor(NORMAL);
      *paint_buffer = ' ';
      strncpy(&paint_buffer[1], Name, cwidth-3);
      *(paint_buffer + cwidth - 2) = 0;
      len = strlen(paint_buffer);

      if (*CustomString) {
        while (len < cwidth- (int)strlen(CustomString)-1) {// pad w/Spaces
          *(paint_buffer+len) = ' ';
          ++len;
        }
        strcat(paint_buffer, GetCustomString());
      }
      else
        while (len < cwidth) {          // pad w/Spaces
          *(paint_buffer+len) = ' ';
          ++len;
        }
      *paint_buffer = Checked ? GetCheckMark() : ' ';
      *(paint_buffer+cwidth-1) = has_children ? 0x10 : ' ';
    }
    *(paint_buffer+cwidth) = 0;
    FastWrite(paint_buffer, Row, Col, color);
    if (HotKeyOfs >= 0 && Enabled) {
      if (Selected)
        color = (GetColor(SELECTEDBG) << 4) | GetColor(HILITEDFG);
      else
        color = GetColor(HILITED);
      ChangeAttribute(1, Row, Col+1+HotKeyOfs, color);
    }
  }
}

void MenuItem::Paint(void)
{
  if (ParentMenu) {
    if (ParentMenu->IsSelected()) {
      Visible = TRUE;
      RepaintItem();
    }
    if (ParentMenu->ChildMenu == NextItem)
      return;
  }
  else {
    Visible = TRUE;
    UnCheckItem(); // top level item cannot be checked
    RepaintItem();
    if (TopParent() == NextItem)
      return;
  }
  if (NextItem)
    NextItem->Paint();
}

void MenuItem::UnPaint(void)
{
  if (ParentMenu) {
    if (ParentMenu->ChildMenu == NextItem)
      return;
  }
  else
    return;

  if (NextItem)
    if (NextItem != this) {
      NextItem->UnPaint();
      NextItem->Visible = FALSE;
    }
}

void MenuItem::SetItemCustomString(const char *init)
{
  char *ptr;
  unsigned len, clen;

  if (*CustomString) {
    for(ptr = CustomString; *ptr; ptr++)
      *ptr = ' ';
    len = strlen(init);
    clen = strlen(CustomString);
    if (len < clen)
      ptr = CustomString + clen - len;
    else {
      len = clen;
      ptr = CustomString;
    }
    strncpy(ptr, init, len);
  }
}

int MenuItem::GetCustomStringLen() const
{
  return (int) strlen(CustomString);
}

/////////////////////////////// MenuGroup Methods //////////////////////////
static int maximum(int value1, int value2)
{
   return ( (value1 > value2) ? value1 : value2);
}

MenuGroup::MenuGroup(PageType *ptype, PMenuItem parent, PMenuItem previous)
          :MenuItem(ptype, parent, previous)
{
  PMenuItem frst, last;
  int ItemsNo, tmp, limit, left, up;

  CursorWidth = 0;                  // menu cursor width
  StartingItem = 0;
  BTop = BLeft = BBottom = BRight = 0;

  if (ChildMenu) {
    for(ItemsNo = 0, frst = ChildMenu; ;frst = frst->NextItem) {
      ++ItemsNo;
      CursorWidth = maximum(CursorWidth, (int)strlen(frst->GetName()) + frst->GetCustomStringLen());
      if (frst == frst->NextItem)
        break;
    }
    CursorWidth += 3;  // space + MenuItem + space + check_mark
                       // or space + MenuItem + space + CustomString + check_mark
    up = left = -1;
    limit = MenuCol + MenuWidth - 1;
    tmp = Col;
    do {
      BLeft = tmp;
      BRight  = BLeft + CursorWidth + 1;
      if (tmp-- == 0)
        break;
      ++left;
    } while (BRight > limit);
    limit = MenuRow + MenuHeight - 2;  // -1 for the help line
    tmp = Row + 1;
    do {
      BTop = tmp;
      BBottom = BTop + ItemsNo + 1;
      if (tmp-- == 0)
        break;
      ++up;
    } while (BBottom > limit);

    for(frst = ChildMenu; ;frst = frst->NextItem) {
      frst->Col -= left;
      frst->Row -= up;
      if (frst == frst->NextItem) break;
    }
  }
  // Now adjust pointers in Linked List
  if (ChildMenu) {
    frst = last = ChildMenu;
    while (last->NextItem != last)
      last = last->NextItem;
    frst->PrevItem = last;
    last->NextItem = frst;
  }
}

void MenuGroup::Paint(void)
{
  MenuItem *current;
  int row, col;
  int saveSayColor = SayColor;

  MenuItem::Paint();  // draw menu item

  if (ChildMenu && IsSelected() && (GetID() != SelectedItem)) {
    PushWindow(BLeft, BTop, BRight+2, BBottom+1);
    WindowInStack = TRUE;

    SayColor = GetColor(BORDER);
    Box(BLeft, BTop, BRight, BBottom, GetLineStyle(), "");
    SayColor = saveSayColor;

    // handle the Mouse
    current = ChildMenu;
    do {
      row = current->Row;
      col = current->Col;
      AddTarget(col, row, col+CursorWidth,row,-current->GetID(),LeftButtonReleased);
      current = current->NextItem;
    } while(current != ChildMenu);
    AddTarget(1, 1, MAX_AVAIL_COLS, MaxAvailRows(), ReservedID, RightButtonDown);
    EnableMouse();

    ChildMenu->Paint();
  }
}

void MenuGroup::UnPaint(void)
{
  if (ChildMenu) {
    if (ChildMenu->Visible) {
      ChildMenu->UnPaint();
      ChildMenu->Visible = FALSE;
    }
  }
  if (WindowInStack) {
    PopWindow();
    // handle the Mouse
    DisableMouse();
  }
  WindowInStack = FALSE;

  MenuItem::UnPaint();
}

void MenuGroup::DisableMouse(void)
{
  MenuItem *current;
  int row, col;

  ::DisableMouse();

  current = (MenuItem *)Start;
  do {
    row = current->Row;
    col = current->Col;
    AddTarget(col, row, col+strlen(current->GetName())+2,row,-current->GetID(),LeftButtonReleased);
    current = current->NextItem;
  } while(current != (MenuItem *)Start);
  AddTarget(1, 1, MAX_AVAIL_COLS, MaxAvailRows(), ReservedID, RightButtonDown);
  EnableMouse();
}

/////////////////////// tzMenu Methods ///////////////////////////////////////
tzMenu::tzMenu(const char *RCName, int width, int col, int row,
               const char *MenuName)
{
  char rcName[80];
  TableType curTable;
  PageType pageType;

  BOOL found;
  MenuItem *frst, *last;

  strncpy(rcName, Trim(RCName), 80);
  rcName[79] = 0; // we do not need this line, but..let it be there
  if (*rcName == 0)
    SetMenuError(2, "No .BIN-file name specified [tzMenu]");

  memset(&table, 0, sizeof(Table));

  IdLink = 0;
  ErrorNo = 0;
  Visible = 0;
  CallBack = 0;
  CurrentItem = 0;
  FirstMenuGroup = 0;
  QuitMenuByEscape = TRUE;
  if (width <= 0 || width > MAX_AVAIL_COLS)
    width = MAX_AVAIL_COLS;
  if (row <= 0 || row > (int)MaxAvailRows())
    row = 1;
  if (col <= 0 || col > MAX_AVAIL_COLS)
    col = 1;
  MenuRow = row;
  MenuCol = col;
  MenuWidth = width;
  MenuHeight = MaxAvailRows() - MenuRow + 1;
  HelpRow = MenuRow + MenuHeight - 1;

  saveX = wherex();
  saveY = wherey();
  saveCursorVisible = CursorVisible();
  SetCursorOff();
  saveMousePlacement = AutoMousePlacement;
  AutoMousePlacement = 0;

  handle = sopen(AddExt(rcName, "BIN"), O_RDWR|O_BINARY, SH_DENYNO, S_IREAD|S_IWRITE);
  if (handle == -1)
    SetMenuError(_doserrno, BuildStr("Cannot open : ", rcName, " [tzMenu]", NULL));
  else {
    // file was successfully opened. Scan the file until we get to EOF or
    // we find the MENU keyword
    do {
      curTable = AcceleratorTable;
      while (curTable == AcceleratorTable)
        curTable = getTable();
      if (curTable == MenuTable) {
        if ((MenuName) && *Trim(MenuName)) { // was a menu name specified?
          strupr(table.Name);
          if (strstr(table.Name,Upper(MenuName))) // look for specified menu name
            found = TRUE;
        }
        else
          found = TRUE;
      }
    } while(!(found || curTable == NoneTable));

    if (found) {
      do {
        ReadAThing(&pageType, sizeof(PageType));
      } while (pageType.type != Item && pageType.type != Group
            && pageType.type != Eot  && pageType.type != MenuBreak);
      if (pageType.type == Eot) {
        close(handle);
        SetMenuError(11, BuildStr("Corrupted menu structure in: ",MenuName ? MenuName : "MENU"," [tzMenu]", NULL));
      }

      FirstMenuGroup = new MenuGroup(&pageType, 0, 0);

      // Now adjust pointers in Linked List
      frst = last = (MenuItem *) FirstMenuGroup;
      while (last->NextItem != last)
        last = last->NextItem;
      frst->PrevItem = last;
      last->NextItem = frst;

      Start = (void *) FirstMenuGroup;
      close(handle);
      Activate(SelectedItem);
      CurrentItem = (MenuItem *) Active;
      errno = _doserrno = 0;  // Do we really need this ?
    }
    else { // not found
      close(handle);
      SetMenuError(11, BuildStr("Cannot find ", MenuName ? MenuName : "MENU"," keyword in ",rcName," [tzMenu]",NULL));
    }
  }
}

tzMenu::~tzMenu()
{
  AutoMousePlacement = saveMousePlacement;
  gotoxy(saveX, saveY);
  if (saveCursorVisible)
    SetCursorOn();
  delete FirstMenuGroup;
  if (ErrorNo)
    exit(ErrorNo);
}

void tzMenu::SetMenuError(int errNo, char *msg)
{
   SetError(errNo, msg);
   tzMenu::~tzMenu(); // enforce destroying the object
}

FILE *tzMenu::CleanUpFile(FILE *in, char *s,
            const char *outfname, const char *infname)
{
  FILE *out;
  char *ptr, *cptr;
  int len, counter = 0, comments = 0, lineno = 0;

  out = fopen(outfname,"wt+");
  if (out) {
    while ((ptr = fgets(s, STRSIZ-1, in)) != 0) {
      ++lineno;
      CleanUp(ptr);
      if (comments) {
        if ((cptr = strstr(ptr, "*/")) != 0) {
          ptr = cptr + 2;
          while (isspace(*ptr) && *ptr)
            ++ptr;
          comments = 0;
        }
      }
      if (!comments) {
        len = strlen(ptr);
        if (len && ((cptr = strstr(ptr, "/*")) != 0)) {
          *cptr = 0;
          comments = 1;
          len = strlen(ptr);
        }
        if (len) {
          if ((cptr = strstr(ptr, "//")) != 0)
            if (!strstr(ptr, "HELP=") && !strstr(ptr, "CUSTOM="))
              *cptr = 0;
          if (strchr(ptr,'{'))
            ++counter;
          if ((cptr = strstr(ptr, "BEGIN")) != 0) {
            if (strchr(" ,;\t\n", *(cptr+5)))
              if (cptr == ptr)
                ++counter;
              else
                if (strchr(" ,;\t\n", *(cptr-1)))
                  ++counter;
          }
          if (strchr(ptr,'}'))
            --counter;
          if ((cptr = strstr(ptr, "END")) != 0) {
            if (strchr(" ,;\t\n", *(cptr+3)))
              if (cptr == ptr)
                --counter;
              else
                if (strchr(" ,;\t\n", *(cptr-1)))
                  --counter;
          }
          if (counter < 0)// Unexpected '}' or "END" encountered
            break;
          fprintf(out, "\n%s", ptr);
        }
      }
    }
    fprintf(out, "\n");
    fclose(in);
    rewind(out);
    ptr = 0;
    if (counter < 0)  // Unexpected '}' or "END" encountered
      ptr = "Unexpected '}' or \"END\" encountered : ";
    if (counter > 0)  // Misplaced '{' or "BEGIN" encountered
      ptr = "Unpaired '{' or \"BEGIN\" encountered : ";
    if (comments)     // unclosed comments
      ptr = "Unclosed comments encountered : ";
    if (ptr) {
      fclose(out);
      unlink(outfname);
      SetMenuError(11, BuildStr(ptr, infname, ", line: ", SInteger(lineno, 0), NULL));
    }
    errno = _doserrno = 0;
    return out;
  }
  return in;
}

void tzMenu::Paint()         // displays the menu
{
  char line[MAX_AVAIL_COLS+1];
  MenuItem *current;
  int row, col;

  PushWindow(MenuCol, MenuRow, MenuCol+MenuWidth-1, MenuRow);
  PushWindow(MenuCol, HelpRow, MenuCol+MenuWidth-1, HelpRow);
  WindowInStack = TRUE;
  strcpy(line, Space(MenuWidth));
  FastWrite(line, MenuCol, MenuRow, GetColor(NORMAL));

  // handle the Mouse
  current = (MenuItem *)FirstMenuGroup;
  do {
    row = current->Row;
    col = current->Col;
    AddTarget(col, row, col+strlen(current->GetName())+2,row,-current->GetID(),LeftButtonReleased);
    current = current->NextItem;
  } while(current != (MenuItem *)FirstMenuGroup);
  AddTarget(1, 1, MAX_AVAIL_COLS, MaxAvailRows(), ReservedID, RightButtonDown);
  EnableMouse();

  FirstMenuGroup->Paint();
  Visible = TRUE;
}

void tzMenu::UnPaint()
{
  FirstMenuGroup->UnPaint();
  if (WindowInStack) {
    PopWindow();
    PopWindow();
    // handle the Mouse
    DisableMouse();
  }
  WindowInStack = FALSE;
  Visible = FALSE;
}

MenuItem * tzMenu::Find(int id) const  // find item by its internal ID
{
  MenuItem *current;
  int found = 0;

  if ((id > 0) && (id <= TotalItemNo)) {
    current = (MenuItem *) Start;
    do {
      current = current->PrevItem;
      while (id < current->GetID())
        current = current->PrevItem;
      if (id == current->GetID())
        found = TRUE;
      else
        current = current->ChildMenu;
    } while (!found);

    return current;
  }
  else
    return 0;
}

MenuItem * tzMenu::FindFirstEnabled(MenuItem *first) const
{
  MenuItem *ret;

  ret = first;
  while (ret->IsEnabled() == FALSE) {
    ret = ret->NextItem;
    if (ret == first) break;
  }
  if (ret->IsEnabled() == FALSE)
    ret = 0;

  return ret;
}

void  tzMenu::DeActivate()
{
  MenuItem *current, *prev;

  if (Active) {
    current = (MenuItem *) Active;
    while (current) {
      current->DeSelectItem();
      prev = current;
      current = current->ParentMenu;
    }
    prev->UnPaint();
    prev->RepaintItem();
  }
  CurrentItem = FindFirstEnabled((MenuItem *) FirstMenuGroup);
  Active = (void *)CurrentItem;
  if (Active) {
    CurrentItem->SelectItem();
///    CurrentItem->RepaintItem();
  }
}

MenuItem * tzMenu::TryToActivate(MenuItem *current, int select)
{
   MenuItem *prev;

   while (current) {
     if (!current->IsEnabled()) {
       prev = 0;
       break;
     }
     if (select)
       current->SelectItem();
     else
       current->DeSelectItem();
     prev = current;
     current = current->ParentMenu;
   }
   return prev;
}

BOOL tzMenu::Activate(int id, BOOL)// Activate item by its internal ID
{
  MenuItem *prev, *save;

  if ((id > 0) && (id <= TotalItemNo)) {
    if (Visible) {
      if (CurrentItem && CurrentItem == (MenuItem *)Active)
        if (CurrentItem->GetID() == id)
          return TRUE;
      DeActivate();
      if (id) {
        save = Find(id);
        prev = TryToActivate(save, 1);  // activate
        if (prev) {
          Active = (void *) save;
          CurrentItem = save;
          SelectedItem = id;
          prev->Paint();
          return TRUE;
        }
        else {
          TryToActivate(save, 0);  // deactivate
          return FALSE;
        }
      }
      else {
        if (CurrentItem) {
          CurrentItem->SelectItem();
          CurrentItem->RepaintItem();
          return TRUE;
        }
        return FALSE;
      }
    }
    else {
      SelectedItem = id;
      return TRUE;
    }
  }
  else {
    SelectedItem = 0;
    return FALSE;
  }
}

void  tzMenu::Check(int id)
{
  MenuItem *ptr;

  TranslateID(&id);

  if (id)
    ptr = Find(id);
  else
    ptr = CurrentItem;
  if (ptr) {
    ptr->CheckItem();
    ptr->RepaintItem();
  }
}

void  tzMenu::UnCheck(int id)
{
  MenuItem *ptr;

  TranslateID(&id);

  if (id)
    ptr = Find(id);
  else
    ptr = CurrentItem;
  if (ptr) {
    ptr->UnCheckItem();
    ptr->RepaintItem();
  }
}

BOOL tzMenu::IsChecked(int id) const
{
  MenuItem *ptr;

  TranslateID(&id);

  if (id)
    ptr = Find(id);
  else
    ptr = CurrentItem;
  if (ptr)
    return ptr->IsChecked();
  else
    return 0;
}

void  tzMenu::Enable(int id)
{
  MenuItem *ptr;

  TranslateID(&id);

  if (id)
    ptr = Find(id);
  else
    ptr = CurrentItem;
  if (ptr) {
    ptr->EnableItem();
    ptr->RepaintItem();
  }
}

void  tzMenu::Disable(int id)
{
  MenuItem *ptr;

  TranslateID(&id);

  if (id)
    ptr = Find(id);
  else
    ptr = CurrentItem;
  if (ptr) {
    if (ptr == CurrentItem) { // Disable current may cause problems...
      DeActivate();
      if (ptr->ParentMenu)
        ptr->ParentMenu->RememberLastSelected = 0;
    }
    else {
      ptr->DisableItem();
      ptr->RepaintItem();
    }
  }
}

BOOL tzMenu::IsEnabled(int id) const
{
  MenuItem *ptr;

  TranslateID(&id);

  if (id)
    ptr = Find(id);
  else
    ptr = CurrentItem;
  if (ptr)
    return ptr->IsEnabled();
  else
    return 0;
}

void  tzMenu::SetCustomString(const char *init, int id)
{
  MenuItem *ptr;

  TranslateID(&id);

  if (id)
    ptr = Find(id);
  else
    ptr = CurrentItem;
  if (ptr) {
    ptr->SetItemCustomString(init);
    ptr->RepaintItem();
  }
}

void  tzMenu::Next()
{
  MenuItem *next;

  if (CurrentItem) {
    next = CurrentItem->NextItem;
    while (next->IsEnabled() == 0)
      next = next->NextItem;

    if (next != CurrentItem) {
      CurrentItem->DeSelectItem();
      CurrentItem->RepaintItem();
      CurrentItem = next;
      CurrentItem->SelectItem();
      CurrentItem->RepaintItem();
      SelectedItem = CurrentItem->GetID();
      Active = (void *) CurrentItem;
    }
  }
}

void  tzMenu::Prev()
{
  MenuItem *prev;

  if (CurrentItem) {
    prev = CurrentItem->PrevItem;
    while (prev->IsEnabled() == FALSE)
      prev = prev->PrevItem;

    if (prev != CurrentItem) {
      CurrentItem->DeSelectItem();
      CurrentItem->RepaintItem();
      CurrentItem = prev;
      CurrentItem->SelectItem();
      CurrentItem->RepaintItem();
      SelectedItem = CurrentItem->GetID();
      Active = (void *) CurrentItem;
    }
  }
}

static void HandleHelp(const char *help, unsigned color,
                       int row, int col, int width)
{
  int  len;
  char buffer[MAX_AVAIL_COLS+1];

  *buffer = ' ';
  strncpy(buffer+1, help, MAX_AVAIL_COLS);
  buffer[MAX_AVAIL_COLS] = 0;
  len = strlen(help) + 1;
  memset(buffer+len, ' ', MAX_AVAIL_COLS-len);
  if (width < MAX_AVAIL_COLS)
    buffer[width] = 0;
  FastWrite(buffer, row, col, color);
}

int tzMenu::GetChoice(int id) // processes the menu and returns a result
{
  BOOL horizontal;
  int key = 0, expand = 0;
  int processKeyStroke, i, maxi, mini;
  MenuItem *current, *tmp;

  if (!Visible)  Paint();

  TranslateID(&id);

  if ((id <= 0) || (id > TotalItemNo))
    id = 1;
  Activate(id);

  if (CurrentItem == 0)
    return 0;

  HandleHelp(CurrentItem->GetHelp(), GetColor(HELP),
             HelpRow, MenuCol, MenuWidth);

  while (TRUE) {
    horizontal = (CurrentItem->ParentMenu == 0);
    key = getKeyStroke(horizontal);

    if (CallBack) {
        processKeyStroke = (*CallBack)(CurrentItem->GetUserID(),
                            CurrentItem->GetName(), key);
    }
    else
      processKeyStroke = TRUE;

    if (processKeyStroke == TRUE) {
      if (key < 0) { // Mouse event
        key = -key;
        if (!Find(key)->IsEnabled())
          continue;
        current = CurrentItem->ParentMenu;
        if (current) {
          if (current->GetID() == key)
            current->RememberLastSelected = CurrentItem;
          else
            current->RememberLastSelected = 0;
        }
        Activate(key);  // Activate the target
        key = 0x24D;    // Simulate <Enter> key
      }

      // Handle trigger keys
      maxi = HOTKEYSNO;
      mini = 1;
      current = CurrentItem->ParentMenu;
      if (current) {
        mini = current->GetID()+1;
        while (current) {
          current = current->NextItem;
          if (current->GetID() > CurrentItem->GetID()) {
            maxi = current->GetID()-1;
            break;
          }
          current = current->ParentMenu;
        }
      }
      for (i = maxi; i>=mini; i--) {
        if (hotkeys[i] == key)
          if (Find(i)->Visible) {
            Activate(i);
            key = 0x24D;  // Simulate <Enter> key
            break;
          }
      }

      if ((key != 'r') && (key != 'l'))
        expand = 0;

      switch (key) {
        case 'u':      // Up Arrow
          if (CurrentItem->ParentMenu)
            Prev();
          break;

        case 'd':      // Down Arrow
          if (CurrentItem->ParentMenu)
            Next();
          break;

        case 'l':      // Left Arrow
        case 'r':      // Right Arrow
          current = CurrentItem->ParentMenu;
          if (current) {
            if (current->ParentMenu == 0) { // second level
              expand = 1;
              current->RememberLastSelected = CurrentItem;
              current = (key == 'l') ? current->PrevItem : current->NextItem;
              if (current->ChildMenu) {
                if (current->RememberLastSelected)
                  current = current->RememberLastSelected;
                else {
                  tmp = FindFirstEnabled(current->ChildMenu);
                  if (tmp)
                    current = tmp;
                }
              }
              Activate(current->GetID());
            }
          }
          else {
            (key == 'l') ? Prev() : Next();
            if (expand) {
              if (CurrentItem->ChildMenu) {
                if (CurrentItem->RememberLastSelected)
                  current = CurrentItem->RememberLastSelected;
                else {
                  current = FindFirstEnabled(CurrentItem->ChildMenu);
                  if (current == 0)
                    current = CurrentItem;
                }
              }
              Activate(current->GetID());
            }
          }
          break;

        case 'h':      // Home
          current = CurrentItem->ParentMenu;
          if (current)
            current = current->ChildMenu;
          else
            current = (MenuItem *) FirstMenuGroup;
          while (current->IsEnabled() == FALSE)
            current = current->NextItem;
          Activate(current->GetID());
          break;

        case 'e':      // End
          current = CurrentItem->ParentMenu;
          if (current)
            current = current->ChildMenu;
          else
            current = (MenuItem *) FirstMenuGroup;
          do {
            current = current->PrevItem;
          } while (current->IsEnabled() == FALSE);
          Activate(current->GetID());
          break;

        case 0x25B:     // Escape, close the lowest level
          current = CurrentItem->ParentMenu;
          if (current) {
            current->RememberLastSelected = CurrentItem;
            Activate(current->GetID());
          }
          else
            if (QuitMenuByEscape)
              return 0;
          break;

        case 0x24D:  // carriage return, Ctrl/'M'
          current = CurrentItem->ChildMenu;
          if (current) {
            if (CurrentItem->RememberLastSelected)
              current = CurrentItem->RememberLastSelected;
            else
              current = FindFirstEnabled(current);
            if (current)
              Activate(current->GetID());
            break;
          }
          else
            return CurrentItem->GetUserID();
      }
      HandleHelp(CurrentItem->GetHelp(), GetColor(HELP),
                 HelpRow, MenuCol, MenuWidth);
    }
  }
}

void tzMenu::TranslateID(int *id) const
{
  int i;

  if (*id) {
    for(i=1; i<=TotalItemNo; i++)
      if (Find(i)->GetUserID() == *id) {
        *id = i;
        return;
      }
  }
  *id = 0;
}

////////////////////////// MenuConst methods //////////////////////////////
MenuColors MenuConst::Colors = {
    LIGHTGRAY,  // BorderFg;
    BLACK,      // BorderBg;
    LIGHTGRAY,  // NormalFg;
    BLACK,      // NormalBg;
    WHITE,      // HiLitedFg;
    BLACK,      // HiLitedBg;
    BLACK,      // SelectedFg;
    LIGHTGRAY,  // SelectedBg;
    DARKGRAY,   // DisabledFg;
    BLACK,      // DisabledBg;
    LIGHTGRAY,  // HelpFg;
    BLACK,      // HelpBg;
    DARKGRAY,   // ShadowColorFg;
    BLACK       // ShadowColorBg;
};

int    MenuConst::hotkeys[HOTKEYSNO] = {{0}};
IdLinkType *  MenuConst::IdLink = 0;
int    MenuConst::IdLinkNo = 0;
void  *MenuConst::Start = 0;
void  *MenuConst::Active = 0;
int    MenuConst::TotalItemNo = 0;
int    MenuConst::SelectedItem = 0;
int    MenuConst::MenuRow = 1;
int    MenuConst::MenuCol = 1;
int    MenuConst::MenuWidth = 80;
int    MenuConst::MenuHeight = MaxAvailRows() - 1;
int    MenuConst::LineStyle = 1;
int    MenuConst::HelpRow = MenuHeight + 1;
unsigned char MenuConst::CheckMark = 0xFB;
char   MenuConst::EmptyString[1] = "";
UDFPtr MenuConst::UDF = 0;

void MenuConst::SetError(int errNo, const char *msg)
{
  int saveAutoHalt = AutoHalt;

  if (IdLink)
    delete[] IdLink;
  AutoHalt = 1;
  ::SetError(errNo, 1, msg);
  AutoHalt = saveAutoHalt;
}

MenuConst::MenuConst()
{
  WindowInStack = FALSE;
  Row = Col = 1;
  Visible = 0;
}

void MenuConst::SetColors(MenuColorsPtr colors)
{
  if (colors)
    memcpy(&Colors, colors, sizeof(MenuColors));
}

int  MenuConst::GetColor(int ID)
{
  switch(ID) {
    case BORDERFG   : return Colors.BorderFg;
    case BORDERBG   : return Colors.BorderBg;
    case NORMALFG   : return Colors.NormalFg;
    case NORMALBG   : return Colors.NormalBg;
    case HILITEDFG  : return Colors.HiLitedFg;
    case HILITEDBG  : return Colors.HiLitedBg;
    case SELECTEDFG : return Colors.SelectedFg;
    case SELECTEDBG : return Colors.SelectedBg;
    case DISABLEDFG : return Colors.DisabledFg;
    case DISABLEDBG : return Colors.DisabledBg;
    case HELPFG     : return Colors.HelpFg;
    case HELPBG     : return Colors.HelpBg;
    case SHADOWFG   : return Colors.ShadowColorFg;
    case SHADOWBG   : return Colors.ShadowColorBg;

    case BORDER   : return (Colors.BorderBg<<4)|Colors.BorderFg;
    case NORMAL   : return (Colors.NormalBg<<4)|Colors.NormalFg;
    case HILITED  : return (Colors.HiLitedBg<<4)|Colors.HiLitedFg;
    case SELECTED : return (Colors.SelectedBg<<4)|Colors.SelectedFg;
    case DISABLED : return (Colors.DisabledBg<<4)|Colors.DisabledFg;
    case HELP     : return (Colors.HelpBg<<4)|Colors.HelpFg;
    case SHADOW   : return (Colors.ShadowColorBg<<4)|Colors.ShadowColorFg;
    default       : return -1;
  }
}
