/* filename: GETKEYS.C

: T O P A Z for C :Ŀ
                          Version 4.5  05/16/93                              
                                                                             
 Copyright (c) 1988,1994 Software Science Inc. All Rights Reserved Worldwide.
 Unauthorized distribution or disclosure of this source code or modification 
  or removal of this notice  constitutes a breach of the license agreement.  

*/
#include <stdio.h>
#include <sayget.h>

// returrns key stroke or mouse event
// key strokes are bit-coded:
// <Functional><Shift><Ctrl><Alt> | key & 0xFF...
#define FUNCT  0x800
#define SHIFT  0x400
#define CTRL   0x200
#define ALT    0x100

int getKeyStroke(BOOL horizontal)
{
  int ret = 0;
  EventRec e;

  while (!ret) {
    GetEvent(&e);

    switch (e.WhichEvent) {
      case Mouse:
        if (e.v.sMouse.TargetID == ReservedID)
          ret = 0x25B;  // Escape == Ctrl/[
        else  {
          ret = e.v.sMouse.TargetID;
          if (!(e.v.sMouse.ButtonMask & LeftButtonReleased))
            ret = 0;
        }
        break;
      case Keyboard:
        ret = e.v.sKeyboard.Key;

        // Make the keystroke eligible...
        switch (ret) {
          case 0:  // a special key was pressed...
            ret =  e.v.sKeyboard.ScanCode & 0xff;
            switch (ret) {
              case 0x0F :
                if (horizontal)
                  ret = 'l';     // shift-tab == left
                else
                  ret = 'u';     // shift-tab == up
                break;
              case 0x48 : ret = 'u'; break; // up
              case 0x50 : ret = 'd'; break; // down
              case 0x4B : ret = 'l'; break; // left
              case 0x4D : ret = 'r'; break; // right
              case 0x49 : ret = 't'; break; // Page Up
              case 0x51 : ret = 'b'; break; // Page Dn
              case 0x47 : ret = 'h'; break; // Home
              case 0x4F : ret = 'e'; break; // End
              case 0x52 : ret = 'i'; break; // Insert (in)
              case 0x53 : ret = 'o'; break; // Delete (out)

              // control keys
              case 0x03 : ret = 0x200 | '@'; break; // ctrl - @
              case 0x84 : ret = 0x200 | 't'; break; // ctrl - PgUp
              case 0x76 : ret = 0x200 | 'b'; break; // ctrl - PgDn
              case 0x77 : ret = 0x200 | 'h'; break; // ctrl - Home
              case 0x75 : ret = 0x200 | 'e'; break; // ctrl - End
              case 0x74 : ret = 0x200 | 'r'; break; // ctrl - right
              case 0x73 : ret = 0x200 | 'l'; break; // ctrl - left

              // alt keys
              case 0xF8 : ret = 0x100 | '1'; break; // alt - 1
              case 0xF9 : ret = 0x100 | '2'; break; // alt - 2
              case 0xFA : ret = 0x100 | '3'; break; // alt - 3
              case 0xFB : ret = 0x100 | '4'; break; // alt - 4
              case 0xFC : ret = 0x100 | '5'; break; // alt - 5
              case 0xFD : ret = 0x100 | '6'; break; // alt - 6
              case 0xFE : ret = 0x100 | '7'; break; // alt - 7
              case 0xFF : ret = 0x100 | '8'; break; // alt - 8
              case 0x80 : ret = 0x100 | '9'; break; // alt - 9
              case 0x81 : ret = 0x100 | '0'; break; // alt - 0
              case 0x82 : ret = 0x100 | '-'; break; // alt - minus
              case 0x83 : ret = 0x100 | '+'; break; // alt - plus

              case 0x10 : ret = 0x100 | 'Q'; break; // alt - Q
              case 0x11 : ret = 0x100 | 'W'; break; // alt - W
              case 0x12 : ret = 0x100 | 'E'; break; // alt - E
              case 0x13 : ret = 0x100 | 'R'; break; // alt - R
              case 0x14 : ret = 0x100 | 'T'; break; // alt - T
              case 0x15 : ret = 0x100 | 'Y'; break; // alt - Y
              case 0x16 : ret = 0x100 | 'U'; break; // alt - U
              case 0x17 : ret = 0x100 | 'I'; break; // alt - I
              case 0x18 : ret = 0x100 | 'O'; break; // alt - O
              case 0x19 : ret = 0x100 | 'P'; break; // alt - P

              case 0x1E : ret = 0x100 | 'A'; break; // alt - A
              case 0x1F : ret = 0x100 | 'S'; break; // alt - S
              case 0x20 : ret = 0x100 | 'D'; break; // alt - D
              case 0x21 : ret = 0x100 | 'F'; break; // alt - F
              case 0x22 : ret = 0x100 | 'G'; break; // alt - G
              case 0x23 : ret = 0x100 | 'H'; break; // alt - H
              case 0x24 : ret = 0x100 | 'J'; break; // alt - J
              case 0x25 : ret = 0x100 | 'K'; break; // alt - K
              case 0x26 : ret = 0x100 | 'L'; break; // alt - L

              case 0x2C : ret = 0x100 | 'Z'; break; // alt - Z
              case 0x2D : ret = 0x100 | 'X'; break; // alt - X
              case 0x2E : ret = 0x100 | 'C'; break; // alt - C
              case 0x2F : ret = 0x100 | 'V'; break; // alt - V
              case 0x30 : ret = 0x100 | 'B'; break; // alt - B
              case 0x31 : ret = 0x100 | 'N'; break; // alt - N
              case 0x32 : ret = 0x100 | 'M'; break; // alt - M

              case 0x3B : ret = 0x800 | '1'; break; // F1
              case 0x3C : ret = 0x800 | '2'; break; // F2
              case 0x3D : ret = 0x800 | '3'; break; // F3
              case 0x3E : ret = 0x800 | '4'; break; // F4
              case 0x3F : ret = 0x800 | '5'; break; // F5
              case 0x40 : ret = 0x800 | '6'; break; // F6
              case 0x41 : ret = 0x800 | '7'; break; // F7
              case 0x42 : ret = 0x800 | '8'; break; // F8
              case 0x43 : ret = 0x800 | '9'; break; // F9
              case 0x44 : ret = 0x800 | '0'; break; // F10

              case 0x68 : ret = 0x900 | '1'; break; // alt - F1
              case 0x69 : ret = 0x900 | '2'; break; // alt - F2
              case 0x6A : ret = 0x900 | '3'; break; // alt - F3
              case 0x6B : ret = 0x900 | '4'; break; // alt - F4
              case 0x6C : ret = 0x900 | '5'; break; // alt - F5
              case 0x6D : ret = 0x900 | '6'; break; // alt - F6
              case 0x6E : ret = 0x900 | '7'; break; // alt - F7
              case 0x6F : ret = 0x900 | '8'; break; // alt - F8
              case 0x70 : ret = 0x900 | '9'; break; // alt - F9
              case 0x71 : ret = 0x900 | '0'; break; // alt - F10

              case 0x5E : ret = 0xA00 | '1'; break; // ctrl - F1
              case 0x5F : ret = 0xA00 | '2'; break; // ctrl - F2
              case 0x60 : ret = 0xA00 | '3'; break; // ctrl - F3
              case 0x61 : ret = 0xA00 | '4'; break; // ctrl - F4
              case 0x62 : ret = 0xA00 | '5'; break; // ctrl - F5
              case 0x63 : ret = 0xA00 | '6'; break; // ctrl - F6
              case 0x64 : ret = 0xA00 | '7'; break; // ctrl - F7
              case 0x65 : ret = 0xA00 | '8'; break; // ctrl - F8
              case 0x66 : ret = 0xA00 | '9'; break; // ctrl - F9
              case 0x67 : ret = 0xA00 | '0'; break; // ctrl - F10

              case 0x54 : ret = 0xC00 | '1'; break; // shift - F1
              case 0x55 : ret = 0xC00 | '2'; break; // shift - F2
              case 0x56 : ret = 0xC00 | '3'; break; // shift - F3
              case 0x57 : ret = 0xC00 | '4'; break; // shift - F4
              case 0x58 : ret = 0xC00 | '5'; break; // shift - F5
              case 0x59 : ret = 0xC00 | '6'; break; // shift - F6
              case 0x5A : ret = 0xC00 | '7'; break; // shift - F7
              case 0x5B : ret = 0xC00 | '8'; break; // shift - F8
              case 0x5C : ret = 0xC00 | '9'; break; // shift - F9
              case 0x5D : ret = 0xC00 | '0'; break; // shift - F10
            }
            break;
          case ' ' : // advance to next choice when space bar or TAB is pressed
          case '\t':
            if (horizontal)
              ret = 'r';   // tab == right
            else
              ret = 'd';   // tab == down
            break;

          // control - characters
          case 0x01 : ret = 0x200 | 'A'; break;
          case 0x02 : ret = 0x200 | 'B'; break;
          case 0x03 : ret = 0x200 | 'C'; break;
          case 0x04 : ret = 0x200 | 'D'; break;
          case 0x05 : ret = 0x200 | 'E'; break;
          case 0x06 : ret = 0x200 | 'F'; break;
          case 0x07 : ret = 0x200 | 'G'; break;
          case 0x08 : ret = 0x200 | 'H'; break;
//        case 0x09 : ret = 0x200 | 'I'; break; <Tab>
          case 0x0A : ret = 0x200 | 'J'; break;
          case 0x0B : ret = 0x200 | 'K'; break;
          case 0x0C : ret = 0x200 | 'L'; break;
          case 0x0D : ret = 0x200 | 'M'; break; // <Carriage return>
          case 0x0E : ret = 0x200 | 'N'; break;
          case 0x0F : ret = 0x200 | 'O'; break;
          case 0x10 : ret = 0x200 | 'P'; break;
          case 0x11 : ret = 0x200 | 'Q'; break;
          case 0x12 : ret = 0x200 | 'R'; break;
          case 0x13 : ret = 0x200 | 'S'; break;
          case 0x14 : ret = 0x200 | 'T'; break;
          case 0x15 : ret = 0x200 | 'U'; break;
          case 0x16 : ret = 0x200 | 'V'; break;
          case 0x17 : ret = 0x200 | 'W'; break;
          case 0x18 : ret = 0x200 | 'X'; break;
          case 0x19 : ret = 0x200 | 'Y'; break;
          case 0x1A : ret = 0x200 | 'Z'; break;
          case 0x1B : ret = 0x200 | '['; break; // <Escape>
          case 0x1C : ret = 0x200 | '\\'; break;
          case 0x1D : ret = 0x200 | ']'; break;
          case 0x1E : ret = 0x200 | '^'; break;
          case 0x1F : ret = 0x200 | '_'; break;

          default: // any other key pressed gets passed through
            ret = UpCase(ret);
        }
    }
  }
  return ret;
}

#ifdef DEBUGGING

void main(void)
{
  int ret;

  do {
    ret = getKeyStroke(1);
    printf("Key is : %c %d %d %d %d\n", ret,
           (ALT   & ret) ? 1 : 0,
           (CTRL  & ret) ? 1 : 0,
           (SHIFT & ret) ? 1 : 0,
           (FUNCT & ret) ? 1 : 0);
  } while(ret != 'Q');
}

#endif
