/* filename: VALIDATE.C

: T O P A Z for C :Ŀ
                          Version 4.5  05/16/93                              
                                                                             
 Copyright (c) 1988,1994 Software Science Inc. All Rights Reserved Worldwide.
 Unauthorized distribution or disclosure of this source code or modification 
  or removal of this notice  constitutes a breach of the license agreement.  

*/
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>
#include <sayget.h>
#include <timedate.h>

BOOL ValidDate(const char * datestring)
{
  int iyear, imonth, iday, i, j;
  char mdate[11];
  size_t len = strlen( datestring );

  if ((len != 8) && (len != 10))
    return FALSE;
  for( i=j=0; datestring[i]; i++ )
    if( !isdigit(datestring[i]) ) {
      mdate[j] = datestring[i];
      ++j;
    }
  if ((j != 2) || (mdate[0] != mdate[1]))
    return 0;
  strcpy(mdate, datestring);
  Convert2American(mdate);
  imonth = atoi(&mdate[0]);
  iday = atoi(&mdate[3]);
  iyear = atoi(&mdate[6]);
  if (len == 8)
    iyear = ThisCentury(&mdate[6]) + iyear;
  if (!iyear || !imonth || !iday)
    return 0;
  if ((imonth < 1) || (imonth > 12))
    return 0;
  if ((iday < 1) || (iday >31) || ((imonth == 2) && (iday > 29)) )
    return 0;
  if ((iday > 30) && ((imonth == 4)||(imonth == 6)||(imonth == 9)||(imonth == 11)) )
    return 0;
  if (!LeapYear(iyear) && (imonth == 2) && (iday > 28) )
    return 0;

  return TRUE;
}
