/* filename: FULLDATE.C

: T O P A Z for C :Ŀ
                          Version 4.5  05/16/93                              
                                                                             
 Copyright (c) 1988,1994 Software Science Inc. All Rights Reserved Worldwide.
 Unauthorized distribution or disclosure of this source code or modification 
  or removal of this notice  constitutes a breach of the license agreement.  

*/
#include <stdio.h>
#include <string.h>
#include <sayget.h>
#include <timedate.h>

char * InnerFullDate(const char * mdate, int i)
{
  static char _tzfar ret[45] = "";
  int    saveCenturyOn;
  char   *suffix;
  char   mYear[5], mMonth[13], mDay[3], DayOfWeek[12];
  size_t len;

  saveCenturyOn = CenturyOn;
  CenturyOn = TRUE;
  strcpy(mYear, CYear(mdate));
  CenturyOn = saveCenturyOn;
  strcpy(mMonth, Trim(CMonth(mdate)));
  strcpy(mDay, CDay(mdate));
  strcpy(DayOfWeek, Trim(CDOW(mdate)));
  switch (DateFormat) {
    case Germany:
      sprintf(ret, "%s,%s %s. %s %s",DayOfWeek,i?" den":"",mDay,mMonth,mYear);
      break;
    case France:
    case Quebec:
      if (strcmp(mDay,"1") == 0)
        sprintf(ret, "%s %s%s %s %s",DayOfWeek,mDay,i?"er":"",mMonth,mYear);
      else
        sprintf(ret, "%s %s %s %s",DayOfWeek,mDay,mMonth,mYear);
      break;
    case Russia:
      len = strlen( mMonth );
      if( (mMonth[len-1] == '')||(mMonth[len-1] == ''))
        mMonth[len-1] = '\0'; // take off the "soft" letter
      switch (Month(mdate)) {
       case 3:
       case 8:
         sprintf(ret,"%s, %s %s%c %s",DayOfWeek,mDay,mMonth,'',mYear);
         break;
       default:
         sprintf(ret,"%s, %s %s%c %s",DayOfWeek,mDay,mMonth,'',mYear);
      }
      break;
   default:
      switch (Day(mdate)) {
        case 1:
        case 21:
        case 31: suffix = "st"; break;
        case 2:
        case 22: suffix = "nd"; break;
        case 3:
        case 23: suffix = "rd"; break;
        default: suffix = "th";
      }
      sprintf(ret,"%s, %s %s%s, %s", DayOfWeek, mMonth, mDay,
        i ? suffix : "", mYear);
      break;
  }
  return ret;
}

char * FullDate(const char * mdate)
{
  return(InnerFullDate(mdate, TRUE));
}
