/* filename: DOW.C

: T O P A Z for C :Ŀ
                          Version 4.5  05/16/93                              
                                                                             
 Copyright (c) 1988,1994 Software Science Inc. All Rights Reserved Worldwide.
 Unauthorized distribution or disclosure of this source code or modification 
  or removal of this notice  constitutes a breach of the license agreement.  

*/
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sayget.h>
#include <timedate.h>

int DOW(const char * indate)  //  sunday = 1
//  modified version of Jeff Duntemann's version of Zeller's Congruence
{
  int century, imonth, iday, iyear, result;
  char mdate[20];
  size_t  len = strlen(indate);

  if (len < 6)
    return 0;
  strcpy(mdate, indate);

  Convert2American(mdate);
  imonth = atoi(&mdate[0]);
  iday = atoi(&mdate[3]);
  iyear = atoi(&mdate[6]);
  if (len == 8)
    iyear += ThisCentury(&mdate[6]);
  // Zeller's Congruence as Zeller himself described it in
  // "Acta Mathematica" #7, Stockholm, 1887
  // first separate year from century
  century = iyear / 100;
  iyear %= 100;
  // Next, adjust the month so that March remains month #3 but January and
  // February are months #13 and #14 of the previous year
  if (imonth < 3) {
    imonth += 12;
    if (iyear > 0) // the year before 2000 is 1999 not 20 -1...
      --iyear;
    else {
      iyear = 99;
      --century;
    }
  }
  // Zeller's seminal black magic:
  result = (iday + // start with the day of the month
            ((imonth + 1) * 26) / 10 + // calc the increment
            iyear + // add in the year
            (iyear >> 2) + // correct for leap years
            (century >> 2) - // correct for century years
            (century << 1))
            % 7; // get result modulus 7
  if (result < 0)
    result += 7;
  if (!result)
    result = 7;
   return result;
}
