/* filename: DISPCALR.C

: T O P A Z for C :Ŀ
                          Version 4.5  05/16/93                              
                                                                             
 Copyright (c) 1988,1994 Software Science Inc. All Rights Reserved Worldwide.
 Unauthorized distribution or disclosure of this source code or modification 
  or removal of this notice  constitutes a breach of the license agreement.  

*/
#ifndef WINDOWS

#include <stdio.h>
#include <conio.h>
#include <string.h>
#include <sayget.h>
#include <timedate.h>
#ifdef _MSC_VER
#include <graph.h>
#endif

void DisplayCalendar(char * d)
{
  int  oldorder, plain, saveX, saveY;
  unsigned cursorvar;
  int bottomline;
  char *ptr;
#ifdef _MSC_VER
  short r1,c1,r2,c2;
  _gettextwindow( &r1, &c1, &r2, &c2 );
  saveX = wherex();
  saveY = wherey();
  _settextwindow(1,1,25,80);
#else
  struct text_info ti;
  gettextinfo(&ti);
  saveX = wherex();
  saveY = wherey();
  window(1,1,80,25);
#endif

  if (!CheckRegisteredUnits("SelectDate", REGTZCOMMON+REGTZSAYGET+REGTZTMDATE))
    return;

  oldorder = dBASEOrder;
  dBASEOrder = FALSE;
  SaveCursor(&cursorvar);
  SetCursorOff();
  plain = (ptr = strstr(Upper(d),"PLAIN")) != NULL;
  bottomline = OrigY + 10;
  if (plain)
    --bottomline;
  Box(OrigX,OrigY,OrigX + 32,bottomline,(char)CalendarLineStyle,CalendarHeading);
  PaintDaysOfWeekLetters();
  if (plain)
    *ptr = 0;
  if (!ValidDate(d))
    strcpy(d, SystemDate());
  DisplayCalendarData(d, plain);
  dBASEOrder = oldorder;

  // restore the old window
#ifdef _MSC_VER
  _settextwindow(r1,c1,r2,c2);
#else
  window(ti.winleft, ti.wintop, ti.winright, ti.winbottom );
#endif
  gotoxy( saveX, saveY );
  RestoreCursor(cursorvar);
}
#endif
