/* filename: CDOW.C

: T O P A Z for C :Ŀ
                          Version 4.5  05/16/93                              
                                                                             
 Copyright (c) 1988,1994 Software Science Inc. All Rights Reserved Worldwide.
 Unauthorized distribution or disclosure of this source code or modification 
  or removal of this notice  constitutes a breach of the license agreement.  

*/
#include <timedate.h>

static char *EnglishDays[] = {
  "         ", "Sunday   ", "Monday   ", "Tuesday  ",
  "Wednesday", "Thursday ", "Friday   ", "Saturday "
};
static char *ItalianDays[] = {
  "         ", "Domenica ", "Lunedi   ", "Martedi  ",
  "Mercoledi", "Giovedi  ", "Venerdi  ", "Sabato   "
};
static char *FrenchDays[] = {
  "        ", "Dimanche", "Lundi   ", "Mardi   ",
  "Mercredi", "Jeudi   ", "Vendredi", "Samedi  "
};
static char *GermanDays[] = {
  "          ", "Sonntag   ", "Montag    ", "Dienstag  ",
  "Mittwoch  ", "Donnerstag", "Freitag   ", "Samstag   "
};
static char *SpanishDays[] = {
  "         ", "Domingo  ", "Lunes    ", "Martes   ",
  "Miercoles", "Jueves   ", "Viernes  ", "Sabado   "
};
static char *RussianDays[] = {
  "           ", "ᥭ", "쭨", "୨    ",
  "।      ", "⢥    ", "⭨    ", "㡡     "
};

static char **DaysUnion[] = {
// Usa 0        Ansi 1       British 2    Italy 3
   EnglishDays, EnglishDays, EnglishDays, ItalianDays,
// France 4     Germany 5    Spain 6      Quebec 7     Russian 8
   FrenchDays,  GermanDays,  SpanishDays, FrenchDays,  RussianDays
};

char *CDOW(const char *mdate)
{
  return DaysUnion[DateFormat][DOW(mdate)];
}
