/* filename: PRSTATUS.C

: T O P A Z for C :Ŀ
                          Version 4.5  05/16/93                              
                                                                             
 Copyright (c) 1988,1994 Software Science Inc. All Rights Reserved Worldwide.
 Unauthorized distribution or disclosure of this source code or modification 
  or removal of this notice  constitutes a breach of the license agreement.  

*/
#include <dos.h>
#include <string.h>
#include <stdlib.h>
#include <conio.h>
#include <spooler.h>

#ifdef _MSC_VER
 #pragma optimize("i", on)
 #pragma check_stack(off)
 #pragma check_pointer(off)
#else
 #pragma option -N- -k+
#endif

static int CheckStatus(unsigned char status)
{
  int Bit3, Bit4, Bit5;

  Bit3 = (status & 0x08) == 0x08; // I/O error
  Bit4 = (status & 0x10) == 0x10; // Selected
  Bit5 = (status & 0x20) == 0x20; // Paper Out
  if(Bit4 && !Bit3)               // Printer is on-line
    return 16;
  else
    if(Bit3 && !Bit5)             // Printer is off-line
      return 0;
    else
      if(Bit3 && Bit5)            // Paper is out
        return 32;
      else
        return 64; // Undetermined.. busy or timed out or something
}

unsigned char RealPrinterStatus(void)
{
  union MYREGS {
    struct  REGPACK  x;
    struct  BYTEREGS  h;
  } cpu;
  int CTS;
  unsigned char Status, result;

  if(SpoolerInstalled) {
    // check the port directly
    if(Parallel) {
      // just get the parallel printers status and filter
      Status = inp(StatusPort);
      // Bit cleanup, reference = System Bios documentation page 5-75
      Status &= 0xF8;   // Turn off unused bits 0,1,2
      Status ^= 0x48;   // "flip a couple of bits"  Bits 6 & 7
      result = CheckStatus(Status);
    } else {
      // the printer is serial. if not CTS then printer is not available
      outp(UART_MCR + ComBase, 0x0B); // turn on OUT2, DTR, and RTS

      if((inp(UART_MSR + ComBase) & 0x10) == 0x10)
        CTS = TRUE;
      else
        CTS = FALSE;

      if(CTS)
        result = 0x10;
      else
        result =  0x00;
    }
  } else {
    // spooler not installed, call the real Interrupt 17H, like normal
    if(UserPrinterCheck) {
      if(UserPrinterCheck())
        result = 0x10;
      else
        result = 64;
    } else {
      memset(&cpu, 0, sizeof(cpu));
      cpu.h.ah = 0x02;
      cpu.x.r_dx = PortNumber;
      intr(0x17, &cpu.x);
      // bit cleanup already done by bios code
      Status = cpu.h.ah;
      result = CheckStatus(Status);
    }
  }
  return result;
}
